/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.LockListener;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.window.WindowManager;
import org.eclipse.osgi.service.runnable.StartupMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.ILocalWorkingSetManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.ActionSetsEvent;
import org.eclipse.ui.internal.ActivityPersistanceHelper;
import org.eclipse.ui.internal.ApplicationMenuManager;
import org.eclipse.ui.internal.EarlyStartupRunnable;
import org.eclipse.ui.internal.EditorHistory;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.ExceptionHandler;
import org.eclipse.ui.internal.ExtensionEventHandler;
import org.eclipse.ui.internal.ISelectionConversionService;
import org.eclipse.ui.internal.JFaceUtil;
import org.eclipse.ui.internal.LocalWorkingSetManager;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.SelectionConversionService;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.UILockListener;
import org.eclipse.ui.internal.UISynchronizer;
import org.eclipse.ui.internal.WorkbenchColors;
import org.eclipse.ui.internal.WorkbenchConfigurer;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchIntroManager;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.activities.ws.WorkbenchActivitySupport;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.eclipse.ui.internal.commands.CommandImageManager;
import org.eclipse.ui.internal.commands.CommandImageService;
import org.eclipse.ui.internal.commands.CommandService;
import org.eclipse.ui.internal.commands.WorkbenchCommandSupport;
import org.eclipse.ui.internal.contexts.ActiveContextSourceProvider;
import org.eclipse.ui.internal.contexts.ContextService;
import org.eclipse.ui.internal.contexts.WorkbenchContextSupport;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.help.WorkbenchHelpSystem;
import org.eclipse.ui.internal.intro.IIntroRegistry;
import org.eclipse.ui.internal.intro.IntroDescriptor;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.internal.menus.FocusControlSourceProvider;
import org.eclipse.ui.internal.menus.WorkbenchMenuService;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.model.ContributionService;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.UIExtensionTracker;
import org.eclipse.ui.internal.services.ActionSetSourceProvider;
import org.eclipse.ui.internal.services.EvaluationService;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.MenuSourceProvider;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.ServiceLocatorCreator;
import org.eclipse.ui.internal.services.SourceProviderService;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.internal.services.WorkbenchServiceRegistry;
import org.eclipse.ui.internal.splash.EclipseSplashHandler;
import org.eclipse.ui.internal.splash.SplashHandlerFactory;
import org.eclipse.ui.internal.testing.ContributionInfoMessages;
import org.eclipse.ui.internal.testing.WorkbenchTestable;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.themes.WorkbenchThemeManager;
import org.eclipse.ui.internal.tweaklets.GrabFocus;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.internal.tweaklets.WorkbenchImplementation;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.model.IContributionService;
import org.eclipse.ui.operations.IWorkbenchOperationSupport;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.ISourceProviderService;
import org.eclipse.ui.splash.AbstractSplashHandler;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.testing.ContributionInfo;
import org.eclipse.ui.themes.IThemeManager;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.ui.wizards.IWizardRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

public final class Workbench
extends EventManager
implements IWorkbench {
    public static final String EARLY_STARTUP_FAMILY = "earlyStartup";
    static final String[] VERSION_STRING = new String[]{"0.046", "2.0"};
    static final String DEFAULT_WORKBENCH_STATE_FILENAME = "workbench.xml";
    private static Workbench instance;
    private static WorkbenchTestable testableObject;
    private static boolean createSplash;
    private static AbstractSplashHandler splash;
    private Display display;
    private WindowManager windowManager;
    private WorkbenchWindow activatedWindow;
    private EditorHistory editorHistory;
    private boolean runEventLoop = true;
    private boolean isStarting = true;
    private boolean isClosing = false;
    private int returnCode = 2;
    private WorkbenchAdvisor advisor;
    private WorkbenchConfigurer workbenchConfigurer;
    private ExtensionEventHandler extensionEventHandler;
    private int largeUpdates = 0;
    private final ServiceLocator serviceLocator;
    private int progressCount = -1;
    private WorkbenchWindow[] createdWindows;
    private ListenerList workbenchListeners = new ListenerList(1);
    private ServiceRegistration workbenchService;
    private WorkbenchActivitySupport workbenchActivitySupport;
    private WorkbenchCommandSupport workbenchCommandSupport;
    private WorkbenchContextSupport workbenchContextSupport;
    private BindingManager bindingManager;
    private CommandManager commandManager;
    private ContextManager contextManager;
    private final IWindowListener windowListener = new IWindowListener(){

        @Override
        public void windowActivated(IWorkbenchWindow iWorkbenchWindow) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }

        @Override
        public void windowClosed(IWorkbenchWindow iWorkbenchWindow) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }

        @Override
        public void windowDeactivated(IWorkbenchWindow iWorkbenchWindow) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }

        @Override
        public void windowOpened(IWorkbenchWindow iWorkbenchWindow) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }
    };
    private final IBindingManagerListener bindingManagerListener = new IBindingManagerListener(){

        public void bindingManagerChanged(BindingManagerEvent bindingManagerEvent) {
            if (bindingManagerEvent.isActiveBindingsChanged()) {
                Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
            }
        }
    };
    private ActionSetSourceProvider actionSetSourceProvider;
    private WorkbenchWindow activeWorkbenchWindow = null;
    private ActivityPersistanceHelper activityHelper;
    private WorkbenchIntroManager introManager;
    private IntroDescriptor introDescriptor;
    private IExtensionTracker tracker;
    private IRegistryChangeListener startupRegistryListener = new IRegistryChangeListener(){

        public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
            IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "startup");
            if (iExtensionDeltaArray.length == 0) {
                return;
            }
            String string = PrefUtil.getInternalPreferenceStore().getString("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
            int n = 0;
            while (n < iExtensionDeltaArray.length) {
                IExtension iExtension = iExtensionDeltaArray[n].getExtension();
                if (iExtensionDeltaArray[n].getKind() != 2 && string.indexOf(iExtension.getNamespace()) == -1) {
                    SafeRunner.run((ISafeRunnable)new EarlyStartupRunnable(iExtension));
                }
                ++n;
            }
        }
    };
    private String factoryID;
    private MenuSourceProvider menuSourceProvider;
    private IContextActivation workbenchContext;
    private ApplicationMenuManager applicationMenuMgr;

    static {
        createSplash = true;
    }

    private Workbench(Display display, WorkbenchAdvisor workbenchAdvisor) {
        StartupThreading.setWorkbench(this);
        if (instance != null && instance.isRunning()) {
            throw new IllegalStateException(WorkbenchMessages.Workbench_CreatingWorkbenchTwice);
        }
        Assert.isNotNull((Object)display);
        Assert.isNotNull((Object)workbenchAdvisor);
        this.advisor = workbenchAdvisor;
        this.display = display;
        instance = this;
        this.extensionEventHandler = new ExtensionEventHandler(this);
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this.extensionEventHandler);
        ServiceLocatorCreator serviceLocatorCreator = new ServiceLocatorCreator();
        this.serviceLocator = (ServiceLocator)serviceLocatorCreator.createServiceLocator(null, null, new IDisposable(){

            @Override
            public void dispose() {
                Display display = Workbench.this.getDisplay();
                if (display != null && !display.isDisposed()) {
                    MessageDialog.openInformation(null, (String)WorkbenchMessages.Workbench_NeedsClose_Title, (String)WorkbenchMessages.Workbench_NeedsClose_Message);
                    Workbench.this.close(1, true);
                }
            }
        });
        this.serviceLocator.registerService(IServiceLocatorCreator.class, serviceLocatorCreator);
        this.serviceLocator.registerService(IWorkbenchLocationService.class, new WorkbenchLocationService("org.eclipse.ui.services.IWorkbench", this, null, null, null, null, 0));
        this.serviceLocator.registerService(IWorkbench.class, this);
    }

    public static final Workbench getInstance() {
        return instance;
    }

    public static final int createAndRunWorkbench(final Display display, final WorkbenchAdvisor workbenchAdvisor) {
        final int[] nArray = new int[1];
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            @Override
            public void run() {
                String string = Platform.getNLExtensions();
                if (string.length() > 0) {
                    ULocale.setDefault((ULocale.Category)ULocale.Category.FORMAT, (ULocale)new ULocale(String.valueOf(ULocale.getDefault((ULocale.Category)ULocale.Category.FORMAT).getBaseName()) + string));
                }
                Workbench workbench = new Workbench(display, workbenchAdvisor, null);
                nArray[0] = workbench.runUI();
            }
        });
        return nArray[0];
    }

    public static Display createDisplay() {
        Display display;
        String string;
        String string2 = WorkbenchPlugin.getDefault().getAppName();
        if (string2 != null) {
            Display.setAppName((String)string2);
        }
        if ((string = WorkbenchPlugin.getDefault().getAppVersion()) != null) {
            Display.setAppVersion((String)string);
        }
        if ((display = Display.getCurrent()) == null) {
            if (Policy.DEBUG_SWT_GRAPHICS || Policy.DEBUG_SWT_DEBUG) {
                DeviceData deviceData = new DeviceData();
                if (Policy.DEBUG_SWT_GRAPHICS) {
                    deviceData.tracking = true;
                }
                if (Policy.DEBUG_SWT_DEBUG) {
                    deviceData.debug = true;
                }
                display = new Display(deviceData);
            } else {
                display = new Display();
            }
        }
        display.setWarnings(false);
        Thread.currentThread().setPriority(Math.min(10, 6));
        Workbench.initializeImages();
        return display;
    }

    private void createSplashWrapper() {
        final Display display = this.getDisplay();
        String string = System.getProperty("org.eclipse.equinox.launcher.splash.location");
        final Image image = this.loadImage(string);
        SafeRunnable safeRunnable = new SafeRunnable(){

            public void run() throws Exception {
                if (!WorkbenchPlugin.isSplashHandleSpecified()) {
                    createSplash = false;
                    return;
                }
                Workbench.getSplash();
                if (splash == null) {
                    createSplash = false;
                    return;
                }
                Shell shell = splash.getSplash();
                if (shell == null) {
                    shell = WorkbenchPlugin.getSplashShell(display);
                    if (shell == null) {
                        return;
                    }
                    if (image != null) {
                        shell.setBackgroundImage(image);
                    }
                }
                Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
                ((Dictionary)hashtable).put("service.ranking", new Integer(Integer.MAX_VALUE));
                BundleContext bundleContext = WorkbenchPlugin.getDefault().getBundleContext();
                final ServiceRegistration[] serviceRegistrationArray = new ServiceRegistration[1];
                StartupMonitor startupMonitor = new StartupMonitor(){

                    public void applicationRunning() {
                        splash.dispose();
                        if (image != null) {
                            image.dispose();
                        }
                        serviceRegistrationArray[0].unregister();
                        WorkbenchPlugin.unsetSplashShell(display);
                    }

                    public void update() {
                    }
                };
                serviceRegistrationArray[0] = bundleContext.registerService(StartupMonitor.class.getName(), (Object)startupMonitor, hashtable);
                splash.init(shell);
            }

            public void handleException(Throwable throwable) {
                StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, "Could not instantiate splash", throwable));
                createSplash = false;
                splash = null;
                if (image != null) {
                    image.dispose();
                }
            }
        };
        SafeRunner.run((ISafeRunnable)safeRunnable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Image loadImage(String string) {
        Image image = null;
        if (string == null) return image;
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(string));
            image = new Image((Device)this.display, inputStream);
        }
        catch (SWTException sWTException) {
            StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, sWTException));
            if (inputStream == null) return image;
            try {
                inputStream.close();
                return image;
            }
            catch (IOException iOException) {}
            return image;
        }
        catch (IOException iOException) {
            try {
                StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, iOException));
                if (inputStream == null) return image;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                inputStream.close();
                return image;
            }
            catch (IOException iOException3) {}
            return image;
        }
        if (inputStream == null) return image;
        try {
            inputStream.close();
            return image;
        }
        catch (IOException iOException) {}
        return image;
    }

    private static AbstractSplashHandler getSplash() {
        if (!createSplash) {
            return null;
        }
        if (splash == null) {
            IProduct iProduct = Platform.getProduct();
            if (iProduct != null) {
                splash = SplashHandlerFactory.findSplashHandlerFor(iProduct);
            }
            if (splash == null) {
                splash = new EclipseSplashHandler();
            }
        }
        return splash;
    }

    public static WorkbenchTestable getWorkbenchTestable() {
        if (testableObject == null) {
            testableObject = new WorkbenchTestable();
        }
        return testableObject;
    }

    @Override
    public void addWorkbenchListener(IWorkbenchListener iWorkbenchListener) {
        this.workbenchListeners.add((Object)iWorkbenchListener);
    }

    @Override
    public void removeWorkbenchListener(IWorkbenchListener iWorkbenchListener) {
        this.workbenchListeners.remove((Object)iWorkbenchListener);
    }

    boolean firePreShutdown(final boolean bl) {
        Object[] objectArray = this.workbenchListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IWorkbenchListener iWorkbenchListener = (IWorkbenchListener)objectArray[n];
            final boolean[] blArray = new boolean[1];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    blArray[0] = iWorkbenchListener.preShutdown(Workbench.this, bl);
                }
            });
            if (!blArray[0]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    void firePostShutdown() {
        Object[] objectArray = this.workbenchListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IWorkbenchListener iWorkbenchListener = (IWorkbenchListener)objectArray[n];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iWorkbenchListener.postShutdown(Workbench.this);
                }
            });
            ++n;
        }
    }

    @Override
    public void addWindowListener(IWindowListener iWindowListener) {
        this.addListenerObject(iWindowListener);
    }

    @Override
    public void removeWindowListener(IWindowListener iWindowListener) {
        this.removeListenerObject(iWindowListener);
    }

    protected void fireWindowOpened(final IWorkbenchWindow iWorkbenchWindow) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IWindowListener iWindowListener = (IWindowListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iWindowListener.windowOpened(iWorkbenchWindow);
                }
            });
            ++n;
        }
    }

    protected void fireWindowClosed(final IWorkbenchWindow iWorkbenchWindow) {
        if (this.activatedWindow == iWorkbenchWindow) {
            this.activatedWindow = null;
        }
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IWindowListener iWindowListener = (IWindowListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iWindowListener.windowClosed(iWorkbenchWindow);
                }
            });
            ++n;
        }
    }

    protected void fireWindowActivated(final IWorkbenchWindow iWorkbenchWindow) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IWindowListener iWindowListener = (IWindowListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iWindowListener.windowActivated(iWorkbenchWindow);
                }
            });
            ++n;
        }
    }

    protected void fireWindowDeactivated(final IWorkbenchWindow iWorkbenchWindow) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IWindowListener iWindowListener = (IWindowListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iWindowListener.windowDeactivated(iWorkbenchWindow);
                }
            });
            ++n;
        }
    }

    private boolean busyClose(final boolean bl) {
        boolean bl2;
        this.isClosing = this.advisor.preShutdown();
        if (!bl && !this.isClosing) {
            return false;
        }
        this.isClosing = this.firePreShutdown(bl);
        if (!bl && !this.isClosing) {
            return false;
        }
        this.isClosing = this.saveAllEditors(!bl);
        if (!bl && !this.isClosing) {
            return false;
        }
        boolean bl3 = bl2 = !bl && PrefUtil.getAPIPreferenceStore().getBoolean("CLOSE_EDITORS_ON_EXIT");
        if (bl2) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    IWorkbenchWindow[] iWorkbenchWindowArray = Workbench.this.getWorkbenchWindows();
                    int n = 0;
                    while (n < iWorkbenchWindowArray.length) {
                        IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
                        int n2 = 0;
                        while (n2 < iWorkbenchPageArray.length) {
                            Workbench.this.isClosing = Workbench.this.isClosing && iWorkbenchPageArray[n2].closeAllEditors(false);
                            ++n2;
                        }
                        ++n;
                    }
                }
            });
            if (!bl && !this.isClosing) {
                return false;
            }
        }
        if (this.getWorkbenchConfigurer().getSaveAndRestore()) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    XMLMemento xMLMemento = Workbench.this.recordWorkbenchState();
                    Workbench.this.saveMementoToFile(xMLMemento);
                }

                public void handleException(Throwable throwable) {
                    String string = throwable.getMessage() == null ? WorkbenchMessages.ErrorClosingNoArg : NLS.bind((String)WorkbenchMessages.ErrorClosingOneArg, (Object)throwable.getMessage());
                    if (!MessageDialog.openQuestion(null, (String)WorkbenchMessages.Error, (String)string)) {
                        Workbench.this.isClosing = false;
                    }
                }
            });
        }
        if (!bl && !this.isClosing) {
            return false;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.ErrorClosing){

            public void run() {
                if (Workbench.this.isClosing || bl) {
                    Workbench.this.isClosing = Workbench.this.windowManager.close();
                }
            }
        });
        if (!bl && !this.isClosing) {
            return false;
        }
        this.shutdown();
        this.runEventLoop = false;
        return true;
    }

    @Override
    public boolean saveAllEditors(boolean bl) {
        final boolean bl2 = bl;
        final boolean[] blArray = new boolean[]{true};
        SafeRunner.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.ErrorClosing){

            public void run() {
                IWorkbenchWindow iWorkbenchWindow;
                ProgressMonitorDialog progressMonitorDialog;
                ArrayList<ISaveablePart> arrayList = new ArrayList<ISaveablePart>();
                ArrayList<IEditorInput> arrayList2 = new ArrayList<IEditorInput>();
                IWorkbenchWindow[] iWorkbenchWindowArray = Workbench.this.getWorkbenchWindows();
                int n = 0;
                while (n < iWorkbenchWindowArray.length) {
                    progressMonitorDialog = iWorkbenchWindowArray[n].getPages();
                    int n2 = 0;
                    while (n2 < ((IWorkbenchPage[])progressMonitorDialog).length) {
                        WorkbenchPage workbenchPage = (WorkbenchPage)progressMonitorDialog[n2];
                        ISaveablePart[] iSaveablePartArray = workbenchPage.getDirtyParts();
                        int n3 = 0;
                        while (n3 < iSaveablePartArray.length) {
                            ISaveablePart iSaveablePart = iSaveablePartArray[n3];
                            if (iSaveablePart.isSaveOnCloseNeeded()) {
                                if (iSaveablePart instanceof IEditorPart) {
                                    IEditorPart iEditorPart = (IEditorPart)iSaveablePart;
                                    if (!arrayList2.contains(iEditorPart.getEditorInput())) {
                                        arrayList.add(iEditorPart);
                                        arrayList2.add(iEditorPart.getEditorInput());
                                    }
                                } else {
                                    arrayList.add(iSaveablePart);
                                }
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                    ++n;
                }
                IWorkbenchWindow iWorkbenchWindow2 = Workbench.this.getActiveWorkbenchWindow();
                if (iWorkbenchWindow2 == null && iWorkbenchWindowArray.length > 0) {
                    iWorkbenchWindow2 = iWorkbenchWindowArray[0];
                }
                if (iWorkbenchWindow2 != null) {
                    iWorkbenchWindow = iWorkbenchWindow2;
                    progressMonitorDialog = iWorkbenchWindow2;
                } else {
                    iWorkbenchWindow = new IShellProvider(){

                        public Shell getShell() {
                            return null;
                        }
                    };
                    progressMonitorDialog = new ProgressMonitorDialog(null);
                }
                blArray[0] = EditorManager.saveAll(arrayList, bl2, false, true, (IRunnableContext)progressMonitorDialog, iWorkbenchWindow);
            }
        });
        return blArray[0];
    }

    private IWorkbenchWindow busyOpenWorkbenchWindow(final String string, final IAdaptable iAdaptable) throws WorkbenchException {
        final WorkbenchWindow[] workbenchWindowArray = new WorkbenchWindow[1];
        StartupThreading.runWithWorkbenchExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                workbenchWindowArray[0] = Workbench.this.newWorkbenchWindow();
            }
        });
        final WorkbenchWindow workbenchWindow = workbenchWindowArray[0];
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                workbenchWindow.create();
            }
        });
        this.windowManager.add((Window)workbenchWindow);
        final WorkbenchException[] workbenchExceptionArray = new WorkbenchException[1];
        if (string != null) {
            StartupThreading.runWithWorkbenchExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() {
                    try {
                        workbenchWindow.busyOpenPage(string, iAdaptable);
                    }
                    catch (WorkbenchException workbenchException) {
                        Workbench.this.windowManager.remove((Window)workbenchWindow);
                        workbenchExceptionArray[0] = workbenchException;
                    }
                }
            });
        }
        if (workbenchExceptionArray[0] != null) {
            throw workbenchExceptionArray[0];
        }
        StartupThreading.runWithWorkbenchExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                workbenchWindow.open();
            }
        });
        return workbenchWindow;
    }

    @Override
    public boolean close() {
        return this.close(0, false);
    }

    boolean close(int n, final boolean bl) {
        this.returnCode = n;
        final boolean[] blArray = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                blArray[0] = Workbench.this.busyClose(bl);
            }
        });
        return blArray[0];
    }

    @Override
    public IWorkbenchWindow getActiveWorkbenchWindow() {
        Object object;
        if (Display.getCurrent() == null) {
            return null;
        }
        Shell shell = this.display.getActiveShell();
        while (shell != null) {
            object = shell.getData();
            if (object instanceof IWorkbenchWindow) {
                return (IWorkbenchWindow)object;
            }
            shell = shell.getParent();
        }
        object = this.getActivatedWindow();
        if (object != null) {
            return object;
        }
        Shell[] shellArray = this.display.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Object object2 = shellArray[n].getData();
            if (object2 instanceof IWorkbenchWindow) {
                return (IWorkbenchWindow)object2;
            }
            ++n;
        }
        return null;
    }

    public EditorHistory getEditorHistory() {
        if (this.editorHistory == null) {
            this.editorHistory = new EditorHistory();
        }
        return this.editorHistory;
    }

    @Override
    public IEditorRegistry getEditorRegistry() {
        return WorkbenchPlugin.getDefault().getEditorRegistry();
    }

    private int getNewWindowNumber() {
        Window[] windowArray = this.windowManager.getWindows();
        int n = windowArray.length;
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            WorkbenchWindow workbenchWindow;
            int n3;
            if (windowArray[n2] instanceof WorkbenchWindow && (n3 = (workbenchWindow = (WorkbenchWindow)windowArray[n2]).getNumber() - 1) >= 0 && n3 < n) {
                blArray[n3] = true;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (!blArray[n2]) {
                return n2 + 1;
            }
            ++n2;
        }
        return n + 1;
    }

    @Override
    public IWorkbenchOperationSupport getOperationSupport() {
        return WorkbenchPlugin.getDefault().getOperationSupport();
    }

    @Override
    public IPerspectiveRegistry getPerspectiveRegistry() {
        return WorkbenchPlugin.getDefault().getPerspectiveRegistry();
    }

    @Override
    public PreferenceManager getPreferenceManager() {
        return WorkbenchPlugin.getDefault().getPreferenceManager();
    }

    @Override
    public IPreferenceStore getPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    @Override
    public ISharedImages getSharedImages() {
        return WorkbenchPlugin.getDefault().getSharedImages();
    }

    WindowManager getWindowManager() {
        return this.windowManager;
    }

    private File getWorkbenchStateFile() {
        IPath iPath = WorkbenchPlugin.getDefault().getDataLocation();
        if (iPath == null) {
            return null;
        }
        iPath = iPath.append(DEFAULT_WORKBENCH_STATE_FILENAME);
        return iPath.toFile();
    }

    @Override
    public int getWorkbenchWindowCount() {
        if (this.windowManager == null) {
            return 0;
        }
        return this.windowManager.getWindowCount();
    }

    @Override
    public IWorkbenchWindow[] getWorkbenchWindows() {
        if (this.windowManager == null) {
            return new IWorkbenchWindow[0];
        }
        Window[] windowArray = this.windowManager.getWindows();
        IWorkbenchWindow[] iWorkbenchWindowArray = new IWorkbenchWindow[windowArray.length];
        System.arraycopy(windowArray, 0, iWorkbenchWindowArray, 0, windowArray.length);
        return iWorkbenchWindowArray;
    }

    @Override
    public IWorkingSetManager getWorkingSetManager() {
        return WorkbenchPlugin.getDefault().getWorkingSetManager();
    }

    @Override
    public ILocalWorkingSetManager createLocalWorkingSetManager() {
        return new LocalWorkingSetManager(WorkbenchPlugin.getDefault().getBundleContext());
    }

    private boolean init() {
        Object object;
        if (WorkbenchPlugin.getDefault().isDebugging()) {
            WorkbenchPlugin.DEBUG = true;
            ModalContext.setDebugMode((boolean)true);
        }
        JFaceUtil.initializeJFacePreferences();
        this.windowManager = new WindowManager();
        IIntroRegistry iIntroRegistry = WorkbenchPlugin.getDefault().getIntroRegistry();
        if (iIntroRegistry.getIntroCount() > 0 && (object = Platform.getProduct()) != null) {
            this.introDescriptor = (IntroDescriptor)iIntroRegistry.getIntroForProduct(object.getId());
        }
        object = new EvaluationService();
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable((EvaluationService)object){
            private final /* synthetic */ EvaluationService val$evaluationService;
            {
                this.val$evaluationService = evaluationService;
            }

            @Override
            public void runWithException() {
                Workbench.this.serviceLocator.registerService(IEvaluationService.class, this.val$evaluationService);
            }
        });
        this.workbenchActivitySupport = new WorkbenchActivitySupport();
        this.activityHelper = ActivityPersistanceHelper.getInstance();
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                WorkbenchImages.getImageRegistry();
            }
        });
        this.initializeDefaultServices();
        this.initializeFonts();
        this.initializeColors();
        this.initializeApplicationColors();
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                Workbench.this.advisor.internalBasicInitialize(Workbench.this.getWorkbenchConfigurer());
            }
        });
        boolean bl = PrefUtil.getInternalPreferenceStore().getBoolean("COLOR_ICONS");
        ActionContributionItem.setUseColorIconsInToolbars((boolean)bl);
        this.initializeSingleClickOption();
        this.initializeWorkbenchImages();
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                ((GrabFocus)Tweaklets.get(GrabFocus.KEY)).init(Workbench.this.getDisplay());
            }
        });
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                Workbench.this.startSourceProviders();
            }
        });
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                Workbench.this.activateWorkbenchContext();
            }
        });
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                Workbench.this.createApplicationMenu();
            }
        });
        try {
            UIStats.start(4, "Workbench");
            final boolean[] blArray = new boolean[1];
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    Workbench.this.advisor.preStartup();
                    if (Workbench.this.isClosing() || !Workbench.this.advisor.openWindows()) {
                        blArray[0] = true;
                    }
                }
            });
            if (blArray[0]) {
                return false;
            }
        }
        finally {
            UIStats.end(4, this, "Workbench");
        }
        this.forceOpenPerspective();
        return true;
    }

    private void initializeWorkbenchImages() {
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                WorkbenchImages.getDescriptors();
            }
        });
    }

    private void initializeCommandResolver() {
        ExternalActionManager.getInstance().setCallback((ExternalActionManager.ICallback)new ExternalActionManager.CommandCallback(this.bindingManager, this.commandManager, new ExternalActionManager.IActiveChecker(){

            public final boolean isActive(String string) {
                return Workbench.this.workbenchActivitySupport.getActivityManager().getIdentifier(string).isEnabled();
            }
        }, new ExternalActionManager.IExecuteApplicable(){

            public boolean isApplicable(IAction iAction) {
                return !(iAction instanceof CommandAction);
            }
        }));
    }

    private void initializeApplicationColors() {
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                ColorDefinition[] colorDefinitionArray = WorkbenchPlugin.getDefault().getThemeRegistry().getColors();
                ThemeElementHelper.populateRegistry(Workbench.this.getThemeManager().getTheme("org.eclipse.ui.defaultTheme"), colorDefinitionArray, PrefUtil.getInternalPreferenceStore());
            }
        });
    }

    private void initializeSingleClickOption() {
        int n;
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("OPEN_ON_SINGLE_CLICK");
        boolean bl2 = iPreferenceStore.getBoolean("SELECT_ON_HOVER");
        boolean bl3 = iPreferenceStore.getBoolean("OPEN_AFTER_DELAY");
        int n2 = n = bl ? 1 : 0;
        if (bl) {
            if (bl2) {
                n |= 2;
            }
            if (bl3) {
                n |= 4;
            }
        }
        OpenStrategy.setOpenMethod((int)n);
    }

    private void initializeFonts() {
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                FontDefinition[] fontDefinitionArray = WorkbenchPlugin.getDefault().getThemeRegistry().getFonts();
                ThemeElementHelper.populateRegistry(Workbench.this.getThemeManager().getCurrentTheme(), fontDefinitionArray, PrefUtil.getInternalPreferenceStore());
            }
        });
    }

    private static void initializeImages() {
        ImageDescriptor[] imageDescriptorArray = WorkbenchPlugin.getDefault().getWindowImages();
        if (imageDescriptorArray == null) {
            return;
        }
        Image[] imageArray = new Image[imageDescriptorArray.length];
        int n = 0;
        while (n < imageDescriptorArray.length) {
            imageArray[n] = imageDescriptorArray[n].createImage();
            ++n;
        }
        Window.setDefaultImages((Image[])imageArray);
    }

    private void uninitializeImages() {
        WorkbenchImages.dispose();
        Image[] imageArray = Window.getDefaultImages();
        Window.setDefaultImage(null);
        int n = 0;
        while (n < imageArray.length) {
            imageArray[n].dispose();
            ++n;
        }
    }

    private void initializeColors() {
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                WorkbenchColors.startup();
            }
        });
    }

    @Override
    public boolean isClosing() {
        return this.isClosing;
    }

    private final void initializeDefaultServices() {
        ContributionService contributionService = new ContributionService(this.getAdvisor());
        this.serviceLocator.registerService(IContributionService.class, contributionService);
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                Workbench.this.serviceLocator.registerService(ISaveablesLifecycleListener.class, new SaveablesList());
            }
        });
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                Workbench.this.getProgressService();
            }
        });
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                Command.DEBUG_COMMAND_EXECUTION = Policy.DEBUG_COMMANDS;
                Workbench.this.commandManager = new CommandManager();
            }
        });
        final CommandService[] commandServiceArray = new CommandService[1];
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                commandServiceArray[0] = new CommandService(Workbench.this.commandManager);
                commandServiceArray[0].readRegistry();
                Workbench.this.serviceLocator.registerService(ICommandService.class, commandServiceArray[0]);
            }
        });
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                ContextManager.DEBUG = Policy.DEBUG_CONTEXTS;
                Workbench.this.contextManager = new ContextManager();
            }
        });
        final ContextService contextService = new ContextService(this.contextManager);
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                contextService.readRegistry();
            }
        });
        this.serviceLocator.registerService(IContextService.class, contextService);
        final IBindingService[] iBindingServiceArray = new BindingService[1];
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                BindingManager.DEBUG = Policy.DEBUG_KEY_BINDINGS;
                Workbench.this.bindingManager = new BindingManager(Workbench.this.contextManager, Workbench.this.commandManager);
                iBindingServiceArray[0] = new BindingService(Workbench.this.bindingManager, commandServiceArray[0], Workbench.this);
            }
        });
        iBindingServiceArray[0].readRegistryAndPreferences(commandServiceArray[0]);
        this.serviceLocator.registerService(IBindingService.class, iBindingServiceArray[0]);
        ((BindingService)iBindingServiceArray[0]).getKeyboard().getKeyDownFilter().setEnabled(true);
        CommandImageManager commandImageManager = new CommandImageManager();
        CommandImageService commandImageService = new CommandImageService(commandImageManager, commandServiceArray[0]);
        commandImageService.readRegistry();
        this.serviceLocator.registerService(ICommandImageService.class, commandImageService);
        final WorkbenchMenuService workbenchMenuService = new WorkbenchMenuService(this.serviceLocator);
        this.serviceLocator.registerService(IMenuService.class, workbenchMenuService);
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                workbenchMenuService.readRegistry();
            }
        });
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                Workbench.this.initializeSourcePriorities();
            }
        });
        final IHandlerService[] iHandlerServiceArray = new IHandlerService[1];
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                iHandlerServiceArray[0] = (IHandlerService)Workbench.this.serviceLocator.getService(IHandlerService.class);
            }
        });
        this.workbenchContextSupport = new WorkbenchContextSupport(this, this.contextManager);
        this.workbenchCommandSupport = new WorkbenchCommandSupport(this.bindingManager, this.commandManager, this.contextManager, iHandlerServiceArray[0]);
        this.initializeCommandResolver();
        this.addWindowListener(this.windowListener);
        this.bindingManager.addBindingManagerListener(this.bindingManagerListener);
        this.serviceLocator.registerService(ISelectionConversionService.class, new SelectionConversionService());
    }

    @Override
    public boolean isStarting() {
        return this.isStarting && this.isRunning();
    }

    private WorkbenchWindow newWorkbenchWindow() {
        WorkbenchWindow workbenchWindow = ((WorkbenchImplementation)Tweaklets.get(WorkbenchImplementation.KEY)).createWorkbenchWindow(this.getNewWindowNumber());
        return workbenchWindow;
    }

    private void forceOpenPerspective() {
        if (this.getWorkbenchWindowCount() == 0) {
            return;
        }
        String string = null;
        String[] stringArray = Platform.getCommandLineArgs();
        int n = 0;
        while (n < stringArray.length - 1) {
            if (stringArray[n].equalsIgnoreCase("-perspective")) {
                string = stringArray[n + 1];
                break;
            }
            ++n;
        }
        if (string == null) {
            return;
        }
        IPerspectiveDescriptor iPerspectiveDescriptor = this.getPerspectiveRegistry().findPerspectiveWithId(string);
        if (iPerspectiveDescriptor == null) {
            return;
        }
        IWorkbenchWindow iWorkbenchWindow = this.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            iWorkbenchWindow = this.getWorkbenchWindows()[0];
        }
        final String string2 = string;
        final IWorkbenchWindow iWorkbenchWindow2 = iWorkbenchWindow;
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() throws Throwable {
                try {
                    Workbench.this.showPerspective(string2, iWorkbenchWindow2);
                }
                catch (WorkbenchException workbenchException) {
                    String string = "Workbench exception showing specified command line perspective on startup.";
                    WorkbenchPlugin.log(string, (IStatus)new Status(4, "org.eclipse.ui", 0, string, (Throwable)((Object)workbenchException)));
                }
            }
        });
    }

    void openFirstTimeWindow() {
        boolean bl = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_PROGRESS_ON_STARTUP");
        if (!bl) {
            this.doOpenFirstTimeWindow();
        } else {
            int n = Math.max(1, WorkbenchPlugin.getDefault().getBundleCount() / 10);
            this.runStartupWithProgress(n, new Runnable(){

                @Override
                public void run() {
                    Workbench.this.doOpenFirstTimeWindow();
                }
            });
        }
    }

    private void runStartupWithProgress(int n, Runnable runnable) {
        this.progressCount = 0;
        AbstractSplashHandler abstractSplashHandler = Workbench.getSplash();
        IProgressMonitor iProgressMonitor = null;
        if (abstractSplashHandler != null) {
            iProgressMonitor = abstractSplashHandler.getBundleProgressMonitor();
        }
        if (iProgressMonitor == null) {
            runnable.run();
        } else {
            Shell shell = null;
            if (abstractSplashHandler != null) {
                shell = abstractSplashHandler.getSplash();
            }
            iProgressMonitor = new TaskBarDelegatingProgressMontior(iProgressMonitor, shell);
            iProgressMonitor.beginTask("", n);
            StartupProgressBundleListener startupProgressBundleListener = new StartupProgressBundleListener(iProgressMonitor, (int)((double)n * 0.95));
            WorkbenchPlugin.getDefault().addBundleListener((BundleListener)startupProgressBundleListener);
            try {
                runnable.run();
                iProgressMonitor.subTask(WorkbenchMessages.Startup_Done);
                int n2 = n - Math.min(this.progressCount, (int)((double)n * 0.95));
                iProgressMonitor.worked(n2);
                iProgressMonitor.done();
            }
            finally {
                WorkbenchPlugin.getDefault().removeBundleListener((BundleListener)startupProgressBundleListener);
            }
        }
    }

    private void doOpenFirstTimeWindow() {
        try {
            final IAdaptable[] iAdaptableArray = new IAdaptable[1];
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    iAdaptableArray[0] = Workbench.this.getDefaultPageInput();
                }
            });
            this.busyOpenWorkbenchWindow(this.getPerspectiveRegistry().getDefaultPerspective(), iAdaptableArray[0]);
        }
        catch (WorkbenchException workbenchException) {
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    ErrorDialog.openError(null, (String)WorkbenchMessages.Problems_Opening_Page, (String)workbenchException.getMessage(), (IStatus)workbenchException.getStatus());
                }
            });
        }
    }

    IStatus restoreState() {
        if (!this.getWorkbenchConfigurer().getSaveAndRestore()) {
            String string = WorkbenchMessages.Workbench_restoreDisabled;
            return new Status(2, WorkbenchPlugin.PI_WORKBENCH, 1, string, null);
        }
        final File file = this.getWorkbenchStateFile();
        if (file == null || !file.exists()) {
            String string = WorkbenchMessages.Workbench_noStateToRestore;
            return new Status(2, WorkbenchPlugin.PI_WORKBENCH, 1, string, null);
        }
        final IStatus[] iStatusArray = new IStatus[]{Status.OK_STATUS};
        SafeRunner.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.ErrorReadingState){

            public void run() throws Exception {
                FileInputStream fileInputStream = new FileInputStream(file);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf-8"));
                XMLMemento xMLMemento = XMLMemento.createReadRoot(bufferedReader);
                String string = xMLMemento.getString("version");
                boolean bl = false;
                int n = 0;
                while (n < VERSION_STRING.length) {
                    if (VERSION_STRING[n].equals(string)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    bufferedReader.close();
                    String string2 = WorkbenchMessages.Invalid_workbench_state_ve;
                    MessageDialog.openError(null, (String)WorkbenchMessages.Restoring_Problems, (String)string2);
                    file.delete();
                    iStatusArray[0] = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, string2, null);
                    return;
                }
                if (VERSION_STRING[0].equals(string)) {
                    boolean bl2;
                    bufferedReader.close();
                    String string3 = WorkbenchMessages.Workbench_incompatibleSavedStateVersion;
                    boolean bl3 = bl2 = new MessageDialog(null, WorkbenchMessages.Workbench_incompatibleUIState, null, string3, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0).open() == 0;
                    if (bl2) {
                        file.delete();
                        iStatusArray[0] = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 1, string3, null);
                    } else {
                        iStatusArray[0] = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 2, string3, null);
                    }
                    return;
                }
                final IStatus iStatus = Workbench.this.restoreState(xMLMemento);
                bufferedReader.close();
                if (iStatus.getSeverity() == 4) {
                    StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                        @Override
                        public void runWithException() throws Throwable {
                            StatusManager.getManager().handle(iStatus, 1);
                        }
                    });
                }
            }

            public void handleException(final Throwable throwable) {
                StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                    @Override
                    public void runWithException() {
                        this.handle(throwable);
                        String string = throwable.getMessage() == null ? "" : throwable.getMessage();
                        iStatusArray[0] = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, string, throwable);
                        file.delete();
                    }
                });
            }

            private void handle(Throwable throwable) {
                super.handleException(throwable);
            }
        });
        if (this.shouldReturnNoWindowError(iStatusArray[0])) {
            String string = WorkbenchMessages.Workbench_noWindowsRestored;
            iStatusArray[0] = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, string, null);
        }
        return iStatusArray[0];
    }

    private boolean shouldReturnNoWindowError(IStatus iStatus) {
        final boolean[] blArray = new boolean[1];
        boolean bl = blArray[0] = iStatus.isOK() && this.windowManager.getWindows().length == 0;
        if (blArray[0]) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    blArray[0] = !Workbench.this.hasAppMenu();
                }
            });
        }
        return blArray[0];
    }

    @Override
    public IWorkbenchWindow openWorkbenchWindow(IAdaptable iAdaptable) throws WorkbenchException {
        return this.openWorkbenchWindow(this.getPerspectiveRegistry().getDefaultPerspective(), iAdaptable);
    }

    @Override
    public IWorkbenchWindow openWorkbenchWindow(final String string, final IAdaptable iAdaptable) throws WorkbenchException {
        final Object[] objectArray = new Object[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    objectArray[0] = Workbench.this.busyOpenWorkbenchWindow(string, iAdaptable);
                }
                catch (WorkbenchException workbenchException) {
                    objectArray[0] = workbenchException;
                }
            }
        });
        if (objectArray[0] instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)objectArray[0];
        }
        if (objectArray[0] instanceof WorkbenchException) {
            throw (WorkbenchException)((Object)objectArray[0]);
        }
        throw new WorkbenchException(WorkbenchMessages.Abnormal_Workbench_Conditi);
    }

    IWorkbenchWindow restoreWorkbenchWindow(IMemento iMemento) throws WorkbenchException {
        WorkbenchWindow workbenchWindow = this.newWorkbenchWindow();
        workbenchWindow.create();
        this.windowManager.add((Window)workbenchWindow);
        boolean bl = false;
        try {
            workbenchWindow.restoreState(iMemento, null);
            workbenchWindow.fireWindowRestored();
            workbenchWindow.open();
            bl = true;
        }
        finally {
            if (!bl) {
                workbenchWindow.close();
            }
        }
        return workbenchWindow;
    }

    private XMLMemento recordWorkbenchState() {
        XMLMemento xMLMemento = XMLMemento.createWriteRoot("workbench");
        final IStatus iStatus = this.saveState(xMLMemento);
        if (iStatus.getSeverity() != 0) {
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    ErrorDialog.openError(null, (String)WorkbenchMessages.Workbench_problemsSaving, (String)WorkbenchMessages.Workbench_problemsSavingMsg, (IStatus)iStatus);
                }
            });
        }
        return xMLMemento;
    }

    @Override
    public boolean restart() {
        return this.close(1, false);
    }

    private IStatus restoreState(final IMemento iMemento) {
        final MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Workbench_problemsRestoring, null);
        boolean bl = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_PROGRESS_ON_STARTUP");
        try {
            if (!bl) {
                this.doRestoreState(iMemento, multiStatus);
            } else {
                Integer n = iMemento.getInteger("progressCount");
                int n2 = Math.max(1, n == null ? WorkbenchPlugin.getDefault().getBundleCount() / 2 : n);
                this.runStartupWithProgress(n2, new Runnable(){

                    @Override
                    public void run() {
                        Workbench.this.doRestoreState(iMemento, multiStatus);
                    }
                });
            }
        }
        finally {
            this.openWindowsAfterRestore();
        }
        return multiStatus;
    }

    public ContributionInfo[] getEarlyActivatedPlugins() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "startup");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        ArrayList<String> arrayList = new ArrayList<String>(iExtensionArray.length);
        int n = 0;
        while (n < iExtensionArray.length) {
            String string = iExtensionArray[n].getNamespace();
            if (!arrayList.contains(string)) {
                arrayList.add(string);
            }
            ++n;
        }
        ContributionInfo[] contributionInfoArray = new ContributionInfo[arrayList.size()];
        int n2 = 0;
        while (n2 < contributionInfoArray.length) {
            contributionInfoArray[n2] = new ContributionInfo((String)arrayList.get(n2), ContributionInfoMessages.ContributionInfo_EarlyStartupPlugin, null);
            ++n2;
        }
        return contributionInfoArray;
    }

    public String[] getDisabledEarlyActivatedPlugins() {
        String string = PrefUtil.getInternalPreferenceStore().getString("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
        return Util.getArrayFromList(string, ";");
    }

    private void initializeSourcePriorities() {
        WorkbenchServiceRegistry.getRegistry().initializeSourcePriorities();
    }

    private void startSourceProviders() {
        final IEvaluationService iEvaluationService = (IEvaluationService)this.serviceLocator.getService(IEvaluationService.class);
        final IContextService iContextService = (IContextService)this.serviceLocator.getService(IContextService.class);
        final SourceProviderService sourceProviderService = new SourceProviderService(this.serviceLocator);
        this.serviceLocator.registerService(ISourceProviderService.class, sourceProviderService);
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                sourceProviderService.readRegistry();
                ISourceProvider[] iSourceProviderArray = sourceProviderService.getSourceProviders();
                int n = 0;
                while (n < iSourceProviderArray.length) {
                    iEvaluationService.addSourceProvider(iSourceProviderArray[n]);
                    if (!(iSourceProviderArray[n] instanceof ActiveContextSourceProvider)) {
                        iContextService.addSourceProvider(iSourceProviderArray[n]);
                    }
                    ++n;
                }
            }

            public void handleException(Throwable throwable) {
                WorkbenchPlugin.log("Failed to initialize a source provider", throwable);
            }
        });
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                Workbench.this.actionSetSourceProvider = (ActionSetSourceProvider)sourceProviderService.getSourceProvider("activeActionSets");
                FocusControlSourceProvider focusControlSourceProvider = (FocusControlSourceProvider)sourceProviderService.getSourceProvider("activeFocusControlId");
                Workbench.this.serviceLocator.registerService(IFocusService.class, focusControlSourceProvider);
                Workbench.this.menuSourceProvider = (MenuSourceProvider)sourceProviderService.getSourceProvider("activeMenu");
            }

            public void handleException(Throwable throwable) {
                WorkbenchPlugin.log("Failed to initialize a source provider", throwable);
            }
        });
    }

    private void startPlugins() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.ui", "startup");
        final IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        if (iExtensionArray.length == 0) {
            return;
        }
        Job job = new Job("Workbench early startup"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                HashSet<String> hashSet = new HashSet<String>(Arrays.asList(Workbench.this.getDisabledEarlyActivatedPlugins()));
                iProgressMonitor.beginTask(WorkbenchMessages.Workbench_startingPlugins, iExtensionArray.length);
                int n = 0;
                while (n < iExtensionArray.length) {
                    if (iProgressMonitor.isCanceled() || !Workbench.this.isRunning()) {
                        return Status.CANCEL_STATUS;
                    }
                    IExtension iExtension = iExtensionArray[n];
                    if (!hashSet.contains(iExtension.getNamespace())) {
                        iProgressMonitor.subTask(iExtension.getNamespace());
                        SafeRunner.run((ISafeRunnable)new EarlyStartupRunnable(iExtension));
                    }
                    iProgressMonitor.worked(1);
                    ++n;
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object object) {
                return Workbench.EARLY_STARTUP_FAMILY.equals(object);
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private int runUI() {
        Object object;
        Object object2;
        UISynchronizer uISynchronizer;
        UILockListener uILockListener;
        UIStats.start(5, "Workbench");
        boolean bl = true;
        String[] stringArray = Platform.getCommandLineArgs();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-allowDeadlock")) {
                bl = false;
            }
            ++n;
        }
        if (bl) {
            uILockListener = new UILockListener(this.display);
            Job.getJobManager().setLockListener((LockListener)uILockListener);
            uISynchronizer = new UISynchronizer(this.display, uILockListener);
            this.display.setSynchronizer((Synchronizer)uISynchronizer);
            UISynchronizer.startupThread.set(Boolean.TRUE);
        } else {
            uISynchronizer = null;
        }
        if (createSplash) {
            this.createSplashWrapper();
        }
        if (BundleUtility.isReady((Bundle)(uILockListener = Platform.getBundle((String)"org.eclipse.e4.ui.css.swt.theme")))) {
            try {
                object2 = uILockListener.loadClass("org.eclipse.e4.ui.css.swt.internal.theme.BootstrapTheme3x");
                object = ((Class)object2).getConstructor(Display.class);
                ((Constructor)object).newInstance(this.display);
            }
            catch (Exception exception) {
                WorkbenchPlugin.log(StatusUtil.newStatus(2, "Could not start styling support.", (Throwable)exception));
            }
        }
        ModalContext.setAllowReadAndDispatch((boolean)false);
        if (WorkbenchPlugin.getDefault().isDebugging()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (Workbench.this.isStarting()) {
                        WorkbenchPlugin.log(StatusUtil.newStatus(2, "Event loop should not be run while the Workbench is starting.", (Throwable)new RuntimeException()));
                    }
                }
            });
        }
        object2 = new Listener(){

            public void handleEvent(Event event) {
                event.doit = Workbench.this.close();
            }
        };
        object = ExceptionHandler.getInstance();
        try {
            try {
                this.display.addListener(21, (Listener)object2);
                Window.setExceptionHandler((Window.IExceptionHandler)object);
                final boolean[] blArray = new boolean[1];
                if (Workbench.getSplash() != null) {
                    final boolean[] blArray2 = new boolean[1];
                    final Throwable[] throwableArray = new Throwable[1];
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                try {
                                    UISynchronizer.startupThread.set(Boolean.TRUE);
                                    blArray[0] = Workbench.this.init();
                                }
                                catch (Throwable throwable) {
                                    throwableArray[0] = throwable;
                                    blArray2[0] = true;
                                    Workbench.this.display.wake();
                                }
                            }
                            finally {
                                blArray2[0] = true;
                                Workbench.this.display.wake();
                            }
                        }
                    };
                    thread.start();
                    while (true) {
                        if (this.display.readAndDispatch()) {
                            continue;
                        }
                        if (blArray2[0]) break;
                        this.display.sleep();
                    }
                    Throwable throwable = throwableArray[0];
                    if (throwable != null) {
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                        if (throwable instanceof Exception) {
                            throw (Exception)throwable;
                        }
                        throw new Error(throwable);
                    }
                } else {
                    blArray[0] = this.init();
                }
                Platform.endSplash();
                if (blArray[0]) {
                    this.advisor.postStartup();
                }
                if (blArray[0] && this.runEventLoop) {
                    this.workbenchService = WorkbenchPlugin.getDefault().getBundleContext().registerService(IWorkbench.class.getName(), (Object)this, null);
                    this.startPlugins();
                    this.addStartupRegistryListener();
                    this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            UIStats.end(5, this, "Workbench");
                            UIStats.startupComplete();
                        }
                    });
                    Workbench.getWorkbenchTestable().init(this.display, this);
                    ModalContext.setAllowReadAndDispatch((boolean)true);
                    this.isStarting = false;
                    if (uISynchronizer != null) {
                        uISynchronizer.started();
                    }
                    this.runEventLoop((Window.IExceptionHandler)object, this.display);
                }
            }
            catch (Exception exception) {
                if (!this.display.isDisposed()) {
                    object.handleException((Throwable)exception);
                } else {
                    String string = "Exception in Workbench.runUI after display was disposed";
                    WorkbenchPlugin.log(string, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, string, (Throwable)exception));
                }
                this.runEventLoop = false;
                if (!this.display.isDisposed()) {
                    this.display.removeListener(21, (Listener)object2);
                }
            }
        }
        finally {
            this.runEventLoop = false;
            if (!this.display.isDisposed()) {
                this.display.removeListener(21, (Listener)object2);
            }
        }
        return this.returnCode;
    }

    private void runEventLoop(Window.IExceptionHandler iExceptionHandler, Display display) {
        this.runEventLoop = true;
        while (this.runEventLoop) {
            try {
                if (display.readAndDispatch()) continue;
                this.getAdvisor().eventLoopIdle(display);
            }
            catch (Throwable throwable) {
                iExceptionHandler.handleException(throwable);
                if (!display.isDisposed()) continue;
                this.runEventLoop = false;
            }
        }
    }

    private IStatus saveState(IMemento iMemento) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Workbench_problemsSaving, null);
        iMemento.putString("version", VERSION_STRING[1]);
        if (this.progressCount != -1) {
            iMemento.putInteger("progressCount", this.progressCount);
        }
        IMemento iMemento2 = iMemento.createChild("workbenchAdvisor");
        multiStatus.add(this.getAdvisor().saveState(iMemento2));
        IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindowArray[n];
            IMemento iMemento3 = iMemento.createChild("window");
            multiStatus.merge(workbenchWindow.saveState(iMemento3));
            ++n;
        }
        multiStatus.add(this.getEditorHistory().saveState(iMemento.createChild("mruList")));
        return multiStatus;
    }

    private boolean saveMementoToFile(XMLMemento xMLMemento) {
        File file = this.getWorkbenchStateFile();
        if (file == null) {
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
            xMLMemento.save(outputStreamWriter);
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            file.delete();
            MessageDialog.openError(null, (String)WorkbenchMessages.SavingProblem, (String)WorkbenchMessages.ProblemSavingState);
            return false;
        }
        return true;
    }

    @Override
    public IWorkbenchPage showPerspective(String string, IWorkbenchWindow iWorkbenchWindow) throws WorkbenchException {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object[] objectArray;
        WorkbenchPage workbenchPage;
        Assert.isNotNull((Object)string);
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindow;
        if (workbenchWindow != null && (workbenchPage = workbenchWindow.getActiveWorkbenchPage()) != null) {
            objectArray = workbenchPage.getOpenPerspectives();
            n = 0;
            while (n < objectArray.length) {
                object3 = objectArray[n];
                if (string.equals(object3.getId())) {
                    workbenchWindow.makeVisible();
                    workbenchPage.setPerspective((IPerspectiveDescriptor)object3);
                    return workbenchPage;
                }
                ++n;
            }
        }
        workbenchPage = this.getDefaultPageInput();
        objectArray = this.getWorkbenchWindows();
        n = 0;
        while (n < objectArray.length) {
            workbenchWindow = (WorkbenchWindow)objectArray[n];
            if (iWorkbenchWindow != workbenchWindow && (object3 = workbenchWindow.getActiveWorkbenchPage()) != null) {
                boolean bl = false;
                bl = workbenchPage == null ? ((WorkbenchPage)object3).getInput() == null : workbenchPage.equals(((WorkbenchPage)object3).getInput());
                if (bl && (object2 = ((WorkbenchPage)object3).getActivePerspective()) != null && (object = ((Perspective)object2).getDesc()) != null && string.equals(object.getId())) {
                    Shell shell = workbenchWindow.getShell();
                    shell.open();
                    if (shell.getMinimized()) {
                        shell.setMinimized(false);
                    }
                    return object3;
                }
            }
            ++n;
        }
        workbenchWindow = (WorkbenchWindow)iWorkbenchWindow;
        if (workbenchWindow != null) {
            IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
            int n2 = iPreferenceStore.getInt("OPEN_PERSPECTIVE_MODE");
            IWorkbenchPage iWorkbenchPage = workbenchWindow.getActiveWorkbenchPage();
            object2 = null;
            if (iWorkbenchPage != null) {
                object2 = iWorkbenchPage.getPerspective();
            }
            if (2 == n2 && object2 != null) {
                object = this.openWorkbenchWindow(string, (IAdaptable)workbenchPage);
                return object.getActivePage();
            }
            object = this.getPerspectiveRegistry().findPerspectiveWithId(string);
            if (object == null) {
                throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)string));
            }
            workbenchWindow.getShell().open();
            if (iWorkbenchPage == null) {
                iWorkbenchPage = workbenchWindow.openPage(string, (IAdaptable)workbenchPage);
            } else {
                iWorkbenchPage.setPerspective((IPerspectiveDescriptor)object);
            }
            return iWorkbenchPage;
        }
        throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.Workbench_showPerspectiveError, (Object)string));
    }

    @Override
    public IWorkbenchPage showPerspective(String string, IWorkbenchWindow iWorkbenchWindow, IAdaptable iAdaptable) throws WorkbenchException {
        IPreferenceStore iPreferenceStore;
        int n;
        Object object;
        int n2;
        Object object2;
        int n3;
        IWorkbenchWindow[] iWorkbenchWindowArray;
        Assert.isNotNull((Object)string);
        boolean bl = false;
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindow;
        if (workbenchWindow != null && (iWorkbenchWindowArray = workbenchWindow.getActiveWorkbenchPage()) != null) {
            n3 = 0;
            n3 = iAdaptable == null ? (iWorkbenchWindowArray.getInput() == null ? 1 : 0) : (int)(iAdaptable.equals(iWorkbenchWindowArray.getInput()) ? 1 : 0);
            if (n3 != 0) {
                bl = true;
                object2 = iWorkbenchWindowArray.getOpenPerspectives();
                n2 = 0;
                while (n2 < ((IPerspectiveDescriptor[])object2).length) {
                    object = object2[n2];
                    if (string.equals(object.getId())) {
                        workbenchWindow.makeVisible();
                        iWorkbenchWindowArray.setPerspective((IPerspectiveDescriptor)object);
                        return iWorkbenchWindowArray;
                    }
                    ++n2;
                }
            }
        }
        iWorkbenchWindowArray = this.getWorkbenchWindows();
        n3 = 0;
        while (n3 < iWorkbenchWindowArray.length) {
            workbenchWindow = (WorkbenchWindow)iWorkbenchWindowArray[n3];
            if (iWorkbenchWindow != workbenchWindow && (object2 = workbenchWindow.getActiveWorkbenchPage()) != null) {
                IPerspectiveDescriptor iPerspectiveDescriptor;
                n2 = 0;
                n2 = iAdaptable == null ? (((WorkbenchPage)object2).getInput() == null ? 1 : 0) : (int)(iAdaptable.equals(((WorkbenchPage)object2).getInput()) ? 1 : 0);
                if (n2 != 0 && (object = ((WorkbenchPage)object2).getActivePerspective()) != null && (iPerspectiveDescriptor = ((Perspective)object).getDesc()) != null && string.equals(iPerspectiveDescriptor.getId())) {
                    workbenchWindow.getShell().open();
                    return object2;
                }
            }
            ++n3;
        }
        workbenchWindow = (WorkbenchWindow)iWorkbenchWindow;
        if (bl && workbenchWindow != null && 2 != (n = (iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore()).getInt("OPEN_PERSPECTIVE_MODE"))) {
            IWorkbenchPage iWorkbenchPage = workbenchWindow.getActiveWorkbenchPage();
            object = this.getPerspectiveRegistry().findPerspectiveWithId(string);
            if (object == null) {
                throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)string));
            }
            workbenchWindow.getShell().open();
            if (iWorkbenchPage == null) {
                iWorkbenchPage = workbenchWindow.openPage(string, iAdaptable);
            } else {
                iWorkbenchPage.setPerspective((IPerspectiveDescriptor)object);
            }
            return iWorkbenchPage;
        }
        if (workbenchWindow != null) {
            IWorkbenchPage iWorkbenchPage = workbenchWindow.getActiveWorkbenchPage();
            IPerspectiveDescriptor iPerspectiveDescriptor = null;
            if (iWorkbenchPage != null) {
                iPerspectiveDescriptor = iWorkbenchPage.getPerspective();
            }
            if (iPerspectiveDescriptor == null) {
                IPerspectiveDescriptor iPerspectiveDescriptor2 = this.getPerspectiveRegistry().findPerspectiveWithId(string);
                if (iPerspectiveDescriptor2 == null) {
                    throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)string));
                }
                workbenchWindow.getShell().open();
                if (iWorkbenchPage == null) {
                    iWorkbenchPage = workbenchWindow.openPage(string, iAdaptable);
                } else {
                    iWorkbenchPage.setPerspective(iPerspectiveDescriptor2);
                }
                return iWorkbenchPage;
            }
        }
        IWorkbenchWindow iWorkbenchWindow2 = this.openWorkbenchWindow(string, iAdaptable);
        return iWorkbenchWindow2.getActivePage();
    }

    private void shutdown() {
        try {
            this.advisor.postShutdown();
        }
        catch (Exception exception) {
            StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, "Exceptions during shutdown", (Throwable)exception));
        }
        this.firePostShutdown();
        this.workbenchListeners.clear();
        this.cancelEarlyStartup();
        if (this.workbenchService != null) {
            this.workbenchService.unregister();
        }
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this.extensionEventHandler);
        Platform.getExtensionRegistry().removeRegistryChangeListener(this.startupRegistryListener);
        ((GrabFocus)Tweaklets.get(GrabFocus.KEY)).dispose();
        this.deactivateWorkbenchContext();
        this.disposeApplicationMenu();
        this.serviceLocator.dispose();
        this.workbenchActivitySupport.dispose();
        WorkbenchHelpSystem.disposeIfNecessary();
        WorkbenchColors.shutdown();
        this.activityHelper.shutdown();
        this.uninitializeImages();
        if (WorkbenchPlugin.getDefault() != null) {
            WorkbenchPlugin.getDefault().reset();
        }
        WorkbenchThemeManager.getInstance().dispose();
        PropertyPageContributorManager.getManager().dispose();
        ObjectActionContributorManager.getManager().dispose();
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    private void cancelEarlyStartup() {
        Job.getJobManager().cancel((Object)EARLY_STARTUP_FAMILY);
    }

    @Override
    public IDecoratorManager getDecoratorManager() {
        return WorkbenchPlugin.getDefault().getDecoratorManager();
    }

    private WorkbenchWindow getActivatedWindow() {
        Shell shell;
        if (this.activatedWindow != null && (shell = this.activatedWindow.getShell()) != null && !shell.isDisposed()) {
            return this.activatedWindow;
        }
        return null;
    }

    void setActivatedWindow(WorkbenchWindow workbenchWindow) {
        this.activatedWindow = workbenchWindow;
    }

    WorkbenchConfigurer getWorkbenchConfigurer() {
        if (this.workbenchConfigurer == null) {
            this.workbenchConfigurer = new WorkbenchConfigurer();
        }
        return this.workbenchConfigurer;
    }

    WorkbenchAdvisor getAdvisor() {
        return this.advisor;
    }

    @Override
    public Display getDisplay() {
        return this.display;
    }

    public String getDefaultPerspectiveId() {
        return this.getAdvisor().getInitialWindowPerspectiveId();
    }

    public IAdaptable getDefaultPageInput() {
        return this.getAdvisor().getDefaultPageInput();
    }

    public String getMainPreferencePageId() {
        String string = this.getAdvisor().getMainPreferencePageId();
        return string;
    }

    @Override
    public IElementFactory getElementFactory(String string) {
        Assert.isNotNull((Object)string);
        return WorkbenchPlugin.getDefault().getElementFactory(string);
    }

    @Override
    public IProgressService getProgressService() {
        return ProgressManager.getInstance();
    }

    @Override
    public IWorkbenchActivitySupport getActivitySupport() {
        return this.workbenchActivitySupport;
    }

    @Override
    public IWorkbenchCommandSupport getCommandSupport() {
        return this.workbenchCommandSupport;
    }

    @Override
    public IWorkbenchContextSupport getContextSupport() {
        return this.workbenchContextSupport;
    }

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    private void updateActiveWorkbenchWindowMenuManager(boolean bl) {
        ActionSetsEvent actionSetsEvent;
        if (this.activeWorkbenchWindow != null) {
            if (this.actionSetSourceProvider != null) {
                this.activeWorkbenchWindow.removeActionSetsListener(this.actionSetSourceProvider);
            }
            this.activeWorkbenchWindow = null;
        }
        boolean bl2 = false;
        IWorkbenchWindow iWorkbenchWindow = this.getActiveWorkbenchWindow();
        if (iWorkbenchWindow instanceof WorkbenchWindow) {
            Object object;
            this.activeWorkbenchWindow = (WorkbenchWindow)iWorkbenchWindow;
            if (this.activeWorkbenchWindow.isClosing()) {
                return;
            }
            actionSetsEvent = this.activeWorkbenchWindow.getShell();
            Shell shell = this.getDisplay().getActiveShell();
            IContextService iContextService = (IContextService)this.getService(IContextService.class);
            if ((Util.equals(actionSetsEvent, shell) || iContextService.getShellType(shell) == 2) && this.actionSetSourceProvider != null) {
                this.activeWorkbenchWindow.addActionSetsListener(this.actionSetSourceProvider);
                object = this.activeWorkbenchWindow.getActiveWorkbenchPage();
                if (object != null) {
                    IActionSetDescriptor[] iActionSetDescriptorArray = ((WorkbenchPage)object).getActionSets();
                    ActionSetsEvent actionSetsEvent2 = new ActionSetsEvent(iActionSetDescriptorArray);
                    this.actionSetSourceProvider.actionSetsChanged(actionSetsEvent2);
                    bl2 = true;
                }
            }
            object = this.activeWorkbenchWindow.getMenuManager();
            if (bl) {
                object.update("text");
            } else {
                object.update(true);
            }
        }
        if (!bl2 && this.actionSetSourceProvider != null) {
            actionSetsEvent = new ActionSetsEvent(null);
            this.actionSetSourceProvider.actionSetsChanged(actionSetsEvent);
        }
    }

    @Override
    public IIntroManager getIntroManager() {
        return this.getWorkbenchIntroManager();
    }

    WorkbenchIntroManager getWorkbenchIntroManager() {
        if (this.introManager == null) {
            this.introManager = new WorkbenchIntroManager(this);
        }
        return this.introManager;
    }

    public IntroDescriptor getIntroDescriptor() {
        return this.introDescriptor;
    }

    public void setIntroDescriptor(IntroDescriptor introDescriptor) {
        if (this.getIntroManager().getIntro() != null) {
            this.getIntroManager().closeIntro(this.getIntroManager().getIntro());
        }
        this.introDescriptor = introDescriptor;
    }

    @Override
    public IThemeManager getThemeManager() {
        return WorkbenchThemeManager.getInstance();
    }

    public boolean isRunning() {
        return this.runEventLoop;
    }

    public String getPresentationId() {
        if (this.factoryID != null) {
            return this.factoryID;
        }
        this.factoryID = PrefUtil.getAPIPreferenceStore().getString("presentationFactoryId");
        if (this.factoryID == null || this.factoryID.equals("")) {
            this.factoryID = "org.eclipse.ui.presentations.default";
        }
        return this.factoryID;
    }

    public final void largeUpdateStart() {
        if (this.largeUpdates++ == 0) {
            IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbenchWindows();
            int n = 0;
            while (n < iWorkbenchWindowArray.length) {
                IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n];
                if (iWorkbenchWindow instanceof WorkbenchWindow) {
                    ((WorkbenchWindow)iWorkbenchWindow).largeUpdateStart();
                }
                ++n;
            }
        }
    }

    public final void largeUpdateEnd() {
        if (--this.largeUpdates == 0) {
            IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbenchWindows();
            int n = 0;
            while (n < iWorkbenchWindowArray.length) {
                IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n];
                if (iWorkbenchWindow instanceof WorkbenchWindow) {
                    ((WorkbenchWindow)iWorkbenchWindow).largeUpdateEnd();
                }
                ++n;
            }
        }
    }

    @Override
    public IExtensionTracker getExtensionTracker() {
        if (this.tracker == null) {
            this.tracker = new UIExtensionTracker(this.getDisplay());
        }
        return this.tracker;
    }

    private void addStartupRegistryListener() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        iExtensionRegistry.addRegistryChangeListener(this.startupRegistryListener);
    }

    @Override
    public IWorkbenchHelpSystem getHelpSystem() {
        return WorkbenchHelpSystem.getInstance();
    }

    @Override
    public IWorkbenchBrowserSupport getBrowserSupport() {
        return WorkbenchBrowserSupport.getInstance();
    }

    @Override
    public IViewRegistry getViewRegistry() {
        return WorkbenchPlugin.getDefault().getViewRegistry();
    }

    @Override
    public IWizardRegistry getNewWizardRegistry() {
        return WorkbenchPlugin.getDefault().getNewWizardRegistry();
    }

    @Override
    public IWizardRegistry getImportWizardRegistry() {
        return WorkbenchPlugin.getDefault().getImportWizardRegistry();
    }

    @Override
    public IWizardRegistry getExportWizardRegistry() {
        return WorkbenchPlugin.getDefault().getExportWizardRegistry();
    }

    public final Object getAdapter(Class clazz) {
        return this.serviceLocator.getService(clazz);
    }

    private void doRestoreState(IMemento iMemento, MultiStatus multiStatus) {
        IMemento iMemento2;
        try {
            UIStats.start(4, "MRUList");
            iMemento2 = iMemento.getChild("mruList");
            if (iMemento2 != null) {
                multiStatus.add(this.getEditorHistory().restoreState(iMemento2));
            }
        }
        finally {
            UIStats.end(4, this, "MRUList");
        }
        iMemento2 = iMemento.getChild("workbenchAdvisor");
        if (iMemento2 != null) {
            multiStatus.add(this.getAdvisor().restoreState(iMemento2));
        }
        IMemento[] iMementoArray = iMemento.getChildren("window");
        this.createdWindows = new WorkbenchWindow[iMementoArray.length];
        int n = 0;
        while (n < iMementoArray.length) {
            IMemento iMemento3 = iMementoArray[n];
            final WorkbenchWindow[] workbenchWindowArray = new WorkbenchWindow[1];
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() {
                    workbenchWindowArray[0] = Workbench.this.newWorkbenchWindow();
                    workbenchWindowArray[0].create();
                }
            });
            this.createdWindows[n] = workbenchWindowArray[0];
            this.windowManager.add((Window)workbenchWindowArray[0]);
            boolean bl = false;
            try {
                multiStatus.merge(workbenchWindowArray[0].restoreState(iMemento3, null));
                try {
                    workbenchWindowArray[0].fireWindowRestored();
                }
                catch (WorkbenchException workbenchException) {
                    multiStatus.add(workbenchException.getStatus());
                }
                bl = true;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    this.createdWindows[n] = null;
                    StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(workbenchWindowArray){
                        private final /* synthetic */ WorkbenchWindow[] val$newWindow;
                        {
                            this.val$newWindow = workbenchWindowArray;
                        }

                        @Override
                        public void runWithException() throws Throwable {
                            this.val$newWindow[0].close();
                        }
                    });
                }
                throw throwable;
            }
            if (!bl) {
                this.createdWindows[n] = null;
                StartupThreading.runWithoutExceptions(new /* invalid duplicate definition of identical inner class */);
            }
            ++n;
        }
    }

    private void openWindowsAfterRestore() {
        if (this.createdWindows == null) {
            return;
        }
        int n = 0;
        while (n < this.createdWindows.length) {
            if (this.createdWindows[n] != null) {
                final WorkbenchWindow workbenchWindow = this.createdWindows[n];
                StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                    @Override
                    public void runWithException() throws Throwable {
                        boolean bl = false;
                        try {
                            workbenchWindow.open();
                            bl = true;
                        }
                        finally {
                            if (!bl) {
                                workbenchWindow.close();
                            }
                        }
                    }
                });
            }
            ++n;
        }
        this.createdWindows = null;
    }

    @Override
    public final Object getService(Class clazz) {
        return this.serviceLocator.getService(clazz);
    }

    @Override
    public final boolean hasService(Class clazz) {
        return this.serviceLocator.hasService(clazz);
    }

    public final void registerService(Class clazz, Object object) {
        this.serviceLocator.registerService(clazz, object);
    }

    public final void addShowingMenus(Set set, ISelection iSelection, ISelection iSelection2) {
        this.menuSourceProvider.addShowingMenus(set, iSelection, iSelection2);
    }

    public final void removeShowingMenus(Set set, ISelection iSelection, ISelection iSelection2) {
        this.menuSourceProvider.removeShowingMenus(set, iSelection, iSelection2);
    }

    @Override
    public boolean saveAll(IShellProvider iShellProvider, IRunnableContext iRunnableContext, ISaveableFilter iSaveableFilter, boolean bl) {
        SaveablesList saveablesList = (SaveablesList)PlatformUI.getWorkbench().getService(ISaveablesLifecycleListener.class);
        Saveable[] saveableArray = saveablesList.getOpenModels();
        List list = this.getFilteredSaveables(iSaveableFilter, saveableArray);
        if (list.isEmpty()) {
            return true;
        }
        if (!bl) {
            return !saveablesList.saveModels(list, iShellProvider, iRunnableContext);
        }
        return !saveablesList.promptForSaving(list, iShellProvider, iRunnableContext, true, false);
    }

    private List getFilteredSaveables(ISaveableFilter iSaveableFilter, Saveable[] saveableArray) {
        ArrayList<Saveable> arrayList = new ArrayList<Saveable>();
        if (iSaveableFilter == null) {
            int n = 0;
            while (n < saveableArray.length) {
                Saveable saveable = saveableArray[n];
                if (saveable.isDirty()) {
                    arrayList.add(saveable);
                }
                ++n;
            }
        } else {
            SaveablesList saveablesList = (SaveablesList)this.getService(ISaveablesLifecycleListener.class);
            int n = 0;
            while (n < saveableArray.length) {
                IWorkbenchPart[] iWorkbenchPartArray;
                Saveable saveable = saveableArray[n];
                if (saveable.isDirty() && this.matchesFilter(iSaveableFilter, saveable, iWorkbenchPartArray = saveablesList.getPartsForSaveable(saveable))) {
                    arrayList.add(saveable);
                }
                ++n;
            }
        }
        return arrayList;
    }

    private boolean matchesFilter(ISaveableFilter iSaveableFilter, Saveable saveable, IWorkbenchPart[] iWorkbenchPartArray) {
        return iSaveableFilter == null || iSaveableFilter.select(saveable, iWorkbenchPartArray);
    }

    public ServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    @Override
    public IShellProvider getModalDialogShellProvider() {
        return new IShellProvider(){

            public Shell getShell() {
                return ProgressManagerUtil.getDefaultParent();
            }
        };
    }

    private void createApplicationMenu() {
        if (!this.hasAppMenu()) {
            return;
        }
        this.applicationMenuMgr = new ApplicationMenuManager(this.getAppMenu());
        IMenuService iMenuService = (IMenuService)this.serviceLocator.getService(IMenuService.class);
        iMenuService.populateContributionManager((ContributionManager)this.applicationMenuMgr, "menu:org.eclipse.ui.workbench.menu");
        this.applicationMenuMgr.update(true);
    }

    private void disposeApplicationMenu() {
        if (this.applicationMenuMgr == null) {
            return;
        }
        IMenuService iMenuService = (IMenuService)this.serviceLocator.getService(IMenuService.class);
        iMenuService.releaseContributions((ContributionManager)this.applicationMenuMgr);
        this.applicationMenuMgr.dispose();
    }

    private void activateWorkbenchContext() {
        IContextService iContextService = (IContextService)this.serviceLocator.getService(IContextService.class);
        this.workbenchContext = iContextService.activateContext("org.eclipse.ui.contexts.workbenchMenu");
    }

    private void deactivateWorkbenchContext() {
        if (this.workbenchContext == null) {
            return;
        }
        this.workbenchContext.getContextService().deactivateContext(this.workbenchContext);
    }

    public boolean hasAppMenu() {
        if (this.getAppMenu() == null) {
            return false;
        }
        return !this.getWorkbenchConfigurer().getExitOnLastWindowClose();
    }

    private Menu getAppMenu() {
        return this.getDisplay().getMenuBar();
    }

    /* synthetic */ Workbench(Display display, WorkbenchAdvisor workbenchAdvisor, Workbench workbench) {
        this(display, workbenchAdvisor);
    }

    private final class StartupProgressBundleListener
    implements SynchronousBundleListener {
        private final IProgressMonitor progressMonitor;
        private final int maximumProgressCount;
        private final List starting;

        StartupProgressBundleListener(IProgressMonitor iProgressMonitor, int n) {
            this.progressMonitor = iProgressMonitor;
            this.maximumProgressCount = n;
            this.starting = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleChanged(BundleEvent bundleEvent) {
            String string;
            int n = bundleEvent.getType();
            Object object = this;
            synchronized (object) {
                if (n == 128) {
                    string = bundleEvent.getBundle().getSymbolicName();
                    this.starting.add(string);
                } else if (n == 2) {
                    int n2;
                    Workbench workbench = Workbench.this;
                    workbench.progressCount = workbench.progressCount + 1;
                    if (Workbench.this.progressCount <= this.maximumProgressCount) {
                        this.progressMonitor.worked(1);
                    }
                    if ((n2 = this.starting.lastIndexOf(bundleEvent.getBundle().getSymbolicName())) >= 0) {
                        this.starting.remove(n2);
                    }
                    if (n2 != this.starting.size()) {
                        return;
                    }
                    string = n2 == 0 ? null : (String)this.starting.get(n2 - 1);
                } else {
                    return;
                }
            }
            object = string == null ? WorkbenchMessages.Startup_Loading_Workbench : NLS.bind((String)WorkbenchMessages.Startup_Loading, (Object)string);
            this.progressMonitor.subTask((String)object);
        }
    }

    private final class TaskBarDelegatingProgressMontior
    implements IProgressMonitor {
        private final Shell shell;
        private IProgressMonitor progessMonitor;
        private TaskItem systemTaskItem;
        private int totalWork;
        private int totalWorked;

        public TaskBarDelegatingProgressMontior(IProgressMonitor iProgressMonitor, Shell shell) {
            Assert.isNotNull((Object)iProgressMonitor);
            this.shell = shell;
            this.progessMonitor = iProgressMonitor;
        }

        public void beginTask(String string, int n) {
            this.progessMonitor.beginTask(string, n);
            if (this.totalWork == 0) {
                this.totalWork = n;
            }
        }

        public void worked(int n) {
            this.progessMonitor.worked(n);
            this.totalWorked += n;
            if (Display.getCurrent() != null) {
                this.handleTaskBarProgressUpdated();
            } else if (Workbench.this.getDisplay() != null && !Workbench.this.getDisplay().isDisposed()) {
                Workbench.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TaskBarDelegatingProgressMontior.this.handleTaskBarProgressUpdated();
                    }
                });
            }
        }

        public void done() {
            this.progessMonitor.done();
            if (Display.getCurrent() != null) {
                this.handleTaskBarProgressDone();
            } else if (Workbench.this.getDisplay() != null && !Workbench.this.getDisplay().isDisposed()) {
                Workbench.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TaskBarDelegatingProgressMontior.this.handleTaskBarProgressDone();
                    }
                });
            }
        }

        private TaskItem getTaskItem(Shell shell) {
            TaskBar taskBar;
            if (Display.getCurrent() == null) {
                return null;
            }
            if (this.systemTaskItem == null && Workbench.this.getDisplay() != null && shell != null && !shell.isDisposed() && (taskBar = Workbench.this.getDisplay().getSystemTaskBar()) != null) {
                this.systemTaskItem = taskBar.getItem(shell);
                if (this.systemTaskItem == null) {
                    this.systemTaskItem = taskBar.getItem(null);
                }
            }
            return this.systemTaskItem;
        }

        private void handleTaskBarProgressUpdated() {
            if (this.systemTaskItem == null) {
                this.systemTaskItem = this.getTaskItem(this.shell);
            }
            if (this.systemTaskItem != null && !this.systemTaskItem.isDisposed()) {
                if (this.systemTaskItem.getProgressState() != 0) {
                    this.systemTaskItem.setProgressState(0);
                }
                float f = (float)this.totalWorked / (float)this.totalWork * 100.0f;
                this.systemTaskItem.setProgress(Math.round(f));
            }
        }

        private void handleTaskBarProgressDone() {
            if (this.systemTaskItem == null) {
                this.systemTaskItem = this.getTaskItem(this.shell);
            }
            if (this.systemTaskItem != null && !this.systemTaskItem.isDisposed() && this.systemTaskItem.getProgressState() != -1) {
                this.systemTaskItem.setProgressState(-1);
            }
        }

        public void internalWorked(double d) {
            this.progessMonitor.internalWorked(d);
        }

        public boolean isCanceled() {
            return this.progessMonitor.isCanceled();
        }

        public void setCanceled(boolean bl) {
            this.progessMonitor.setCanceled(bl);
        }

        public void setTaskName(String string) {
            this.progessMonitor.setTaskName(string);
        }

        public void subTask(String string) {
            this.progessMonitor.subTask(string);
        }
    }
}

