/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.AbstractPartSelectionTracker;

public class WindowPartSelectionTracker
extends AbstractPartSelectionTracker
implements IPageListener {
    private IWorkbenchWindow fWindow;
    private final INullSelectionListener selListener = new INullSelectionListener(){

        @Override
        public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
            WindowPartSelectionTracker.this.fireSelection(iWorkbenchPart, iSelection);
        }
    };
    private final INullSelectionListener postSelListener = new INullSelectionListener(){

        @Override
        public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
            WindowPartSelectionTracker.this.firePostSelection(iWorkbenchPart, iSelection);
        }
    };

    public WindowPartSelectionTracker(IWorkbenchWindow iWorkbenchWindow, String string) {
        super(string);
        this.setWindow(iWorkbenchWindow);
        iWorkbenchWindow.addPageListener(this);
        IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindow.getPages();
        int n = 0;
        while (n < iWorkbenchPageArray.length) {
            this.pageOpened(iWorkbenchPageArray[n]);
            ++n;
        }
    }

    @Override
    public void pageActivated(IWorkbenchPage iWorkbenchPage) {
    }

    @Override
    public void pageClosed(IWorkbenchPage iWorkbenchPage) {
        iWorkbenchPage.removeSelectionListener(this.getPartId(), this.selListener);
        iWorkbenchPage.removePostSelectionListener(this.getPartId(), this.postSelListener);
    }

    @Override
    public void pageOpened(IWorkbenchPage iWorkbenchPage) {
        iWorkbenchPage.addSelectionListener(this.getPartId(), this.selListener);
        iWorkbenchPage.addPostSelectionListener(this.getPartId(), this.postSelListener);
    }

    private void setWindow(IWorkbenchWindow iWorkbenchWindow) {
        this.fWindow = iWorkbenchWindow;
    }

    protected IWorkbenchWindow getWindow() {
        return this.fWindow;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fWindow = null;
    }

    @Override
    public ISelection getSelection() {
        IWorkbenchPage iWorkbenchPage = this.getWindow().getActivePage();
        if (iWorkbenchPage != null) {
            return iWorkbenchPage.getSelection(this.getPartId());
        }
        return null;
    }
}

