/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.PartService;
import org.eclipse.ui.internal.WindowSelectionService;
import org.eclipse.ui.internal.WorkbenchPage;

public class WWinPartService
implements IPartService {
    private PartService partService = new PartService("org.eclipse.ui/listeners/IWorkbenchWindow.IPartListener", "org.eclipse.ui/listeners/IWorkbenchWindow.IPartListener2");
    private WindowSelectionService selectionService;
    private IWorkbenchPage activePage;
    private IPartListener2 partListner = new WWinListener();

    public WWinPartService(IWorkbenchWindow iWorkbenchWindow) {
        this.selectionService = new WindowSelectionService(iWorkbenchWindow);
    }

    @Override
    public void addPartListener(IPartListener iPartListener) {
        this.partService.addPartListener(iPartListener);
    }

    @Override
    public void addPartListener(IPartListener2 iPartListener2) {
        this.partService.addPartListener(iPartListener2);
    }

    @Override
    public void removePartListener(IPartListener iPartListener) {
        this.partService.removePartListener(iPartListener);
    }

    @Override
    public void removePartListener(IPartListener2 iPartListener2) {
        this.partService.removePartListener(iPartListener2);
    }

    @Override
    public IWorkbenchPart getActivePart() {
        return this.partService.getActivePart();
    }

    private void updateActivePart() {
        IWorkbenchPartReference iWorkbenchPartReference = null;
        IWorkbenchPart iWorkbenchPart = null;
        if (this.activePage != null) {
            iWorkbenchPart = this.activePage.getActivePart();
            iWorkbenchPartReference = this.activePage.getActivePartReference();
        }
        this.partService.setActivePart(iWorkbenchPartReference);
        this.selectionService.setActivePart(iWorkbenchPart);
    }

    @Override
    public IWorkbenchPartReference getActivePartReference() {
        return this.partService.getActivePartReference();
    }

    ISelectionService getSelectionService() {
        return this.selectionService;
    }

    void pageActivated(IWorkbenchPage iWorkbenchPage) {
        if (iWorkbenchPage == this.activePage) {
            return;
        }
        if (iWorkbenchPage != null) {
            IWorkbenchPartReference[] iWorkbenchPartReferenceArray = ((WorkbenchPage)iWorkbenchPage).getOpenParts();
            int n = 0;
            while (n < iWorkbenchPartReferenceArray.length) {
                IWorkbenchPartReference iWorkbenchPartReference = iWorkbenchPartReferenceArray[n];
                this.partService.firePartOpened(iWorkbenchPartReference);
                IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
                if (iWorkbenchPart != null && iWorkbenchPage.isPartVisible(iWorkbenchPart)) {
                    this.partService.firePartVisible(iWorkbenchPartReference);
                }
                ++n;
            }
            this.partService.setActivePart(iWorkbenchPage.getActivePartReference());
            this.selectionService.setActivePart(iWorkbenchPage.getActivePart());
        } else {
            this.partService.setActivePart(null);
            this.selectionService.setActivePart(null);
        }
        this.reset();
        this.activePage = iWorkbenchPage;
        if (iWorkbenchPage != null) {
            iWorkbenchPage.addPartListener(this.partListner);
        }
    }

    void pageClosed(IWorkbenchPage iWorkbenchPage) {
        if (iWorkbenchPage == this.activePage) {
            this.reset();
        }
    }

    void pageOpened(IWorkbenchPage iWorkbenchPage) {
        this.pageActivated(iWorkbenchPage);
    }

    private void reset() {
        IWorkbenchPage iWorkbenchPage = this.activePage;
        this.activePage = null;
        if (iWorkbenchPage != null) {
            WorkbenchPage workbenchPage = (WorkbenchPage)iWorkbenchPage;
            IWorkbenchPartReference[] iWorkbenchPartReferenceArray = workbenchPage.getOpenParts();
            int n = 0;
            while (n < iWorkbenchPartReferenceArray.length) {
                IWorkbenchPartReference iWorkbenchPartReference = iWorkbenchPartReferenceArray[n];
                if (workbenchPage.isPartVisible(iWorkbenchPartReference)) {
                    this.partService.firePartHidden(iWorkbenchPartReference);
                }
                this.partService.firePartClosed(iWorkbenchPartReference);
                ++n;
            }
            iWorkbenchPage.removePartListener(this.partListner);
        }
    }

    private class WWinListener
    implements IPartListener2,
    IPageChangedListener {
        private WWinListener() {
        }

        @Override
        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            WWinPartService.this.updateActivePart();
        }

        @Override
        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            WWinPartService.this.partService.firePartBroughtToTop(iWorkbenchPartReference);
        }

        @Override
        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
            WWinPartService.this.partService.firePartClosed(iWorkbenchPartReference);
        }

        @Override
        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
            WWinPartService.this.updateActivePart();
        }

        @Override
        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
            WWinPartService.this.partService.firePartOpened(iWorkbenchPartReference);
        }

        @Override
        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            WWinPartService.this.partService.firePartHidden(iWorkbenchPartReference);
        }

        @Override
        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            WWinPartService.this.partService.firePartVisible(iWorkbenchPartReference);
        }

        @Override
        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
            WWinPartService.this.partService.firePartInputChanged(iWorkbenchPartReference);
        }

        public void pageChanged(PageChangedEvent pageChangedEvent) {
            WWinPartService.this.partService.firePageChanged(pageChangedEvent);
        }
    }
}

