/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.PluginActionBuilder;

public class ViewerActionBuilder
extends PluginActionBuilder {
    private ISelectionProvider provider;
    private IWorkbenchPart part;

    @Override
    protected ActionDescriptor createActionDescriptor(IConfigurationElement iConfigurationElement) {
        if (this.part instanceof IViewPart) {
            return new ActionDescriptor(iConfigurationElement, 2, this.part);
        }
        return new ActionDescriptor(iConfigurationElement, 4, this.part);
    }

    @Override
    protected PluginActionBuilder.BasicContribution createContribution() {
        return new ViewerContribution(this.provider);
    }

    public void dispose() {
        if (this.cache != null) {
            int n = 0;
            while (n < this.cache.size()) {
                ((PluginActionBuilder.BasicContribution)this.cache.get(n)).dispose();
                ++n;
            }
            this.cache = null;
        }
    }

    @Override
    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getName();
        if (this.currentContribution != null && string.equals("visibility")) {
            ((ViewerContribution)this.currentContribution).setVisibilityTest(iConfigurationElement);
            return true;
        }
        return super.readElement(iConfigurationElement);
    }

    public boolean readViewerContributions(String string, ISelectionProvider iSelectionProvider, IWorkbenchPart iWorkbenchPart) {
        Assert.isTrue((iWorkbenchPart instanceof IViewPart || iWorkbenchPart instanceof IEditorPart ? 1 : 0) != 0);
        this.provider = iSelectionProvider;
        this.part = iWorkbenchPart;
        this.readContributions(string, "viewerContribution", "popupMenus");
        return this.cache != null;
    }

    private static class ViewerContribution
    extends PluginActionBuilder.BasicContribution
    implements ISelectionChangedListener {
        private ISelectionProvider selProvider;
        private ActionExpression visibilityTest;

        public ViewerContribution(ISelectionProvider iSelectionProvider) {
            this.selProvider = iSelectionProvider;
            if (iSelectionProvider != null) {
                iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void setVisibilityTest(IConfigurationElement iConfigurationElement) {
            this.visibilityTest = new ActionExpression(iConfigurationElement);
        }

        @Override
        public void contribute(IMenuManager iMenuManager, boolean bl, IToolBarManager iToolBarManager, boolean bl2) {
            boolean bl3 = true;
            if (this.visibilityTest != null) {
                ISelection iSelection = this.selProvider.getSelection();
                bl3 = iSelection instanceof IStructuredSelection ? this.visibilityTest.isEnabledFor((IStructuredSelection)iSelection) : this.visibilityTest.isEnabledFor(iSelection);
            }
            if (bl3) {
                super.contribute(iMenuManager, bl, iToolBarManager, bl2);
            }
        }

        @Override
        public void dispose() {
            if (this.selProvider != null) {
                this.selProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            this.disposeActions();
            super.dispose();
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            if (this.actions != null && this.actions != null) {
                int n = 0;
                while (n < this.actions.size()) {
                    PluginAction pluginAction = ((ActionDescriptor)this.actions.get(n)).getAction();
                    pluginAction.selectionChanged(selectionChangedEvent);
                    ++n;
                }
            }
        }
    }
}

