/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.FastViewDnDHandler;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ShowFastViewContribution;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.TrimToolBarBase;

public class ViewStackTrimToolBar
extends TrimToolBarBase {
    private boolean restoreOnUnzoom = false;
    private int paneOrientation;
    private String selectedTabId;

    public ViewStackTrimToolBar(String string, int n, int n2, WorkbenchWindow workbenchWindow) {
        super(string, n, workbenchWindow);
        this.paneOrientation = n2;
        this.dock(n);
    }

    protected void restoreToPresentation() {
        Perspective perspective = this.wbw.getActiveWorkbenchPage().getActivePerspective();
        LayoutPart layoutPart = perspective.getPresentation().findPart(this.getId(), null);
        if (layoutPart instanceof ContainerPlaceholder) {
            ViewStack viewStack = (ViewStack)((ContainerPlaceholder)layoutPart).getRealContainer();
            viewStack.setMinimized(false);
        }
    }

    @Override
    public void initToolBarManager(final ToolBarManager toolBarManager) {
        ContributionItem contributionItem = new ContributionItem(){

            public void fill(ToolBar toolBar, int n) {
                ToolItem toolItem = new ToolItem(toolBarManager.getControl(), 8, n);
                Image image = WorkbenchImages.getImage("IMG_ETOOL_RESTORE_TRIMPART");
                toolItem.setImage(image);
                String string = WorkbenchMessages.StandardSystemToolbar_Restore;
                toolItem.setToolTipText(string);
                toolItem.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                        ViewStackTrimToolBar.this.restoreToPresentation();
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        ViewStackTrimToolBar.this.restoreToPresentation();
                    }
                });
            }
        };
        toolBarManager.add((IContributionItem)contributionItem);
        ShowFastViewContribution showFastViewContribution = new ShowFastViewContribution(this.wbw, this.getId());
        toolBarManager.add((IContributionItem)showFastViewContribution);
        toolBarManager.setContextMenuManager(new MenuManager());
        MenuManager menuManager = toolBarManager.getContextMenuManager();
        ContributionItem contributionItem2 = new ContributionItem(){

            public void fill(Menu menu, int n) {
                MenuItem menuItem = new MenuItem(menu, 0, n++);
                menuItem.setText(WorkbenchMessages.WorkbenchWindow_close);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        WorkbenchPage workbenchPage;
                        IViewReference iViewReference = null;
                        if (ViewStackTrimToolBar.this.contextToolItem != null) {
                            iViewReference = (IViewReference)ViewStackTrimToolBar.this.contextToolItem.getData("FastView");
                        }
                        if (iViewReference != null && (workbenchPage = ViewStackTrimToolBar.this.wbw.getActiveWorkbenchPage()) != null) {
                            workbenchPage.hideView(iViewReference);
                        }
                    }
                });
            }
        };
        menuManager.addMenuListener(new IMenuListener((IContributionItem)contributionItem2){
            private final /* synthetic */ IContributionItem val$closeContrib;
            {
                this.val$closeContrib = iContributionItem;
            }

            public void menuAboutToShow(IMenuManager iMenuManager) {
                IViewReference iViewReference = null;
                if (ViewStackTrimToolBar.this.contextToolItem != null) {
                    iViewReference = (IViewReference)ViewStackTrimToolBar.this.contextToolItem.getData("FastView");
                }
                Perspective perspective = ViewStackTrimToolBar.this.wbw.getActiveWorkbenchPage().getActivePerspective();
                this.val$closeContrib.setVisible(iViewReference != null && perspective.isCloseable(iViewReference));
                iMenuManager.update(true);
            }
        });
        menuManager.add((IContributionItem)contributionItem2);
    }

    @Override
    public void hookControl(ToolBarManager toolBarManager) {
        new FastViewDnDHandler(this.id, toolBarManager, this.wbw);
    }

    public void setRestoreOnUnzoom(boolean bl) {
        this.restoreOnUnzoom = bl;
    }

    public boolean restoreOnUnzoom() {
        return this.restoreOnUnzoom;
    }

    public void setIconSelection(IViewReference iViewReference, boolean bl) {
        ToolItem toolItem = ShowFastViewContribution.getItem(this.tbMgr.getControl(), iViewReference);
        if (toolItem != null) {
            toolItem.setSelection(bl);
            if (bl) {
                this.selectedTabId = iViewReference.getId();
                if (iViewReference.getSecondaryId() != null) {
                    this.selectedTabId = String.valueOf(this.selectedTabId) + ':' + iViewReference.getSecondaryId();
                }
            }
        }
    }

    public int getPaneOrientation() {
        return this.paneOrientation;
    }

    public void setSelectedTabId(String string) {
        this.selectedTabId = string;
    }

    public String getSelectedTabId() {
        return this.selectedTabId;
    }

    public void setOrientation(int n, WorkbenchWindow workbenchWindow) {
        IViewReference iViewReference;
        WorkbenchPage workbenchPage;
        Perspective perspective;
        if (n == this.paneOrientation) {
            return;
        }
        this.paneOrientation = n;
        if (workbenchWindow.getActivePage() instanceof WorkbenchPage && (perspective = (workbenchPage = (WorkbenchPage)workbenchWindow.getActivePage()).getActivePerspective()) != null && (iViewReference = perspective.getActiveFastView()) != null) {
            perspective.setActiveFastView(null);
            perspective.setActiveFastView(iViewReference);
        }
    }
}

