/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.internal.FastViewManager;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.internal.presentations.SystemMenuDetach;
import org.eclipse.ui.internal.presentations.SystemMenuFastView;
import org.eclipse.ui.internal.presentations.SystemMenuSize;
import org.eclipse.ui.internal.presentations.UpdatingActionContributionItem;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackPresentation;

public class ViewStack
extends PartStack {
    private boolean allowStateChanges;
    private WorkbenchPage page;
    private SystemMenuSize sizeItem = new SystemMenuSize(null);
    private SystemMenuFastView fastViewAction;
    private SystemMenuDetach detachViewAction;
    private boolean durable = false;

    @Override
    public void addSystemActions(IMenuManager iMenuManager) {
        ViewStack.appendToGroupIfPossible(iMenuManager, "misc", (ContributionItem)new UpdatingActionContributionItem(this.fastViewAction));
        ViewStack.appendToGroupIfPossible(iMenuManager, "misc", (ContributionItem)new UpdatingActionContributionItem(this.detachViewAction));
        this.sizeItem = new SystemMenuSize(this.getSelection());
        ViewStack.appendToGroupIfPossible(iMenuManager, "size", this.sizeItem);
    }

    public ViewStack(WorkbenchPage workbenchPage) {
        this(workbenchPage, true);
    }

    public ViewStack(WorkbenchPage workbenchPage, boolean bl) {
        this(workbenchPage, bl, 2, null);
    }

    public ViewStack(WorkbenchPage workbenchPage, boolean bl, int n, AbstractPresentationFactory abstractPresentationFactory) {
        super(n, abstractPresentationFactory);
        this.page = workbenchPage;
        this.setID(this.toString());
        this.allowStateChanges = bl;
        this.fastViewAction = new SystemMenuFastView(this.getPresentationSite());
        this.detachViewAction = new SystemMenuDetach(this.getPresentationSite());
    }

    @Override
    protected WorkbenchPage getPage() {
        return this.page;
    }

    @Override
    protected boolean canMoveFolder() {
        Perspective perspective = this.page.getActivePerspective();
        if (perspective == null) {
            return false;
        }
        IStackPresentationSite iStackPresentationSite = this.getPresentationSite();
        if (iStackPresentationSite != null) {
            IPresentablePart[] iPresentablePartArray = iStackPresentationSite.getPartList();
            int n = 0;
            while (n < iPresentablePartArray.length) {
                if (!iStackPresentationSite.isPartMoveable(iPresentablePartArray[n])) {
                    return false;
                }
                ++n;
            }
        }
        return !perspective.isFixedLayout();
    }

    @Override
    protected void updateActions(PresentablePart presentablePart) {
        ViewPane viewPane = null;
        if (presentablePart != null && presentablePart.getPane() instanceof ViewPane) {
            viewPane = (ViewPane)presentablePart.getPane();
        }
        this.fastViewAction.setPane(presentablePart);
        this.detachViewAction.setPane(viewPane);
        this.sizeItem.setPane(viewPane);
    }

    @Override
    public void setMinimized(boolean bl) {
        Perspective perspective = this.getPage().getActivePerspective();
        if (Perspective.useNewMinMax(perspective)) {
            FastViewManager fastViewManager = perspective.getFastViewManager();
            if (bl) {
                boolean bl2 = this.durable;
                this.durable = false;
                fastViewManager.moveToTrim(this, false);
                this.durable = bl2;
            } else {
                PartStack partStack;
                if (perspective.getPresentation().getMaximizedStack() != null && (partStack = perspective.getPresentation().getMaximizedStack()) != null) {
                    partStack.setState(2);
                }
                fastViewManager.restoreToPresentation(this.getID());
            }
        }
        super.setMinimized(bl);
    }

    @Override
    protected boolean isMoveable(IPresentablePart iPresentablePart) {
        ViewPane viewPane = (ViewPane)this.getPaneFor(iPresentablePart);
        Perspective perspective = this.page.getActivePerspective();
        if (perspective == null) {
            return true;
        }
        return perspective.isMoveable(viewPane.getViewReference());
    }

    @Override
    protected boolean supportsState(int n) {
        if (this.page.isFixedLayout()) {
            return false;
        }
        return this.allowStateChanges;
    }

    @Override
    protected void derefPart(LayoutPart layoutPart) {
        this.page.getActivePerspective().getPresentation().derefPart(layoutPart);
    }

    @Override
    protected boolean allowsDrop(PartPane partPane) {
        return partPane instanceof ViewPane;
    }

    public StackPresentation getTestPresentation() {
        return this.getPresentation();
    }

    public void setDurable(boolean bl) {
        this.durable = bl;
    }

    public boolean getDurable() {
        return this.durable;
    }
}

