/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.ErrorViewPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PartTester;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.ViewActionBars;
import org.eclipse.ui.internal.ViewActionBuilder;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.internal.testing.ContributionInfoMessages;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.testing.ContributionInfo;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

class ViewReference
extends WorkbenchPartReference
implements IViewReference {
    private final ViewFactory factory;
    String secondaryId;
    private IMemento memento;
    private ViewActionBuilder actionBuilder;

    public ViewReference(ViewFactory viewFactory, String string, String string2, IMemento iMemento) {
        this.memento = iMemento;
        this.factory = viewFactory;
        ViewDescriptor viewDescriptor = (ViewDescriptor)this.factory.viewReg.find(string);
        ImageDescriptor imageDescriptor = null;
        String string3 = null;
        if (viewDescriptor != null) {
            imageDescriptor = viewDescriptor.getImageDescriptor();
            string3 = viewDescriptor.getLabel();
        }
        String string4 = null;
        if (iMemento != null) {
            string4 = iMemento.getString("partName");
            IMemento iMemento2 = iMemento.getChild("properties");
            if (iMemento2 != null) {
                IMemento[] iMementoArray = iMemento2.getChildren("property");
                int n = 0;
                while (n < iMementoArray.length) {
                    this.propertyCache.put(iMementoArray[n].getID(), iMementoArray[n].getTextData());
                    ++n;
                }
            }
        }
        if (string4 == null) {
            string4 = string3;
        }
        this.init(string, string3, "", imageDescriptor, string4, "");
        this.secondaryId = string2;
    }

    @Override
    protected PartPane createPane() {
        return new ViewPane(this, this.factory.page);
    }

    @Override
    protected void doDisposePart() {
        IViewPart iViewPart = (IViewPart)this.part;
        super.doDisposePart();
        if (iViewPart != null) {
            IToolBarManager iToolBarManager;
            PartSite partSite = (PartSite)iViewPart.getSite();
            IActionBars iActionBars = partSite.getActionBars();
            IMenuService iMenuService = (IMenuService)partSite.getService(IMenuService.class);
            IMenuManager iMenuManager = iActionBars.getMenuManager();
            if (iMenuManager instanceof ContributionManager) {
                iMenuService.releaseContributions((ContributionManager)iMenuManager);
            }
            if ((iToolBarManager = iActionBars.getToolBarManager()) instanceof ContributionManager) {
                iMenuService.releaseContributions((ContributionManager)iToolBarManager);
            }
            if (iActionBars instanceof SubActionBars) {
                ((SubActionBars)iActionBars).dispose();
            }
            if (this.actionBuilder != null) {
                this.actionBuilder.dispose();
                this.actionBuilder = null;
            }
            partSite.dispose();
        }
    }

    @Override
    public IWorkbenchPage getPage() {
        return this.factory.page;
    }

    public String getRegisteredName() {
        if (this.part != null && this.part.getSite() != null) {
            return this.part.getSite().getRegisteredName();
        }
        IViewRegistry iViewRegistry = this.factory.viewReg;
        IViewDescriptor iViewDescriptor = iViewRegistry.find(this.getId());
        if (iViewDescriptor != null) {
            return iViewDescriptor.getLabel();
        }
        return this.getTitle();
    }

    @Override
    protected String computePartName() {
        if (this.part instanceof IWorkbenchPart2) {
            return super.computePartName();
        }
        return this.getRegisteredName();
    }

    @Override
    protected String computeContentDescription() {
        if (this.part instanceof IWorkbenchPart2) {
            return super.computeContentDescription();
        }
        String string = this.getRawTitle();
        if (!Util.equals(string, this.getRegisteredName())) {
            return string;
        }
        return "";
    }

    @Override
    public String getSecondaryId() {
        return this.secondaryId;
    }

    @Override
    public IViewPart getView(boolean bl) {
        return (IViewPart)this.getPart(bl);
    }

    @Override
    public boolean isFastView() {
        return this.factory.page.isFastView(this);
    }

    @Override
    protected IWorkbenchPart createPart() {
        IWorkbenchPart iWorkbenchPart = null;
        PartInitException partInitException = null;
        try {
            iWorkbenchPart = this.createPartHelper();
        }
        catch (PartInitException partInitException2) {
            partInitException = partInitException2;
        }
        if (partInitException != null) {
            IStatus iStatus = partInitException.getStatus();
            IStatus iStatus2 = StatusUtil.newStatus(iStatus, NLS.bind((String)WorkbenchMessages.ViewFactory_initException, (Object)iStatus.getMessage()));
            IStatus iStatus3 = StatusUtil.newStatus(iStatus, NLS.bind((String)"Unable to create view ID {0}: {1}", (Object)this.getId(), (Object)iStatus.getMessage()));
            StatusManager.getManager().handle(iStatus3);
            IViewDescriptor iViewDescriptor = this.factory.viewReg.find(this.getId());
            String string = this.getId();
            if (iViewDescriptor != null) {
                string = iViewDescriptor.getLabel();
            }
            ErrorViewPart errorViewPart = new ErrorViewPart(iStatus2);
            PartPane partPane = this.getPane();
            ViewSite viewSite = new ViewSite(this, errorViewPart, this.factory.page, this.getId(), "org.eclipse.ui", string);
            viewSite.setActionBars(new ViewActionBars(this.factory.page.getActionBars(), viewSite, (ViewPane)partPane));
            try {
                errorViewPart.init(viewSite);
            }
            catch (PartInitException partInitException3) {
                StatusUtil.handleStatus((Throwable)((Object)partInitException3), 3);
                return null;
            }
            errorViewPart.setPartName(string);
            Composite composite = (Composite)partPane.getControl();
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new FillLayout());
            try {
                errorViewPart.createPartControl(composite2);
            }
            catch (Exception exception) {
                composite2.dispose();
                StatusUtil.handleStatus(exception, 3);
                return null;
            }
            iWorkbenchPart = errorViewPart;
        }
        return iWorkbenchPart;
    }

    private IWorkbenchPart createPartHelper() throws PartInitException {
        IViewDescriptor iViewDescriptor;
        IViewPart iViewPart = null;
        IMemento iMemento = null;
        if (this.memento != null) {
            iMemento = this.memento.getChild("viewState");
        }
        if ((iViewDescriptor = this.factory.viewReg.find(this.getId())) == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.ViewFactory_couldNotCreate, (Object)this.getId()));
        }
        PartPane partPane = this.getPane();
        partPane.createControl(this.factory.page.getClientComposite());
        String string = iViewDescriptor.getLabel();
        Composite composite = null;
        IWorkbenchPart iWorkbenchPart = null;
        PartSite partSite = null;
        SubActionBars subActionBars = null;
        try {
            IViewPart iViewPart2 = null;
            try {
                UIStats.start(0, string);
                iViewPart2 = iViewDescriptor.createView();
            }
            finally {
                UIStats.end(0, iViewPart2, string);
            }
            if (iViewPart2 instanceof IWorkbenchPart3) {
                this.createPartProperties((IWorkbenchPart3)((Object)iViewPart2));
            }
            partSite = new ViewSite(this, iViewPart2, this.factory.page, iViewDescriptor);
            subActionBars = new ViewActionBars(this.factory.page.getActionBars(), partSite, (ViewPane)partPane);
            partSite.setActionBars(subActionBars);
            try {
                UIStats.start(2, string);
                iViewPart2.init((IViewSite)((Object)partSite), iMemento);
                iWorkbenchPart = iViewPart2;
            }
            finally {
                UIStats.end(2, iViewPart2, string);
            }
            if (iViewPart2.getSite() != partSite) {
                throw new PartInitException(WorkbenchMessages.ViewFactory_siteException, null);
            }
            int n = 0;
            if (iViewPart2 instanceof IWorkbenchPartOrientation) {
                n = ((IWorkbenchPartOrientation)((Object)iViewPart2)).getOrientation();
            }
            Object object = (Composite)partPane.getControl();
            ActionDescriptor[] actionDescriptorArray = (ActionDescriptor[])this.factory.viewReg.find(this.getId());
            if (actionDescriptorArray != null && actionDescriptorArray.getPluginId() != null) {
                object.setData((Object)new ContributionInfo(actionDescriptorArray.getPluginId(), ContributionInfoMessages.ContributionInfo_View, null));
            }
            composite = new Composite((Composite)object, n);
            composite.setLayout((Layout)new FillLayout());
            try {
                UIStats.start(1, string);
                iViewPart2.createPartControl(composite);
                object.layout(true);
            }
            finally {
                UIStats.end(1, iViewPart2, string);
            }
            object = (IMenuService)partSite.getService(IMenuService.class);
            object.populateContributionManager((ContributionManager)partSite.getActionBars().getMenuManager(), "menu:" + partSite.getId());
            object.populateContributionManager((ContributionManager)partSite.getActionBars().getToolBarManager(), "toolbar:" + partSite.getId());
            this.actionBuilder = new ViewActionBuilder();
            this.actionBuilder.readActionExtensions(iViewPart2);
            actionDescriptorArray = this.actionBuilder.getExtendedActions();
            IKeyBindingService iKeyBindingService = iViewPart2.getSite().getKeyBindingService();
            if (actionDescriptorArray != null) {
                int n2 = 0;
                while (n2 < actionDescriptorArray.length) {
                    PluginAction pluginAction;
                    ActionDescriptor actionDescriptor = actionDescriptorArray[n2];
                    if (actionDescriptor != null && (pluginAction = actionDescriptorArray[n2].getAction()) != null && pluginAction.getActionDefinitionId() != null) {
                        iKeyBindingService.registerAction((IAction)pluginAction);
                    }
                    ++n2;
                }
            }
            partSite.getActionBars().updateActionBars();
            PartTester.testView(iViewPart2);
            iViewPart = iViewPart2;
            object = (IConfigurationElement)Util.getAdapter(iViewDescriptor, IConfigurationElement.class);
            if (object != null) {
                this.factory.page.getExtensionTracker().registerObject(object.getDeclaringExtension(), (Object)iViewPart2, 2);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error && !(throwable instanceof LinkageError)) {
                throw (Error)throwable;
            }
            if (composite != null) {
                try {
                    composite.dispose();
                }
                catch (RuntimeException runtimeException) {
                    StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, runtimeException));
                }
            }
            if (iWorkbenchPart != null) {
                try {
                    iWorkbenchPart.dispose();
                }
                catch (RuntimeException runtimeException) {
                    StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, runtimeException));
                }
            }
            if (subActionBars != null) {
                try {
                    subActionBars.dispose();
                }
                catch (RuntimeException runtimeException) {
                    StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, runtimeException));
                }
            }
            if (partSite != null) {
                try {
                    partSite.dispose();
                }
                catch (RuntimeException runtimeException) {
                    StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, runtimeException));
                }
            }
            throw new PartInitException(WorkbenchPlugin.getStatus(throwable));
        }
        return iViewPart;
    }

    public IMemento getMemento() {
        return this.memento;
    }
}

