/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.internal.provisional.action.IToolBarManager2;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.AnimationEngine;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.FastViewManager;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.provisional.presentations.IActionBarPresentationFactory;

public class ViewPane
extends PartPane {
    private IToolBarManager2 isvToolBarMgr = null;
    private MenuManager isvMenuMgr;
    boolean hasFocus;
    private boolean hadViewMenu = false;

    public ViewPane(IViewReference iViewReference, WorkbenchPage workbenchPage) {
        super(iViewReference, workbenchPage);
        IActionBarPresentationFactory iActionBarPresentationFactory = ((WorkbenchWindow)workbenchPage.getWorkbenchWindow()).getActionBarPresentationFactory();
        this.isvToolBarMgr = iActionBarPresentationFactory.createViewToolBarManager();
    }

    @Override
    public void createControl(Composite composite) {
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            return;
        }
        super.createControl(composite);
    }

    @Override
    protected void createTitleBar() {
        this.updateTitles();
        this.getPartReference().addPropertyListener(this);
        this.createToolBars();
    }

    private void toolBarResized(Control control, int n) {
        Control control2 = this.isvToolBarMgr.getControl2();
        if (control2 != null) {
            boolean bl;
            Control control3 = this.getControl();
            boolean bl2 = bl = control3 != null && control3.isVisible() && this.toolbarIsVisible();
            if (control2.isVisible() != bl) {
                control2.setVisible(bl);
            }
        }
        this.firePropertyChange(147);
    }

    private void createToolBars() {
        Composite composite = this.control;
        Control control = this.isvToolBarMgr.createControl2(composite.getParent());
        control.setVisible(false);
        this.isvToolBarMgr.addPropertyChangeListener((IPropertyChangeListener)new ISVPropListener(control));
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (mouseEvent.widget instanceof ToolBar && ((ToolBar)mouseEvent.widget).getItem(new Point(mouseEvent.x, mouseEvent.y)) == null) {
                    ViewPane.this.doZoom();
                }
            }
        });
        control.addListener(26, (Listener)this);
        control.moveAbove((Control)this.control);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.isvMenuMgr != null) {
            this.isvMenuMgr.dispose();
        }
        if (this.isvToolBarMgr != null) {
            this.isvToolBarMgr.dispose();
        }
    }

    @Override
    public void doHide() {
        this.getPage().hideView(this.getViewReference());
    }

    Rectangle getParentBounds() {
        LayoutPart layoutPart;
        Control control = this.getControl();
        if (this.getContainer() != null && this.getContainer() instanceof LayoutPart && (layoutPart = (LayoutPart)((Object)this.getContainer())).getControl() != null) {
            control = layoutPart.getControl();
        }
        return DragUtil.getDisplayBounds(control);
    }

    public void doMakeFast() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getPage().getWorkbenchWindow();
        FastViewBar fastViewBar = workbenchWindow.getFastViewBar();
        if (fastViewBar == null || this.getPage().getActivePerspective() == null) {
            return;
        }
        Shell shell = workbenchWindow.getShell();
        AnimationEngine.createTweakedAnimation(shell, 400, this.getParentBounds(), fastViewBar.getLocationOfNextIcon());
        FastViewManager fastViewManager = this.getPage().getActivePerspective().getFastViewManager();
        fastViewManager.addViewReference(FastViewBar.FASTVIEWBAR_ID, -1, this.getViewReference(), true);
    }

    public void doRemoveFast() {
        if (this.getPage().getActivePerspective() == null) {
            return;
        }
        Shell shell = this.getControl().getShell();
        Rectangle rectangle = this.getParentBounds();
        FastViewManager fastViewManager = this.getPage().getActivePerspective().getFastViewManager();
        fastViewManager.removeViewReference(this.getViewReference(), true, true);
        IWorkbenchPart iWorkbenchPart = this.getViewReference().getPart(true);
        if (iWorkbenchPart != null) {
            this.getPage().activate(iWorkbenchPart);
        }
        Rectangle rectangle2 = this.getParentBounds();
        AnimationEngine.createTweakedAnimation(shell, 400, rectangle, rectangle2);
    }

    @Override
    protected void doDock() {
        Perspective perspective = this.getPage().getActivePerspective();
        if (perspective != null) {
            perspective.getFastViewManager().removeViewReference(this.getViewReference(), true, true);
        }
    }

    public void doDetach() {
        this.getPage().detachView(this.getViewReference());
    }

    public void doAttach() {
        this.getPage().attachView(this.getViewReference());
    }

    @Override
    public String getCompoundId() {
        IViewReference iViewReference = this.getViewReference();
        if (iViewReference != null) {
            return ViewFactory.getKey(iViewReference);
        }
        return super.getCompoundId();
    }

    public Control getDragHandle() {
        return this.control;
    }

    public MenuManager getMenuManager() {
        if (this.isvMenuMgr == null) {
            this.isvMenuMgr = new PaneMenuManager();
        }
        return this.isvMenuMgr;
    }

    public Control[] getTabList() {
        Control control = this.getControl();
        if (this.getContainer() instanceof ViewStack) {
            ViewStack viewStack = (ViewStack)this.getContainer();
            return viewStack.getTabList(this);
        }
        return new Control[]{control};
    }

    public IToolBarManager2 getToolBarManager() {
        return this.isvToolBarMgr;
    }

    public IViewReference getViewReference() {
        return (IViewReference)this.getPartReference();
    }

    public void setFast(boolean bl) {
    }

    @Override
    void shellActivated() {
    }

    @Override
    void shellDeactivated() {
    }

    void setActive(boolean bl) {
        this.hasFocus = bl;
        if (this.getContainer() instanceof PartStack) {
            ((PartStack)this.getContainer()).setActive(bl ? 1 : 0);
        }
    }

    @Override
    public void showFocus(boolean bl) {
        this.setActive(bl);
    }

    private boolean isFastView() {
        return this.page.isFastView(this.getViewReference());
    }

    boolean isMoveable() {
        return !this.page.isFixedLayout();
    }

    @Override
    public boolean hasViewMenu() {
        return this.isvMenuMgr != null && this.hadViewMenu;
    }

    @Override
    public void showViewMenu(Point point) {
        if (!this.hasViewMenu()) {
            return;
        }
        if (this.isFastView() && this.page.getActiveFastView() != this.getViewReference()) {
            return;
        }
        Menu menu = this.isvMenuMgr.createContextMenu((Control)this.getControl().getParent());
        menu.setLocation(point.x, point.y);
        menu.setVisible(true);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode());
    }

    public void updateActionBars() {
        if (this.isvMenuMgr != null) {
            this.isvMenuMgr.update(false);
        }
        if (this.isvToolBarMgr != null) {
            this.isvToolBarMgr.update(false);
        }
    }

    public void updateTitles() {
        this.firePropertyChange(1);
    }

    @Override
    public void addSizeMenuItem(Menu menu, int n) {
        if (this.isMoveable()) {
            super.addSizeMenuItem(menu, n);
        }
    }

    @Override
    protected void doZoom() {
        if (this.isMoveable()) {
            super.doZoom();
        }
    }

    @Override
    public void setContainer(ILayoutContainer iLayoutContainer) {
        ILayoutContainer iLayoutContainer2 = this.getContainer();
        if (this.hasFocus) {
            if (iLayoutContainer2 != null && iLayoutContainer2 instanceof PartStack) {
                ((PartStack)iLayoutContainer2).setActive(0);
            }
            if (iLayoutContainer != null && iLayoutContainer instanceof PartStack) {
                ((PartStack)iLayoutContainer).setActive(1);
            }
        }
        super.setContainer(iLayoutContainer);
    }

    @Override
    public void reparent(Composite composite) {
        Control control;
        super.reparent(composite);
        if (this.isvToolBarMgr != null && (control = this.isvToolBarMgr.getControl2()) != null) {
            control.setParent(composite);
            control.moveAbove((Control)this.control);
        }
    }

    @Override
    public void moveAbove(Control control) {
        super.moveAbove(control);
        Control control2 = this.internalGetToolbar();
        if (control2 != null) {
            control2.moveAbove((Control)this.control);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        Control control = this.internalGetToolbar();
        if (control != null) {
            boolean bl2 = bl && this.toolbarIsVisible();
            control.setVisible(bl2);
        }
    }

    public boolean toolbarIsVisible() {
        IToolBarManager2 iToolBarManager2 = this.getToolBarManager();
        if (iToolBarManager2 == null) {
            return false;
        }
        Control control = iToolBarManager2.getControl2();
        if (control == null || control.isDisposed()) {
            return false;
        }
        return iToolBarManager2.getItemCount() > 0;
    }

    @Override
    public void showHighlight() {
        this.firePropertyChange(148);
    }

    @Override
    public String getPlaceHolderId() {
        return ViewFactory.getKey(this.getViewReference());
    }

    @Override
    public Control getToolBar() {
        if (!this.toolbarIsVisible()) {
            return null;
        }
        return this.internalGetToolbar();
    }

    private Control internalGetToolbar() {
        if (this.isvToolBarMgr == null) {
            return null;
        }
        return this.isvToolBarMgr.getControl2();
    }

    @Override
    public boolean isCloseable() {
        Perspective perspective = this.page.getActivePerspective();
        if (perspective == null) {
            return true;
        }
        return perspective.isCloseable(this.getViewReference());
    }

    @Override
    public void showSystemMenu() {
        if (this.isFastView()) {
            Perspective perspective = this.page.getActivePerspective();
            if (perspective != null) {
                perspective.getFastViewPane().showSystemMenu();
            }
        } else {
            super.showSystemMenu();
        }
    }

    @Override
    public void showPaneMenu() {
        if (this.isFastView()) {
            Perspective perspective = this.page.getActivePerspective();
            if (perspective != null) {
                perspective.getFastViewPane().showPaneMenu();
            }
        } else {
            super.showPaneMenu();
        }
    }

    @Override
    public void removeContributions() {
        super.removeContributions();
        if (this.isvMenuMgr != null) {
            this.isvMenuMgr.removeAll();
        }
        if (this.isvToolBarMgr != null) {
            this.isvToolBarMgr.removeAll();
        }
    }

    private class ISVPropListener
    implements IPropertyChangeListener {
        private Control toolBar;

        public ISVPropListener(Control control) {
            this.toolBar = control;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            if ("PROP_LAYOUT".equals(string)) {
                ViewPane.this.toolBarResized(this.toolBar, n != null ? n : 0);
                if (this.toolBar instanceof Composite) {
                    ((Composite)this.toolBar).layout();
                } else {
                    this.toolBar.getParent().layout();
                }
            }
        }
    }

    class PaneMenuManager
    extends MenuManager {
        public PaneMenuManager() {
            super("View Local Menu");
        }

        protected void update(boolean bl, boolean bl2) {
            super.update(bl, bl2);
            boolean bl3 = false;
            IContributionItem[] iContributionItemArray = this.getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                if (iContributionItemArray[n].isVisible() && !iContributionItemArray[n].isSeparator() && !iContributionItemArray[n].isGroupMarker()) {
                    bl3 = true;
                    break;
                }
                ++n;
            }
            if (bl3 != ViewPane.this.hadViewMenu) {
                ViewPane.this.hadViewMenu = bl3;
                ViewPane.this.firePropertyChange(770);
            }
        }
    }
}

