/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.ViewIntroAdapterSite;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.intro.IntroMessages;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.part.ViewPart;

public final class ViewIntroAdapterPart
extends ViewPart {
    private IIntroPart introPart;
    private IIntroSite introSite;
    private boolean handleZoomEvents = true;

    private void addPaneListener() {
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        if (iWorkbenchPartSite instanceof PartSite) {
            final WorkbenchPartReference workbenchPartReference = (WorkbenchPartReference)((PartSite)iWorkbenchPartSite).getPartReference();
            workbenchPartReference.addInternalPropertyListener(new IPropertyListener(){

                @Override
                public void propertyChanged(Object object, int n) {
                    if (ViewIntroAdapterPart.this.handleZoomEvents && n == 533) {
                        ViewIntroAdapterPart.this.setStandby(!workbenchPartReference.getPane().isZoomed());
                    }
                }
            });
        }
    }

    public void setStandby(final boolean bl) {
        final Control control = ((PartSite)this.getSite()).getPane().getControl();
        BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    control.setRedraw(false);
                    ViewIntroAdapterPart.this.introPart.standbyStateChanged(bl);
                }
                finally {
                    control.setRedraw(true);
                }
                ViewIntroAdapterPart.this.setBarVisibility(bl);
            }
        });
    }

    public void setHandleZoomEvents(boolean bl) {
        this.handleZoomEvents = bl;
    }

    @Override
    public void createPartControl(Composite composite) {
        this.addPaneListener();
        this.introPart.createPartControl(composite);
    }

    @Override
    public void dispose() {
        this.setBarVisibility(true);
        super.dispose();
        this.getSite().getWorkbenchWindow().getWorkbench().getIntroManager().closeIntro(this.introPart);
        this.introPart.dispose();
    }

    @Override
    public Object getAdapter(Class clazz) {
        return this.introPart.getAdapter(clazz);
    }

    @Override
    public Image getTitleImage() {
        return this.introPart.getTitleImage();
    }

    @Override
    public String getTitle() {
        return this.introPart == null ? super.getTitle() : this.introPart.getTitle();
    }

    @Override
    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite);
        Workbench workbench = (Workbench)iViewSite.getWorkbenchWindow().getWorkbench();
        try {
            this.introPart = workbench.getWorkbenchIntroManager().createNewIntroPart();
            this.setPartName(this.introPart.getTitle());
            this.introPart.addPropertyListener(new IPropertyListener(){

                @Override
                public void propertyChanged(Object object, int n) {
                    ViewIntroAdapterPart.this.firePropertyChange(n);
                }
            });
            this.introSite = new ViewIntroAdapterSite(iViewSite, workbench.getIntroDescriptor());
            this.introPart.init(this.introSite, iMemento);
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log(IntroMessages.Intro_could_not_create_proxy, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, IntroMessages.Intro_could_not_create_proxy, (Throwable)coreException));
        }
    }

    @Override
    public void setFocus() {
        this.introPart.setFocus();
    }

    @Override
    public void saveState(IMemento iMemento) {
        this.introPart.saveState(iMemento);
    }

    private void setBarVisibility(boolean bl) {
        if (Platform.getWS().equals("cocoa")) {
            return;
        }
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getSite().getWorkbenchWindow();
        boolean bl2 = false;
        if (bl) {
            boolean bl3 = PrefUtil.getInternalPreferenceStore().getBoolean("coolBarVisible");
            boolean bl4 = PrefUtil.getInternalPreferenceStore().getBoolean("perspectiveBarVisible");
            bl2 = bl3 != workbenchWindow.getCoolBarVisible() || bl4 != workbenchWindow.getPerspectiveBarVisible();
            workbenchWindow.setCoolBarVisible(bl3);
            workbenchWindow.setPerspectiveBarVisible(bl4);
        } else {
            bl2 = workbenchWindow.getCoolBarVisible() || workbenchWindow.getPerspectiveBarVisible();
            workbenchWindow.setCoolBarVisible(false);
            workbenchWindow.setPerspectiveBarVisible(false);
        }
        if (bl2) {
            workbenchWindow.getShell().layout();
        }
    }
}

