/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.ReferenceCounter;
import org.eclipse.ui.internal.ViewReference;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ViewFactory
implements IExtensionChangeHandler {
    private ReferenceCounter counter;
    private HashMap mementoTable = new HashMap();
    WorkbenchPage page;
    IViewRegistry viewReg;
    static final String ID_SEP = ":";

    static String getKey(String string, String string2) {
        return string2 == null ? string : String.valueOf(string) + ID_SEP + string2;
    }

    static String getKey(IViewReference iViewReference) {
        return ViewFactory.getKey(iViewReference.getId(), iViewReference.getSecondaryId());
    }

    static String extractPrimaryId(String string) {
        int n = string.lastIndexOf(ID_SEP);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    static String extractSecondaryId(String string) {
        int n = string.lastIndexOf(ID_SEP);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    static boolean hasWildcard(String string) {
        return string.indexOf(PartPlaceholder.WILD_CARD) >= 0;
    }

    public ViewFactory(WorkbenchPage workbenchPage, IViewRegistry iViewRegistry) {
        this.page = workbenchPage;
        this.viewReg = iViewRegistry;
        this.counter = new ReferenceCounter();
        workbenchPage.getExtensionTracker().registerHandler((IExtensionChangeHandler)this, null);
    }

    public IViewReference createView(String string) throws PartInitException {
        return this.createView(string, null);
    }

    public IViewReference createView(String string, String string2) throws PartInitException {
        IViewDescriptor iViewDescriptor = this.viewReg.find(string);
        if (iViewDescriptor == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.ViewFactory_couldNotCreate, (Object)string));
        }
        if (string2 != null && !iViewDescriptor.getAllowMultiple()) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.ViewFactory_noMultiple, (Object)string));
        }
        String string3 = ViewFactory.getKey(string, string2);
        IViewReference iViewReference = (IViewReference)this.counter.get(string3);
        if (iViewReference == null) {
            IMemento iMemento = (IMemento)this.mementoTable.get(string3);
            iViewReference = new ViewReference(this, string, string2, iMemento);
            this.mementoTable.remove(string3);
            this.counter.put(string3, iViewReference);
            this.getWorkbenchPage().partAdded((ViewReference)iViewReference);
        } else {
            this.counter.addRef(string3);
        }
        return iViewReference;
    }

    public IViewReference[] getViewReferences() {
        List list = this.counter.values();
        return list.toArray(new IViewReference[list.size()]);
    }

    public IViewReference getView(String string) {
        return this.getView(string, null);
    }

    public IViewReference getView(String string, String string2) {
        String string3 = ViewFactory.getKey(string, string2);
        return (IViewReference)this.counter.get(string3);
    }

    public IViewRegistry getViewRegistry() {
        return this.viewReg;
    }

    public IViewReference[] getViews() {
        List list = this.counter.values();
        IViewReference[] iViewReferenceArray = new IViewReference[list.size()];
        list.toArray(iViewReferenceArray);
        return iViewReferenceArray;
    }

    public WorkbenchPage getWorkbenchPage() {
        return this.page;
    }

    public int getReferenceCount(IViewReference iViewReference) {
        String string = ViewFactory.getKey(iViewReference);
        IViewReference iViewReference2 = (IViewReference)this.counter.get(string);
        return iViewReference2 == null ? 0 : this.counter.getRef(string);
    }

    public void releaseView(IViewReference iViewReference) {
        String string = ViewFactory.getKey(iViewReference);
        IViewReference iViewReference2 = (IViewReference)this.counter.get(string);
        if (iViewReference2 == null) {
            return;
        }
        int n = this.counter.removeRef(string);
        if (n <= 0) {
            this.getWorkbenchPage().partRemoved((ViewReference)iViewReference2);
        }
    }

    public IStatus restoreState(IMemento iMemento) {
        IMemento[] iMementoArray = iMemento.getChildren("view");
        int n = 0;
        while (n < iMementoArray.length) {
            this.restoreViewState(iMementoArray[n]);
            ++n;
        }
        return Status.OK_STATUS;
    }

    public IStatus saveState(IMemento iMemento) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.ViewFactory_problemsSavingViews, null);
        IViewReference[] iViewReferenceArray = this.getViews();
        int n = 0;
        while (n < iViewReferenceArray.length) {
            IViewDescriptor iViewDescriptor = this.viewReg.find(iViewReferenceArray[n].getId());
            if (iViewDescriptor != null && iViewDescriptor.isRestorable()) {
                this.saveViewState(iMemento, iViewReferenceArray[n], multiStatus);
            }
            ++n;
        }
        return multiStatus;
    }

    public IMemento saveViewState(IMemento iMemento, IViewReference iViewReference, MultiStatus multiStatus) {
        final MultiStatus multiStatus2 = multiStatus;
        final IMemento iMemento2 = iMemento.createChild("view");
        iMemento2.putString("id", ViewFactory.getKey(iViewReference));
        if (iViewReference instanceof ViewReference) {
            iMemento2.putString("partName", ((ViewReference)iViewReference).getPartName());
        }
        final IViewReference iViewReference2 = iViewReference;
        final IViewPart iViewPart = (IViewPart)iViewReference.getPart(false);
        if (iViewPart != null) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    Map map;
                    if (iViewPart instanceof IWorkbenchPart3 && !(map = ((IWorkbenchPart3)((Object)iViewPart)).getPartProperties()).isEmpty()) {
                        IMemento iMemento = iMemento2.createChild("properties");
                        for (Map.Entry entry : map.entrySet()) {
                            IMemento iMemento22 = iMemento.createChild("property", (String)entry.getKey());
                            iMemento22.putTextData((String)entry.getValue());
                        }
                    }
                    iViewPart.saveState(iMemento2.createChild("viewState"));
                }

                public void handleException(Throwable throwable) {
                    multiStatus2.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.ViewFactory_couldNotSave, (Object)iViewReference2.getTitle()), throwable));
                }
            });
        } else {
            IMemento iMemento3 = null;
            IMemento iMemento4 = null;
            if (iViewReference instanceof ViewReference) {
                iMemento3 = ((ViewReference)iViewReference).getMemento();
                if (iMemento3 != null) {
                    iMemento4 = iMemento3.getChild("properties");
                }
                if (iMemento3 != null) {
                    iMemento3 = iMemento3.getChild("viewState");
                }
            }
            if (iMemento4 != null) {
                iMemento2.createChild("properties").putMemento(iMemento4);
            }
            if (iMemento3 != null) {
                IMemento iMemento5 = iMemento2.createChild("viewState");
                iMemento5.putMemento(iMemento3);
            }
        }
        return iMemento2;
    }

    public void restoreViewState(IMemento iMemento) {
        String string = iMemento.getString("id");
        this.mementoTable.put(string, iMemento);
    }

    IMemento getViewState(String string) {
        IMemento iMemento = (IMemento)this.mementoTable.get(string);
        if (iMemento == null) {
            return null;
        }
        return iMemento.getChild("viewState");
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IViewPart) {
                IViewPart iViewPart = (IViewPart)objectArray[n];
                this.page.hideView(iViewPart);
            }
            ++n;
        }
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
    }
}

