/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.themes.ColorUtil;

public class TrimFrame {
    private static int blend = 40;
    Canvas canvas = null;

    public TrimFrame(Composite composite) {
        this.createControl(composite);
    }

    private void createControl(Composite composite) {
        this.dispose();
        this.canvas = new Canvas(composite, 0);
        this.canvas.setBackground(composite.getDisplay().getSystemColor(22));
        this.canvas.addPaintListener(new PaintListener(){

            private void drawLine(GC gC, int n, int n2, int n3, int n4, boolean bl) {
                if (bl) {
                    int n5 = n;
                    n = n2;
                    n2 = n5;
                    n5 = n3;
                    n3 = n4;
                    n4 = n5;
                }
                gC.drawLine(n, n2, n3, n4);
            }

            public void paintControl(PaintEvent paintEvent) {
                Canvas canvas = (Canvas)paintEvent.widget;
                Control control = canvas.getChildren()[0];
                boolean bl = false;
                if (control instanceof ToolBar && (((ToolBar)control).getStyle() & 0x200) != 0) {
                    bl = true;
                } else if (control instanceof CoolBar && (((CoolBar)control).getStyle() & 0x200) != 0) {
                    bl = true;
                }
                Rectangle rectangle = canvas.getBounds();
                int n = rectangle.width - 1;
                int n2 = rectangle.height - 1;
                if (bl) {
                    int n3 = n;
                    n = n2;
                    n2 = n3;
                }
                Color color = paintEvent.gc.getDevice().getSystemColor(1);
                Color color2 = paintEvent.gc.getDevice().getSystemColor(18);
                RGB rGB = ColorUtil.blend(color.getRGB(), color2.getRGB(), blend);
                Color color3 = new Color(paintEvent.gc.getDevice(), rGB);
                paintEvent.gc.setForeground(color3);
                this.drawLine(paintEvent.gc, 1, 0, n - 5, 0, bl);
                this.drawLine(paintEvent.gc, n - 4, 1, n - 3, 1, bl);
                this.drawLine(paintEvent.gc, n - 2, 2, n - 2, 2, bl);
                this.drawLine(paintEvent.gc, n - 1, 3, n - 1, 4, bl);
                this.drawLine(paintEvent.gc, 1, n2, n - 5, n2, bl);
                this.drawLine(paintEvent.gc, n - 4, n2 - 1, n - 3, n2 - 1, bl);
                this.drawLine(paintEvent.gc, n - 2, n2 - 2, n - 2, n2 - 2, bl);
                this.drawLine(paintEvent.gc, n - 1, n2 - 3, n - 1, n2 - 4, bl);
                this.drawLine(paintEvent.gc, 0, 1, 0, n2 - 1, bl);
                this.drawLine(paintEvent.gc, n, 5, n, n2 - 5, bl);
                color3.dispose();
                paintEvent.gc.setForeground(color);
                this.drawLine(paintEvent.gc, 1, 1, n - 5, 1, bl);
                this.drawLine(paintEvent.gc, n - 4, 2, n - 3, 2, bl);
                this.drawLine(paintEvent.gc, n - 3, 3, n - 2, 3, bl);
                this.drawLine(paintEvent.gc, n - 2, 4, n - 2, 4, bl);
                this.drawLine(paintEvent.gc, 1, n2 - 1, n - 5, n2 - 1, bl);
                this.drawLine(paintEvent.gc, n - 4, n2 - 2, n - 3, n2 - 2, bl);
                this.drawLine(paintEvent.gc, n - 3, n2 - 3, n - 2, n2 - 3, bl);
                this.drawLine(paintEvent.gc, n - 2, n2 - 4, n - 2, n2 - 4, bl);
                this.drawLine(paintEvent.gc, 1, 1, 1, n2 - 1, bl);
                this.drawLine(paintEvent.gc, n - 1, 5, n - 1, n2 - 5, bl);
            }
        });
        this.canvas.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
                Control[] controlArray = composite.getChildren();
                if (controlArray.length == 0) {
                    return new Point(0, 0);
                }
                Point point = controlArray[0].computeSize(n2, n, bl);
                point.x += 4;
                point.y += 4;
                Control control = controlArray[0];
                if (control instanceof CoolBar && (((CoolBar)control).getStyle() & 0x200) != 0) {
                    point.y += 3;
                } else {
                    point.x += 3;
                }
                return point;
            }

            protected void layout(Composite composite, boolean bl) {
                Control[] controlArray = composite.getChildren();
                if (controlArray.length == 0) {
                    return;
                }
                controlArray[0].setLocation(2, 2);
            }
        });
    }

    private void dispose() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.dispose();
        }
    }

    public Composite getComposite() {
        return this.canvas;
    }
}

