/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.AnimationEngine;
import org.eclipse.ui.internal.TrimDragPreferences;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.DragBorder;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.dnd.IDropTarget2;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.layout.TrimDescriptor;
import org.eclipse.ui.internal.layout.TrimLayout;
import org.eclipse.ui.internal.layout.TrimToolBarBase;

class TrimDropTarget
implements IDragOverListener {
    private ActualTrimDropTarget dropTarget;
    private TrimLayout layout;
    private Composite windowComposite;

    public TrimDropTarget(Composite composite, WorkbenchWindow workbenchWindow) {
        this.layout = (TrimLayout)composite.getLayout();
        this.windowComposite = composite;
        this.dropTarget = new ActualTrimDropTarget();
    }

    @Override
    public IDropTarget drag(Control control, Object object, Point point, Rectangle rectangle) {
        if (!(object instanceof IWindowTrim)) {
            return null;
        }
        IWindowTrim iWindowTrim = (IWindowTrim)object;
        if (iWindowTrim.getControl().getShell() != this.windowComposite.getShell()) {
            return null;
        }
        if (this.dropTarget.draggedTrim == null) {
            this.dropTarget.startDrag(iWindowTrim);
        }
        this.dropTarget.track(point);
        this.windowComposite.getDisplay().update();
        return this.dropTarget;
    }

    private final class ActualTrimDropTarget
    implements IDropTarget2 {
        public IWindowTrim draggedTrim = null;
        private DragBorder border = null;
        private int dockedArea = 0;
        private int cursorAreaId;
        private int initialAreaId = 0;
        private IWindowTrim initialInsertBefore = null;
        private Rectangle initialLocation;

        private ActualTrimDropTarget() {
        }

        public void startDrag(IWindowTrim iWindowTrim) {
            if (this.draggedTrim != iWindowTrim) {
                this.draggedTrim = iWindowTrim;
                this.initialAreaId = TrimDropTarget.this.layout.getTrimAreaId(this.draggedTrim.getControl());
                this.initialInsertBefore = this.getInsertBefore(this.initialAreaId, this.draggedTrim);
                this.initialLocation = DragUtil.getDisplayBounds(this.draggedTrim.getControl());
                this.dockedArea = this.initialAreaId;
            }
        }

        private int getTrimArea(Point point) {
            int n = this.getTrimArea(point, 0);
            if (n == 0) {
                n = this.getTrimArea(point, TrimDragPreferences.getThreshold());
            }
            return n;
        }

        private int getTrimArea(Point point, int n) {
            int[] nArray = TrimDropTarget.this.layout.getAreaIds();
            int n2 = 0;
            while (n2 < nArray.length) {
                Rectangle rectangle = TrimDropTarget.this.layout.getTrimRect(TrimDropTarget.this.windowComposite, nArray[n2]);
                rectangle = Geometry.toControl((Control)TrimDropTarget.this.windowComposite, (Rectangle)rectangle);
                if ((nArray[n2] & this.getValidSides()) != 0) {
                    switch (nArray[n2]) {
                        case 16384: {
                            rectangle.width += n;
                            if (point.y < rectangle.y || point.y > rectangle.y + rectangle.height || point.x > rectangle.x + rectangle.width) break;
                            return nArray[n2];
                        }
                        case 131072: {
                            rectangle.x -= n;
                            rectangle.width += n;
                            if (point.y < rectangle.y || point.y > rectangle.y + rectangle.height || point.x < rectangle.x) break;
                            return nArray[n2];
                        }
                        case 128: {
                            rectangle.height += n;
                            if (point.x < rectangle.x || point.x > rectangle.x + rectangle.width || point.y > rectangle.y + rectangle.height) break;
                            return nArray[n2];
                        }
                        case 1024: {
                            rectangle.y -= n;
                            rectangle.height += n;
                            if (point.x < rectangle.x || point.x > rectangle.x + rectangle.width || point.y < rectangle.y) break;
                            return nArray[n2];
                        }
                    }
                }
                ++n2;
            }
            return 0;
        }

        private IWindowTrim getInsertBefore(int n, Point point) {
            boolean bl = n == 128 || n == 1024;
            List list = TrimDropTarget.this.layout.getTrimArea(n).getDescriptors();
            for (TrimDescriptor trimDescriptor : list) {
                if (trimDescriptor.getTrim() == this.draggedTrim) continue;
                Rectangle rectangle = trimDescriptor.getCache().getControl().getBounds();
                Point point2 = Geometry.centerPoint((Rectangle)rectangle);
                if (!(bl ? point.x < point2.x : point.y < point2.y)) continue;
                return trimDescriptor.getTrim();
            }
            return null;
        }

        private IWindowTrim getInsertBefore(int n, IWindowTrim iWindowTrim) {
            List list = TrimDropTarget.this.layout.getTrimArea(n).getDescriptors();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TrimDescriptor trimDescriptor = (TrimDescriptor)iterator.next();
                if (trimDescriptor.getTrim() != iWindowTrim) continue;
                if (iterator.hasNext()) {
                    trimDescriptor = (TrimDescriptor)iterator.next();
                    return trimDescriptor.getTrim();
                }
                return null;
            }
            return null;
        }

        public void track(Point point) {
            Rectangle rectangle = new Rectangle(point.x, point.y, 1, 1);
            rectangle = Geometry.toControl((Control)TrimDropTarget.this.windowComposite, (Rectangle)rectangle);
            point.x = rectangle.x;
            point.y = rectangle.y;
            this.cursorAreaId = this.getTrimArea(point);
            if (this.cursorAreaId != 0) {
                this.trackInsideTrimArea(point);
            } else {
                this.trackOutsideTrimArea(point);
            }
        }

        private void trackInsideTrimArea(Point point) {
            boolean bl;
            int n = this.getTrimArea(point);
            IWindowTrim iWindowTrim = this.getInsertBefore(n, point);
            boolean bl2 = bl = this.dockedArea == 0;
            if (this.dockedArea != 0) {
                IWindowTrim iWindowTrim2 = this.getInsertBefore(this.dockedArea, this.draggedTrim);
                boolean bl3 = bl = this.dockedArea != n || iWindowTrim2 != iWindowTrim;
            }
            if (bl) {
                this.dock(n, iWindowTrim);
            }
        }

        private void trackOutsideTrimArea(Point point) {
            if (this.dockedArea != 0) {
                this.undock();
            }
            this.border.setLocation(point, 1024);
        }

        private int getValidSides() {
            int n = this.draggedTrim.getValidSides();
            if (n == 0) {
                return n;
            }
            return 148608;
        }

        private void redock() {
            Rectangle rectangle = DragUtil.getDisplayBounds(this.draggedTrim.getControl());
            AnimationEngine.createTweakedAnimation(TrimDropTarget.this.windowComposite.getShell(), 400, rectangle, this.initialLocation);
            this.dock(this.initialAreaId, this.initialInsertBefore);
        }

        @Override
        public void drop() {
            if (this.dockedArea == 0) {
                this.redock();
            }
        }

        private void undock() {
            TrimDropTarget.this.layout.removeTrim(this.draggedTrim);
            LayoutUtil.resize(this.draggedTrim.getControl());
            this.draggedTrim.dock(this.initialAreaId);
            this.draggedTrim.getControl().setSize(this.initialLocation.width, this.initialLocation.height);
            boolean bl = !(this.draggedTrim instanceof TrimToolBarBase);
            this.border = new DragBorder(TrimDropTarget.this.windowComposite, this.draggedTrim.getControl(), bl);
            this.dockedArea = 0;
        }

        private void dock(int n, IWindowTrim iWindowTrim) {
            if (this.border != null) {
                this.border.dispose();
                this.border = null;
            }
            this.draggedTrim.dock(n);
            TrimDropTarget.this.layout.addTrim(n, this.draggedTrim, iWindowTrim);
            LayoutUtil.resize(this.draggedTrim.getControl());
            this.dockedArea = n;
        }

        @Override
        public Cursor getCursor() {
            if (this.cursorAreaId == 0) {
                return TrimDropTarget.this.windowComposite.getDisplay().getSystemCursor(20);
            }
            return TrimDropTarget.this.windowComposite.getDisplay().getSystemCursor(5);
        }

        @Override
        public Rectangle getSnapRectangle() {
            return new Rectangle(100000, 0, 0, 0);
        }

        @Override
        public void dragFinished(boolean bl) {
            if (!bl && this.dockedArea == 0) {
                this.redock();
            }
            this.draggedTrim = null;
        }
    }
}

