/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.PerspectiveAction;
import org.eclipse.ui.internal.WorkbenchMessages;

public class ToggleEditorsVisibilityAction
extends PerspectiveAction
implements IPerspectiveListener {
    @Override
    public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
        if (iWorkbenchPage.isEditorAreaVisible()) {
            this.setText(WorkbenchMessages.ToggleEditor_hideEditors);
        } else {
            this.setText(WorkbenchMessages.ToggleEditor_showEditors);
        }
    }

    @Override
    public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
        if (string == "reset" || string == "editorAreaHide" || string == "editorAreaShow") {
            if (iWorkbenchPage.isEditorAreaVisible()) {
                this.setText(WorkbenchMessages.ToggleEditor_hideEditors);
            } else {
                this.setText(WorkbenchMessages.ToggleEditor_showEditors);
            }
        }
    }

    public ToggleEditorsVisibilityAction(IWorkbenchWindow iWorkbenchWindow) {
        super(iWorkbenchWindow);
        this.setText(WorkbenchMessages.ToggleEditor_hideEditors);
        this.setActionDefinitionId("org.eclipse.ui.window.hideShowEditors");
        this.setToolTipText(WorkbenchMessages.ToggleEditor_toolTip);
        iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.target_editors_visibility_action_context");
        iWorkbenchWindow.addPerspectiveListener(this);
    }

    @Override
    protected void run(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
        boolean bl = iWorkbenchPage.isEditorAreaVisible();
        if (bl) {
            iWorkbenchPage.setEditorAreaVisible(false);
            this.setText(WorkbenchMessages.ToggleEditor_showEditors);
        } else {
            iWorkbenchPage.setEditorAreaVisible(true);
            this.setText(WorkbenchMessages.ToggleEditor_hideEditors);
        }
    }

    @Override
    public void dispose() {
        if (this.getWindow() != null) {
            this.getWindow().removePerspectiveListener(this);
        }
        super.dispose();
    }
}

