/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;

public class SwitchToWindowMenu
extends ContributionItem {
    private static final int MAX_TEXT_LENGTH = 40;
    private IWorkbenchWindow workbenchWindow;
    private boolean showSeparator;
    private boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager iMenuManager) {
            iMenuManager.markDirty();
            SwitchToWindowMenu.this.dirty = true;
        }
    };

    public SwitchToWindowMenu(IWorkbenchWindow iWorkbenchWindow, String string, boolean bl) {
        super(string);
        this.workbenchWindow = iWorkbenchWindow;
        this.showSeparator = bl;
    }

    private String calcText(int n, IWorkbenchWindow iWorkbenchWindow) {
        String string = iWorkbenchWindow.getShell().getText();
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 10) {
            stringBuffer.append('&');
        }
        stringBuffer.append(n);
        stringBuffer.append(' ');
        if (string.length() <= 40) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string.substring(0, 40));
            stringBuffer.append("...");
        }
        return stringBuffer.toString();
    }

    public void fill(Menu menu, int n) {
        IWorkbench iWorkbench = this.workbenchWindow.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        if (iWorkbenchWindowArray.length < 2) {
            return;
        }
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        if (this.showSeparator) {
            new MenuItem(menu, 2, n);
            ++n;
        }
        int n2 = 1;
        int n3 = 0;
        while (n3 < iWorkbenchWindowArray.length) {
            String string;
            final IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n3];
            if (!iWorkbenchWindow.getShell().isDisposed() && (string = this.calcText(n2, iWorkbenchWindow)) != null) {
                MenuItem menuItem = new MenuItem(menu, 16, n);
                ++n;
                ++n2;
                menuItem.setText(string);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        Shell shell = iWorkbenchWindow.getShell();
                        if (shell.getMinimized()) {
                            shell.setMinimized(false);
                        }
                        shell.setActive();
                        shell.moveAbove(null);
                    }
                });
                menuItem.setSelection(iWorkbenchWindow == this.workbenchWindow);
            }
            ++n3;
        }
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }
}

