/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.IStickyViewManager;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.views.IStickyViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

class StickyViewManager32
implements IStickyViewManager {
    private Map stickyPerspectives = new HashMap(7);
    private IWorkbenchPage page;

    public StickyViewManager32(IWorkbenchPage iWorkbenchPage) {
        this.page = iWorkbenchPage;
    }

    @Override
    public void remove(String string) {
        this.stickyPerspectives.remove(string);
    }

    @Override
    public void add(String string, Set set) {
        this.stickyPerspectives.put(string, set);
    }

    @Override
    public void clear() {
        this.stickyPerspectives.clear();
    }

    @Override
    public void update(Perspective perspective, Perspective perspective2) {
        if (perspective2 != null && perspective != null) {
            HashSet<String> hashSet = (HashSet<String>)this.stickyPerspectives.get(perspective2.getDesc().getId());
            if (hashSet == null) {
                hashSet = new HashSet<String>(7);
                this.stickyPerspectives.put(perspective2.getDesc().getId(), hashSet);
            }
            IViewRegistry iViewRegistry = WorkbenchPlugin.getDefault().getViewRegistry();
            IStickyViewDescriptor[] iStickyViewDescriptorArray = iViewRegistry.getStickyViews();
            int n = 0;
            while (n < iStickyViewDescriptorArray.length) {
                String string = iStickyViewDescriptorArray[n].getId();
                try {
                    if (perspective.findView(string) != null && !hashSet.contains(string)) {
                        this.page.showView(string, null, 3);
                        hashSet.add(string);
                    }
                }
                catch (PartInitException partInitException) {
                    WorkbenchPlugin.log("Could not open view :" + string, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, "Could not open view :" + string, (Throwable)((Object)partInitException)));
                }
                ++n;
            }
        }
    }

    @Override
    public void save(IMemento iMemento) {
        IMemento iMemento2 = iMemento.createChild("stickyState");
        for (Map.Entry entry : this.stickyPerspectives.entrySet()) {
            String string = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            IMemento iMemento3 = iMemento2.createChild("perspective", string);
            for (String string2 : set) {
                iMemento3.createChild("view", string2);
            }
        }
    }

    @Override
    public void restore(IMemento iMemento) {
        IMemento iMemento2 = iMemento.getChild("stickyState");
        if (iMemento2 != null) {
            IMemento[] iMementoArray = iMemento2.getChildren("perspective");
            int n = 0;
            while (n < iMementoArray.length) {
                String string = iMementoArray[n].getID();
                HashSet<String> hashSet = new HashSet<String>(7);
                this.stickyPerspectives.put(string, hashSet);
                IMemento[] iMementoArray2 = iMementoArray[n].getChildren("view");
                int n2 = 0;
                while (n2 < iMementoArray2.length) {
                    hashSet.add(iMementoArray2[n2].getID());
                    ++n2;
                }
                ++n;
            }
        }
    }
}

