/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.IStickyViewManager;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.StickyViewManager32;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.views.IStickyViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class StickyViewManager
implements IStickyViewManager {
    private IWorkbenchPage page;

    public StickyViewManager(IWorkbenchPage iWorkbenchPage) {
        this.page = iWorkbenchPage;
    }

    public static IStickyViewManager getInstance(IWorkbenchPage iWorkbenchPage) {
        IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("ENABLE_32_STICKY_CLOSE_BEHAVIOR");
        IStickyViewManager iStickyViewManager = bl ? new StickyViewManager32(iWorkbenchPage) : new StickyViewManager(iWorkbenchPage);
        return iStickyViewManager;
    }

    @Override
    public void add(String string, Set set) {
    }

    @Override
    public void clear() {
    }

    @Override
    public void remove(String string) {
    }

    @Override
    public void restore(IMemento iMemento) {
    }

    @Override
    public void save(IMemento iMemento) {
    }

    @Override
    public void update(Perspective perspective, Perspective perspective2) {
        if (perspective == null || perspective2 == null) {
            return;
        }
        IViewRegistry iViewRegistry = WorkbenchPlugin.getDefault().getViewRegistry();
        IStickyViewDescriptor[] iStickyViewDescriptorArray = iViewRegistry.getStickyViews();
        IViewReference[] iViewReferenceArray = perspective.getViewReferences();
        IViewReference[] iViewReferenceArray2 = perspective2.getViewReferences();
        int n = 0;
        while (n < iStickyViewDescriptorArray.length) {
            String string = iStickyViewDescriptorArray[n].getId();
            try {
                String string2;
                String string3;
                int n2 = 0;
                while (n2 < iViewReferenceArray.length) {
                    string3 = iViewReferenceArray[n2].getId();
                    if (string.equals(string3)) {
                        string2 = iViewReferenceArray[n2].getSecondaryId();
                        this.page.showView(string, string2, 3);
                    }
                    ++n2;
                }
                n2 = 0;
                while (n2 < iViewReferenceArray2.length) {
                    string3 = iViewReferenceArray2[n2].getId();
                    if (string.equals(string3) && perspective.findView(string3, string2 = iViewReferenceArray2[n2].getSecondaryId()) == null) {
                        this.page.hideView(iViewReferenceArray2[n2]);
                    }
                    ++n2;
                }
            }
            catch (PartInitException partInitException) {
                WorkbenchPlugin.log("Could not open view :" + string, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, "Could not open view :" + string, (Throwable)((Object)partInitException)));
            }
            ++n;
        }
    }
}

