/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;

public final class StartupThreading {
    static Workbench workbench;

    static void setWorkbench(Workbench workbench) {
        StartupThreading.workbench = workbench;
    }

    public static void runWithWorkbenchExceptions(StartupRunnable startupRunnable) throws WorkbenchException {
        workbench.getDisplay().syncExec((Runnable)startupRunnable);
        Throwable throwable = startupRunnable.getThrowable();
        if (throwable != null) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof WorkbenchException) {
                throw (WorkbenchException)((Object)throwable);
            }
            throw new WorkbenchException(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, throwable));
        }
    }

    public static void runWithPartInitExceptions(StartupRunnable startupRunnable) throws PartInitException {
        workbench.getDisplay().syncExec((Runnable)startupRunnable);
        Throwable throwable = startupRunnable.getThrowable();
        if (throwable != null) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof WorkbenchException) {
                throw (PartInitException)((Object)throwable);
            }
            throw new PartInitException(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, throwable));
        }
    }

    public static void runWithThrowable(StartupRunnable startupRunnable) throws Throwable {
        workbench.getDisplay().syncExec((Runnable)startupRunnable);
        Throwable throwable = startupRunnable.getThrowable();
        if (throwable != null) {
            throw throwable;
        }
    }

    public static void runWithoutExceptions(StartupRunnable startupRunnable) throws RuntimeException {
        workbench.getDisplay().syncExec((Runnable)startupRunnable);
        Throwable throwable = startupRunnable.getThrowable();
        if (throwable != null) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public static abstract class StartupRunnable
    implements Runnable {
        private Throwable throwable;

        @Override
        public final void run() {
            try {
                this.runWithException();
            }
            catch (Throwable throwable) {
                this.throwable = throwable;
            }
        }

        public abstract void runWithException() throws Throwable;

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

