/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.services.IDisposable;

public class SlaveSelectionService
implements ISelectionService,
IDisposable {
    private ListenerList postListeners = new ListenerList(1);
    private ListenerList listeners = new ListenerList(1);
    private Map listenersToPartId = new HashMap();
    private Map postListenersToPartId = new HashMap();
    private ISelectionService parentSelectionService;

    public SlaveSelectionService(ISelectionService iSelectionService) {
        if (iSelectionService == null) {
            throw new IllegalArgumentException("The parent selection service cannot be null");
        }
        this.parentSelectionService = iSelectionService;
    }

    @Override
    public void addPostSelectionListener(ISelectionListener iSelectionListener) {
        this.postListeners.add((Object)iSelectionListener);
        this.parentSelectionService.addPostSelectionListener(iSelectionListener);
    }

    @Override
    public void addPostSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.listenersToPartId.put(iSelectionListener, string);
        this.parentSelectionService.addPostSelectionListener(string, iSelectionListener);
    }

    @Override
    public void addSelectionListener(ISelectionListener iSelectionListener) {
        this.listeners.add((Object)iSelectionListener);
        this.parentSelectionService.addSelectionListener(iSelectionListener);
    }

    @Override
    public void addSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.postListenersToPartId.put(iSelectionListener, string);
        this.parentSelectionService.addPostSelectionListener(string, iSelectionListener);
    }

    @Override
    public ISelection getSelection() {
        return this.parentSelectionService.getSelection();
    }

    @Override
    public ISelection getSelection(String string) {
        return this.parentSelectionService.getSelection(string);
    }

    @Override
    public void removePostSelectionListener(ISelectionListener iSelectionListener) {
        this.postListeners.remove((Object)iSelectionListener);
        this.parentSelectionService.removePostSelectionListener(iSelectionListener);
    }

    @Override
    public void removePostSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.postListenersToPartId.remove(iSelectionListener);
        this.parentSelectionService.removePostSelectionListener(string, iSelectionListener);
    }

    @Override
    public void removeSelectionListener(ISelectionListener iSelectionListener) {
        this.listeners.remove((Object)iSelectionListener);
        this.parentSelectionService.removeSelectionListener(iSelectionListener);
    }

    @Override
    public void removeSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.listenersToPartId.remove(iSelectionListener);
        this.parentSelectionService.removeSelectionListener(string, iSelectionListener);
    }

    @Override
    public void dispose() {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            this.parentSelectionService.removeSelectionListener((ISelectionListener)objectArray[n]);
            ++n;
        }
        this.listeners.clear();
        objectArray = this.postListeners.getListeners();
        n = 0;
        while (n < objectArray.length) {
            this.parentSelectionService.removePostSelectionListener((ISelectionListener)objectArray[n]);
            ++n;
        }
        this.postListeners.clear();
        for (Object k : this.listenersToPartId.keySet()) {
            this.parentSelectionService.removeSelectionListener((String)this.listenersToPartId.get(k), (ISelectionListener)k);
        }
        this.listenersToPartId.clear();
        for (Object k : this.postListenersToPartId.keySet()) {
            this.parentSelectionService.removePostSelectionListener((String)this.postListenersToPartId.get(k), (ISelectionListener)k);
        }
        this.postListenersToPartId.clear();
    }
}

