/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.services.IDisposable;

public class SlavePartService
implements IPartService,
IDisposable {
    private IPartService parent;
    private ListenerList listeners = new ListenerList(1);

    public SlavePartService(IPartService iPartService) {
        if (iPartService == null) {
            throw new IllegalArgumentException("The parent part service cannot be null");
        }
        this.parent = iPartService;
    }

    @Override
    public void addPartListener(IPartListener iPartListener) {
        this.listeners.add((Object)iPartListener);
        this.parent.addPartListener(iPartListener);
    }

    @Override
    public void addPartListener(IPartListener2 iPartListener2) {
        this.listeners.add((Object)iPartListener2);
        this.parent.addPartListener(iPartListener2);
    }

    @Override
    public IWorkbenchPart getActivePart() {
        return this.parent.getActivePart();
    }

    @Override
    public IWorkbenchPartReference getActivePartReference() {
        return this.parent.getActivePartReference();
    }

    @Override
    public void removePartListener(IPartListener iPartListener) {
        this.listeners.remove((Object)iPartListener);
        this.parent.removePartListener(iPartListener);
    }

    @Override
    public void removePartListener(IPartListener2 iPartListener2) {
        this.listeners.remove((Object)iPartListener2);
        this.parent.removePartListener(iPartListener2);
    }

    @Override
    public void dispose() {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof IPartListener) {
                this.parent.removePartListener((IPartListener)object);
            }
            if (object instanceof IPartListener2) {
                this.parent.removePartListener((IPartListener2)object);
            }
            ++n;
        }
        this.listeners.clear();
    }
}

