/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPageService;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.services.IDisposable;

public class SlavePageService
implements IPageService,
IDisposable {
    private IPageService parent;
    private ListenerList pageListeners = new ListenerList(1);
    private ListenerList perspectiveListeners = new ListenerList(1);

    public SlavePageService(IPageService iPageService) {
        if (iPageService == null) {
            throw new IllegalArgumentException("Parent IPageService cannot be null");
        }
        this.parent = iPageService;
    }

    @Override
    public void addPageListener(IPageListener iPageListener) {
        this.pageListeners.add((Object)iPageListener);
        this.parent.addPageListener(iPageListener);
    }

    @Override
    public void addPerspectiveListener(IPerspectiveListener iPerspectiveListener) {
        this.perspectiveListeners.add((Object)iPerspectiveListener);
        this.parent.addPerspectiveListener(iPerspectiveListener);
    }

    @Override
    public IWorkbenchPage getActivePage() {
        return this.parent.getActivePage();
    }

    @Override
    public void removePageListener(IPageListener iPageListener) {
        this.pageListeners.remove((Object)iPageListener);
        this.parent.removePageListener(iPageListener);
    }

    @Override
    public void removePerspectiveListener(IPerspectiveListener iPerspectiveListener) {
        this.perspectiveListeners.remove((Object)iPerspectiveListener);
        this.parent.removePerspectiveListener(iPerspectiveListener);
    }

    @Override
    public void dispose() {
        Object[] objectArray = this.pageListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            this.parent.removePageListener((IPageListener)objectArray[n]);
            ++n;
        }
        this.pageListeners.clear();
        objectArray = this.perspectiveListeners.getListeners();
        n = 0;
        while (n < objectArray.length) {
            this.parent.removePerspectiveListener((IPerspectiveListener)objectArray[n]);
            ++n;
        }
        this.perspectiveListeners.clear();
    }
}

