/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ShowViewMenu
extends ContributionItem {
    private IWorkbenchWindow window;
    private static final String NO_TARGETS_MSG = WorkbenchMessages.Workbench_showInNoTargets;
    private Comparator actionComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            if (collator == null) {
                ShowViewMenu.collator = Collator.getInstance();
            }
            CommandContributionItemParameter commandContributionItemParameter = (CommandContributionItemParameter)object;
            CommandContributionItemParameter commandContributionItemParameter2 = (CommandContributionItemParameter)object2;
            return collator.compare(commandContributionItemParameter.label, commandContributionItemParameter2.label);
        }
    };
    private Action showDlgAction;
    private Map actions = new HashMap(21);
    protected boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager iMenuManager) {
            iMenuManager.markDirty();
            ShowViewMenu.this.dirty = true;
        }
    };
    private boolean makeFast;
    private static Collator collator;

    public ShowViewMenu(IWorkbenchWindow iWorkbenchWindow, String string) {
        this(iWorkbenchWindow, string, false);
    }

    public ShowViewMenu(IWorkbenchWindow iWorkbenchWindow, String string, boolean bl) {
        super(string);
        this.window = iWorkbenchWindow;
        this.makeFast = bl;
        final IHandlerService iHandlerService = (IHandlerService)iWorkbenchWindow.getService(IHandlerService.class);
        ICommandService iCommandService = (ICommandService)iWorkbenchWindow.getService(ICommandService.class);
        final ParameterizedCommand parameterizedCommand = this.getCommand(iCommandService, bl);
        this.showDlgAction = new Action(WorkbenchMessages.ShowView_title){

            public void run() {
                try {
                    iHandlerService.executeCommand(parameterizedCommand, null);
                }
                catch (ExecutionException executionException) {
                }
                catch (NotDefinedException notDefinedException) {
                }
                catch (NotEnabledException notEnabledException) {
                }
                catch (NotHandledException notHandledException) {}
            }
        };
        iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp((IAction)this.showDlgAction, "org.eclipse.ui.show_view_other_action_context");
        if (iWorkbenchWindow instanceof WorkbenchWindow) {
            ((WorkbenchWindow)iWorkbenchWindow).addSubmenu(1);
        }
        this.showDlgAction.setActionDefinitionId("org.eclipse.ui.views.showView");
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    private void fillMenu(IMenuManager iMenuManager) {
        Object object;
        iMenuManager.removeAll();
        IWorkbenchPage iWorkbenchPage = this.window.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        if (iWorkbenchPage.getPerspective() == null) {
            return;
        }
        List list = this.getShortcuts(iWorkbenchPage);
        list = this.addOpenedViews(iWorkbenchPage, list);
        ArrayList<CommandContributionItemParameter> arrayList = new ArrayList<CommandContributionItemParameter>(list.size());
        for (Pair object2 : list) {
            if (object2.a.equals("org.eclipse.ui.internal.introview") || (object = this.getItem((String)object2.a, (String)object2.b)) == null) continue;
            arrayList.add((CommandContributionItemParameter)object);
        }
        Collections.sort(arrayList, this.actionComparator);
        for (CommandContributionItemParameter commandContributionItemParameter : arrayList) {
            if (WorkbenchActivityHelper.filterItem(commandContributionItemParameter)) continue;
            object = new CommandContributionItem(commandContributionItemParameter);
            iMenuManager.add((IContributionItem)object);
        }
        if (!iMenuManager.isEmpty()) {
            iMenuManager.add((IContributionItem)new Separator());
        }
        iMenuManager.add((IAction)this.showDlgAction);
    }

    private List getShortcuts(IWorkbenchPage iWorkbenchPage) {
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        String[] stringArray = iWorkbenchPage.getShowViewShortcuts();
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(new Pair(stringArray[n], null));
            ++n;
        }
        return arrayList;
    }

    private CommandContributionItemParameter getItem(String string, String string2) {
        IViewRegistry iViewRegistry = WorkbenchPlugin.getDefault().getViewRegistry();
        IViewDescriptor iViewDescriptor = iViewRegistry.find(string);
        if (iViewDescriptor == null) {
            return null;
        }
        String string3 = iViewDescriptor.getLabel();
        PluginCCIP pluginCCIP = new PluginCCIP(iViewDescriptor, this.window, string, "org.eclipse.ui.views.showView", 8);
        pluginCCIP.label = string3;
        pluginCCIP.icon = iViewDescriptor.getImageDescriptor();
        pluginCCIP.parameters = new HashMap();
        pluginCCIP.parameters.put("org.eclipse.ui.views.showView.viewId", string);
        if (this.makeFast) {
            pluginCCIP.parameters.put("org.eclipse.ui.views.showView.makeFast", "true");
        }
        if (string2 != null) {
            pluginCCIP.parameters.put("org.eclipse.ui.views.showView.secondaryId", string2);
        }
        return pluginCCIP;
    }

    private List addOpenedViews(IWorkbenchPage iWorkbenchPage, List list) {
        Object e;
        ArrayList arrayList = this.getParts(iWorkbenchPage);
        ArrayList arrayList2 = new ArrayList(arrayList.size() + list.size());
        int n = 0;
        while (n < list.size()) {
            e = list.get(n);
            if (arrayList2.indexOf(e) < 0) {
                arrayList2.add(e);
            }
            ++n;
        }
        n = 0;
        while (n < arrayList.size()) {
            e = arrayList.get(n);
            if (arrayList2.indexOf(e) < 0) {
                arrayList2.add(e);
            }
            ++n;
        }
        return arrayList2;
    }

    private ArrayList getParts(IWorkbenchPage iWorkbenchPage) {
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        IViewReference[] iViewReferenceArray = iWorkbenchPage.getViewReferences();
        int n = 0;
        while (n < iViewReferenceArray.length) {
            arrayList.add(new Pair(iViewReferenceArray[n].getId(), iViewReferenceArray[n].getSecondaryId()));
            ++n;
        }
        return arrayList;
    }

    public void fill(Menu menu, int n) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager menuManager = new MenuManager();
        this.fillMenu((IMenuManager)menuManager);
        IContributionItem[] iContributionItemArray = menuManager.getItems();
        if (iContributionItemArray.length == 0) {
            MenuItem menuItem = new MenuItem(menu, 0, n++);
            menuItem.setText(NO_TARGETS_MSG);
            menuItem.setEnabled(false);
        } else {
            int n2 = 0;
            while (n2 < iContributionItemArray.length) {
                iContributionItemArray[n2].fill(menu, n++);
                ++n2;
            }
        }
        this.dirty = false;
    }

    protected void removeAction(String string) {
        this.actions.remove(string);
    }

    private ParameterizedCommand getCommand(ICommandService iCommandService, boolean bl) {
        Command command = iCommandService.getCommand("org.eclipse.ui.views.showView");
        Parameterization[] parameterizationArray = null;
        if (bl) {
            try {
                IParameter iParameter = command.getParameter("org.eclipse.ui.views.showView.makeFast");
                parameterizationArray = new Parameterization[]{new Parameterization(iParameter, "true")};
            }
            catch (NotDefinedException notDefinedException) {}
        }
        return new ParameterizedCommand(command, parameterizationArray);
    }

    static class Pair {
        public final Object a;
        public final Object b;
        int hashCode = -1;

        public Pair(Object object, Object object2) {
            this.a = object;
            this.b = object2;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = 1;
                this.hashCode = 31 * this.hashCode + (this.a == null ? 0 : this.a.hashCode());
                this.hashCode = 31 * this.hashCode + (this.b == null ? 0 : this.b.hashCode());
                if (this.hashCode == -1) {
                    this.hashCode = this.a.hashCode();
                }
            }
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            Pair pair = (Pair)object;
            if (!this.a.equals(pair.a)) {
                return false;
            }
            if (this.b == pair.b) {
                return true;
            }
            if (this.b == null || pair.b == null) {
                return false;
            }
            return this.b.equals(pair.b);
        }
    }

    static class PluginCCIP
    extends CommandContributionItemParameter
    implements IPluginContribution {
        private String localId;
        private String pluginId;

        public PluginCCIP(IViewDescriptor iViewDescriptor, IServiceLocator iServiceLocator, String string, String string2, int n) {
            super(iServiceLocator, string, string2, n);
            this.localId = ((ViewDescriptor)iViewDescriptor).getLocalId();
            this.pluginId = ((ViewDescriptor)iViewDescriptor).getPluginId();
        }

        @Override
        public String getLocalId() {
            return this.localId;
        }

        @Override
        public String getPluginId() {
            return this.pluginId;
        }
    }
}

