/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.views.IViewDescriptor;

public class ShowViewAction
extends Action
implements IPluginContribution {
    private IWorkbenchWindow window;
    private IViewDescriptor desc;
    private boolean makeFast = false;

    protected ShowViewAction(IWorkbenchWindow iWorkbenchWindow, IViewDescriptor iViewDescriptor, boolean bl) {
        super("");
        String string = iViewDescriptor instanceof ViewDescriptor ? ((ViewDescriptor)iViewDescriptor).getAccelerator() : null;
        String string2 = iViewDescriptor.getLabel();
        this.setText(string == null ? string2 : String.valueOf(string2) + "@" + string);
        this.setImageDescriptor(iViewDescriptor.getImageDescriptor());
        this.setToolTipText(string2);
        iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.show_view_action_context");
        this.window = iWorkbenchWindow;
        this.desc = iViewDescriptor;
        this.makeFast = bl;
    }

    public void run() {
        IWorkbenchPage iWorkbenchPage = this.window.getActivePage();
        if (iWorkbenchPage != null) {
            try {
                if (this.makeFast) {
                    WorkbenchPage workbenchPage = (WorkbenchPage)iWorkbenchPage;
                    Perspective perspective = workbenchPage.getActivePerspective();
                    boolean bl = Perspective.useNewMinMax(perspective);
                    if (bl) {
                        IViewReference iViewReference = perspective.getViewReference(this.desc.getId(), null);
                        if (iViewReference == null) {
                            return;
                        }
                        perspective.getFastViewManager().addViewReference(FastViewBar.FASTVIEWBAR_ID, -1, iViewReference, true);
                        workbenchPage.activate(iViewReference.getPart(true));
                        return;
                    }
                    IViewReference iViewReference = workbenchPage.findViewReference(this.desc.getId());
                    if (iViewReference == null) {
                        IViewPart iViewPart = iWorkbenchPage.showView(this.desc.getId(), null, 3);
                        iViewReference = (IViewReference)workbenchPage.getReference(iViewPart);
                    }
                    if (!workbenchPage.isFastView(iViewReference) && perspective != null) {
                        perspective.getFastViewManager().addViewReference(FastViewBar.FASTVIEWBAR_ID, -1, iViewReference, true);
                    }
                    workbenchPage.activate(iViewReference.getPart(true));
                } else {
                    iWorkbenchPage.showView(this.desc.getId());
                }
            }
            catch (PartInitException partInitException) {
                ErrorDialog.openError((Shell)this.window.getShell(), (String)WorkbenchMessages.ShowView_errorTitle, (String)partInitException.getMessage(), (IStatus)partInitException.getStatus());
            }
        }
    }

    @Override
    public String getLocalId() {
        return this.desc.getId();
    }

    @Override
    public String getPluginId() {
        return this.desc instanceof IPluginContribution ? ((IPluginContribution)((Object)this.desc)).getPluginId() : null;
    }
}

