/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.AbstractEvaluationHandler;
import org.eclipse.ui.internal.InternalHandlerUtil;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;

public class ShowPartPaneMenuHandler
extends AbstractEvaluationHandler {
    private Expression enabledWhen;

    public ShowPartPaneMenuHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IWorkbenchPartSite iWorkbenchPartSite;
        IWorkbenchPart iWorkbenchPart = HandlerUtil.getActivePart(executionEvent);
        if (iWorkbenchPart != null && (iWorkbenchPartSite = iWorkbenchPart.getSite()) instanceof PartSite) {
            PartPane partPane = ((PartSite)iWorkbenchPartSite).getPane();
            partPane.showSystemMenu();
        }
        return null;
    }

    @Override
    protected Expression getEnabledWhenExpression() {
        if (this.enabledWhen == null) {
            this.enabledWhen = new Expression(){

                public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
                    IWorkbenchPart iWorkbenchPart = InternalHandlerUtil.getActivePart(iEvaluationContext);
                    if (iWorkbenchPart != null) {
                        return EvaluationResult.TRUE;
                    }
                    return EvaluationResult.FALSE;
                }

                public void collectExpressionInfo(ExpressionInfo expressionInfo) {
                    expressionInfo.addVariableNameAccess("activePart");
                }
            };
        }
        return this.enabledWhen;
    }
}

