/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.WorkbenchSourceProvider;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.services.ISourceProviderService;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ShowInMenu
extends ContributionItem
implements IWorkbenchContribution {
    private static final String NO_TARGETS_MSG = WorkbenchMessages.Workbench_showInNoTargets;
    private IWorkbenchWindow window;
    private Map actions = new HashMap(21);
    private boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager iMenuManager) {
            iMenuManager.markDirty();
            ShowInMenu.this.dirty = true;
        }
    };
    private IServiceLocator locator;
    private MenuManager currentManager;

    public ShowInMenu() {
    }

    public ShowInMenu(IWorkbenchWindow iWorkbenchWindow, String string) {
        super(string);
        this.window = iWorkbenchWindow;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    public void fill(Menu menu, int n) {
        IContributionItem[] iContributionItemArray;
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        if (this.currentManager != null && this.currentManager.getSize() > 0) {
            iContributionItemArray = (IContributionItem[])this.locator.getService(IMenuService.class);
            iContributionItemArray.releaseContributions((ContributionManager)this.currentManager);
            this.currentManager.removeAll();
        }
        this.currentManager = new MenuManager();
        this.fillMenu((IMenuManager)this.currentManager);
        iContributionItemArray = this.currentManager.getItems();
        if (iContributionItemArray.length == 0) {
            MenuItem menuItem = new MenuItem(menu, 0, n++);
            menuItem.setText(NO_TARGETS_MSG);
            menuItem.setEnabled(false);
        } else {
            int n2 = 0;
            while (n2 < iContributionItemArray.length) {
                if (iContributionItemArray[n2].isVisible()) {
                    iContributionItemArray[n2].fill(menu, n++);
                }
                ++n2;
            }
        }
        this.dirty = false;
    }

    private void fillMenu(IMenuManager iMenuManager) {
        Object object;
        iMenuManager.removeAll();
        IWorkbenchPart iWorkbenchPart = this.getSourcePart();
        ShowInContext showInContext = this.getContext(iWorkbenchPart);
        if (showInContext == null) {
            return;
        }
        if (showInContext.getInput() == null && (showInContext.getSelection() == null || showInContext.getSelection().isEmpty())) {
            return;
        }
        IViewDescriptor[] iViewDescriptorArray = this.getViewDescriptors(iWorkbenchPart);
        int n = 0;
        while (n < iViewDescriptorArray.length) {
            object = this.getContributionItem(iViewDescriptorArray[n]);
            if (object != null) {
                iMenuManager.add(object);
            }
            ++n;
        }
        if (iWorkbenchPart != null && iMenuManager instanceof MenuManager) {
            ISourceProviderService iSourceProviderService = (ISourceProviderService)this.locator.getService(ISourceProviderService.class);
            object = iSourceProviderService.getSourceProvider("showInSelection");
            if (object instanceof WorkbenchSourceProvider) {
                ((WorkbenchSourceProvider)object).checkActivePart(true);
            }
            IMenuService iMenuService = (IMenuService)this.locator.getService(IMenuService.class);
            iMenuService.populateContributionManager((ContributionManager)iMenuManager, "popup:org.eclipse.ui.menus.showInMenu");
        }
    }

    protected IContributionItem getContributionItem(IViewDescriptor iViewDescriptor) {
        CommandContributionItemParameter commandContributionItemParameter = new CommandContributionItemParameter(this.locator, iViewDescriptor.getId(), "org.eclipse.ui.navigate.showIn", 8);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("org.eclipse.ui.navigate.showIn.targetId", iViewDescriptor.getId());
        commandContributionItemParameter.parameters = hashMap;
        commandContributionItemParameter.label = iViewDescriptor.getLabel();
        if (commandContributionItemParameter.label.length() > 0) {
            commandContributionItemParameter.mnemonic = commandContributionItemParameter.label.substring(0, 1);
        }
        commandContributionItemParameter.icon = iViewDescriptor.getImageDescriptor();
        return new CommandContributionItem(commandContributionItemParameter);
    }

    private ArrayList getShowInPartIds(IWorkbenchPart iWorkbenchPart) {
        String[] stringArray;
        IShowInTargetList iShowInTargetList;
        ArrayList<String> arrayList = new ArrayList<String>();
        WorkbenchPage workbenchPage = (WorkbenchPage)this.getWindow().getActivePage();
        if (workbenchPage != null) {
            arrayList.addAll(workbenchPage.getShowInPartIds());
        }
        if ((iShowInTargetList = this.getShowInTargetList(iWorkbenchPart)) != null && (stringArray = iShowInTargetList.getShowInTargetIds()) != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (!arrayList.contains(stringArray[n])) {
                    arrayList.add(stringArray[n]);
                }
                ++n;
            }
        }
        workbenchPage.sortShowInPartIds(arrayList);
        return arrayList;
    }

    private IWorkbenchPart getSourcePart() {
        IWorkbenchWindow iWorkbenchWindow = this.getWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        Shell shell = iWorkbenchWindow.getShell();
        if (shell == null || shell != shell.getDisplay().getActiveShell()) {
            return null;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage != null) {
            return iWorkbenchPage.getActivePart();
        }
        return null;
    }

    private IShowInSource getShowInSource(IWorkbenchPart iWorkbenchPart) {
        return (IShowInSource)Util.getAdapter(iWorkbenchPart, IShowInSource.class);
    }

    private IShowInTargetList getShowInTargetList(IWorkbenchPart iWorkbenchPart) {
        return (IShowInTargetList)Util.getAdapter(iWorkbenchPart, IShowInTargetList.class);
    }

    protected ShowInContext getContext(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart != null) {
            IShowInSource iShowInSource = this.getShowInSource(iWorkbenchPart);
            if (iShowInSource != null) {
                ShowInContext showInContext = iShowInSource.getShowInContext();
                if (showInContext != null) {
                    return showInContext;
                }
            } else if (iWorkbenchPart instanceof IEditorPart) {
                IEditorInput iEditorInput = ((IEditorPart)iWorkbenchPart).getEditorInput();
                ISelectionProvider iSelectionProvider = iWorkbenchPart.getSite().getSelectionProvider();
                ISelection iSelection = iSelectionProvider == null ? null : iSelectionProvider.getSelection();
                return new ShowInContext(iEditorInput, iSelection);
            }
        }
        return null;
    }

    private IViewDescriptor[] getViewDescriptors(IWorkbenchPart iWorkbenchPart) {
        String string = iWorkbenchPart == null ? null : iWorkbenchPart.getSite().getId();
        ArrayList arrayList = this.getShowInPartIds(iWorkbenchPart);
        ArrayList<IViewDescriptor> arrayList2 = new ArrayList<IViewDescriptor>();
        IViewRegistry iViewRegistry = WorkbenchPlugin.getDefault().getViewRegistry();
        for (String string2 : arrayList) {
            IViewDescriptor iViewDescriptor;
            if (string2.equals(string) || (iViewDescriptor = iViewRegistry.find(string2)) == null) continue;
            arrayList2.add(iViewDescriptor);
        }
        return arrayList2.toArray(new IViewDescriptor[arrayList2.size()]);
    }

    @Override
    public void initialize(IServiceLocator iServiceLocator) {
        this.locator = iServiceLocator;
    }

    protected IWorkbenchWindow getWindow() {
        IWorkbench iWorkbench;
        if (this.locator == null) {
            return null;
        }
        IWorkbenchLocationService iWorkbenchLocationService = (IWorkbenchLocationService)this.locator.getService(IWorkbenchLocationService.class);
        if (this.window == null) {
            this.window = iWorkbenchLocationService.getWorkbenchWindow();
        }
        if (this.window == null && (iWorkbench = iWorkbenchLocationService.getWorkbench()) != null) {
            this.window = iWorkbench.getActiveWorkbenchWindow();
        }
        return this.window;
    }

    public void dispose() {
        if (this.currentManager != null && this.currentManager.getSize() > 0) {
            IMenuService iMenuService = (IMenuService)this.locator.getService(IMenuService.class);
            if (iMenuService != null) {
                iMenuService.releaseContributions((ContributionManager)this.currentManager);
            }
            this.currentManager.removeAll();
            this.currentManager = null;
        }
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).removeMenuListener(this.menuListener);
        }
        this.actions.clear();
        this.window = null;
        this.locator = null;
    }
}

