/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.services.WorkbenchSourceProvider;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.services.ISourceProviderService;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ShowInHandler
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        Object object;
        String string = executionEvent.getParameter("org.eclipse.ui.navigate.showIn.targetId");
        if (string == null) {
            throw new ExecutionException("No targetId specified");
        }
        IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked(executionEvent);
        ISourceProviderService iSourceProviderService = (ISourceProviderService)iWorkbenchWindow.getService(ISourceProviderService.class);
        if (iSourceProviderService != null && (object = iSourceProviderService.getSourceProvider("showInSelection")) instanceof WorkbenchSourceProvider) {
            ((WorkbenchSourceProvider)object).checkActivePart(true);
        }
        if ((object = this.getContext(HandlerUtil.getShowInSelection(executionEvent), HandlerUtil.getShowInInput(executionEvent))) == null) {
            return null;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        try {
            IViewPart iViewPart = iWorkbenchPage.showView(string);
            IShowInTarget iShowInTarget = this.getShowInTarget(iViewPart);
            if (iShowInTarget == null || !iShowInTarget.show((ShowInContext)object)) {
                iWorkbenchPage.getWorkbenchWindow().getShell().getDisplay().beep();
            }
            ((WorkbenchPage)iWorkbenchPage).performedShowIn(string);
        }
        catch (PartInitException partInitException) {
            throw new ExecutionException("Failed to show in", (Throwable)((Object)partInitException));
        }
        return null;
    }

    private ShowInContext getContext(ISelection iSelection, Object object) {
        if (object == null && iSelection == null) {
            return null;
        }
        return new ShowInContext(object, iSelection);
    }

    private IShowInTarget getShowInTarget(IWorkbenchPart iWorkbenchPart) {
        return (IShowInTarget)Util.getAdapter(iWorkbenchPart, IShowInTarget.class);
    }

    @Override
    public void updateElement(UIElement uIElement, Map map) {
        String string = (String)map.get("org.eclipse.ui.navigate.showIn.targetId");
        if (string == null || string.length() == 0) {
            return;
        }
        IViewRegistry iViewRegistry = WorkbenchPlugin.getDefault().getViewRegistry();
        IViewDescriptor iViewDescriptor = iViewRegistry.find(string);
        if (iViewDescriptor != null) {
            uIElement.setIcon(iViewDescriptor.getImageDescriptor());
            uIElement.setText(iViewDescriptor.getLabel());
        }
    }
}

