/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.util.Util;

public class ShowFastViewContribution
extends ContributionItem {
    public static final String FAST_VIEW = "FastView";
    private IWorkbenchWindow window;
    private String fvbId;

    public ShowFastViewContribution(IWorkbenchWindow iWorkbenchWindow, String string) {
        super("showFastViewContr");
        this.window = iWorkbenchWindow;
        this.fvbId = string;
    }

    public ShowFastViewContribution(IWorkbenchWindow iWorkbenchWindow) {
        this(iWorkbenchWindow, FastViewBar.FASTVIEWBAR_ID);
    }

    private void updateItem(ToolItem toolItem, IViewReference iViewReference) {
        if (toolItem.getImage() != iViewReference.getTitleImage()) {
            toolItem.setImage(iViewReference.getTitleImage());
        }
        if (!Util.equals(toolItem.getToolTipText(), iViewReference.getTitle())) {
            toolItem.setToolTipText(iViewReference.getTitle());
        }
    }

    public static ToolItem getItem(ToolBar toolBar, IWorkbenchPartReference iWorkbenchPartReference) {
        ToolItem[] toolItemArray = toolBar.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem.getData(FAST_VIEW) == iWorkbenchPartReference) {
                return toolItem;
            }
            ++n;
        }
        return null;
    }

    public void fill(ToolBar toolBar, int n) {
        WorkbenchPage workbenchPage = (WorkbenchPage)this.window.getActivePage();
        if (workbenchPage == null) {
            return;
        }
        List list = new ArrayList();
        Perspective perspective = workbenchPage.getActivePerspective();
        if (perspective != null) {
            list = perspective.getFastViewManager().getFastViews(this.fvbId);
        }
        for (final IViewReference iViewReference : list) {
            final ToolItem toolItem = new ToolItem(toolBar, 32, n);
            this.updateItem(toolItem, iViewReference);
            toolItem.setData(FAST_VIEW, (Object)iViewReference);
            final IPropertyListener iPropertyListener = new IPropertyListener(){

                @Override
                public void propertyChanged(Object object, int n) {
                    if (n == 1 && !toolItem.isDisposed()) {
                        ShowFastViewContribution.this.updateItem(toolItem, iViewReference);
                    }
                }
            };
            iViewReference.addPropertyListener(iPropertyListener);
            toolItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    iViewReference.removePropertyListener(iPropertyListener);
                }
            });
            if (iViewReference == workbenchPage.getActiveFastView()) {
                toolItem.setSelection(true);
            } else {
                toolItem.setSelection(false);
            }
            toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ShowFastViewContribution.this.showView(iViewReference);
                }
            });
            ++n;
        }
    }

    public boolean isDynamic() {
        return true;
    }

    private void showView(IViewReference iViewReference) {
        WorkbenchPage workbenchPage = (WorkbenchPage)iViewReference.getPage();
        workbenchPage.toggleFastView(iViewReference);
    }
}

