/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.LinkedList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class ShellPool {
    private int flags;
    private Shell parentShell;
    private LinkedList availableShells = new LinkedList();
    private static final String CLOSE_LISTENER = "close listener";
    private boolean isDisposed = false;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            WorkbenchPlugin.log(new RuntimeException("Widget disposed too early!"));
        }
    };
    private ShellListener closeListener = new ShellAdapter(){

        public void shellClosed(ShellEvent shellEvent) {
            Shell shell;
            ShellListener shellListener;
            if (ShellPool.this.isDisposed) {
                return;
            }
            if (shellEvent.doit && (shellListener = (ShellListener)(shell = (Shell)shellEvent.widget).getData(ShellPool.CLOSE_LISTENER)) != null) {
                shell.setData(ShellPool.CLOSE_LISTENER, null);
                shellListener.shellClosed(shellEvent);
                if (shellEvent.doit) {
                    Control[] controlArray = shell.getChildren();
                    int n = 0;
                    while (n < controlArray.length) {
                        Control control = controlArray[n];
                        control.dispose();
                        ++n;
                    }
                    ShellPool.this.availableShells.add(shell);
                    shell.setVisible(false);
                } else {
                    shell.setData(ShellPool.CLOSE_LISTENER, (Object)shellListener);
                }
            }
            shellEvent.doit = false;
        }
    };

    public ShellPool(Shell shell, int n) {
        this.parentShell = shell;
        this.flags = n;
    }

    public Shell allocateShell(ShellListener shellListener) {
        Shell shell;
        if (!this.availableShells.isEmpty()) {
            shell = (Shell)this.availableShells.removeFirst();
        } else {
            shell = new Shell(this.parentShell, this.flags);
            shell.addShellListener(this.closeListener);
            shell.addDisposeListener(this.disposeListener);
        }
        shell.setData(CLOSE_LISTENER, (Object)shellListener);
        return shell;
    }

    public void dispose() {
        for (Shell shell : this.availableShells) {
            shell.removeDisposeListener(this.disposeListener);
            shell.dispose();
        }
        this.availableShells.clear();
        this.isDisposed = true;
    }
}

