/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.ICountable;
import org.eclipse.core.expressions.IIterable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class SelectionAdapterFactory
implements IAdapterFactory {
    private static final ICountable ICOUNT_0 = new ICountable(){

        public int count() {
            return 0;
        }
    };
    private static final ICountable ICOUNT_1 = new ICountable(){

        public int count() {
            return 1;
        }
    };
    private static final IIterable ITERATE_EMPTY = new IIterable(){

        public Iterator iterator() {
            return Collections.EMPTY_LIST.iterator();
        }
    };
    private static final Class[] CLASSES = new Class[]{IIterable.class, ICountable.class};

    public Object getAdapter(Object object, Class clazz) {
        if (object instanceof ISelection) {
            if (clazz == IIterable.class) {
                return this.iterable((ISelection)object);
            }
            if (clazz == ICountable.class) {
                return this.countable((ISelection)object);
            }
        }
        return null;
    }

    private Object iterable(final ISelection iSelection) {
        if (iSelection.isEmpty()) {
            return ITERATE_EMPTY;
        }
        if (iSelection instanceof IStructuredSelection) {
            return new IIterable(){

                public Iterator iterator() {
                    return ((IStructuredSelection)iSelection).iterator();
                }
            };
        }
        final List<Object> list = Arrays.asList(iSelection);
        return new IIterable(){

            public Iterator iterator() {
                return list.iterator();
            }
        };
    }

    private Object countable(ISelection iSelection) {
        if (iSelection.isEmpty()) {
            return ICOUNT_0;
        }
        if (iSelection instanceof IStructuredSelection) {
            final IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            return new ICountable(){

                public int count() {
                    return iStructuredSelection.size();
                }
            };
        }
        return ICOUNT_1;
    }

    public Class[] getAdapterList() {
        return CLASSES;
    }
}

