/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.internal.DefaultSaveable;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class SaveablesList
implements ISaveablesLifecycleListener {
    private ListenerList listeners = new ListenerList();
    private Map modelMap = new HashMap();
    private Map modelRefCounts = new HashMap();
    private Set nonPartSources = new HashSet();

    public Saveable[] getOpenModels() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.modelMap.values().iterator();
        while (iterator.hasNext()) {
            hashSet.addAll((Set)iterator.next());
        }
        return hashSet.toArray(new Saveable[hashSet.size()]);
    }

    private boolean addModel(Object object, Saveable saveable) {
        if (saveable == null) {
            this.logWarning("Ignored attempt to add invalid saveable", object, saveable);
            return false;
        }
        boolean bl = false;
        HashSet<Saveable> hashSet = (HashSet<Saveable>)this.modelMap.get(object);
        if (hashSet == null) {
            hashSet = new HashSet<Saveable>();
            this.modelMap.put(object, hashSet);
        }
        if (hashSet.add(saveable)) {
            bl = this.incrementRefCount(this.modelRefCounts, saveable);
        } else {
            this.logWarning("Ignored attempt to add saveable that was already registered", object, saveable);
        }
        return bl;
    }

    private boolean incrementRefCount(Map map, Object object) {
        boolean bl = false;
        Integer n = (Integer)map.get(object);
        if (n == null) {
            bl = true;
            n = new Integer(0);
        }
        map.put(object, new Integer(n + 1));
        return bl;
    }

    private boolean decrementRefCount(Map map, Object object) {
        boolean bl = false;
        Integer n = (Integer)map.get(object);
        if (n == null) {
            Assert.isTrue((boolean)false, (String)(object + ": " + ((Saveable)object).getName()));
        }
        if (n == 1) {
            map.remove(object);
            bl = true;
        } else {
            map.put(object, new Integer(n - 1));
        }
        return bl;
    }

    private boolean removeModel(Object object, Saveable saveable) {
        boolean bl = false;
        Set set = (Set)this.modelMap.get(object);
        if (set == null) {
            this.logWarning("Ignored attempt to remove a saveable when no saveables were known", object, saveable);
        } else if (set.remove(saveable)) {
            bl = this.decrementRefCount(this.modelRefCounts, saveable);
            if (set.isEmpty()) {
                this.modelMap.remove(object);
            }
        } else {
            this.logWarning("Ignored attempt to remove a saveable that was not registered", object, saveable);
        }
        return bl;
    }

    private void logWarning(String string, Object object, Saveable saveable) {
        AssertionFailedException assertionFailedException = new AssertionFailedException("unknown saveable: " + saveable + " from part: " + object);
        assertionFailedException.fillInStackTrace();
        WorkbenchPlugin.log(StatusUtil.newStatus(2, string, (Throwable)assertionFailedException));
    }

    @Override
    public void handleLifecycleEvent(SaveablesLifecycleEvent saveablesLifecycleEvent) {
        if (!(saveablesLifecycleEvent.getSource() instanceof IWorkbenchPart)) {
            this.updateNonPartSource((ISaveablesSource)saveablesLifecycleEvent.getSource());
            return;
        }
        Saveable[] saveableArray = saveablesLifecycleEvent.getSaveables();
        switch (saveablesLifecycleEvent.getEventType()) {
            case 1: {
                this.addModels(saveablesLifecycleEvent.getSource(), saveableArray);
                break;
            }
            case 2: {
                Saveable[] saveableArray2 = saveablesLifecycleEvent.getSaveables();
                HashMap hashMap = new HashMap();
                HashSet hashSet = new HashSet();
                int n = 0;
                while (n < saveableArray2.length) {
                    this.incrementRefCount(hashMap, saveableArray2[n]);
                    ++n;
                }
                this.fillModelsClosing(hashSet, hashMap);
                n = this.promptForSavingIfNecessary(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), hashSet, hashMap, !saveablesLifecycleEvent.isForce()) ? 1 : 0;
                if (n == 0) break;
                saveablesLifecycleEvent.setVeto(true);
                break;
            }
            case 3: {
                this.removeModels(saveablesLifecycleEvent.getSource(), saveableArray);
                break;
            }
            case 4: {
                this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, saveablesLifecycleEvent.getEventType(), saveablesLifecycleEvent.getSaveables(), false));
            }
        }
    }

    private void updateNonPartSource(ISaveablesSource iSaveablesSource) {
        Saveable[] saveableArray = iSaveablesSource.getSaveables();
        if (saveableArray.length == 0) {
            this.nonPartSources.remove(iSaveablesSource);
        } else {
            this.nonPartSources.add(iSaveablesSource);
        }
    }

    private void removeModels(Object object, Saveable[] saveableArray) {
        ArrayList<Saveable> arrayList = new ArrayList<Saveable>();
        int n = 0;
        while (n < saveableArray.length) {
            Saveable saveable = saveableArray[n];
            if (this.removeModel(object, saveable)) {
                arrayList.add(saveable);
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 1, arrayList.toArray(new Saveable[arrayList.size()]), false));
        }
    }

    private void addModels(Object object, Saveable[] saveableArray) {
        ArrayList<Saveable> arrayList = new ArrayList<Saveable>();
        int n = 0;
        while (n < saveableArray.length) {
            Saveable saveable = saveableArray[n];
            if (this.addModel(object, saveable)) {
                arrayList.add(saveable);
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 1, arrayList.toArray(new Saveable[arrayList.size()]), false));
        }
    }

    private void fireModelLifecycleEvent(SaveablesLifecycleEvent saveablesLifecycleEvent) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((ISaveablesLifecycleListener)objectArray[n]).handleLifecycleEvent(saveablesLifecycleEvent);
            ++n;
        }
    }

    public void addModelLifecycleListener(ISaveablesLifecycleListener iSaveablesLifecycleListener) {
        this.listeners.add((Object)iSaveablesLifecycleListener);
    }

    public void removeModelLifecycleListener(ISaveablesLifecycleListener iSaveablesLifecycleListener) {
        this.listeners.remove((Object)iSaveablesLifecycleListener);
    }

    public Object preCloseParts(List list, boolean bl, IWorkbenchWindow iWorkbenchWindow) {
        return this.preCloseParts(list, bl, iWorkbenchWindow, iWorkbenchWindow);
    }

    public Object preCloseParts(List list, boolean bl, IShellProvider iShellProvider, IWorkbenchWindow iWorkbenchWindow) {
        boolean bl2;
        PostCloseInfo postCloseInfo = new PostCloseInfo();
        for (IWorkbenchPart iWorkbenchPart : list) {
            int n;
            Object object;
            postCloseInfo.partsClosing.add(iWorkbenchPart);
            if (iWorkbenchPart instanceof ISaveablePart) {
                object = (Saveable[])iWorkbenchPart;
                if (bl && !object.isSaveOnCloseNeeded()) continue;
            }
            if (bl && iWorkbenchPart instanceof ISaveablePart2) {
                object = (ISaveablePart2)((Object)iWorkbenchPart);
                n = SaveableHelper.savePart((ISaveablePart2)object, iWorkbenchWindow, true);
                if (n == 2) {
                    return null;
                }
                if (n != 3) continue;
            }
            object = this.getSaveables(iWorkbenchPart);
            n = 0;
            while (n < ((Saveable[])object).length) {
                this.incrementRefCount(postCloseInfo.modelsDecrementing, object[n]);
                ++n;
            }
        }
        this.fillModelsClosing(postCloseInfo.modelsClosing, postCloseInfo.modelsDecrementing);
        if (bl && (bl2 = this.promptForSavingIfNecessary(iShellProvider, iWorkbenchWindow, postCloseInfo.modelsClosing, postCloseInfo.modelsDecrementing, true))) {
            return null;
        }
        return postCloseInfo;
    }

    private boolean promptForSavingIfNecessary(IWorkbenchWindow iWorkbenchWindow, Set set, Map map, boolean bl) {
        return this.promptForSavingIfNecessary(iWorkbenchWindow, iWorkbenchWindow, set, map, bl);
    }

    private boolean promptForSavingIfNecessary(IShellProvider iShellProvider, IWorkbenchWindow iWorkbenchWindow, Set set, Map map, boolean bl) {
        boolean bl2;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object2 : map.keySet()) {
            if (!((Saveable)object2).isDirty() || set.contains(object2)) continue;
            arrayList.add(object2);
        }
        boolean bl3 = bl2 = arrayList.isEmpty() ? false : this.promptForSaving(arrayList, iShellProvider, iWorkbenchWindow, bl, true);
        if (bl2) {
            return true;
        }
        object2 = new ArrayList();
        for (Saveable saveable : set) {
            if (!saveable.isDirty()) continue;
            object2.add(saveable);
        }
        return object2.isEmpty() ? false : this.promptForSaving((List)object2, iShellProvider, iWorkbenchWindow, bl, false);
    }

    private void fillModelsClosing(Set set, Map map) {
        for (Saveable saveable : map.keySet()) {
            if (!map.get(saveable).equals(this.modelRefCounts.get(saveable))) continue;
            set.add(saveable);
        }
    }

    public boolean promptForSaving(List list, IShellProvider iShellProvider, IRunnableContext iRunnableContext, final boolean bl, boolean bl2) {
        block19: {
            IPreferenceStore iPreferenceStore;
            block20: {
                Object object;
                String string;
                boolean bl3;
                if (list.size() <= 0) break block19;
                boolean bl4 = SaveableHelper.waitForBackgroundSaveJobs(list);
                if (bl4) {
                    return true;
                }
                iPreferenceStore = PrefUtil.getAPIPreferenceStore();
                boolean bl5 = bl3 = bl2 && !iPreferenceStore.getBoolean("PROMPT_WHEN_SAVEABLE_STILL_OPEN");
                if (bl3) {
                    list.clear();
                    return false;
                }
                if (list.size() != 1) break block20;
                Saveable saveable = (Saveable)list.get(0);
                String[] stringArray = bl ? new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL} : new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
                int n = 1;
                if (bl2) {
                    string = NLS.bind((String)WorkbenchMessages.EditorManager_saveChangesOptionallyQuestion, (Object)saveable.getName());
                    MessageDialogWithToggle messageDialogWithToggle = new MessageDialogWithToggle(iShellProvider.getShell(), WorkbenchMessages.Save_Resource, null, string, 3, stringArray, 0, WorkbenchMessages.EditorManager_closeWithoutPromptingOption, false){

                        protected int getShellStyle() {
                            return (bl ? 64 : 0) | 0x20 | 0x800 | 0x10000 | 0x10000000 | 1.getDefaultOrientation();
                        }
                    };
                    object = messageDialogWithToggle;
                } else {
                    string = NLS.bind((String)WorkbenchMessages.EditorManager_saveChangesQuestion, (Object)saveable.getName());
                    object = new MessageDialog(iShellProvider.getShell(), WorkbenchMessages.Save_Resource, null, string, 3, stringArray, 0){

                        protected int getShellStyle() {
                            return (bl ? 64 : 0) | 0x20 | 0x800 | 0x10000 | 0x10000000 | 2.getDefaultOrientation();
                        }
                    };
                }
                n = SaveableHelper.testGetAutomatedResponse();
                if (SaveableHelper.testGetAutomatedResponse() == -1) {
                    n = object.open();
                    if (bl2) {
                        switch (n) {
                            case 2: {
                                n = 0;
                                break;
                            }
                            case 3: {
                                n = 1;
                                break;
                            }
                            case 1: {
                                n = 2;
                                break;
                            }
                        }
                        string = (MessageDialogWithToggle)object;
                        if (n != 2 && string.getToggleState()) {
                            iPreferenceStore.setValue("PROMPT_WHEN_SAVEABLE_STILL_OPEN", false);
                        }
                    }
                }
                switch (n) {
                    case 0: {
                        break block19;
                    }
                    case 1: {
                        list.clear();
                        break block19;
                    }
                    default: {
                        return true;
                    }
                }
            }
            MyListSelectionDialog myListSelectionDialog = new MyListSelectionDialog(iShellProvider.getShell(), list, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), bl2 ? WorkbenchMessages.EditorManager_saveResourcesOptionallyMessage : WorkbenchMessages.EditorManager_saveResourcesMessage, bl, bl2);
            myListSelectionDialog.setInitialSelections(list.toArray());
            myListSelectionDialog.setTitle(EditorManager.SAVE_RESOURCES_TITLE);
            if (SaveableHelper.testGetAutomatedResponse() == -1) {
                int n = myListSelectionDialog.open();
                if (n == 1) {
                    return true;
                }
                if (myListSelectionDialog.getDontPromptSelection()) {
                    iPreferenceStore.setValue("PROMPT_WHEN_SAVEABLE_STILL_OPEN", false);
                }
                list = Arrays.asList(myListSelectionDialog.getResult());
            }
        }
        return this.saveModels(list, iShellProvider, iRunnableContext);
    }

    public boolean saveModels(final List list, final IShellProvider iShellProvider, IRunnableContext iRunnableContext) {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                EventLoopProgressMonitor eventLoopProgressMonitor = new EventLoopProgressMonitor(iProgressMonitor);
                eventLoopProgressMonitor.beginTask(WorkbenchMessages.Saving_Modifications, list.size());
                for (Saveable saveable : list) {
                    if (!saveable.isDirty()) {
                        iProgressMonitor.worked(1);
                        continue;
                    }
                    SaveableHelper.doSaveModel(saveable, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)eventLoopProgressMonitor, 1), iShellProvider, true);
                    if (eventLoopProgressMonitor.isCanceled()) break;
                }
                eventLoopProgressMonitor.done();
            }
        };
        return !SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save_All, iRunnableWithProgress, iRunnableContext, iShellProvider);
    }

    public void postClose(Object object) {
        PostCloseInfo postCloseInfo = (PostCloseInfo)object;
        ArrayList<Saveable> arrayList = new ArrayList<Saveable>();
        for (IWorkbenchPart iWorkbenchPart : postCloseInfo.partsClosing) {
            HashSet hashSet = (HashSet)this.modelMap.get(iWorkbenchPart);
            if (hashSet == null) continue;
            hashSet = new HashSet(hashSet);
            for (Saveable saveable : hashSet) {
                if (!this.removeModel(iWorkbenchPart, saveable)) continue;
                arrayList.add(saveable);
            }
        }
        if (arrayList.size() > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 3, arrayList.toArray(new Saveable[arrayList.size()]), false));
        }
    }

    private Saveable[] getSaveables(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof ISaveablesSource) {
            ISaveablesSource iSaveablesSource = (ISaveablesSource)((Object)iWorkbenchPart);
            return iSaveablesSource.getSaveables();
        }
        if (iWorkbenchPart instanceof ISaveablePart) {
            return new Saveable[]{new DefaultSaveable(iWorkbenchPart)};
        }
        return new Saveable[0];
    }

    public void postOpen(IWorkbenchPart iWorkbenchPart) {
        this.addModels(iWorkbenchPart, this.getSaveables(iWorkbenchPart));
    }

    public void dirtyChanged(IWorkbenchPart iWorkbenchPart) {
        Saveable[] saveableArray = this.getSaveables(iWorkbenchPart);
        if (saveableArray.length > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 4, saveableArray, false));
        }
    }

    public Object[] testGetSourcesForModel(Saveable saveable) {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : this.modelMap.entrySet()) {
            Set set = (Set)entry.getValue();
            if (!set.contains(saveable)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList.toArray();
    }

    public ISaveablesSource[] getNonPartSources() {
        return this.nonPartSources.toArray(new ISaveablesSource[this.nonPartSources.size()]);
    }

    public IWorkbenchPart[] getPartsForSaveable(Saveable saveable) {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : this.modelMap.entrySet()) {
            Set set = (Set)entry.getValue();
            if (!set.contains(saveable) || !(entry.getKey() instanceof IWorkbenchPart)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList.toArray(new IWorkbenchPart[arrayList.size()]);
    }

    private static final class MyListSelectionDialog
    extends ListSelectionDialog {
        private final boolean canCancel;
        private Button checkbox;
        private boolean dontPromptSelection;
        private boolean stillOpenElsewhere;

        private MyListSelectionDialog(Shell shell, Object object, IStructuredContentProvider iStructuredContentProvider, ILabelProvider iLabelProvider, String string, boolean bl, boolean bl2) {
            super(shell, object, iStructuredContentProvider, iLabelProvider, string);
            this.canCancel = bl;
            this.stillOpenElsewhere = bl2;
            int n = this.getShellStyle();
            if (!bl) {
                n &= 0xFFFFFFBF;
            }
            this.setShellStyle(n | 0x10000000);
        }

        public boolean getDontPromptSelection() {
            return this.dontPromptSelection;
        }

        @Override
        protected void createButtonsForButtonBar(Composite composite) {
            this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
            if (this.canCancel) {
                this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
            }
        }

        @Override
        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            if (this.stillOpenElsewhere) {
                Composite composite3 = new Composite(composite2, 0);
                composite3.setLayout((Layout)new GridLayout(2, false));
                this.checkbox = new Button(composite3, 32);
                this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        MyListSelectionDialog.this.dontPromptSelection = MyListSelectionDialog.this.checkbox.getSelection();
                    }
                });
                GridData gridData = new GridData();
                gridData.horizontalAlignment = 1;
                this.checkbox.setLayoutData((Object)gridData);
                Label label = new Label(composite3, 0);
                label.setText(WorkbenchMessages.EditorManager_closeWithoutPromptingOption);
                gridData = new GridData();
                gridData.grabExcessHorizontalSpace = true;
                gridData.horizontalAlignment = 1;
            }
            return composite2;
        }
    }

    private static class PostCloseInfo {
        private List partsClosing = new ArrayList();
        private Map modelsDecrementing = new HashMap();
        private Set modelsClosing = new HashSet();

        private PostCloseInfo() {
        }
    }
}

