/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.progress.IJobRunnable;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class SaveableHelper {
    public static final int USER_RESPONSE = -1;
    private static int AutomatedResponse = -1;

    public static void testSetAutomatedResponse(int n) {
        AutomatedResponse = n;
    }

    public static int testGetAutomatedResponse() {
        return AutomatedResponse;
    }

    static boolean savePart(final ISaveablePart iSaveablePart, IWorkbenchPart iWorkbenchPart, IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        if (!iSaveablePart.isDirty()) {
            return true;
        }
        if (bl) {
            int n = AutomatedResponse;
            if (n == -1) {
                if (iSaveablePart instanceof ISaveablePart2) {
                    n = ((ISaveablePart2)iSaveablePart).promptToSaveOnClose();
                }
                if (n == -1 || n == 3) {
                    String string = NLS.bind((String)WorkbenchMessages.EditorManager_saveChangesQuestion, (Object)iWorkbenchPart.getTitle());
                    String[] stringArray = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                    MessageDialog messageDialog = new MessageDialog(iWorkbenchWindow.getShell(), WorkbenchMessages.Save_Resource, null, string, 3, stringArray, 0){

                        protected int getShellStyle() {
                            return super.getShellStyle() | 0x10000000;
                        }
                    };
                    n = messageDialog.open();
                }
            }
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        if (iSaveablePart instanceof ISaveablesSource) {
            return SaveableHelper.saveModels((ISaveablesSource)((Object)iSaveablePart), iWorkbenchWindow, bl);
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                EventLoopProgressMonitor eventLoopProgressMonitor = new EventLoopProgressMonitor(iProgressMonitor);
                iSaveablePart.doSave((IProgressMonitor)eventLoopProgressMonitor);
            }
        };
        return SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save, iRunnableWithProgress, iWorkbenchWindow);
    }

    private static boolean saveModels(ISaveablesSource iSaveablesSource, final IWorkbenchWindow iWorkbenchWindow, final boolean bl) {
        Saveable[] saveableArray = iSaveablesSource.getActiveSaveables();
        final ArrayList<Saveable> arrayList = new ArrayList<Saveable>();
        int n = 0;
        while (n < saveableArray.length) {
            Saveable saveable = saveableArray[n];
            if (saveable.isDirty()) {
                arrayList.add(saveable);
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                EventLoopProgressMonitor eventLoopProgressMonitor = new EventLoopProgressMonitor(iProgressMonitor);
                eventLoopProgressMonitor.beginTask(WorkbenchMessages.Save, arrayList.size());
                try {
                    for (Saveable saveable : arrayList) {
                        if (!saveable.isDirty()) {
                            iProgressMonitor.worked(1);
                            continue;
                        }
                        SaveableHelper.doSaveModel(saveable, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)eventLoopProgressMonitor, 1), iWorkbenchWindow, bl);
                        if (!iProgressMonitor.isCanceled()) continue;
                        break;
                    }
                }
                finally {
                    eventLoopProgressMonitor.done();
                }
            }
        };
        return SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save, iRunnableWithProgress, iWorkbenchWindow);
    }

    static int savePart(final ISaveablePart2 iSaveablePart2, IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        IRunnableWithProgress iRunnableWithProgress;
        if (!iSaveablePart2.isDirty()) {
            return 0;
        }
        if (bl) {
            int n = AutomatedResponse;
            if (n == -1) {
                n = iSaveablePart2.promptToSaveOnClose();
            }
            if (n != 0) {
                return n == -1 ? 3 : n;
            }
        }
        if (!SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save, iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                EventLoopProgressMonitor eventLoopProgressMonitor = new EventLoopProgressMonitor(iProgressMonitor);
                iSaveablePart2.doSave((IProgressMonitor)eventLoopProgressMonitor);
            }
        }, iWorkbenchWindow)) {
            return 2;
        }
        return 0;
    }

    static boolean runProgressMonitorOperation(String string, IRunnableWithProgress iRunnableWithProgress, IWorkbenchWindow iWorkbenchWindow) {
        return SaveableHelper.runProgressMonitorOperation(string, iRunnableWithProgress, iWorkbenchWindow, iWorkbenchWindow);
    }

    static boolean runProgressMonitorOperation(String string, final IRunnableWithProgress iRunnableWithProgress, IRunnableContext iRunnableContext, IShellProvider iShellProvider) {
        final boolean[] blArray = new boolean[1];
        IRunnableWithProgress iRunnableWithProgress2 = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                iRunnableWithProgress.run(iProgressMonitor);
                if (!iProgressMonitor.isCanceled()) {
                    blArray[0] = true;
                }
            }
        };
        try {
            iRunnableContext.run(false, true, iRunnableWithProgress2);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string2 = NLS.bind((String)WorkbenchMessages.EditorManager_operationFailed, (Object)string);
            Throwable throwable = invocationTargetException.getTargetException();
            WorkbenchPlugin.log(string2, (IStatus)new Status(2, "org.eclipse.ui", 0, string2, throwable));
            StatusUtil.handleStatus(string2, throwable, 2, iShellProvider.getShell());
        }
        catch (InterruptedException interruptedException) {
        }
        catch (OperationCanceledException operationCanceledException) {}
        return blArray[0];
    }

    public static boolean needsSave(ISaveablesSource iSaveablesSource) {
        Saveable[] saveableArray = iSaveablesSource.getActiveSaveables();
        int n = 0;
        while (n < saveableArray.length) {
            Saveable saveable = saveableArray[n];
            if (saveable.isDirty() && !saveable.isSavingInBackground()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void doSaveModel(final Saveable saveable, IProgressMonitor iProgressMonitor, final IShellProvider iShellProvider, boolean bl) {
        try {
            IJobRunnable[] iJobRunnableArray;
            block13: {
                block14: {
                    SubMonitor subMonitor;
                    block12: {
                        block15: {
                            block17: {
                                block16: {
                                    Job job = saveable.getBackgroundSaveJob();
                                    if (job == null) break block15;
                                    boolean bl2 = SaveableHelper.waitForBackgroundSaveJob(saveable);
                                    if (!bl2) break block16;
                                    iProgressMonitor.setCanceled(true);
                                    break block17;
                                }
                                if (saveable.isDirty()) break block15;
                            }
                            iProgressMonitor.done();
                            return;
                        }
                        iJobRunnableArray = new IJobRunnable[1];
                        subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)3);
                        iJobRunnableArray[0] = saveable.doSave((IProgressMonitor)subMonitor.newChild(2), iShellProvider);
                        if (iJobRunnableArray[0] != null) break block12;
                        iProgressMonitor.done();
                        return;
                    }
                    if (!bl) break block13;
                    IStatus iStatus = iJobRunnableArray[0].run((IProgressMonitor)subMonitor.newChild(1));
                    if (iStatus.isOK()) break block14;
                    StatusUtil.handleStatus(iStatus, 2, iShellProvider.getShell());
                    iProgressMonitor.setCanceled(true);
                }
                iProgressMonitor.done();
                return;
            }
            try {
                Job job = new Job(NLS.bind((String)WorkbenchMessages.EditorManager_backgroundSaveJobName, (Object)saveable.getName())){

                    public boolean belongsTo(Object object) {
                        if (object instanceof DynamicFamily) {
                            return ((DynamicFamily)object).contains(saveable);
                        }
                        return object.equals(saveable);
                    }

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        return iJobRunnableArray[0].run(iProgressMonitor);
                    }
                };
                saveable.setBackgroundSaveJob(job);
                SaveablesList saveablesList = (SaveablesList)PlatformUI.getWorkbench().getService(ISaveablesLifecycleListener.class);
                final IWorkbenchPart[] iWorkbenchPartArray = saveablesList.getPartsForSaveable(saveable);
                int n = 0;
                while (n < iWorkbenchPartArray.length) {
                    IWorkbenchPart iWorkbenchPart = iWorkbenchPartArray[n];
                    IWorkbenchSiteProgressService iWorkbenchSiteProgressService = (IWorkbenchSiteProgressService)iWorkbenchPart.getSite().getAdapter(IWorkbenchSiteProgressService.class);
                    iWorkbenchSiteProgressService.showBusyForFamily(saveable);
                    ++n;
                }
                saveable.disableUI(iWorkbenchPartArray, bl);
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent iJobChangeEvent) {
                        saveable.setBackgroundSaveJob(null);
                        iShellProvider.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SaveableHelper.notifySaveAction(iWorkbenchPartArray);
                                saveable.enableUI(iWorkbenchPartArray);
                            }
                        });
                    }
                });
                job.schedule();
                SaveableHelper.notifySaveAction(iWorkbenchPartArray);
                return;
            }
            catch (CoreException coreException) {
                StatusUtil.handleStatus(coreException.getStatus(), 2, iShellProvider.getShell());
                iProgressMonitor.setCanceled(true);
                return;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private static void notifySaveAction(IWorkbenchPart[] iWorkbenchPartArray) {
        HashSet<IWorkbenchWindow> hashSet = new HashSet<IWorkbenchWindow>();
        int n = 0;
        while (n < iWorkbenchPartArray.length) {
            hashSet.add(iWorkbenchPartArray[n].getSite().getWorkbenchWindow());
            ++n;
        }
        for (WorkbenchWindow workbenchWindow : hashSet) {
            workbenchWindow.fireBackgroundSaveStarted();
        }
    }

    private static boolean waitForBackgroundSaveJob(Saveable saveable) {
        ArrayList<Saveable> arrayList = new ArrayList<Saveable>();
        arrayList.add(saveable);
        return SaveableHelper.waitForBackgroundSaveJobs(arrayList);
    }

    public static boolean waitForBackgroundSaveJobs(final List list) {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
                    Job.getJobManager().join((Object)new DynamicFamily((Collection)list), iProgressMonitor);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            StatusUtil.handleStatus(invocationTargetException, 3);
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Saveable saveable = (Saveable)iterator.next();
            if (saveable.isDirty()) continue;
            iterator.remove();
        }
        return false;
    }

    private static class DynamicFamily
    extends HashSet {
        private static final long serialVersionUID = 1L;

        public DynamicFamily(Collection collection) {
            super(collection);
        }
    }
}

