/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.EditorHistory;
import org.eclipse.ui.internal.EditorHistoryItem;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class ReopenEditorMenu
extends ContributionItem {
    private IWorkbenchWindow window;
    private EditorHistory history;
    private boolean showSeparator;
    private boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager iMenuManager) {
            iMenuManager.markDirty();
            ReopenEditorMenu.this.dirty = true;
        }
    };
    private static final int MAX_TEXT_LENGTH = 40;
    private static final int MAX_MNEMONIC_SIZE = 9;

    public ReopenEditorMenu(IWorkbenchWindow iWorkbenchWindow, String string, boolean bl) {
        super(string);
        this.window = iWorkbenchWindow;
        this.showSeparator = bl;
        IWorkbench iWorkbench = iWorkbenchWindow.getWorkbench();
        if (iWorkbench instanceof Workbench) {
            this.history = ((Workbench)iWorkbench).getEditorHistory();
        }
    }

    private String calcText(int n, EditorHistoryItem editorHistoryItem) {
        return ReopenEditorMenu.calcText(n, editorHistoryItem.getName(), editorHistoryItem.getToolTipText(), Window.getDefaultOrientation() == 0x4000000);
    }

    public static String calcText(int n, String string, String string2, boolean bl) {
        Path path;
        String string3;
        String string4;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n + 1;
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(n2);
        if (n2 <= 9) {
            stringBuffer2.insert(stringBuffer2.length() - String.valueOf(n2).length(), '&');
        }
        if ((string4 = string2).equals(string3 = string)) {
            string4 = "";
        }
        if ((path = new Path(string4)).segmentCount() > 1 && path.segment(path.segmentCount() - 1).equals(string3)) {
            path = path.removeLastSegments(1);
            string4 = path.toString();
        }
        if (string3.length() + string4.length() <= 36) {
            stringBuffer.append(string3);
            if (string4.length() > 0) {
                stringBuffer.append("  [");
                stringBuffer.append(string4);
                stringBuffer.append("]");
            }
        } else {
            int n3 = string3.length();
            if (n3 > 40) {
                stringBuffer.append(string3.substring(0, 37));
                stringBuffer.append("...");
            } else if (n3 > 33) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append(string3);
                int n4 = path.segmentCount();
                if (n4 > 0) {
                    int n5;
                    String string5;
                    n3 += 7;
                    stringBuffer.append("  [");
                    for (n5 = 0; n5 < n4 && n3 < 40; n3 += string5.length() + 1, ++n5) {
                        string5 = path.segment(n5);
                        if (n3 + string5.length() < 40) {
                            stringBuffer.append(string5);
                            stringBuffer.append('/');
                            continue;
                        }
                        if (n5 != 0) break;
                        stringBuffer.append(string5.substring(0, 40 - n3));
                        n3 = 40;
                        break;
                    }
                    stringBuffer.append("...");
                    n5 = n4 - 1;
                    while (n5 > 0 && n3 < 40) {
                        string5 = path.segment(n5);
                        if (n3 + string5.length() >= 40) break;
                        stringBuffer.append('/');
                        stringBuffer.append(string5);
                        n3 += string5.length() + 1;
                        --n5;
                    }
                    stringBuffer.append("]");
                }
            }
        }
        String string6 = bl ? stringBuffer + " " + stringBuffer2 : stringBuffer2 + " " + stringBuffer;
        return TextProcessor.process((String)string6, (String)(String.valueOf(TextProcessor.getDefaultDelimiters()) + "[]"));
    }

    public void fill(final Menu menu, int n) {
        int n2;
        if (this.window.getActivePage() == null || this.window.getActivePage().getPerspective() == null) {
            return;
        }
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if ((n2 = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("RECENT_FILES")) == 0 || this.history == null) {
            return;
        }
        EditorHistoryItem[] editorHistoryItemArray = this.history.getItems();
        int n3 = Math.min(n2, editorHistoryItemArray.length);
        if (n3 <= 0) {
            return;
        }
        if (this.showSeparator) {
            new MenuItem(menu, 2, n);
        }
        final int[] nArray = new int[]{++n};
        int n4 = 0;
        while (n4 < n3) {
            final EditorHistoryItem editorHistoryItem = editorHistoryItemArray[n4];
            final int n5 = n4++;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    String string = ReopenEditorMenu.this.calcText(n5, editorHistoryItem);
                    MenuItem menuItem = new MenuItem(menu, 8, nArray[0]);
                    nArray[0] = nArray[0] + 1;
                    menuItem.setText(string);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            ReopenEditorMenu.this.open(editorHistoryItem);
                        }
                    });
                }

                public void handleException(Throwable throwable) {
                    WorkbenchPlugin.log(((Object)((Object)this)).getClass(), "fill", throwable);
                }
            });
        }
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    private void open(EditorHistoryItem editorHistoryItem) {
        IWorkbenchPage iWorkbenchPage = this.window.getActivePage();
        if (iWorkbenchPage != null) {
            try {
                String string = editorHistoryItem.getName();
                if (!editorHistoryItem.isRestored()) {
                    editorHistoryItem.restoreState();
                }
                IEditorInput iEditorInput = editorHistoryItem.getInput();
                IEditorDescriptor iEditorDescriptor = editorHistoryItem.getDescriptor();
                if (iEditorInput == null || iEditorDescriptor == null) {
                    String string2 = WorkbenchMessages.OpenRecent_errorTitle;
                    String string3 = NLS.bind((String)WorkbenchMessages.OpenRecent_unableToOpen, (Object)string);
                    MessageDialog.openWarning((Shell)this.window.getShell(), (String)string2, (String)string3);
                    this.history.remove(editorHistoryItem);
                } else {
                    iWorkbenchPage.openEditor(iEditorInput, iEditorDescriptor.getId());
                }
            }
            catch (PartInitException partInitException) {
                String string = WorkbenchMessages.OpenRecent_errorTitle;
                MessageDialog.openWarning((Shell)this.window.getShell(), (String)string, (String)partInitException.getMessage());
                this.history.remove(editorHistoryItem);
            }
        }
    }
}

