/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.AnimationEngine;
import org.eclipse.ui.internal.RectangleAnimationFeedbackBase;

public class RectangleAnimationImageFeedback
extends RectangleAnimationFeedbackBase {
    private Image backingStore;
    private Shell theShell;
    private Display display;
    private List controls = new ArrayList();

    public RectangleAnimationImageFeedback(Shell shell, Rectangle rectangle, Rectangle rectangle2) {
        super(shell, rectangle, rectangle2);
    }

    @Override
    public void dispose() {
        this.backingStore.dispose();
        for (ImageCanvas imageCanvas : this.controls) {
            imageCanvas.dispose();
        }
        this.theShell.setVisible(false);
        this.theShell.dispose();
    }

    @Override
    public void initialize(AnimationEngine animationEngine) {
        this.display = this.getAnimationShell().getDisplay();
        Rectangle rectangle = this.getAnimationShell().getBounds();
        this.theShell = new Shell(this.getAnimationShell(), 16392);
        this.theShell.setBounds(this.getAnimationShell().getBounds());
        this.backingStore = new Image((Device)this.theShell.getDisplay(), rectangle);
        GC gC = new GC((Drawable)this.display);
        gC.copyArea(this.backingStore, rectangle.x, rectangle.y);
        gC.dispose();
        this.theShell.setBackgroundImage(this.backingStore);
        this.theShell.setVisible(true);
        this.display.update();
    }

    @Override
    public boolean jobInit(AnimationEngine animationEngine) {
        this.changeCoordinates();
        this.captureImages();
        return super.jobInit(animationEngine);
    }

    @Override
    public void addStartRect(Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        super.addStartRect(rectangle);
    }

    @Override
    public void addEndRect(Rectangle rectangle) {
        if (rectangle != null) {
            super.addEndRect(rectangle);
        }
    }

    @Override
    public void renderStep(AnimationEngine animationEngine) {
        Iterator iterator = this.controls.iterator();
        Iterator iterator2 = this.getCurrentRects(animationEngine.amount()).iterator();
        while (iterator2.hasNext()) {
            ImageCanvas imageCanvas = (ImageCanvas)((Object)iterator.next());
            imageCanvas.setBounds((Rectangle)iterator2.next());
        }
        this.display.update();
    }

    public void changeCoordinates() {
        Iterator iterator = this.getStartRects().iterator();
        Iterator iterator2 = this.getEndRects().iterator();
        while (iterator.hasNext()) {
            Rectangle rectangle = (Rectangle)iterator.next();
            Rectangle rectangle2 = Geometry.toControl((Control)this.theShell, (Rectangle)rectangle);
            rectangle.x = rectangle2.x;
            rectangle.y = rectangle2.y;
            Rectangle rectangle3 = (Rectangle)iterator2.next();
            Rectangle rectangle4 = Geometry.toControl((Control)this.theShell, (Rectangle)rectangle3);
            rectangle3.x = rectangle4.x;
            rectangle3.y = rectangle4.y;
        }
    }

    private void captureImages() {
        for (Rectangle rectangle : this.getStartRects()) {
            Image image = new Image((Device)this.display, rectangle.width, rectangle.height);
            GC gC = new GC((Drawable)this.backingStore);
            gC.copyArea(image, rectangle.x, rectangle.y);
            gC.dispose();
            ImageCanvas imageCanvas = new ImageCanvas((Composite)this.theShell, 264192, image);
            this.controls.add(imageCanvas);
        }
    }

    private class ImageCanvas
    extends Canvas {
        private Image image;

        public ImageCanvas(Composite composite, int n, Image image) {
            super(composite, n);
            this.image = image;
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    ImageCanvas.this.paintImage(paintEvent.gc);
                }
            });
        }

        protected void paintImage(GC gC) {
            gC.drawImage(this.image, 0, 0, this.image.getBounds().width, this.image.getBounds().height, 0, 0, this.getBounds().width, this.getBounds().height);
        }

        public void dispose() {
            super.dispose();
            this.image.dispose();
        }
    }
}

