/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.AnimationEngine;
import org.eclipse.ui.internal.AnimationFeedbackBase;

public abstract class RectangleAnimationFeedbackBase
extends AnimationFeedbackBase {
    private List startRects = new ArrayList();
    private List endRects = new ArrayList();

    public RectangleAnimationFeedbackBase(Shell shell, Rectangle rectangle, Rectangle rectangle2) {
        super(shell);
        this.addStartRect(rectangle);
        this.addEndRect(rectangle2);
    }

    @Override
    public boolean jobInit(AnimationEngine animationEngine) {
        if (!super.jobInit(animationEngine)) {
            return false;
        }
        return this.startRects.size() > 0 && this.startRects.size() == this.endRects.size();
    }

    public void addStartRect(Rectangle rectangle) {
        if (rectangle != null) {
            this.startRects.add(rectangle);
        }
    }

    public void addEndRect(Rectangle rectangle) {
        if (rectangle != null) {
            this.endRects.add(rectangle);
        }
    }

    public void addStartRect(Control control) {
        Rectangle rectangle = control.getBounds();
        Rectangle rectangle2 = Geometry.toDisplay((Control)control.getParent(), (Rectangle)rectangle);
        this.addStartRect(rectangle2);
    }

    public void addEndRect(Control control) {
        Rectangle rectangle = control.getBounds();
        Rectangle rectangle2 = Geometry.toDisplay((Control)control.getParent(), (Rectangle)rectangle);
        this.addEndRect(rectangle2);
    }

    public static Rectangle interpolate(Rectangle rectangle, Rectangle rectangle2, double d) {
        double d2 = 1.0 - d;
        Rectangle rectangle3 = new Rectangle((int)((double)rectangle.x * d2 + (double)rectangle2.x * d), (int)((double)rectangle.y * d2 + (double)rectangle2.y * d), (int)((double)rectangle.width * d2 + (double)rectangle2.width * d), (int)((double)rectangle.height * d2 + (double)rectangle2.height * d));
        return rectangle3;
    }

    public List getStartRects() {
        return this.startRects;
    }

    public List getEndRects() {
        return this.endRects;
    }

    public List getCurrentRects(double d) {
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        Iterator iterator = this.getStartRects().iterator();
        Iterator iterator2 = this.getEndRects().iterator();
        while (iterator.hasNext()) {
            Rectangle rectangle = (Rectangle)iterator.next();
            Rectangle rectangle2 = (Rectangle)iterator2.next();
            Rectangle rectangle3 = RectangleAnimationFeedbackBase.interpolate(rectangle, rectangle2, d);
            arrayList.add(rectangle3);
        }
        return arrayList;
    }
}

