/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.DefaultAnimationFeedback;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.util.PrefUtil;

public class RectangleAnimation
extends Job {
    public static final int TICK_TIMER = 1;
    public static final int FRAME_COUNT = 2;
    private Display display;
    private boolean enableAnimations;
    private int timingStyle = 1;
    private int duration;
    private DefaultAnimationFeedback feedbackRenderer;
    private long frameCount;
    private long startTime;
    private long curTime;
    private long prevTime;
    private Runnable animationStep = new Runnable(){

        @Override
        public void run() {
            RectangleAnimation.this.prevTime = RectangleAnimation.this.curTime;
            RectangleAnimation.this.curTime = System.currentTimeMillis();
            if (RectangleAnimation.this.curTime != RectangleAnimation.this.prevTime) {
                RectangleAnimation.this.clockTick();
            }
            if (RectangleAnimation.this.isUpdateStep()) {
                RectangleAnimation.this.updateDisplay();
                RectangleAnimation rectangleAnimation = RectangleAnimation.this;
                rectangleAnimation.frameCount = rectangleAnimation.frameCount + 1L;
            }
        }
    };

    private boolean done() {
        return this.amount() >= 1.0;
    }

    public static Rectangle interpolate(Rectangle rectangle, Rectangle rectangle2, double d) {
        double d2 = 1.0 - d;
        Rectangle rectangle3 = new Rectangle((int)((double)rectangle.x * d2 + (double)rectangle2.x * d), (int)((double)rectangle.y * d2 + (double)rectangle2.y * d), (int)((double)rectangle.width * d2 + (double)rectangle2.width * d), (int)((double)rectangle.height * d2 + (double)rectangle2.height * d));
        return rectangle3;
    }

    public RectangleAnimation(Shell shell, Rectangle rectangle, Rectangle rectangle2, int n) {
        super(WorkbenchMessages.RectangleAnimation_Animating_Rectangle);
        IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
        this.enableAnimations = iPreferenceStore.getBoolean("ENABLE_ANIMATIONS");
        if (!this.enableAnimations) {
            return;
        }
        this.display = shell.getDisplay();
        this.duration = n;
        this.setSystem(true);
        this.feedbackRenderer = AnimationFeedbackFactory.createAnimationRenderer(shell);
        this.feedbackRenderer.initialize(shell, rectangle, rectangle2);
        this.curTime = this.startTime = System.currentTimeMillis();
    }

    public RectangleAnimation(Shell shell, Rectangle rectangle, Rectangle rectangle2) {
        this(shell, rectangle, rectangle2, 400);
    }

    public void addStartRect(Rectangle rectangle) {
        if (this.feedbackRenderer != null) {
            this.feedbackRenderer.addStartRect(rectangle);
        }
    }

    public void addEndRect(Rectangle rectangle) {
        if (this.feedbackRenderer != null) {
            this.feedbackRenderer.addEndRect(rectangle);
        }
    }

    public void addStartRect(Control control) {
        Rectangle rectangle = control.getBounds();
        Rectangle rectangle2 = Geometry.toDisplay((Control)control.getParent(), (Rectangle)rectangle);
        this.addStartRect(rectangle2);
    }

    public void addEndRect(Control control) {
        Rectangle rectangle = control.getBounds();
        Rectangle rectangle2 = Geometry.toDisplay((Control)control.getParent(), (Rectangle)rectangle);
        this.addEndRect(rectangle2);
    }

    protected void clockTick() {
    }

    protected boolean isUpdateStep() {
        switch (this.timingStyle) {
            case 1: {
                return this.prevTime != this.curTime;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    private double amount() {
        double d = 0.0;
        switch (this.timingStyle) {
            case 1: {
                d = (double)(this.curTime - this.startTime) / (double)this.duration;
                break;
            }
            case 2: {
                d = (double)this.frameCount / (double)this.duration;
            }
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    protected void updateDisplay() {
        this.feedbackRenderer.renderStep(this.amount());
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        boolean bl;
        if (!this.enableAnimations || this.feedbackRenderer == null) {
            return Status.OK_STATUS;
        }
        boolean bl2 = bl = this.feedbackRenderer.getStartRects().size() == 0;
        if (bl) {
            return Status.OK_STATUS;
        }
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                RectangleAnimation.this.feedbackRenderer.jobInit();
            }
        });
        this.curTime = this.startTime = System.currentTimeMillis();
        while (!this.done()) {
            this.display.syncExec(this.animationStep);
            Thread.yield();
        }
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                RectangleAnimation.this.feedbackRenderer.dispose();
            }
        });
        return Status.OK_STATUS;
    }

    private static class AnimationFeedbackFactory {
        private AnimationFeedbackFactory() {
        }

        public static DefaultAnimationFeedback createAnimationRenderer(Shell shell) {
            return new DefaultAnimationFeedback();
        }
    }
}

