/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.internal.IChangeListener;
import org.eclipse.ui.internal.Model;

public class RadioMenu
implements IChangeListener {
    private Model data;
    private Menu parent;
    private List items = new ArrayList();
    SelectionAdapter selectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Object object = selectionEvent.widget.getData();
            RadioMenu.this.data.setState(object, RadioMenu.this);
        }
    };

    public RadioMenu(Menu menu, Model model) {
        this.parent = menu;
        this.data = model;
        model.addChangeListener(this);
    }

    private static boolean isEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public void addMenuItem(String string, Object object) {
        MenuItem menuItem = new MenuItem(this.parent, 16);
        menuItem.setSelection(RadioMenu.isEqual(this.data.getState(), object));
        menuItem.setText(string);
        menuItem.setData(object);
        this.items.add(menuItem);
        menuItem.addSelectionListener((SelectionListener)this.selectionAdapter);
    }

    public void dispose() {
        for (MenuItem menuItem : this.items) {
            if (menuItem.isDisposed()) continue;
            menuItem.removeSelectionListener((SelectionListener)this.selectionAdapter);
            menuItem.dispose();
        }
        this.items.clear();
    }

    private void refreshSelection() {
        for (MenuItem menuItem : this.items) {
            if (menuItem.isDisposed()) continue;
            menuItem.setSelection(RadioMenu.isEqual(this.data.getState(), menuItem.getData()));
        }
    }

    @Override
    public void update(boolean bl) {
        this.refreshSelection();
    }
}

