/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.branding.IProductConstants;
import org.eclipse.ui.internal.BrandingProperties;
import org.osgi.framework.Bundle;

public class ProductProperties
extends BrandingProperties
implements IProductConstants {
    private final IProduct product;
    private String appName;
    private String aboutText;
    private ImageDescriptor aboutImageDescriptor;
    private ImageDescriptor[] windowImageDescriptors;
    private URL welcomePageUrl;
    private String productName;
    private String productId;
    private static final String ABOUT_MAPPINGS = "$nl$/about.mappings";
    private static HashMap mappingsMap = new HashMap(4);

    private static String[] loadMappings(Bundle bundle) {
        PropertyResourceBundle propertyResourceBundle;
        block19: {
            URL uRL = Platform.find((Bundle)bundle, (IPath)new Path(ABOUT_MAPPINGS));
            propertyResourceBundle = null;
            if (uRL != null) {
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = uRL.openStream();
                        propertyResourceBundle = new PropertyResourceBundle(inputStream);
                    }
                    catch (IOException iOException) {
                        propertyResourceBundle = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            break block19;
                        }
                        catch (IOException iOException2) {}
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (propertyResourceBundle != null) {
            boolean bl = true;
            int n = 0;
            while (bl) {
                try {
                    arrayList.add(propertyResourceBundle.getString(Integer.toString(n)));
                }
                catch (MissingResourceException missingResourceException) {
                    bl = false;
                }
                ++n;
            }
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        mappingsMap.put(bundle, stringArray);
        return stringArray;
    }

    private static String[] getMappings(Bundle bundle) {
        String[] stringArray = (String[])mappingsMap.get(bundle);
        if (stringArray == null) {
            stringArray = ProductProperties.loadMappings(bundle);
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public ProductProperties(IProduct iProduct) {
        if (iProduct == null) {
            throw new IllegalArgumentException();
        }
        this.product = iProduct;
    }

    public String getAppName() {
        if (this.appName == null) {
            this.appName = ProductProperties.getAppName(this.product);
        }
        return this.appName;
    }

    public String getAboutText() {
        if (this.aboutText == null) {
            this.aboutText = ProductProperties.getAboutText(this.product);
        }
        return this.aboutText;
    }

    public ImageDescriptor getAboutImage() {
        if (this.aboutImageDescriptor == null) {
            this.aboutImageDescriptor = ProductProperties.getAboutImage(this.product);
        }
        return this.aboutImageDescriptor;
    }

    public ImageDescriptor[] getWindowImages() {
        if (this.windowImageDescriptors == null) {
            this.windowImageDescriptors = ProductProperties.getWindowImages(this.product);
        }
        return this.windowImageDescriptors;
    }

    public URL getWelcomePageUrl() {
        if (this.welcomePageUrl == null) {
            this.welcomePageUrl = ProductProperties.getWelcomePageUrl(this.product);
        }
        return this.welcomePageUrl;
    }

    public String getProductName() {
        if (this.productName == null) {
            this.productName = ProductProperties.getProductName(this.product);
        }
        return this.productName;
    }

    public String getProductId() {
        if (this.productId == null) {
            this.productId = ProductProperties.getProductId(this.product);
        }
        return this.productId;
    }

    public static String getAppName(IProduct iProduct) {
        String string = iProduct.getProperty("appName");
        if (string == null) {
            return "";
        }
        if (string.indexOf(123) == -1) {
            return string;
        }
        Object[] objectArray = ProductProperties.getMappings(iProduct.getDefiningBundle());
        return MessageFormat.format((String)string, (Object[])objectArray);
    }

    public static String getAboutText(IProduct iProduct) {
        String string = iProduct.getProperty("aboutText");
        if (string == null) {
            return "";
        }
        if (string.indexOf(123) == -1) {
            return string;
        }
        Object[] objectArray = (String[])ProductProperties.getMappings(iProduct.getDefiningBundle()).clone();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            int n2 = ((String)object).length();
            if (n2 > 2 && ((String)object).charAt(0) == '$' && ((String)object).charAt(n2 - 1) == '$') {
                String string2 = ((String)object).substring(1, n2 - 1);
                objectArray[n] = System.getProperty(string2, "");
            }
            ++n;
        }
        return MessageFormat.format((String)string, (Object[])objectArray);
    }

    public static ImageDescriptor getAboutImage(IProduct iProduct) {
        return ProductProperties.getImage(iProduct.getProperty("aboutImage"), iProduct.getDefiningBundle());
    }

    public static ImageDescriptor[] getWindowImages(IProduct iProduct) {
        String string = iProduct.getProperty("windowImages");
        if (string == null) {
            string = iProduct.getProperty("windowImage");
        }
        return ProductProperties.getImages(string, iProduct.getDefiningBundle());
    }

    public static URL getWelcomePageUrl(IProduct iProduct) {
        return ProductProperties.getUrl(iProduct.getProperty("welcomePage"), iProduct.getDefiningBundle());
    }

    public static String getProductName(IProduct iProduct) {
        return iProduct.getName();
    }

    public static String getProductId(IProduct iProduct) {
        return iProduct.getId();
    }
}

