/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.PluginActionContributionItem;
import org.eclipse.ui.internal.ViewerActionBuilder;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.menus.InternalMenuService;
import org.eclipse.ui.menus.IMenuService;

public class PopupMenuExtender
implements IMenuListener2,
IRegistryChangeListener {
    private static final int STATIC_ACTION_READ = 1;
    private static final int INCLUDE_EDITOR_INPUT = 2;
    private final MenuManager menu;
    private SubMenuManager menuWrapper;
    private final ISelectionProvider selProvider;
    private final IWorkbenchPart part;
    private Map staticActionBuilders = null;
    private int bitSet = 0;
    private ArrayList actionContributionCache = new ArrayList();
    private ArrayList managerContributionCache = new ArrayList();
    private boolean cleanupNeeded = false;
    private boolean contributionsPopulated = false;

    public PopupMenuExtender(String string, MenuManager menuManager, ISelectionProvider iSelectionProvider, IWorkbenchPart iWorkbenchPart) {
        this(string, menuManager, iSelectionProvider, iWorkbenchPart, true);
    }

    public PopupMenuExtender(String string, MenuManager menuManager, ISelectionProvider iSelectionProvider, IWorkbenchPart iWorkbenchPart, boolean bl) {
        this.menu = menuManager;
        this.selProvider = iSelectionProvider;
        this.part = iWorkbenchPart;
        if (bl) {
            this.bitSet |= 2;
        }
        menuManager.addMenuListener((IMenuListener)this);
        if (!menuManager.getRemoveAllWhenShown()) {
            this.menuWrapper = new SubMenuManager((IMenuManager)menuManager);
            this.menuWrapper.setVisible(true);
        }
        this.readStaticActionsFor(string);
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public Set getMenuIds() {
        if (this.staticActionBuilders == null) {
            return Collections.EMPTY_SET;
        }
        return this.staticActionBuilders.keySet();
    }

    public final void addMenuId(String string) {
        this.bitSet &= 0xFFFFFFFE;
        this.readStaticActionsFor(string);
    }

    public final boolean matches(MenuManager menuManager, ISelectionProvider iSelectionProvider, IWorkbenchPart iWorkbenchPart) {
        return this.menu == menuManager && this.selProvider == iSelectionProvider && this.part == iWorkbenchPart;
    }

    private void addEditorActions(IMenuManager iMenuManager) {
        ISelectionProvider iSelectionProvider = new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }

            public ISelection getSelection() {
                if (PopupMenuExtender.this.part instanceof IEditorPart) {
                    IEditorPart iEditorPart = (IEditorPart)PopupMenuExtender.this.part;
                    return new StructuredSelection(new Object[]{iEditorPart.getEditorInput()});
                }
                return new StructuredSelection(new Object[0]);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }

            public void setSelection(ISelection iSelection) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }
        };
        if (ObjectActionContributorManager.getManager().contributeObjectActions(this.part, iMenuManager, iSelectionProvider)) {
            iMenuManager.add((IContributionItem)new Separator());
        }
    }

    private void addObjectActions(IMenuManager iMenuManager) {
        if (this.selProvider != null && ObjectActionContributorManager.getManager().contributeObjectActions(this.part, iMenuManager, this.selProvider)) {
            iMenuManager.add((IContributionItem)new Separator());
        }
    }

    private final void clearStaticActions() {
        this.bitSet &= 0xFFFFFFFE;
        if (this.staticActionBuilders != null) {
            for (Object v : this.staticActionBuilders.values()) {
                if (!(v instanceof ViewerActionBuilder)) continue;
                ((ViewerActionBuilder)v).dispose();
            }
        }
    }

    private void addStaticActions(IMenuManager iMenuManager) {
        if (this.staticActionBuilders != null) {
            for (ViewerActionBuilder viewerActionBuilder : this.staticActionBuilders.values()) {
                viewerActionBuilder.contribute(iMenuManager, null, true);
            }
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        IWorkbench iWorkbench;
        IMenuManager iMenuManager2 = iMenuManager;
        IWorkbenchPartSite iWorkbenchPartSite = this.part.getSite();
        if (iWorkbenchPartSite != null && (iWorkbench = iWorkbenchPartSite.getWorkbenchWindow().getWorkbench()) instanceof Workbench) {
            Object object;
            Workbench workbench = (Workbench)iWorkbench;
            this.runCleanUp(workbench);
            StructuredSelection structuredSelection = null;
            if ((this.bitSet & 2) != 0 && this.part instanceof IEditorPart) {
                object = (IEditorPart)this.part;
                structuredSelection = new StructuredSelection(new Object[]{object.getEditorInput()});
            }
            object = this.selProvider == null ? null : this.selProvider.getSelection();
            workbench.addShowingMenus(this.getMenuIds(), (ISelection)object, (ISelection)structuredSelection);
        }
        this.readStaticActions();
        if (this.menuWrapper != null) {
            iMenuManager = this.menuWrapper;
            this.menuWrapper.removeAll();
        }
        this.addMenuContributions(iMenuManager2);
        if ((this.bitSet & 2) != 0) {
            this.addEditorActions(iMenuManager);
        }
        this.addObjectActions(iMenuManager);
        this.addStaticActions(iMenuManager);
        this.cleanUpContributionCache();
    }

    private void addMenuContributions(IMenuManager iMenuManager) {
        IMenuService iMenuService = (IMenuService)this.part.getSite().getService(IMenuService.class);
        if (iMenuService == null) {
            return;
        }
        if ((iMenuManager.getRemoveAllWhenShown() || !this.contributionsPopulated) && iMenuManager instanceof ContributionManager) {
            ContributionManager contributionManager = (ContributionManager)iMenuManager;
            this.contributionsPopulated = true;
            iMenuService.populateContributionManager(contributionManager, "popup:org.eclipse.ui.popup.any");
            Iterator iterator = this.getMenuIds().iterator();
            while (iterator.hasNext()) {
                String string = "popup:" + iterator.next();
                if (iMenuService instanceof InternalMenuService) {
                    ((InternalMenuService)iMenuService).populateContributionManager(contributionManager, string, false);
                    continue;
                }
                iMenuService.populateContributionManager(contributionManager, string);
            }
        }
    }

    public final void menuAboutToHide(IMenuManager iMenuManager) {
        IWorkbench iWorkbench;
        this.gatherContributions(iMenuManager);
        this.cleanupNeeded = true;
        IWorkbenchPartSite iWorkbenchPartSite = this.part.getSite();
        if (iWorkbenchPartSite != null && (iWorkbench = iWorkbenchPartSite.getWorkbenchWindow().getWorkbench()) instanceof Workbench) {
            iWorkbench.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Workbench workbench = (Workbench)iWorkbench;
                    PopupMenuExtender.this.runCleanUp(workbench);
                }
            });
        }
    }

    private void runCleanUp(Workbench workbench) {
        if (!this.cleanupNeeded) {
            return;
        }
        this.cleanupNeeded = false;
        workbench.removeShowingMenus(this.getMenuIds(), null, null);
        this.cleanUpContributionCache();
    }

    private void gatherContributions(IMenuManager iMenuManager) {
        IContributionItem[] iContributionItemArray = iMenuManager.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            if (iContributionItemArray[n] instanceof PluginActionContributionItem) {
                this.actionContributionCache.add(iContributionItemArray[n]);
            } else if (iContributionItemArray[n] instanceof IMenuManager) {
                if (iContributionItemArray[n] instanceof ContributionManager) {
                    this.managerContributionCache.add(iContributionItemArray[n]);
                }
                this.gatherContributions((IMenuManager)iContributionItemArray[n]);
            }
            ++n;
        }
    }

    private void cleanUpContributionCache() {
        PluginActionContributionItem[] pluginActionContributionItemArray;
        if (!this.actionContributionCache.isEmpty()) {
            pluginActionContributionItemArray = this.actionContributionCache.toArray(new PluginActionContributionItem[this.actionContributionCache.size()]);
            this.actionContributionCache.clear();
            int n = 0;
            while (n < pluginActionContributionItemArray.length) {
                pluginActionContributionItemArray[n].dispose();
                ++n;
            }
        }
        if (!this.managerContributionCache.isEmpty() && this.menu.getRemoveAllWhenShown()) {
            pluginActionContributionItemArray = this.managerContributionCache.toArray(new ContributionManager[this.managerContributionCache.size()]);
            this.managerContributionCache.clear();
            IMenuService iMenuService = (IMenuService)this.part.getSite().getService(IMenuService.class);
            if (iMenuService instanceof InternalMenuService) {
                InternalMenuService internalMenuService = (InternalMenuService)iMenuService;
                int n = 0;
                while (n < pluginActionContributionItemArray.length) {
                    internalMenuService.releaseContributions((ContributionManager)pluginActionContributionItemArray[n]);
                    pluginActionContributionItemArray[n].removeAll();
                    ++n;
                }
            }
        } else {
            this.managerContributionCache.clear();
        }
    }

    private final void readStaticActions() {
        if (this.staticActionBuilders != null) {
            for (String string : this.staticActionBuilders.keySet()) {
                this.readStaticActionsFor(string);
            }
        }
    }

    private void readStaticActionsFor(String string) {
        Object object;
        if ((this.bitSet & 1) != 0) {
            return;
        }
        this.bitSet |= 1;
        if (string == null || string.length() < 1) {
            return;
        }
        if (this.staticActionBuilders == null) {
            this.staticActionBuilders = new HashMap();
        }
        if (!((object = this.staticActionBuilders.get(string)) instanceof ViewerActionBuilder)) {
            object = new ViewerActionBuilder();
            this.staticActionBuilders.put(string, object);
        }
        ViewerActionBuilder viewerActionBuilder = (ViewerActionBuilder)object;
        viewerActionBuilder.readViewerContributions(string, this.selProvider, this.part);
    }

    public void dispose() {
        this.clearStaticActions();
        IMenuService iMenuService = (IMenuService)this.part.getSite().getService(IMenuService.class);
        if (iMenuService != null) {
            iMenuService.releaseContributions((ContributionManager)this.menu);
        }
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
        this.menu.removeMenuListener((IMenuListener)this);
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        Display display = Display.getDefault();
        if (this.part != null) {
            display = this.part.getSite().getPage().getWorkbenchWindow().getWorkbench().getDisplay();
        }
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas();
        int n = 0;
        while (n < iExtensionDeltaArray.length) {
            IExtensionDelta iExtensionDelta = iExtensionDeltaArray[n];
            IExtensionPoint iExtensionPoint = iExtensionDelta.getExtensionPoint();
            if (iExtensionPoint.getNamespace().equals(WorkbenchPlugin.PI_WORKBENCH) && iExtensionPoint.getSimpleIdentifier().equals("popupMenus")) {
                boolean bl = false;
                IConfigurationElement[] iConfigurationElementArray = iExtensionDelta.getExtension().getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    if (iConfigurationElement.getName().equals("viewerContribution")) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            PopupMenuExtender.this.clearStaticActions();
                        }
                    });
                }
            }
            ++n;
        }
    }

    public MenuManager getManager() {
        return this.menu;
    }
}

