/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.ActionSetActionBars;
import org.eclipse.ui.internal.ActionSetContributionItem;
import org.eclipse.ui.internal.ActionSetSeparator;
import org.eclipse.ui.internal.IActionSetContributionItem;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.PluginActionBuilder;
import org.eclipse.ui.internal.PluginActionCoolBarContributionItem;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.WWinPluginAction;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.services.IDisposable;

public class PluginActionSetBuilder
extends PluginActionBuilder {
    private PluginActionSet actionSet;
    private IWorkbenchWindow window;
    private ArrayList adjunctContributions = new ArrayList(0);

    public void buildMenuAndToolBarStructure(PluginActionSet pluginActionSet, IWorkbenchWindow iWorkbenchWindow) {
        ActionSetContribution actionSetContribution;
        int n;
        this.actionSet = pluginActionSet;
        this.window = iWorkbenchWindow;
        this.cache = null;
        this.currentContribution = null;
        this.targetID = null;
        this.targetContributionTag = "actionSet";
        this.readElements(new IConfigurationElement[]{pluginActionSet.getConfigElement()});
        if (this.cache != null) {
            n = 0;
            while (n < this.cache.size()) {
                actionSetContribution = (ActionSetContribution)this.cache.get(n);
                actionSetContribution.contribute(this.actionSet.getBars(), true, true);
                if (actionSetContribution.isAdjunctContributor()) {
                    this.adjunctContributions.add(actionSetContribution);
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.adjunctContributions.size()) {
            actionSetContribution = (ActionSetContribution)this.adjunctContributions.get(n);
            ActionSetActionBars actionSetActionBars = this.actionSet.getBars();
            int n2 = 0;
            while (n2 < actionSetContribution.adjunctActions.size()) {
                ActionDescriptor actionDescriptor = (ActionDescriptor)actionSetContribution.adjunctActions.get(n2);
                actionSetContribution.contributeAdjunctCoolbarAction(actionDescriptor, actionSetActionBars);
                ++n2;
            }
            ++n;
        }
        this.registerBinding(pluginActionSet);
    }

    @Override
    protected ActionDescriptor createActionDescriptor(IConfigurationElement iConfigurationElement) {
        Object object;
        boolean bl = false;
        String string = iConfigurationElement.getAttribute("style");
        bl = string != null ? string.equals("pulldown") : (object = iConfigurationElement.getAttribute("pulldown")) != null && ((String)object).equals("true");
        object = null;
        object = bl ? new ActionDescriptor(iConfigurationElement, 5, this.window) : new ActionDescriptor(iConfigurationElement, 3, this.window);
        WWinPluginAction wWinPluginAction = (WWinPluginAction)((ActionDescriptor)object).getAction();
        wWinPluginAction.setActionSetId(this.actionSet.getDesc().getId());
        this.actionSet.addPluginAction(wWinPluginAction);
        return object;
    }

    @Override
    protected PluginActionBuilder.BasicContribution createContribution() {
        return new ActionSetContribution(this.actionSet.getDesc().getId(), this.window);
    }

    public static IContributionItem findInsertionPoint(String string, String string2, IContributionManager iContributionManager, boolean bl) {
        IContributionItem[] iContributionItemArray = iContributionManager.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            if (string.equals(iContributionItemArray[n].getId())) break;
            ++n;
        }
        if (n >= iContributionItemArray.length) {
            return null;
        }
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        int n3 = n + 1;
        while (n3 < iContributionItemArray.length) {
            String string3;
            IContributionItem iContributionItem = iContributionItemArray[n3];
            if (iContributionItem.isSeparator() || iContributionItem.isGroupMarker() || !(iContributionItem instanceof IActionSetContributionItem) || string2 != null && string2.compareTo(string3 = ((IActionSetContributionItem)iContributionItem).getActionSetId()) < n2) break;
            n = n3++;
        }
        return iContributionItemArray[n];
    }

    static void processActionSets(ArrayList arrayList, WorkbenchWindow workbenchWindow) {
        Object object;
        PluginActionSetBuilder[] pluginActionSetBuilderArray = new PluginActionSetBuilder[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            object = (PluginActionSet)arrayList.get(n);
            PluginActionSetBuilder pluginActionSetBuilder = new PluginActionSetBuilder();
            pluginActionSetBuilder.readActionExtensions((PluginActionSet)object, workbenchWindow);
            pluginActionSetBuilderArray[n] = pluginActionSetBuilder;
            ++n;
        }
        n = 0;
        while (n < pluginActionSetBuilderArray.length) {
            object = pluginActionSetBuilderArray[n];
            ((PluginActionSetBuilder)object).processAdjunctContributions();
            ++n;
        }
    }

    protected void processAdjunctContributions() {
        int n = 0;
        while (n < this.adjunctContributions.size()) {
            ActionSetContribution actionSetContribution = (ActionSetContribution)this.adjunctContributions.get(n);
            ActionSetActionBars actionSetActionBars = this.actionSet.getBars();
            int n2 = 0;
            while (n2 < actionSetContribution.adjunctActions.size()) {
                ActionDescriptor actionDescriptor = (ActionDescriptor)actionSetContribution.adjunctActions.get(n2);
                actionSetContribution.contributeAdjunctCoolbarAction(actionDescriptor, actionSetActionBars);
                ++n2;
            }
            ++n;
        }
    }

    protected void readActionExtensions(PluginActionSet pluginActionSet, IWorkbenchWindow iWorkbenchWindow) {
        this.actionSet = pluginActionSet;
        this.window = iWorkbenchWindow;
        this.cache = null;
        this.currentContribution = null;
        this.targetID = null;
        this.targetContributionTag = "actionSet";
        this.readElements(new IConfigurationElement[]{pluginActionSet.getConfigElement()});
        if (this.cache != null) {
            int n = 0;
            while (n < this.cache.size()) {
                ActionSetContribution actionSetContribution = (ActionSetContribution)this.cache.get(n);
                actionSetContribution.contribute(this.actionSet.getBars(), true, true);
                if (actionSetContribution.isAdjunctContributor()) {
                    this.adjunctContributions.add(actionSetContribution);
                }
                ++n;
            }
            this.registerBinding(pluginActionSet);
        } else {
            WorkbenchPlugin.log("Action Set is empty: " + pluginActionSet.getDesc().getId());
        }
    }

    private void registerBinding(PluginActionSet pluginActionSet) {
        IExtensionTracker iExtensionTracker = this.window.getExtensionTracker();
        Binding binding = new Binding();
        binding.builder = this;
        binding.set = pluginActionSet;
        binding.window = this.window;
        binding.tracker = iExtensionTracker;
        iExtensionTracker.registerObject(pluginActionSet.getConfigElement().getDeclaringExtension(), (Object)binding, 0);
        pluginActionSet.setBuilder(binding);
    }

    protected void removeActionExtensions(PluginActionSet pluginActionSet, IWorkbenchWindow iWorkbenchWindow) {
        this.actionSet = pluginActionSet;
        this.window = iWorkbenchWindow;
        this.currentContribution = null;
        this.targetID = null;
        this.targetContributionTag = "actionSet";
        String string = pluginActionSet.getDesc().getId();
        if (this.cache != null) {
            int n = 0;
            while (n < this.cache.size()) {
                ActionSetContribution actionSetContribution = (ActionSetContribution)this.cache.get(n);
                actionSetContribution.revokeContribution((WorkbenchWindow)iWorkbenchWindow, this.actionSet.getBars(), string);
                if (actionSetContribution.isAdjunctContributor()) {
                    int n2 = 0;
                    while (n2 < actionSetContribution.adjunctActions.size()) {
                        ActionDescriptor actionDescriptor = (ActionDescriptor)actionSetContribution.adjunctActions.get(n2);
                        actionSetContribution.revokeAdjunctCoolbarAction(actionDescriptor, this.actionSet.getBars());
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    private static class ActionSetContribution
    extends PluginActionBuilder.BasicContribution {
        private String actionSetId;
        private WorkbenchWindow window;
        protected ArrayList adjunctActions = new ArrayList(0);

        public ActionSetContribution(String string, IWorkbenchWindow iWorkbenchWindow) {
            this.actionSetId = string;
            this.window = (WorkbenchWindow)iWorkbenchWindow;
        }

        @Override
        protected void addGroup(IContributionManager iContributionManager, String string) {
            IContributionItem iContributionItem = PluginActionSetBuilder.findInsertionPoint("additions", this.actionSetId, iContributionManager, true);
            ActionSetSeparator actionSetSeparator = new ActionSetSeparator(string, this.actionSetId);
            if (iContributionItem == null) {
                iContributionManager.add((IContributionItem)actionSetSeparator);
            } else {
                iContributionManager.insertAfter(iContributionItem.getId(), (IContributionItem)actionSetSeparator);
            }
        }

        public void contribute(IActionBars iActionBars, boolean bl, boolean bl2) {
            Object object;
            int n;
            IMenuManager iMenuManager = iActionBars.getMenuManager();
            IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
            if (this.menus != null && iMenuManager != null) {
                n = 0;
                while (n < this.menus.size()) {
                    object = (IConfigurationElement)this.menus.get(n);
                    this.contributeMenu((IConfigurationElement)object, iMenuManager, bl);
                    ++n;
                }
            }
            if (this.actions != null) {
                n = 0;
                while (n < this.actions.size()) {
                    object = (ActionDescriptor)this.actions.get(n);
                    if (iMenuManager != null) {
                        this.contributeMenuAction((ActionDescriptor)object, iMenuManager, bl);
                    }
                    if (iToolBarManager != null) {
                        if (iActionBars instanceof ActionSetActionBars) {
                            this.contributeCoolbarAction((ActionDescriptor)object, (ActionSetActionBars)iActionBars);
                        } else {
                            this.contributeToolbarAction((ActionDescriptor)object, iToolBarManager, bl2);
                        }
                    }
                    ++n;
                }
            }
        }

        protected void contributeAdjunctCoolbarAction(ActionDescriptor actionDescriptor, ActionSetActionBars actionSetActionBars) {
            IContributionItem iContributionItem;
            String string = actionDescriptor.getToolbarId();
            String string2 = actionDescriptor.getToolbarGroupId();
            String string3 = actionSetActionBars.getActionSetId();
            ICoolBarManager iCoolBarManager = actionSetActionBars.getCoolBarManager();
            if (iCoolBarManager == null) {
                return;
            }
            PluginAction pluginAction = actionDescriptor.getAction();
            PluginActionCoolBarContributionItem pluginActionCoolBarContributionItem = new PluginActionCoolBarContributionItem(pluginAction);
            pluginActionCoolBarContributionItem.setMode(actionDescriptor.getMode());
            actionSetActionBars.addAdjunctContribution((IContributionItem)pluginActionCoolBarContributionItem);
            IToolBarManager iToolBarManager = actionSetActionBars.getToolBarManager(string);
            IContributionItem iContributionItem2 = iToolBarManager.find(string2);
            if (iContributionItem2 == null) {
                iToolBarManager.add((IContributionItem)new Separator(string2));
            }
            if ((iContributionItem = this.findAlphabeticalOrder(string2, string3, (IContributionManager)iToolBarManager)) != null && iContributionItem.getId() != null) {
                iToolBarManager.insertAfter(iContributionItem.getId(), (IContributionItem)pluginActionCoolBarContributionItem);
            } else {
                iToolBarManager.add((IContributionItem)pluginActionCoolBarContributionItem);
            }
            iToolBarManager.update(false);
        }

        protected void contributeCoolbarAction(ActionDescriptor actionDescriptor, ActionSetActionBars actionSetActionBars) {
            String string = actionDescriptor.getToolbarId();
            String string2 = actionDescriptor.getToolbarGroupId();
            if (string == null && string2 == null) {
                return;
            }
            String string3 = actionSetActionBars.getActionSetId();
            if (string == null || string.equals("")) {
                string = string3;
            }
            if (!string.equals(string3)) {
                if (!this.isValidCoolItemId(string, this.window)) {
                    string = string3;
                } else {
                    this.adjunctActions.add(actionDescriptor);
                    return;
                }
            }
            PluginAction pluginAction = actionDescriptor.getAction();
            PluginActionCoolBarContributionItem pluginActionCoolBarContributionItem = new PluginActionCoolBarContributionItem(pluginAction);
            pluginActionCoolBarContributionItem.setMode(actionDescriptor.getMode());
            IToolBarManager iToolBarManager = actionSetActionBars.getToolBarManager(string);
            IContributionItem iContributionItem = iToolBarManager.find(string2);
            if (iContributionItem == null) {
                iToolBarManager.add((IContributionItem)new Separator(string2));
            }
            iToolBarManager.prependToGroup(string2, (IContributionItem)pluginActionCoolBarContributionItem);
            iToolBarManager.update(false);
        }

        private boolean isValidCoolItemId(String string, WorkbenchWindow workbenchWindow) {
            ActionSetRegistry actionSetRegistry = WorkbenchPlugin.getDefault().getActionSetRegistry();
            if (actionSetRegistry.findActionSet(string) != null) {
                return true;
            }
            if (workbenchWindow != null) {
                return workbenchWindow.isWorkbenchCoolItemId(string);
            }
            return false;
        }

        @Override
        protected void insertMenuGroup(IMenuManager iMenuManager, AbstractGroupMarker abstractGroupMarker) {
            if (this.actionSetId != null) {
                IContributionItem[] iContributionItemArray = iMenuManager.getItems();
                int n = 0;
                while (n < iContributionItemArray.length) {
                    String string;
                    IContributionItem iContributionItem = iContributionItemArray[n];
                    if ((iContributionItem.isSeparator() || iContributionItem.isGroupMarker()) && iContributionItem instanceof IActionSetContributionItem && this.actionSetId.compareTo(string = ((IActionSetContributionItem)iContributionItem).getActionSetId()) < 0) {
                        iMenuManager.insertBefore(iContributionItemArray[n].getId(), (IContributionItem)abstractGroupMarker);
                        return;
                    }
                    ++n;
                }
            }
            iMenuManager.add((IContributionItem)abstractGroupMarker);
        }

        private IContributionItem findAlphabeticalOrder(String string, String string2, IContributionManager iContributionManager) {
            IContributionItem[] iContributionItemArray = iContributionManager.getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                IContributionItem iContributionItem = iContributionItemArray[n];
                if (string != null && string.equals(iContributionItem.getId())) break;
                ++n;
            }
            int n2 = n + 1;
            while (n2 < iContributionItemArray.length) {
                IContributionItem iContributionItem = iContributionItemArray[n2];
                if (iContributionItem.isGroupMarker()) break;
                String string3 = null;
                if (iContributionItem instanceof PluginActionCoolBarContributionItem) {
                    string3 = ((PluginActionCoolBarContributionItem)iContributionItem).getActionSetId();
                }
                if (string3 == null || string2 != null && string3 != null && string2.compareTo(string3) < 1) break;
                n = n2++;
            }
            if (n >= iContributionItemArray.length) {
                return null;
            }
            return iContributionItemArray[n];
        }

        public boolean isAdjunctContributor() {
            return this.adjunctActions.size() > 0;
        }

        @Override
        protected void insertAfter(IContributionManager iContributionManager, String string, IContributionItem iContributionItem) {
            IContributionItem iContributionItem2 = PluginActionSetBuilder.findInsertionPoint(string, this.actionSetId, iContributionManager, true);
            if (iContributionItem2 != null) {
                iContributionManager.insertAfter(iContributionItem2.getId(), iContributionItem);
            } else {
                WorkbenchPlugin.log("Reference item " + string + " not found for action " + iContributionItem.getId());
            }
        }

        protected void revokeContribution(WorkbenchWindow workbenchWindow, IActionBars iActionBars, String string) {
            this.revokeActionSetFromMenu((IMenuManager)workbenchWindow.getMenuManager(), string);
            this.revokeActionSetFromCoolbar(workbenchWindow.getCoolBarManager2(), string);
        }

        protected void revokeAdjunctCoolbarAction(ActionDescriptor actionDescriptor, ActionSetActionBars actionSetActionBars) {
            String string = actionDescriptor.getToolbarId();
            ICoolBarManager iCoolBarManager = actionSetActionBars.getCoolBarManager();
            PluginAction pluginAction = actionDescriptor.getAction();
            PluginActionCoolBarContributionItem pluginActionCoolBarContributionItem = new PluginActionCoolBarContributionItem(pluginAction);
            pluginActionCoolBarContributionItem.setMode(actionDescriptor.getMode());
            actionSetActionBars.removeAdjunctContribution((ContributionItem)pluginActionCoolBarContributionItem);
            IContributionItem iContributionItem = iCoolBarManager.find(string);
            if (iContributionItem != null) {
                iCoolBarManager.remove(iContributionItem);
            }
        }

        private void revokeActionSetFromMenu(IMenuManager iMenuManager, String string) {
            IContributionItem[] iContributionItemArray = iMenuManager.getItems();
            ArrayList<IContributionItem> arrayList = new ArrayList<IContributionItem>();
            int n = 0;
            while (n < iContributionItemArray.length) {
                String string2;
                if (iContributionItemArray[n] instanceof IMenuManager) {
                    this.revokeActionSetFromMenu((IMenuManager)iContributionItemArray[n], string);
                } else if (iContributionItemArray[n] instanceof ActionSetContributionItem) {
                    string2 = ((ActionSetContributionItem)iContributionItemArray[n]).getActionSetId();
                    if (string.equals(string2)) {
                        arrayList.add(iContributionItemArray[n]);
                    }
                } else if (iContributionItemArray[n] instanceof Separator) {
                    string2 = ((Separator)iContributionItemArray[n]).getId();
                    if (string.equals(string2)) {
                        arrayList.add(iContributionItemArray[n]);
                    }
                } else if (iContributionItemArray[n] instanceof GroupMarker && string.equals(string2 = ((GroupMarker)iContributionItemArray[n]).getId())) {
                    arrayList.add(iContributionItemArray[n]);
                }
                ++n;
            }
            for (IContributionItem iContributionItem : arrayList) {
                iMenuManager.remove(iContributionItem);
            }
            iMenuManager.update(true);
        }

        private void revokeActionSetFromCoolbar(ICoolBarManager iCoolBarManager, String string) {
            IContributionItem[] iContributionItemArray = iCoolBarManager.getItems();
            ArrayList<IContributionItem> arrayList = new ArrayList<IContributionItem>();
            int n = 0;
            while (n < iContributionItemArray.length) {
                String string2 = iContributionItemArray[n].getId();
                if (string.equals(string2)) {
                    arrayList.add(iContributionItemArray[n]);
                } else if (iContributionItemArray[n] instanceof IToolBarManager) {
                    this.revokeActionSetFromToolbar((IToolBarManager)iContributionItemArray[n], string);
                } else if (iContributionItemArray[n] instanceof IToolBarContributionItem) {
                    string2 = ((IToolBarContributionItem)iContributionItemArray[n]).getId();
                    if (string.equals(string2)) {
                        arrayList.add(iContributionItemArray[n]);
                    }
                } else if (iContributionItemArray[n] instanceof GroupMarker && string.equals(string2 = ((GroupMarker)iContributionItemArray[n]).getId())) {
                    arrayList.add(iContributionItemArray[n]);
                }
                ++n;
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                iCoolBarManager.remove((IContributionItem)iterator.next());
            }
            iCoolBarManager.update(true);
        }

        private void revokeActionSetFromToolbar(IToolBarManager iToolBarManager, String string) {
            IContributionItem[] iContributionItemArray = iToolBarManager.getItems();
            ArrayList<IContributionItem> arrayList = new ArrayList<IContributionItem>();
            int n = 0;
            while (n < iContributionItemArray.length) {
                String string2 = iContributionItemArray[n].getId();
                if (string2.equals(string)) {
                    arrayList.add(iContributionItemArray[n]);
                } else if (iContributionItemArray[n] instanceof PluginActionCoolBarContributionItem) {
                    string2 = ((PluginActionCoolBarContributionItem)iContributionItemArray[n]).getActionSetId();
                    if (string.equals(string2)) {
                        arrayList.add(iContributionItemArray[n]);
                    }
                } else if (iContributionItemArray[n] instanceof ActionContributionItem) {
                    string2 = ((ActionContributionItem)iContributionItemArray[n]).getId();
                    if (string.equals(string2)) {
                        arrayList.add(iContributionItemArray[n]);
                    }
                } else if (iContributionItemArray[n] instanceof GroupMarker && string.equals(string2 = ((GroupMarker)iContributionItemArray[n]).getId())) {
                    arrayList.add(iContributionItemArray[n]);
                }
                ++n;
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                iToolBarManager.remove((IContributionItem)iterator.next());
            }
            iToolBarManager.update(true);
        }
    }

    public static class Binding
    implements IDisposable {
        PluginActionSetBuilder builder;
        PluginActionSet set;
        IWorkbenchWindow window;
        IExtensionTracker tracker;

        @Override
        public void dispose() {
            if (this.tracker != null) {
                this.tracker.unregisterObject(this.set.getConfigElement().getDeclaringExtension(), (Object)this);
                this.tracker = null;
            }
        }
    }
}

