/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ActionSetActionBars;
import org.eclipse.ui.internal.WWinPluginAction;
import org.eclipse.ui.internal.registry.ActionSetDescriptor;
import org.eclipse.ui.internal.registry.IActionSet;
import org.eclipse.ui.services.IDisposable;

public class PluginActionSet
implements IActionSet {
    private ActionSetDescriptor desc;
    private ArrayList pluginActions = new ArrayList(4);
    private ActionSetActionBars bars;
    private IDisposable disposableBuilder;

    public PluginActionSet(ActionSetDescriptor actionSetDescriptor) {
        this.desc = actionSetDescriptor;
    }

    public void addPluginAction(WWinPluginAction wWinPluginAction) {
        this.pluginActions.add(wWinPluginAction);
    }

    public IAction[] getPluginActions() {
        IAction[] iActionArray = new IAction[this.pluginActions.size()];
        this.pluginActions.toArray(iActionArray);
        return iActionArray;
    }

    @Override
    public void dispose() {
        for (WWinPluginAction wWinPluginAction : this.pluginActions) {
            wWinPluginAction.dispose();
        }
        this.pluginActions.clear();
        this.bars = null;
        if (this.disposableBuilder != null) {
            this.disposableBuilder.dispose();
            this.disposableBuilder = null;
        }
    }

    ActionSetActionBars getBars() {
        return this.bars;
    }

    public IConfigurationElement getConfigElement() {
        return this.desc.getConfigurationElement();
    }

    public ActionSetDescriptor getDesc() {
        return this.desc;
    }

    @Override
    public void init(IWorkbenchWindow iWorkbenchWindow, IActionBars iActionBars) {
        this.bars = (ActionSetActionBars)iActionBars;
    }

    public void setBuilder(IDisposable iDisposable) {
        if (this.disposableBuilder != null) {
            this.disposableBuilder.dispose();
        }
        this.disposableBuilder = iDisposable;
    }
}

