/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IIdentifierListener;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.IdentifierEvent;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.PluginAction;

public class PluginActionContributionItem
extends ActionContributionItem
implements IIdentifierListener,
IActivityManagerListener {
    private IIdentifier identifier = null;

    public PluginActionContributionItem(PluginAction pluginAction) {
        super((IAction)pluginAction);
    }

    private void hookListeners() {
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener(this);
        IIdentifier iIdentifier = this.getIdentifier();
        if (iIdentifier != null) {
            iIdentifier.addIdentifierListener(this);
        }
    }

    private void unhookListeners() {
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().removeActivityManagerListener(this);
        IIdentifier iIdentifier = this.getIdentifier();
        if (iIdentifier != null) {
            iIdentifier.removeIdentifierListener(this);
        }
    }

    public void setParent(IContributionManager iContributionManager) {
        IContributionManager iContributionManager2 = this.getParent();
        super.setParent(iContributionManager);
        if (iContributionManager2 == iContributionManager) {
            return;
        }
        if (iContributionManager == null) {
            this.unhookListeners();
        } else {
            this.hookListeners();
        }
    }

    private IIdentifier getIdentifier() {
        if (!WorkbenchActivityHelper.isFiltering()) {
            return null;
        }
        if (this.identifier == null) {
            IWorkbenchActivitySupport iWorkbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            IPluginContribution iPluginContribution = (IPluginContribution)this.getAction();
            this.identifier = iWorkbenchActivitySupport.getActivityManager().getIdentifier(WorkbenchActivityHelper.createUnifiedId(iPluginContribution));
        }
        return this.identifier;
    }

    private void disposeIdentifier() {
        this.identifier = null;
    }

    public void dispose() {
        this.unhookListeners();
        this.disposeIdentifier();
    }

    public boolean isVisible() {
        if (this.identifier != null && !this.identifier.isEnabled()) {
            return false;
        }
        return super.isVisible();
    }

    @Override
    public void identifierChanged(IdentifierEvent identifierEvent) {
        this.invalidateParent();
    }

    private void invalidateParent() {
        IContributionManager iContributionManager = this.getParent();
        if (iContributionManager != null) {
            iContributionManager.markDirty();
        }
    }

    @Override
    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (WorkbenchActivityHelper.isFiltering() && this.identifier == null) {
            this.hookListeners();
            this.invalidateParent();
        } else if (!WorkbenchActivityHelper.isFiltering() && this.identifier != null) {
            this.unhookListeners();
            this.disposeIdentifier();
            this.invalidateParent();
        }
    }

    public ISelection getSelection() {
        return ((PluginAction)this.getAction()).getSelection();
    }
}

