/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.PluginActionContributionItem;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class PluginActionBuilder
extends RegistryReader {
    protected String targetID;
    protected String targetContributionTag;
    protected BasicContribution currentContribution;
    protected ArrayList cache;
    private static boolean allowIdeLogging = false;

    public final void contribute(IMenuManager iMenuManager, IToolBarManager iToolBarManager, boolean bl) {
        if (this.cache == null) {
            return;
        }
        int n = 0;
        while (n < this.cache.size()) {
            BasicContribution basicContribution = (BasicContribution)this.cache.get(n);
            basicContribution.contribute(iMenuManager, bl, iToolBarManager, bl);
            ++n;
        }
    }

    protected abstract ActionDescriptor createActionDescriptor(IConfigurationElement var1);

    protected BasicContribution createContribution() {
        return new BasicContribution();
    }

    protected String getTargetID(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("targetID");
        return string != null ? string : "???";
    }

    protected String getID(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("id");
        return string != null ? string : "???";
    }

    protected void readContributions(String string, String string2, String string3) {
        this.cache = null;
        this.currentContribution = null;
        this.targetID = string;
        this.targetContributionTag = string2;
        this.readRegistry(Platform.getExtensionRegistry(), "org.eclipse.ui", string3);
    }

    @Override
    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getName();
        if (string.equals("objectContribution")) {
            return true;
        }
        if (string.equals(this.targetContributionTag)) {
            String string2;
            if (!(this.targetID == null || (string2 = this.getTargetID(iConfigurationElement)) != null && string2.equals(this.targetID))) {
                return true;
            }
            this.currentContribution = this.createContribution();
            this.readElementChildren(iConfigurationElement);
            if (this.cache == null) {
                this.cache = new ArrayList(4);
            }
            this.cache.add(this.currentContribution);
            this.currentContribution = null;
            return true;
        }
        if (string.equals("menu")) {
            this.currentContribution.addMenu(iConfigurationElement);
            return true;
        }
        if (string.equals("action")) {
            this.currentContribution.addAction(this.createActionDescriptor(iConfigurationElement));
            return true;
        }
        return false;
    }

    public static void setAllowIdeLogging(boolean bl) {
        allowIdeLogging = bl;
    }

    private static void ideLog(String string) {
        if (allowIdeLogging) {
            WorkbenchPlugin.log(string);
        }
    }

    protected static class BasicContribution {
        protected ArrayList menus;
        protected ArrayList actions;

        protected BasicContribution() {
        }

        public void addMenu(IConfigurationElement iConfigurationElement) {
            if (this.menus == null) {
                this.menus = new ArrayList(1);
            }
            this.menus.add(iConfigurationElement);
        }

        public void addAction(ActionDescriptor actionDescriptor) {
            if (this.actions == null) {
                this.actions = new ArrayList(3);
            }
            this.actions.add(actionDescriptor);
        }

        public void contribute(IMenuManager iMenuManager, boolean bl, IToolBarManager iToolBarManager, boolean bl2) {
            Object object;
            int n;
            if (this.menus != null && iMenuManager != null) {
                n = 0;
                while (n < this.menus.size()) {
                    object = (IConfigurationElement)this.menus.get(n);
                    this.contributeMenu((IConfigurationElement)object, iMenuManager, bl);
                    ++n;
                }
            }
            if (this.actions != null) {
                n = 0;
                while (n < this.actions.size()) {
                    object = (ActionDescriptor)this.actions.get(n);
                    if (iMenuManager != null) {
                        this.contributeMenuAction((ActionDescriptor)object, iMenuManager, bl);
                    }
                    if (iToolBarManager != null) {
                        this.contributeToolbarAction((ActionDescriptor)object, iToolBarManager, bl2);
                    }
                    ++n;
                }
            }
        }

        protected void contributeMenu(IConfigurationElement iConfigurationElement, IMenuManager iMenuManager, boolean bl) {
            IMenuManager iMenuManager2;
            IContributionItem iContributionItem;
            String string;
            String string2 = iConfigurationElement.getAttribute("id");
            String string3 = iConfigurationElement.getAttribute("label");
            String string4 = iConfigurationElement.getAttribute("path");
            String string5 = iConfigurationElement.getAttribute("icon");
            ImageDescriptor imageDescriptor = null;
            if (string5 != null) {
                string = iConfigurationElement.getDeclaringExtension().getContributor().getName();
                imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(string, string5);
            }
            if (string3 == null) {
                WorkbenchPlugin.log("Plugin '" + iConfigurationElement.getContributor().getName() + "' invalid Menu Extension (label == null): " + string2);
                return;
            }
            string = null;
            if (string4 != null) {
                int n = string4.lastIndexOf(47);
                if (n != -1) {
                    string = string4.substring(n + 1);
                    string4 = string4.substring(0, n);
                } else {
                    string = string4;
                    string4 = null;
                }
            }
            IMenuManager iMenuManager3 = iMenuManager;
            if (string4 != null && (iMenuManager3 = iMenuManager.findMenuUsingPath(string4)) == null) {
                PluginActionBuilder.ideLog("Plugin '" + iConfigurationElement.getContributor().getName() + "' invalid Menu Extension (Path '" + string4 + "' is invalid): " + string2);
                return;
            }
            if (string == null) {
                string = "additions";
            }
            if ((iContributionItem = iMenuManager3.find(string)) == null) {
                if (bl) {
                    this.addGroup((IContributionManager)iMenuManager3, string);
                } else {
                    WorkbenchPlugin.log("Plugin '" + iConfigurationElement.getContributor().getName() + "' invalid Menu Extension (Group '" + string + "' is invalid): " + string2);
                    return;
                }
            }
            if ((iMenuManager2 = iMenuManager3.findMenuUsingPath(string2)) == null) {
                iMenuManager2 = new MenuManager(string3, imageDescriptor, string2);
            }
            try {
                this.insertAfter((IContributionManager)iMenuManager3, string, (IContributionItem)iMenuManager2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                WorkbenchPlugin.log("Plugin '" + iConfigurationElement.getContributor().getName() + "' invalid Menu Extension (Group '" + string + "' is missing): " + string2);
            }
            iMenuManager2 = iMenuManager3.findMenuUsingPath(string2);
            if (iMenuManager2 == null) {
                WorkbenchPlugin.log("Could not find new menu: " + string2);
            }
            IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                String string6 = iConfigurationElementArray[n].getName();
                if (string6.equals("separator")) {
                    this.contributeSeparator(iMenuManager2, iConfigurationElementArray[n]);
                } else if (string6.equals("groupMarker")) {
                    this.contributeGroupMarker(iMenuManager2, iConfigurationElementArray[n]);
                }
                ++n;
            }
        }

        protected void contributeMenuAction(ActionDescriptor actionDescriptor, IMenuManager iMenuManager, boolean bl) {
            IContributionItem iContributionItem;
            String string = actionDescriptor.getMenuPath();
            String string2 = actionDescriptor.getMenuGroup();
            if (string == null && string2 == null) {
                return;
            }
            IMenuManager iMenuManager2 = iMenuManager;
            if (string != null && (iMenuManager2 = iMenuManager2.findMenuUsingPath(string)) == null) {
                PluginActionBuilder.ideLog("Plug-in '" + actionDescriptor.getPluginId() + "' contributed an invalid Menu Extension (Path: '" + string + "' is invalid): " + actionDescriptor.getId());
                return;
            }
            if (string2 == null) {
                string2 = "additions";
            }
            if ((iContributionItem = iMenuManager2.find(string2)) == null) {
                if (bl) {
                    this.addGroup((IContributionManager)iMenuManager2, string2);
                } else {
                    WorkbenchPlugin.log("Plug-in '" + actionDescriptor.getPluginId() + "' contributed an invalid Menu Extension (Group: '" + string2 + "' is invalid): " + actionDescriptor.getId());
                    return;
                }
            }
            try {
                this.insertAfter((IContributionManager)iMenuManager2, string2, actionDescriptor);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                WorkbenchPlugin.log("Plug-in '" + actionDescriptor.getPluginId() + "' contributed an invalid Menu Extension (Group: '" + string2 + "' is missing): " + actionDescriptor.getId());
            }
        }

        protected void contributeSeparator(IMenuManager iMenuManager, IConfigurationElement iConfigurationElement) {
            String string = iConfigurationElement.getAttribute("name");
            if (string == null || string.length() <= 0) {
                return;
            }
            IContributionItem iContributionItem = iMenuManager.find(string);
            if (iContributionItem != null) {
                return;
            }
            this.insertMenuGroup(iMenuManager, (AbstractGroupMarker)new Separator(string));
        }

        protected void contributeGroupMarker(IMenuManager iMenuManager, IConfigurationElement iConfigurationElement) {
            String string = iConfigurationElement.getAttribute("name");
            if (string == null || string.length() <= 0) {
                return;
            }
            IContributionItem iContributionItem = iMenuManager.find(string);
            if (iContributionItem != null) {
                return;
            }
            this.insertMenuGroup(iMenuManager, (AbstractGroupMarker)new GroupMarker(string));
        }

        protected void contributeToolbarAction(ActionDescriptor actionDescriptor, IToolBarManager iToolBarManager, boolean bl) {
            String string = actionDescriptor.getToolbarId();
            String string2 = actionDescriptor.getToolbarGroupId();
            if (string == null && string2 == null) {
                return;
            }
            if (string2 == null) {
                string2 = "additions";
            }
            IContributionItem iContributionItem = null;
            iContributionItem = iToolBarManager.find(string2);
            if (iContributionItem == null) {
                if (bl) {
                    this.addGroup((IContributionManager)iToolBarManager, string2);
                } else {
                    WorkbenchPlugin.log("Plug-in '" + actionDescriptor.getPluginId() + "' invalid Toolbar Extension (Group '" + string2 + "' is invalid): " + actionDescriptor.getId());
                    return;
                }
            }
            try {
                this.insertAfter((IContributionManager)iToolBarManager, string2, actionDescriptor);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                WorkbenchPlugin.log("Plug-in '" + actionDescriptor.getPluginId() + "' invalid Toolbar Extension (Group '" + string2 + "' is missing): " + actionDescriptor.getId());
            }
        }

        protected void insertMenuGroup(IMenuManager iMenuManager, AbstractGroupMarker abstractGroupMarker) {
            iMenuManager.add((IContributionItem)abstractGroupMarker);
        }

        protected void insertAfter(IContributionManager iContributionManager, String string, ActionDescriptor actionDescriptor) {
            PluginActionContributionItem pluginActionContributionItem = new PluginActionContributionItem(actionDescriptor.getAction());
            pluginActionContributionItem.setMode(actionDescriptor.getMode());
            this.insertAfter(iContributionManager, string, (IContributionItem)pluginActionContributionItem);
        }

        protected void insertAfter(IContributionManager iContributionManager, String string, IContributionItem iContributionItem) {
            iContributionManager.insertAfter(string, iContributionItem);
        }

        protected void addGroup(IContributionManager iContributionManager, String string) {
            iContributionManager.add((IContributionItem)new Separator(string));
        }

        public void dispose() {
        }

        protected void disposeActions() {
            if (this.actions != null) {
                int n = 0;
                while (n < this.actions.size()) {
                    PluginAction pluginAction = ((ActionDescriptor)this.actions.get(n)).getAction();
                    pluginAction.dispose();
                    ++n;
                }
                this.actions = null;
            }
        }
    }
}

