/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.util.PrefUtil;

public class PlatformUIPreferenceListener
implements IEclipsePreferences.IPreferenceChangeListener {
    private static PlatformUIPreferenceListener singleton;

    public static IEclipsePreferences.IPreferenceChangeListener getSingleton() {
        if (singleton == null) {
            singleton = new PlatformUIPreferenceListener();
        }
        return singleton;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
        block27: {
            IEditorRegistry iEditorRegistry;
            boolean bl;
            String string = preferenceChangeEvent.getKey();
            if ("ENABLED_DECORATORS".equals(string)) {
                DecoratorManager decoratorManager = WorkbenchPlugin.getDefault().getDecoratorManager();
                decoratorManager.applyDecoratorsPreference();
                decoratorManager.clearCaches();
                decoratorManager.updateForEnablementChange();
                return;
            }
            if ("SHOW_SYSTEM_JOBS".equals(string)) {
                bl = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_SYSTEM_JOBS");
                ProgressManager.getInstance().setShowSystemJobs(bl);
            }
            if ("defaultPerspectiveId".equals(string)) {
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                iWorkbench.getPerspectiveRegistry().setDefaultPerspective(PrefUtil.getAPIPreferenceStore().getString("defaultPerspectiveId"));
                return;
            }
            if ("DOCK_PERSPECTIVE_BAR".equals(string)) {
                IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
                int n = 0;
                while (n < iWorkbenchWindowArray.length) {
                    IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n];
                    if (iWorkbenchWindow instanceof WorkbenchWindow) {
                        ((WorkbenchWindow)iWorkbenchWindow).setPerspectiveBarLocation(iPreferenceStore.getString("DOCK_PERSPECTIVE_BAR"));
                    }
                    ++n;
                }
                return;
            }
            if ("SHOW_TRADITIONAL_STYLE_TABS".equals(string)) {
                bl = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
                int n = 0;
                while (n < iWorkbenchWindowArray.length) {
                    IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n];
                    if (iWorkbenchWindow instanceof WorkbenchWindow) {
                        ((WorkbenchWindow)iWorkbenchWindow).setBannerCurve(bl);
                    }
                    ++n;
                }
                return;
            }
            if ("resourcetypes".equals(string) && (iEditorRegistry = WorkbenchPlugin.getDefault().getEditorRegistry()) instanceof EditorRegistry) {
                EditorRegistry editorRegistry = (EditorRegistry)iEditorRegistry;
                IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
                Reader reader = null;
                try {
                    try {
                        String string2 = iPreferenceStore.getString("resourcetypes");
                        if (string2 != null && string2.length() > 0) {
                            Object object;
                            reader = new StringReader(string2);
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            int n = 0;
                            IEditorDescriptor[] iEditorDescriptorArray = editorRegistry.getSortedEditorsFromPlugins();
                            n = 0;
                            while (n < iEditorDescriptorArray.length) {
                                object = iEditorDescriptorArray[n];
                                hashMap.put(object.getId(), object);
                                ++n;
                            }
                            iEditorDescriptorArray = editorRegistry.getSortedEditorsFromOS();
                            n = 0;
                            while (n < iEditorDescriptorArray.length) {
                                object = iEditorDescriptorArray[n];
                                hashMap.put(object.getId(), object);
                                ++n;
                            }
                            object = editorRegistry.getFileEditorMappings();
                            int n2 = 0;
                            while (n2 < ((Object)object).length) {
                                Object object2 = object[n2];
                                IEditorDescriptor iEditorDescriptor = object2.getDefaultEditor();
                                if (iEditorDescriptor != null && !hashMap.containsKey(iEditorDescriptor.getId())) {
                                    hashMap.put(iEditorDescriptor.getId(), iEditorDescriptor);
                                }
                                ++n2;
                            }
                            editorRegistry.readResources(hashMap, reader);
                        }
                    }
                    catch (WorkbenchException workbenchException) {
                        WorkbenchPlugin.log((Throwable)((Object)workbenchException));
                        if (reader == null) break block27;
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            WorkbenchPlugin.log(iOException);
                        }
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            WorkbenchPlugin.log(iOException);
                        }
                    }
                }
            }
        }
    }
}

