/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;

public class PerspectiveTracker
extends PerspectiveAdapter
implements IPageListener {
    private IWorkbenchWindow window;
    private IAction action;

    protected PerspectiveTracker(IWorkbenchWindow iWorkbenchWindow) {
        Assert.isNotNull((Object)iWorkbenchWindow);
        this.window = iWorkbenchWindow;
        iWorkbenchWindow.addPageListener(this);
        iWorkbenchWindow.addPerspectiveListener(this);
    }

    public PerspectiveTracker(IWorkbenchWindow iWorkbenchWindow, IAction iAction) {
        this(iWorkbenchWindow);
        this.action = iAction;
        this.update();
    }

    public void dispose() {
        if (this.window != null) {
            this.window.removePageListener(this);
            this.window.removePerspectiveListener(this);
        }
    }

    @Override
    public void pageActivated(IWorkbenchPage iWorkbenchPage) {
        this.update();
    }

    @Override
    public void pageClosed(IWorkbenchPage iWorkbenchPage) {
        this.update();
    }

    @Override
    public void pageOpened(IWorkbenchPage iWorkbenchPage) {
    }

    @Override
    public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
        this.update();
    }

    private void update() {
        if (this.window != null) {
            IPerspectiveDescriptor iPerspectiveDescriptor = null;
            IWorkbenchPage iWorkbenchPage = this.window.getActivePage();
            if (iWorkbenchPage != null) {
                iPerspectiveDescriptor = iWorkbenchPage.getPerspective();
            }
            this.update(iPerspectiveDescriptor);
        }
    }

    protected void update(IPerspectiveDescriptor iPerspectiveDescriptor) {
        if (this.action != null) {
            this.action.setEnabled(iPerspectiveDescriptor != null);
        }
    }
}

