/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.IReorderListener;
import org.eclipse.ui.internal.PerspectiveBarContributionItem;
import org.eclipse.ui.internal.PerspectiveBarManager;
import org.eclipse.ui.internal.PerspectiveBarNewContributionItem;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.AbstractDropTarget;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.layout.CacheWrapper;
import org.eclipse.ui.internal.layout.CellLayout;
import org.eclipse.ui.internal.layout.ITrimManager;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.layout.Row;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.presentations.PresentationUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class PerspectiveSwitcher
implements IWindowTrim {
    private static final int MIN_WIDTH = 45;
    private static final int MIN_DEFAULT_WIDTH = 160;
    private IWorkbenchWindow window;
    private CBanner topBar;
    private int style;
    private Composite parent;
    private Composite trimControl;
    private Label trimSeparator;
    private GridData trimLayoutData;
    private boolean trimVisible = false;
    private int trimOldLength = 0;
    private PerspectiveBarManager perspectiveBar;
    private CoolBar perspectiveCoolBar;
    private CacheWrapper perspectiveCoolBarWrapper;
    private CoolItem coolItem;
    private CacheWrapper toolbarWrapper;
    private Menu popupMenu;
    private Menu genericMenu;
    private static final int INITIAL = -1;
    private static final int TOP_RIGHT = 1;
    private static final int TOP_LEFT = 2;
    private static final int LEFT = 3;
    private int currentLocation = -1;
    private IPreferenceStore apiPreferenceStore = PrefUtil.getAPIPreferenceStore();
    private IPropertyChangeListener propertyChangeListener;
    private Listener popupListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 35) {
                PerspectiveSwitcher.this.showPerspectiveBarPopup(new Point(event.x, event.y));
            }
        }
    };
    private ChangeListener changeListener = new ChangeListener();
    private Listener dragListener;
    private IDragOverListener dragTarget;
    private DisposeListener toolBarListener;
    private IReorderListener reorderListener;

    public PerspectiveSwitcher(IWorkbenchWindow iWorkbenchWindow, CBanner cBanner, int n) {
        this.window = iWorkbenchWindow;
        this.topBar = cBanner;
        this.style = n;
        this.setPropertyChangeListener();
        this.toolBarListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                PerspectiveSwitcher.this.dispose();
            }
        };
    }

    private static int convertLocation(String string) {
        if ("topRight".equals(string)) {
            return 1;
        }
        if ("topLeft".equals(string)) {
            return 2;
        }
        if ("left".equals(string)) {
            return 3;
        }
        return 1;
    }

    public void createControl(Composite composite) {
        Assert.isTrue((this.parent == null ? 1 : 0) != 0);
        this.parent = composite;
        this.setPerspectiveBarLocation(PrefUtil.getAPIPreferenceStore().getString("DOCK_PERSPECTIVE_BAR"));
    }

    private void addPerspectiveShortcut(IPerspectiveDescriptor iPerspectiveDescriptor, IWorkbenchPage iWorkbenchPage) {
        if (this.perspectiveBar == null) {
            return;
        }
        PerspectiveBarContributionItem perspectiveBarContributionItem = new PerspectiveBarContributionItem(iPerspectiveDescriptor, iWorkbenchPage);
        this.perspectiveBar.addItem(perspectiveBarContributionItem);
        this.setCoolItemSize(this.coolItem);
        if (this.perspectiveBar != null) {
            this.perspectiveBar.update(true);
        }
        if (this.currentLocation == 3) {
            this.updatePerspectiveBar();
        }
    }

    public IContributionItem findPerspectiveShortcut(IPerspectiveDescriptor iPerspectiveDescriptor, IWorkbenchPage iWorkbenchPage) {
        if (this.perspectiveBar == null) {
            return null;
        }
        IContributionItem[] iContributionItemArray = this.perspectiveBar.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem iContributionItem = iContributionItemArray[n2];
            if (iContributionItem instanceof PerspectiveBarContributionItem && ((PerspectiveBarContributionItem)iContributionItem).handles(iPerspectiveDescriptor, iWorkbenchPage)) {
                return iContributionItem;
            }
            ++n2;
        }
        return null;
    }

    private void removePerspectiveShortcut(IPerspectiveDescriptor iPerspectiveDescriptor, IWorkbenchPage iWorkbenchPage) {
        if (this.perspectiveBar == null) {
            return;
        }
        IContributionItem iContributionItem = this.findPerspectiveShortcut(iPerspectiveDescriptor, iWorkbenchPage);
        if (iContributionItem != null) {
            if (iContributionItem instanceof PerspectiveBarContributionItem) {
                this.perspectiveBar.removeItem((PerspectiveBarContributionItem)iContributionItem);
            }
            iContributionItem.dispose();
            this.perspectiveBar.update(false);
            this.setCoolItemSize(this.coolItem);
            if (this.currentLocation == 3) {
                this.updatePerspectiveBar();
                LayoutUtil.resize((Control)this.perspectiveBar.getControl());
            }
        }
    }

    public void setPerspectiveBarLocation(String string) {
        if (this.parent == null) {
            return;
        }
        int n = PerspectiveSwitcher.convertLocation(string);
        if (n == this.currentLocation) {
            return;
        }
        this.createControlForLocation(n);
        this.currentLocation = n;
        this.showPerspectiveBar();
        if (n == 2 || n == 1) {
            this.updatePerspectiveBar();
            this.updateBarParent();
        }
    }

    private void showPerspectiveBar() {
        switch (this.currentLocation) {
            case 2: {
                this.topBar.setRight(null);
                this.topBar.setBottom((Control)this.perspectiveCoolBarWrapper.getControl());
                break;
            }
            case 1: {
                this.topBar.setBottom(null);
                this.topBar.setRight((Control)this.perspectiveCoolBarWrapper.getControl());
                this.topBar.setRightWidth(this.getDefaultWidth());
                break;
            }
            case 3: {
                this.topBar.setBottom(null);
                this.topBar.setRight(null);
                LayoutUtil.resize((Control)this.topBar);
                this.getTrimManager().addTrim(16384, this);
                break;
            }
            default: {
                return;
            }
        }
        LayoutUtil.resize((Control)this.perspectiveBar.getControl());
    }

    private int getDefaultWidth() {
        int n;
        GC gC = new GC((Drawable)this.perspectiveBar.getControl());
        try {
            n = gC.stringExtent((String)"Search for file or folder").x;
        }
        finally {
            gC.dispose();
        }
        String string = Platform.getOS();
        float f = "linux".equals(string) ? 1.2f : 1.1f;
        n = (int)((float)n * f);
        n += 32;
        String string2 = PrefUtil.getAPIPreferenceStore().getString("PERSPECTIVE_BAR_SIZE");
        int n2 = 160;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        return Math.max(n2, n);
    }

    private ITrimManager getTrimManager() {
        if (this.window instanceof WorkbenchWindow) {
            return ((WorkbenchWindow)this.window).getTrimManager();
        }
        return null;
    }

    public void update(boolean bl) {
        if (this.perspectiveBar == null) {
            return;
        }
        this.perspectiveBar.update(bl);
        if (this.currentLocation == 3) {
            boolean bl2;
            ToolItem[] toolItemArray = this.perspectiveBar.getControl().getItems();
            boolean bl3 = bl2 = toolItemArray.length > 0;
            if (bl2 != this.trimVisible) {
                this.perspectiveBar.getControl().setVisible(true);
                this.trimVisible = bl2;
            }
            if (toolItemArray.length != this.trimOldLength) {
                LayoutUtil.resize((Control)this.trimControl);
                this.trimOldLength = toolItemArray.length;
            }
        }
    }

    private void selectPerspectiveShortcut(IPerspectiveDescriptor iPerspectiveDescriptor, IWorkbenchPage iWorkbenchPage, boolean bl) {
        IContributionItem iContributionItem = this.findPerspectiveShortcut(iPerspectiveDescriptor, iWorkbenchPage);
        if (iContributionItem != null && iContributionItem instanceof PerspectiveBarContributionItem) {
            if (bl) {
                PerspectiveBarContributionItem perspectiveBarContributionItem = (PerspectiveBarContributionItem)iContributionItem;
                this.perspectiveBar.select(perspectiveBarContributionItem);
            }
            ((PerspectiveBarContributionItem)iContributionItem).setSelection(bl);
        }
    }

    private void updatePerspectiveShortcut(IPerspectiveDescriptor iPerspectiveDescriptor, IPerspectiveDescriptor iPerspectiveDescriptor2, IWorkbenchPage iWorkbenchPage) {
        IContributionItem iContributionItem = this.findPerspectiveShortcut(iPerspectiveDescriptor, iWorkbenchPage);
        if (iContributionItem != null && iContributionItem instanceof PerspectiveBarContributionItem) {
            ((PerspectiveBarContributionItem)iContributionItem).update(iPerspectiveDescriptor2);
        }
    }

    public PerspectiveBarManager getPerspectiveBar() {
        return this.perspectiveBar;
    }

    public void dispose() {
        this.window.removePerspectiveListener(this.changeListener);
        this.window.removePageListener(this.changeListener);
        if (this.propertyChangeListener != null) {
            this.apiPreferenceStore.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        this.unhookDragSupport();
        this.disposeChildControls();
        this.toolBarListener = null;
    }

    private void disposeChildControls() {
        if (this.trimControl != null) {
            this.trimControl.dispose();
            this.trimControl = null;
        }
        if (this.trimSeparator != null) {
            this.trimSeparator.dispose();
            this.trimSeparator = null;
        }
        if (this.perspectiveCoolBar != null) {
            this.perspectiveCoolBar.dispose();
            this.perspectiveCoolBar = null;
        }
        if (this.toolbarWrapper != null) {
            this.toolbarWrapper.dispose();
            this.toolbarWrapper = null;
        }
        if (this.perspectiveBar != null) {
            this.perspectiveBar.dispose();
            this.perspectiveBar = null;
        }
        this.perspectiveCoolBarWrapper = null;
    }

    private void createControlForLocation(int n) {
        if (this.perspectiveBar != null && this.perspectiveBar.getControl() != null && !this.perspectiveBar.getControl().isDisposed()) {
            if (n == 3 && this.currentLocation == 3) {
                return;
            }
            if (!(n != 2 && n != 1 || this.currentLocation != 2 && this.currentLocation != 1)) {
                return;
            }
        }
        if (this.perspectiveBar != null) {
            this.perspectiveBar.getControl().removeDisposeListener(this.toolBarListener);
            this.unhookDragSupport();
        }
        this.getTrimManager().removeTrim(this);
        this.disposeChildControls();
        if (n == 3) {
            this.createControlForLeft();
        } else {
            this.createControlForTop();
        }
        this.hookDragSupport();
        this.perspectiveBar.getControl().addDisposeListener(this.toolBarListener);
    }

    private void unhookDragSupport() {
        ToolBar toolBar = this.perspectiveBar.getControl();
        if (toolBar == null || toolBar.isDisposed() || this.dragListener == null) {
            return;
        }
        PresentationUtil.removeDragListener((Control)toolBar, this.dragListener);
        DragUtil.removeDragTarget((Control)this.perspectiveBar.getControl(), this.dragTarget);
        this.dragListener = null;
        this.dragTarget = null;
    }

    private void hookDragSupport() {
        this.dragListener = new Listener(){

            public void handleEvent(Event event) {
                ToolBar toolBar = PerspectiveSwitcher.this.perspectiveBar.getControl();
                ToolItem toolItem = toolBar.getItem(new Point(event.x, event.y));
                if (toolItem != null) {
                    if (toolItem.getData() instanceof PerspectiveBarNewContributionItem) {
                        return;
                    }
                    Rectangle rectangle = toolItem.getBounds();
                    Rectangle rectangle2 = toolBar.getBounds();
                    rectangle.x += rectangle2.x;
                    rectangle.y += rectangle2.y;
                    this.startDragging(toolItem.getData(), toolBar.getDisplay().map((Control)toolBar, null, rectangle));
                }
            }

            private void startDragging(Object object, Rectangle rectangle) {
                DragUtil.performDrag(object, rectangle, new Point(rectangle.x, rectangle.y), true);
            }
        };
        this.dragTarget = new IDragOverListener(){
            protected PerspectiveDropTarget perspectiveDropTarget;

            @Override
            public IDropTarget drag(Control control, Object object, Point point, Rectangle rectangle) {
                if (object instanceof PerspectiveBarContributionItem) {
                    if (this.perspectiveDropTarget == null) {
                        this.perspectiveDropTarget = new PerspectiveDropTarget(object, point);
                    } else {
                        this.perspectiveDropTarget.update(object, point);
                    }
                    if (!this.perspectiveDropTarget.sameShell()) {
                        return null;
                    }
                    return this.perspectiveDropTarget;
                }
                return null;
            }

            class PerspectiveDropTarget
            extends AbstractDropTarget {
                private PerspectiveBarContributionItem perspective;
                private Point location;

                public PerspectiveDropTarget(Object object, Point point) {
                    this.update(object, point);
                }

                private void update(Object object, Point point) {
                    this.location = point;
                    this.perspective = (PerspectiveBarContributionItem)((Object)object);
                }

                @Override
                public void drop() {
                    ToolBar toolBar = PerspectiveSwitcher.this.perspectiveBar.getControl();
                    ToolItem toolItem = toolBar.getItem(toolBar.getDisplay().map(null, (Control)toolBar, this.location));
                    if (toolBar.getItem(0) == toolItem) {
                        return;
                    }
                    ToolItem[] toolItemArray = toolBar.getItems();
                    ToolItem toolItem2 = null;
                    int n = -1;
                    int n2 = 0;
                    while (n2 < toolItemArray.length) {
                        if (toolItem == toolItemArray[n2]) {
                            n = n2;
                        }
                        if (toolItemArray[n2].getData() == this.perspective) {
                            toolItem2 = toolItemArray[n2];
                        }
                        ++n2;
                    }
                    if (n != -1 && toolItem2 != null && toolItem2 != toolItem) {
                        PerspectiveBarContributionItem perspectiveBarContributionItem = (PerspectiveBarContributionItem)((Object)toolItem2.getData());
                        if (PerspectiveSwitcher.this.reorderListener != null) {
                            PerspectiveSwitcher.this.reorderListener.reorder(perspectiveBarContributionItem.getPerspective(), Math.abs(n - (toolItemArray.length - 1)));
                        }
                        PerspectiveSwitcher.this.perspectiveBar.relocate(perspectiveBarContributionItem, n);
                    }
                }

                @Override
                public Cursor getCursor() {
                    return DragCursors.getCursor(5);
                }

                boolean sameShell() {
                    return this.perspective.getToolItem().getParent().getShell().equals(PerspectiveSwitcher.this.perspectiveBar.getControl().getShell());
                }

                @Override
                public Rectangle getSnapRectangle() {
                    ToolBar toolBar = PerspectiveSwitcher.this.perspectiveBar.getControl();
                    ToolItem toolItem = toolBar.getItem(toolBar.getDisplay().map(null, (Control)toolBar, this.location));
                    if (toolItem == null || toolItem == toolBar.getItem(0)) {
                        return null;
                    }
                    Rectangle rectangle = toolItem.getBounds();
                    return toolBar.getDisplay().map((Control)toolBar, null, rectangle);
                }
            }
        };
        PresentationUtil.addDragListener((Control)this.perspectiveBar.getControl(), this.dragListener);
        DragUtil.addDragTarget((Control)this.perspectiveBar.getControl(), this.dragTarget);
    }

    private void setPropertyChangeListener() {
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("SHOW_TEXT_ON_PERSPECTIVE_BAR".equals(propertyChangeEvent.getProperty())) {
                    if (PerspectiveSwitcher.this.perspectiveBar == null) {
                        return;
                    }
                    PerspectiveSwitcher.this.updatePerspectiveBar();
                    PerspectiveSwitcher.this.updateBarParent();
                }
            }
        };
        this.apiPreferenceStore.addPropertyChangeListener(this.propertyChangeListener);
    }

    private void createControlForLeft() {
        this.trimControl = new Composite(this.parent, 0);
        this.trimControl.setLayout((Layout)new CellLayout(1).setMargins(0, 0).setSpacing(3, 3).setDefaultRow(Row.fixed()).setDefaultColumn(Row.growing()));
        this.perspectiveBar = this.createBarManager(512);
        this.perspectiveBar.createControl(this.trimControl);
        this.perspectiveBar.getControl().addListener(35, this.popupListener);
        this.trimLayoutData = new GridData(1808);
        this.trimVisible = false;
        this.perspectiveBar.getControl().setLayoutData((Object)this.trimLayoutData);
    }

    private void createControlForTop() {
        this.perspectiveBar = this.createBarManager(256);
        this.perspectiveCoolBarWrapper = new CacheWrapper((Composite)this.topBar);
        this.perspectiveCoolBar = new CoolBar(this.perspectiveCoolBarWrapper.getControl(), 0x800000);
        this.coolItem = new CoolItem(this.perspectiveCoolBar, 4);
        this.toolbarWrapper = new CacheWrapper((Composite)this.perspectiveCoolBar);
        this.perspectiveBar.createControl(this.toolbarWrapper.getControl());
        this.coolItem.setControl((Control)this.toolbarWrapper.getControl());
        this.perspectiveCoolBar.setLocked(true);
        this.perspectiveBar.setParent(this.perspectiveCoolBar);
        this.perspectiveBar.update(true);
        this.perspectiveCoolBar.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                PerspectiveSwitcher.this.setCoolItemSize(PerspectiveSwitcher.this.coolItem);
            }
        });
        this.coolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.detail == 4) {
                    // empty if block
                }
            }
        });
        this.coolItem.setMinimumSize(0, 0);
        this.perspectiveBar.getControl().addListener(35, this.popupListener);
    }

    private void setCoolItemSize(CoolItem coolItem) {
        int n;
        if (this.currentLocation == 3) {
            return;
        }
        ToolBar toolBar = this.perspectiveBar.getControl();
        if (toolBar == null) {
            return;
        }
        int n2 = 0;
        ToolItem[] toolItemArray = toolBar.getItems();
        int n3 = 0;
        while (n3 < toolItemArray.length) {
            n2 = Math.max(n2, toolItemArray[n3].getBounds().height);
            ++n3;
        }
        Rectangle rectangle = this.perspectiveCoolBar.getClientArea();
        int n4 = n = n2 <= 0 ? 1 : (int)Math.max(1.0, Math.floor(rectangle.height / n2));
        if (n == 1 || (toolBar.getStyle() & 0x40) == 0 || this.currentLocation == 2) {
            Point point = toolBar.computeSize(-1, -1);
            int n5 = "macosx".equals(Platform.getOS()) ? 4 : 0;
            coolItem.setSize(coolItem.computeSize(point.x, point.y + n5));
            return;
        }
        Point point = coolItem.computeSize(0, 0);
        Point point2 = toolBar.computeSize(rectangle.width - point.x, -1);
        int n6 = n * n2;
        int n7 = point2.y <= n6 ? point2.x : point2.x + 1;
        coolItem.setSize(coolItem.computeSize(n7, n6));
    }

    private void showPerspectiveBarPopup(Point point) {
        if (this.perspectiveBar == null) {
            return;
        }
        ToolBar toolBar = this.perspectiveBar.getControl();
        ToolItem toolItem = toolBar.getItem(toolBar.toControl(point));
        Object object = null;
        if (toolItem != null) {
            object = toolItem.getData();
        }
        if (toolItem == null || !(object instanceof PerspectiveBarContributionItem)) {
            if (this.genericMenu == null) {
                Menu menu = new Menu((Control)toolBar);
                this.addDockOnSubMenu(menu);
                this.addShowTextItem(menu);
                this.genericMenu = menu;
            }
            this.genericMenu.getItem(1).setSelection(PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
            this.updateLocationItems(this.genericMenu.getItem(0).getMenu(), this.currentLocation);
            this.genericMenu.setLocation(point.x, point.y);
            this.genericMenu.setVisible(true);
            return;
        }
        if (object == null || !(object instanceof PerspectiveBarContributionItem)) {
            return;
        }
        PerspectiveBarContributionItem perspectiveBarContributionItem = (PerspectiveBarContributionItem)((Object)object);
        IPerspectiveDescriptor iPerspectiveDescriptor = perspectiveBarContributionItem.getPerspective();
        if (this.popupMenu != null) {
            this.popupMenu.dispose();
            this.popupMenu = null;
        }
        this.popupMenu = this.createPopup(toolBar, iPerspectiveDescriptor);
        this.popupMenu.setData((Object)toolItem);
        this.popupMenu.setLocation(point.x, point.y);
        this.popupMenu.setVisible(true);
    }

    private boolean perspectiveIsActive(IPerspectiveDescriptor iPerspectiveDescriptor) {
        IWorkbenchPage iWorkbenchPage = this.window.getActivePage();
        return iWorkbenchPage != null && iPerspectiveDescriptor.equals(iWorkbenchPage.getPerspective());
    }

    private boolean perspectiveIsOpen(IPerspectiveDescriptor iPerspectiveDescriptor) {
        IWorkbenchPage iWorkbenchPage = this.window.getActivePage();
        return iWorkbenchPage != null && Arrays.asList(iWorkbenchPage.getOpenPerspectives()).contains(iPerspectiveDescriptor);
    }

    private Menu createPopup(ToolBar toolBar, IPerspectiveDescriptor iPerspectiveDescriptor) {
        Menu menu = new Menu((Control)toolBar);
        if (this.perspectiveIsActive(iPerspectiveDescriptor)) {
            this.addCustomizeItem(menu);
            this.addSaveAsItem(menu);
            this.addResetItem(menu);
        }
        if (this.perspectiveIsOpen(iPerspectiveDescriptor)) {
            this.addCloseItem(menu);
        }
        new MenuItem(menu, 2);
        this.addDockOnSubMenu(menu);
        this.addShowTextItem(menu);
        return menu;
    }

    private void addCloseItem(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(WorkbenchMessages.WorkbenchWindow_close);
        this.window.getWorkbench().getHelpSystem().setHelp(menuItem, "org.eclipse.ui.close_page_action_context");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolItem toolItem = (ToolItem)PerspectiveSwitcher.this.popupMenu.getData();
                if (toolItem != null && !toolItem.isDisposed()) {
                    PerspectiveBarContributionItem perspectiveBarContributionItem = (PerspectiveBarContributionItem)((Object)toolItem.getData());
                    IPerspectiveDescriptor iPerspectiveDescriptor = perspectiveBarContributionItem.getPerspective();
                    ICommandService iCommandService = (ICommandService)PerspectiveSwitcher.this.window.getService(ICommandService.class);
                    Command command = iCommandService.getCommand("org.eclipse.ui.window.closePerspective");
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("org.eclipse.ui.window.closePerspective.perspectiveId", iPerspectiveDescriptor.getId());
                    ParameterizedCommand parameterizedCommand = ParameterizedCommand.generateCommand((Command)command, hashMap);
                    IHandlerService iHandlerService = (IHandlerService)PerspectiveSwitcher.this.window.getService(IHandlerService.class);
                    try {
                        iHandlerService.executeCommand(parameterizedCommand, new Event());
                    }
                    catch (ExecutionException executionException) {
                    }
                    catch (NotDefinedException notDefinedException) {
                    }
                    catch (NotEnabledException notEnabledException) {
                    }
                    catch (NotHandledException notHandledException) {}
                }
            }
        });
    }

    private PerspectiveBarManager createBarManager(int n) {
        IWorkbenchPage iWorkbenchPage;
        PerspectiveBarManager perspectiveBarManager = new PerspectiveBarManager(this.style | n);
        int n2 = 0;
        if (this.apiPreferenceStore.getBoolean("SHOW_OPEN_ON_PERSPECTIVE_BAR")) {
            perspectiveBarManager.add((IContributionItem)new PerspectiveBarNewContributionItem(this.window));
            n2 = 1;
        }
        if ((iWorkbenchPage = this.window.getActivePage()) != null) {
            IPerspectiveDescriptor[] iPerspectiveDescriptorArray = iWorkbenchPage.getOpenPerspectives();
            int n3 = 0;
            while (n3 < iPerspectiveDescriptorArray.length) {
                perspectiveBarManager.insert(n2, (IContributionItem)new PerspectiveBarContributionItem(iPerspectiveDescriptorArray[n3], iWorkbenchPage));
                ++n3;
            }
        }
        return perspectiveBarManager;
    }

    private void updateLocationItems(Menu menu, int n) {
        MenuItem menuItem = menu.getItem(0);
        MenuItem menuItem2 = menu.getItem(1);
        MenuItem menuItem3 = menu.getItem(2);
        if (n == 3) {
            menuItem3.setSelection(true);
            menuItem.setSelection(false);
            menuItem2.setSelection(false);
        } else if (n == 2) {
            menuItem2.setSelection(true);
            menuItem3.setSelection(false);
            menuItem.setSelection(false);
        } else {
            menuItem.setSelection(true);
            menuItem3.setSelection(false);
            menuItem2.setSelection(false);
        }
    }

    private void addDockOnSubMenu(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(WorkbenchMessages.PerspectiveSwitcher_dockOn);
        final Menu menu2 = new Menu(menuItem);
        MenuItem menuItem2 = new MenuItem(menu2, 16);
        menuItem2.setText(WorkbenchMessages.PerspectiveSwitcher_topRight);
        this.window.getWorkbench().getHelpSystem().setHelp(menuItem2, "org.eclipse.ui.dock_on_perspective_action_context");
        final MenuItem menuItem3 = new MenuItem(menu2, 16);
        menuItem3.setText(WorkbenchMessages.PerspectiveSwitcher_topLeft);
        this.window.getWorkbench().getHelpSystem().setHelp(menuItem3, "org.eclipse.ui.dock_on_perspective_action_context");
        final MenuItem menuItem4 = new MenuItem(menu2, 16);
        menuItem4.setText(WorkbenchMessages.PerspectiveSwitcher_left);
        this.window.getWorkbench().getHelpSystem().setHelp(menuItem4, "org.eclipse.ui.dock_on_perspective_action_context");
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                String string = null;
                if (menuItem.equals(menuItem4)) {
                    PerspectiveSwitcher.this.updateLocationItems(menu2, 3);
                    string = "left";
                } else if (menuItem.equals(menuItem3)) {
                    PerspectiveSwitcher.this.updateLocationItems(menu2, 2);
                    string = "topLeft";
                } else {
                    PerspectiveSwitcher.this.updateLocationItems(menu2, 1);
                    string = "topRight";
                }
                IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
                if (!string.equals(iPreferenceStore.getDefaultString("DOCK_PERSPECTIVE_BAR"))) {
                    PrefUtil.getInternalPreferenceStore().setValue("overridepresentation", true);
                }
                iPreferenceStore.setValue("DOCK_PERSPECTIVE_BAR", string);
            }
        };
        menuItem2.addSelectionListener((SelectionListener)selectionAdapter);
        menuItem3.addSelectionListener((SelectionListener)selectionAdapter);
        menuItem4.addSelectionListener((SelectionListener)selectionAdapter);
        menuItem.setMenu(menu2);
        this.updateLocationItems(menu2, this.currentLocation);
    }

    private void addShowTextItem(Menu menu) {
        final MenuItem menuItem = new MenuItem(menu, 32);
        menuItem.setText(WorkbenchMessages.PerspectiveBar_showText);
        this.window.getWorkbench().getHelpSystem().setHelp(menuItem, "org.eclipse.ui.show_text_perspective_action_context");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PerspectiveSwitcher.this.perspectiveBar == null) {
                    return;
                }
                boolean bl = menuItem.getSelection();
                if (bl != PrefUtil.getAPIPreferenceStore().getDefaultBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR")) {
                    PrefUtil.getInternalPreferenceStore().setValue("overridepresentation", true);
                }
                PrefUtil.getAPIPreferenceStore().setValue("SHOW_TEXT_ON_PERSPECTIVE_BAR", bl);
            }
        });
        menuItem.setSelection(PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
    }

    private void addCustomizeItem(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 26);
        menuItem.setText(WorkbenchMessages.PerspectiveBar_customize);
        this.window.getWorkbench().getHelpSystem().setHelp(menuItem, "org.eclipse.ui.edit_action_sets_action_context");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PerspectiveSwitcher.this.perspectiveBar == null) {
                    return;
                }
                IHandlerService iHandlerService = (IHandlerService)PerspectiveSwitcher.this.window.getService(IHandlerService.class);
                try {
                    iHandlerService.executeCommand("org.eclipse.ui.window.customizePerspective", null);
                }
                catch (ExecutionException executionException) {
                }
                catch (NotDefinedException notDefinedException) {
                }
                catch (NotEnabledException notEnabledException) {
                }
                catch (NotHandledException notHandledException) {}
            }
        });
    }

    private void addSaveAsItem(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 26);
        menuItem.setText(WorkbenchMessages.PerspectiveBar_saveAs);
        this.window.getWorkbench().getHelpSystem().setHelp(menuItem, "org.eclipse.ui.save_perspective_action_context");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PerspectiveSwitcher.this.perspectiveBar == null) {
                    return;
                }
                IHandlerService iHandlerService = (IHandlerService)PerspectiveSwitcher.this.window.getService(IHandlerService.class);
                IStatus iStatus = Status.OK_STATUS;
                try {
                    iHandlerService.executeCommand("org.eclipse.ui.window.savePerspective", null);
                }
                catch (ExecutionException executionException) {
                    iStatus = new Status(4, "org.eclipse.ui", executionException.getMessage(), (Throwable)executionException);
                }
                catch (NotDefinedException notDefinedException) {
                    iStatus = new Status(4, "org.eclipse.ui", notDefinedException.getMessage(), (Throwable)notDefinedException);
                }
                catch (NotEnabledException notEnabledException) {
                    iStatus = new Status(4, "org.eclipse.ui", notEnabledException.getMessage(), (Throwable)notEnabledException);
                }
                catch (NotHandledException notHandledException) {}
                if (!iStatus.isOK()) {
                    StatusManager.getManager().handle(iStatus, 3);
                }
            }
        });
    }

    private void addResetItem(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 26);
        menuItem.setText(WorkbenchMessages.PerspectiveBar_reset);
        this.window.getWorkbench().getHelpSystem().setHelp(menuItem, "org.eclipse.ui.reset_perspective_action_context");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PerspectiveSwitcher.this.perspectiveBar == null) {
                    return;
                }
                IHandlerService iHandlerService = (IHandlerService)PerspectiveSwitcher.this.window.getService(IHandlerService.class);
                IStatus iStatus = Status.OK_STATUS;
                try {
                    iHandlerService.executeCommand("org.eclipse.ui.window.resetPerspective", null);
                }
                catch (ExecutionException executionException) {
                    iStatus = new Status(4, "org.eclipse.ui", executionException.getMessage(), (Throwable)executionException);
                }
                catch (NotDefinedException notDefinedException) {
                    iStatus = new Status(4, "org.eclipse.ui", notDefinedException.getMessage(), (Throwable)notDefinedException);
                }
                catch (NotEnabledException notEnabledException) {
                    iStatus = new Status(4, "org.eclipse.ui", notEnabledException.getMessage(), (Throwable)notEnabledException);
                }
                catch (NotHandledException notHandledException) {}
                if (!iStatus.isOK()) {
                    StatusManager.getManager().handle(iStatus, 3);
                }
            }
        });
    }

    public void saveState(IMemento iMemento) {
        IMemento iMemento2 = iMemento.createChild("itemSize");
        int n = this.currentLocation == 1 && this.topBar != null ? this.topBar.getRightWidth() : this.getDefaultWidth();
        iMemento2.putString("x", Integer.toString(n));
    }

    public void restoreState(IMemento iMemento) {
        if (iMemento == null) {
            return;
        }
        IMemento iMemento2 = iMemento.getChild("perspectiveBar");
        IMemento iMemento3 = null;
        if (iMemento2 != null) {
            iMemento3 = iMemento2.getChild("itemSize");
        }
        if (iMemento3 != null && this.currentLocation == 1 && this.topBar != null) {
            final Integer n = iMemento3.getInteger("x");
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() {
                    if (n != null) {
                        PerspectiveSwitcher.this.topBar.setRightWidth(n.intValue());
                    } else {
                        PerspectiveSwitcher.this.topBar.setRightWidth(PerspectiveSwitcher.this.getDefaultWidth());
                    }
                }
            });
        }
    }

    void updatePerspectiveBar() {
        IContributionItem[] iContributionItemArray = this.perspectiveBar.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            iContributionItemArray[n].update();
            ++n;
        }
        this.perspectiveBar.arrangeToolbar();
        this.setCoolItemSize(this.coolItem);
        this.perspectiveBar.getControl().redraw();
        if (this.getControl() != null) {
            this.getControl().pack(true);
        }
    }

    public void updateBarParent() {
        if (this.perspectiveBar == null || this.perspectiveBar.getControl() == null) {
            return;
        }
        if (this.currentLocation == 1 && this.topBar != null) {
            int n = 0;
            ToolItem[] toolItemArray = this.perspectiveBar.getControl().getItems();
            int n2 = 0;
            while (n2 < toolItemArray.length) {
                n = Math.max(n, toolItemArray[n2].getBounds().height);
                ++n2;
            }
            this.topBar.setRightMinimumSize(new Point(45, n));
        }
        LayoutUtil.resize((Control)this.perspectiveBar.getControl());
    }

    public void addReorderListener(IReorderListener iReorderListener) {
        this.reorderListener = iReorderListener;
    }

    @Override
    public void dock(int n) {
    }

    @Override
    public Control getControl() {
        return this.trimControl;
    }

    @Override
    public String getId() {
        return "org.eclipse.ui.internal.PerspectiveSwitcher";
    }

    @Override
    public String getDisplayName() {
        return WorkbenchMessages.TrimCommon_PerspectiveSwitcher_TrimName;
    }

    @Override
    public int getValidSides() {
        return 0;
    }

    @Override
    public boolean isCloseable() {
        return false;
    }

    @Override
    public void handleClose() {
    }

    @Override
    public int getWidthHint() {
        return -1;
    }

    @Override
    public int getHeightHint() {
        return -1;
    }

    @Override
    public boolean isResizeable() {
        return false;
    }

    class ChangeListener
    extends PerspectiveAdapter
    implements IPageListener {
        ChangeListener() {
        }

        @Override
        public void perspectiveOpened(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
            if (PerspectiveSwitcher.this.findPerspectiveShortcut(iPerspectiveDescriptor, iWorkbenchPage) == null) {
                PerspectiveSwitcher.this.addPerspectiveShortcut(iPerspectiveDescriptor, iWorkbenchPage);
            }
        }

        @Override
        public void perspectiveClosed(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
            if (iWorkbenchPage != null && !iWorkbenchPage.getWorkbenchWindow().getWorkbench().isClosing()) {
                PerspectiveSwitcher.this.removePerspectiveShortcut(iPerspectiveDescriptor, iWorkbenchPage);
            }
        }

        @Override
        public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
            PerspectiveSwitcher.this.selectPerspectiveShortcut(iPerspectiveDescriptor, iWorkbenchPage, true);
        }

        @Override
        public void perspectiveDeactivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
            PerspectiveSwitcher.this.selectPerspectiveShortcut(iPerspectiveDescriptor, iWorkbenchPage, false);
        }

        @Override
        public void perspectiveSavedAs(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, IPerspectiveDescriptor iPerspectiveDescriptor2) {
            PerspectiveSwitcher.this.updatePerspectiveShortcut(iPerspectiveDescriptor, iPerspectiveDescriptor2, iWorkbenchPage);
        }

        @Override
        public void pageActivated(IWorkbenchPage iWorkbenchPage) {
        }

        @Override
        public void pageClosed(IWorkbenchPage iWorkbenchPage) {
        }

        @Override
        public void pageOpened(IWorkbenchPage iWorkbenchPage) {
        }
    }
}

