/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.DetachedPlaceHolder;
import org.eclipse.ui.internal.DetachedWindow;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.EditorSashContainer;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartSashContainer;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewSashContainer;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dnd.AbstractDropTarget;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.misc.StringMatcher;

public class PerspectiveHelper {
    private WorkbenchPage page;
    protected Perspective perspective;
    protected Composite parentWidget;
    private ViewSashContainer mainLayout;
    private PartStack maximizedStack;
    private String maximizedStackId;
    private ArrayList detachedWindowList = new ArrayList(1);
    private ArrayList detachedPlaceHolderList = new ArrayList(1);
    private Map boundsMap = new HashMap();
    private boolean detachable = false;
    protected boolean active = false;
    private static final int MIN_DETACH_WIDTH = 150;
    private static final int MIN_DETACH_HEIGHT = 250;
    protected ActualDropTarget dropTarget;
    private IDragOverListener dragTarget = new IDragOverListener(){

        @Override
        public IDropTarget drag(Control control, Object object, Point point, Rectangle rectangle) {
            if (!(object instanceof ViewPane) && !(object instanceof ViewStack)) {
                return null;
            }
            LayoutPart layoutPart = (LayoutPart)object;
            if (layoutPart instanceof ViewPane ? ((ViewPane)layoutPart).getPage() != PerspectiveHelper.this.page : layoutPart.getWorkbenchWindow() != PerspectiveHelper.this.page.getWorkbenchWindow()) {
                return null;
            }
            if (PerspectiveHelper.this.dropTarget == null) {
                PerspectiveHelper.this.dropTarget = new ActualDropTarget(layoutPart, rectangle);
            } else {
                PerspectiveHelper.this.dropTarget.setTarget(layoutPart, rectangle);
            }
            return PerspectiveHelper.this.dropTarget;
        }
    };
    private String tmpViewId = null;
    private Exception tmpStackTrace = null;

    public PerspectiveHelper(WorkbenchPage workbenchPage, ViewSashContainer viewSashContainer, Perspective perspective) {
        this.page = workbenchPage;
        this.mainLayout = viewSashContainer;
        this.perspective = perspective;
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        this.detachable = iPreferenceStore.getBoolean("ENABLE_DETACHED_VIEWS");
        if (this.detachable) {
            Composite composite = workbenchPage.getClientComposite();
            if (composite == null) {
                this.detachable = false;
            } else {
                Composite composite2 = new Composite(composite, 0);
                this.detachable = composite2.isReparentable();
                composite2.dispose();
            }
        }
    }

    public void activate(Composite composite) {
        LayoutPart layoutPart;
        if (this.active) {
            return;
        }
        this.parentWidget = composite;
        Vector vector = new Vector();
        this.collectViewPanes(vector, this.mainLayout.getChildren());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LayoutPart layoutPart2 = (LayoutPart)enumeration.nextElement();
            layoutPart2.reparent(composite);
        }
        this.mainLayout.createControl(composite);
        this.mainLayout.setActive(true);
        int n = 0;
        int n2 = this.detachedWindowList.size();
        while (n < n2) {
            DetachedWindow detachedWindow = (DetachedWindow)this.detachedWindowList.get(n);
            detachedWindow.open();
            ++n;
        }
        this.enableAllDrag();
        if (this.maximizedStackId != null && (layoutPart = this.findPart(this.maximizedStackId)) instanceof PartStack) {
            this.maximizedStack = (PartStack)layoutPart;
            this.maximizedStackId = null;
        }
        if (this.maximizedStack instanceof ViewStack) {
            this.maximizedStack.setPresentationState(1);
        }
        this.active = true;
    }

    public void addPart(LayoutPart layoutPart) {
        Object object;
        LayoutPart layoutPart2 = null;
        LayoutPart layoutPart3 = null;
        String string = layoutPart.getID();
        String string2 = null;
        IViewReference iViewReference = null;
        if (layoutPart instanceof ViewPane) {
            object = (ViewPane)layoutPart;
            iViewReference = (IViewReference)((PartPane)object).getPartReference();
            string2 = iViewReference.getSecondaryId();
        }
        if ((layoutPart3 = string2 != null ? this.findPart(string, string2) : this.findPart(string)) != null && layoutPart3 instanceof PartPlaceholder) {
            layoutPart2 = (PartPlaceholder)layoutPart3;
        }
        if (layoutPart2 == null) {
            layoutPart.reparent(this.mainLayout.getParent());
            object = this.mainLayout.findBottomRight();
            if (object != null && object instanceof ILayoutContainer) {
                ILayoutContainer iLayoutContainer = (ILayoutContainer)object;
                if (iLayoutContainer.allowsAdd(layoutPart)) {
                    this.mainLayout.stack(layoutPart, iLayoutContainer);
                } else {
                    this.mainLayout.add(layoutPart);
                }
            } else {
                this.mainLayout.add(layoutPart);
            }
        } else {
            object = layoutPart2.getContainer();
            if (object != null) {
                if (object instanceof DetachedPlaceHolder) {
                    DetachedPlaceHolder detachedPlaceHolder = (DetachedPlaceHolder)object;
                    this.detachedPlaceHolderList.remove(detachedPlaceHolder);
                    object.remove(layoutPart3);
                    DetachedWindow detachedWindow = new DetachedWindow(this.page);
                    this.detachedWindowList.add(detachedWindow);
                    detachedWindow.create();
                    layoutPart.createControl((Composite)detachedWindow.getShell());
                    detachedWindow.getShell().setBounds(detachedPlaceHolder.getBounds());
                    detachedWindow.open();
                    ViewPane viewPane = (ViewPane)layoutPart;
                    detachedWindow.add(viewPane);
                    LayoutPart[] layoutPartArray = detachedPlaceHolder.getChildren();
                    int n = 0;
                    while (n < layoutPartArray.length) {
                        layoutPart.getContainer().add(layoutPartArray[n]);
                        ++n;
                    }
                } else {
                    if (object instanceof ContainerPlaceholder) {
                        ContainerPlaceholder containerPlaceholder = (ContainerPlaceholder)object;
                        ILayoutContainer iLayoutContainer = containerPlaceholder.getContainer();
                        if (iLayoutContainer == null) {
                            if (Policy.DEBUG_PERSPECTIVES) {
                                WorkbenchPlugin.log("Previous ContainerPlaceholder for " + this.tmpViewId, this.tmpStackTrace);
                                this.tmpViewId = null;
                                this.tmpStackTrace = new Exception();
                                this.tmpStackTrace.fillInStackTrace();
                                WorkbenchPlugin.log("Current ContainerPlaceholder with null parent for " + string + ":" + string2, this.tmpStackTrace);
                                this.tmpStackTrace = null;
                            }
                            return;
                        }
                        if (Policy.DEBUG_PERSPECTIVES) {
                            this.tmpViewId = String.valueOf(string) + ":" + string2;
                            this.tmpStackTrace = new Exception();
                            this.tmpStackTrace.fillInStackTrace();
                        }
                        if ((object = (ILayoutContainer)((Object)containerPlaceholder.getRealContainer())) instanceof LayoutPart) {
                            iLayoutContainer.replace(containerPlaceholder, (LayoutPart)object);
                        }
                        containerPlaceholder.setRealContainer(null);
                    }
                    if (!(object instanceof ViewStack)) {
                        layoutPart.reparent(this.mainLayout.getParent());
                    }
                    if (((PartPlaceholder)layoutPart2).hasWildCard()) {
                        if (object instanceof PartSashContainer) {
                            ((PartSashContainer)object).addChildForPlaceholder(layoutPart, layoutPart2);
                        } else {
                            object.add(layoutPart);
                        }
                    } else {
                        object.replace(layoutPart2, layoutPart);
                    }
                }
            }
        }
    }

    public void attachPart(IViewReference iViewReference) {
        ViewPane viewPane = (ViewPane)((WorkbenchPartReference)((Object)iViewReference)).getPane();
        if (this.getMaximizedStack() != null) {
            this.getMaximizedStack().setState(2);
        }
        this.derefPart(viewPane);
        this.addPart(viewPane);
        this.bringPartToTop(viewPane);
        viewPane.setFocus();
    }

    public boolean canDetach() {
        return this.detachable;
    }

    public boolean bringPartToTop(LayoutPart layoutPart) {
        PartStack partStack;
        ILayoutContainer iLayoutContainer = layoutPart.getContainer();
        if (iLayoutContainer != null && iLayoutContainer instanceof PartStack && (partStack = (PartStack)iLayoutContainer).getSelection() != layoutPart) {
            partStack.setSelection(layoutPart);
            return true;
        }
        return false;
    }

    public boolean isPartVisible(IWorkbenchPartReference iWorkbenchPartReference) {
        LayoutPart layoutPart = iWorkbenchPartReference instanceof IViewReference ? this.findPart(iWorkbenchPartReference.getId(), ((IViewReference)iWorkbenchPartReference).getSecondaryId()) : this.findPart(iWorkbenchPartReference.getId());
        if (layoutPart == null) {
            return false;
        }
        if (layoutPart instanceof PartPlaceholder) {
            return false;
        }
        ILayoutContainer iLayoutContainer = layoutPart.getContainer();
        if (iLayoutContainer instanceof ContainerPlaceholder) {
            return false;
        }
        if (iLayoutContainer instanceof ViewStack) {
            ViewStack viewStack = (ViewStack)iLayoutContainer;
            PartPane partPane = viewStack.getSelection();
            if (partPane == null) {
                return false;
            }
            return iWorkbenchPartReference.equals(partPane.getPartReference());
        }
        return true;
    }

    public boolean willPartBeVisible(String string) {
        return this.willPartBeVisible(string, null);
    }

    public boolean willPartBeVisible(String string, String string2) {
        LayoutPart layoutPart = this.findPart(string, string2);
        if (layoutPart == null) {
            return false;
        }
        ILayoutContainer iLayoutContainer = layoutPart.getContainer();
        if (iLayoutContainer != null && iLayoutContainer instanceof ContainerPlaceholder) {
            iLayoutContainer = (ILayoutContainer)((Object)((ContainerPlaceholder)iLayoutContainer).getRealContainer());
        }
        if (iLayoutContainer != null && iLayoutContainer instanceof ViewStack) {
            ViewStack viewStack = (ViewStack)iLayoutContainer;
            if (viewStack.getSelection() == null) {
                return false;
            }
            return layoutPart.getCompoundId().equals(viewStack.getSelection().getCompoundId());
        }
        return true;
    }

    private PartPlaceholder[] collectPlaceholders() {
        PartPlaceholder[] partPlaceholderArray = this.collectPlaceholders(this.mainLayout.getChildren());
        if (this.detachable) {
            int n = 0;
            int n2 = this.detachedWindowList.size();
            while (n < n2) {
                DetachedWindow detachedWindow = (DetachedWindow)this.detachedWindowList.get(n);
                PartPlaceholder[] partPlaceholderArray2 = this.collectPlaceholders(detachedWindow.getChildren());
                if (partPlaceholderArray2.length > 0) {
                    int n3 = partPlaceholderArray.length + partPlaceholderArray2.length;
                    PartPlaceholder[] partPlaceholderArray3 = new PartPlaceholder[n3];
                    System.arraycopy(partPlaceholderArray, 0, partPlaceholderArray3, 0, partPlaceholderArray.length);
                    System.arraycopy(partPlaceholderArray2, 0, partPlaceholderArray3, partPlaceholderArray.length, partPlaceholderArray2.length);
                    partPlaceholderArray = partPlaceholderArray3;
                }
                ++n;
            }
        }
        return partPlaceholderArray;
    }

    private PartPlaceholder[] collectPlaceholders(LayoutPart[] layoutPartArray) {
        PartPlaceholder[] partPlaceholderArray = new PartPlaceholder[]{};
        int n = 0;
        int n2 = layoutPartArray.length;
        while (n < n2) {
            PartPlaceholder[] partPlaceholderArray2;
            LayoutPart layoutPart = layoutPartArray[n];
            if (layoutPart instanceof ILayoutContainer) {
                partPlaceholderArray2 = this.collectPlaceholders(((ILayoutContainer)((Object)layoutPart)).getChildren());
                PartPlaceholder[] partPlaceholderArray3 = new PartPlaceholder[partPlaceholderArray.length + partPlaceholderArray2.length];
                System.arraycopy(partPlaceholderArray, 0, partPlaceholderArray3, 0, partPlaceholderArray.length);
                System.arraycopy(partPlaceholderArray2, 0, partPlaceholderArray3, partPlaceholderArray.length, partPlaceholderArray2.length);
                partPlaceholderArray = partPlaceholderArray3;
            } else if (layoutPart instanceof PartPlaceholder) {
                partPlaceholderArray2 = new PartPlaceholder[partPlaceholderArray.length + 1];
                System.arraycopy(partPlaceholderArray, 0, partPlaceholderArray2, 0, partPlaceholderArray.length);
                partPlaceholderArray2[partPlaceholderArray.length] = (PartPlaceholder)layoutPart;
                partPlaceholderArray = partPlaceholderArray2;
            }
            ++n;
        }
        return partPlaceholderArray;
    }

    public void collectViewPanes(List list) {
        this.collectViewPanes(list, this.mainLayout.getChildren());
        if (this.detachable) {
            int n = 0;
            int n2 = this.detachedWindowList.size();
            while (n < n2) {
                DetachedWindow detachedWindow = (DetachedWindow)this.detachedWindowList.get(n);
                this.collectViewPanes(list, detachedWindow.getChildren());
                ++n;
            }
        }
    }

    private void collectViewPanes(List list, LayoutPart[] layoutPartArray) {
        int n = 0;
        int n2 = layoutPartArray.length;
        while (n < n2) {
            LayoutPart layoutPart = layoutPartArray[n];
            if (layoutPart instanceof ViewPane) {
                list.add(layoutPart);
            } else if (layoutPart instanceof ILayoutContainer) {
                this.collectViewPanes(list, ((ILayoutContainer)((Object)layoutPart)).getChildren());
            }
            ++n;
        }
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.disableAllDrag();
        Composite composite = this.mainLayout.getParent();
        Vector vector = new Vector();
        this.collectViewPanes(vector, this.mainLayout.getChildren());
        int n = 0;
        int n2 = this.detachedWindowList.size();
        while (n < n2) {
            DetachedWindow detachedWindow = (DetachedWindow)this.detachedWindowList.get(n);
            this.collectViewPanes(vector, detachedWindow.getChildren());
            ++n;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LayoutPart layoutPart = (LayoutPart)enumeration.nextElement();
            layoutPart.reparent(composite);
        }
        this.mainLayout.setActive(false);
        n2 = 0;
        int n3 = this.detachedWindowList.size();
        while (n2 < n3) {
            DetachedWindow detachedWindow = (DetachedWindow)this.detachedWindowList.get(n2);
            detachedWindow.close();
            ++n2;
        }
        this.active = false;
    }

    public void dispose() {
        this.mainLayout.dispose();
        this.mainLayout.disposeSashes();
    }

    public void describeLayout(StringBuffer stringBuffer) {
        if (this.detachable && this.detachedWindowList.size() != 0) {
            stringBuffer.append("detachedWindows (");
            int n = 0;
            int n2 = this.detachedWindowList.size();
            while (n < n2) {
                DetachedWindow detachedWindow = (DetachedWindow)this.detachedWindowList.get(n);
                LayoutPart[] layoutPartArray = detachedWindow.getChildren();
                if (layoutPartArray.length != 0) {
                    stringBuffer.append("dWindow (");
                    int n3 = 0;
                    while (n3 < layoutPartArray.length) {
                        stringBuffer.append(((ViewPane)layoutPartArray[n3]).getViewReference().getPartName());
                        if (n3 < layoutPartArray.length - 1) {
                            stringBuffer.append(", ");
                        }
                        ++n3;
                    }
                    stringBuffer.append(")");
                }
                ++n;
            }
            stringBuffer.append("), ");
        }
        this.getLayout().describeLayout(stringBuffer);
    }

    void derefPart(LayoutPart layoutPart) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (layoutPart instanceof ViewPane && this.perspective.isFastView((IViewReference)(object4 = ((ViewPane)layoutPart).getViewReference()))) {
            String string = this.perspective.getFastViewManager().getIdForRef((IViewReference)object4);
            object3 = this.findPart(string, null);
            if (object3 instanceof ContainerPlaceholder) {
                object2 = (ViewStack)((ContainerPlaceholder)object3).getRealContainer();
                object = ((PartStack)object2).getChildren();
                n = 0;
                while (n < ((LayoutPart[])object).length) {
                    if (object[n] instanceof PartPlaceholder && object4.getId().equals(object[n].id)) {
                        ((PartStack)object2).remove(object[n]);
                    }
                    ++n;
                }
            }
            this.perspective.getFastViewManager().removeViewReference((IViewReference)object4, true, true);
        }
        object4 = layoutPart.getContainer();
        boolean bl = layoutPart.isDocked();
        object3 = layoutPart.getShell();
        layoutPart.reparent(this.mainLayout.getParent());
        if (object4 == null) {
            return;
        }
        object4.remove(layoutPart);
        object2 = object4.getChildren();
        if (bl) {
            LayoutPart layoutPart2;
            ILayoutContainer iLayoutContainer;
            boolean bl2;
            boolean bl3 = bl2 = object2 != null && ((LayoutPart[])object2).length > 0;
            if (bl2) {
                n = 0;
                int n2 = 0;
                while (n2 < ((Object)object2).length) {
                    if (((LayoutPart)object2[n2]).getControl() != null) {
                        ++n;
                    }
                    ++n2;
                }
                if (object4 instanceof ViewStack) {
                    ViewStack viewStack = (ViewStack)object4;
                    boolean bl4 = false;
                    if (this.perspective.getFastViewManager() != null) {
                        boolean bl5 = bl4 = this.perspective.getFastViewManager().getFastViews(viewStack.getID()).size() > 0;
                    }
                    if (n == 0 && !bl4) {
                        ILayoutContainer iLayoutContainer2 = viewStack.getContainer();
                        boolean bl6 = bl2 = viewStack.getChildren().length > 0;
                        if (bl2) {
                            viewStack.dispose();
                            ContainerPlaceholder containerPlaceholder = new ContainerPlaceholder(viewStack.getID());
                            containerPlaceholder.setRealContainer(viewStack);
                            iLayoutContainer2.replace(viewStack, containerPlaceholder);
                        }
                    } else if (n == 1) {
                        LayoutTree layoutTree = this.mainLayout.getLayoutTree();
                        layoutTree = layoutTree.find(viewStack);
                        layoutTree.setBounds(layoutTree.getBounds());
                    }
                }
            }
            if (!(bl2 || object4 instanceof ViewStack && ((ViewStack)object4).getDurable() || !(object4 instanceof LayoutPart) || (iLayoutContainer = (layoutPart2 = (LayoutPart)object4).getContainer()) == null)) {
                iLayoutContainer.remove(layoutPart2);
                layoutPart2.dispose();
            }
        } else if (!bl) {
            if (object2 == null || ((Object)object2).length == 0) {
                object = (DetachedWindow)object3.getData();
                object3.close();
                this.detachedWindowList.remove(object);
            } else {
                boolean bl7 = true;
                n = 0;
                int n3 = ((Object)object2).length;
                while (n < n3) {
                    if (!(object2[n] instanceof PartPlaceholder)) {
                        bl7 = false;
                        break;
                    }
                    ++n;
                }
                if (bl7) {
                    DetachedPlaceHolder detachedPlaceHolder = new DetachedPlaceHolder("", object3.getBounds());
                    n3 = 0;
                    int n4 = ((Object)object2).length;
                    while (n3 < n4) {
                        object4.remove((LayoutPart)object2[n3]);
                        ((LayoutPart)object2[n3]).setContainer(detachedPlaceHolder);
                        detachedPlaceHolder.add((LayoutPart)object2[n3]);
                        ++n3;
                    }
                    this.detachedPlaceHolderList.add(detachedPlaceHolder);
                    DetachedWindow detachedWindow = (DetachedWindow)object3.getData();
                    object3.close();
                    this.detachedWindowList.remove(detachedWindow);
                }
            }
        }
    }

    private void detach(LayoutPart layoutPart, int n, int n2) {
        ILayoutContainer iLayoutContainer;
        if (!this.detachable) {
            return;
        }
        LayoutPart layoutPart2 = layoutPart.getPart();
        Point point = layoutPart2.getSize();
        if ((point.x == 0 || point.y == 0) && (iLayoutContainer = layoutPart2.getContainer()) instanceof LayoutPart) {
            point = ((LayoutPart)((Object)iLayoutContainer)).getSize();
        }
        int n3 = Math.max(point.x, 150);
        int n4 = Math.max(point.y, 250);
        DetachedWindow detachedWindow = new DetachedWindow(this.page);
        this.detachedWindowList.add(detachedWindow);
        detachedWindow.create();
        detachedWindow.getShell().setBounds(n, n2, n3, n4);
        detachedWindow.open();
        if (layoutPart2 instanceof ViewStack) {
            detachedWindow.getShell().setRedraw(false);
            this.parentWidget.setRedraw(false);
            PartPane partPane = ((ViewStack)layoutPart2).getSelection();
            LayoutPart[] layoutPartArray = ((ViewStack)layoutPart2).getChildren();
            int n5 = 0;
            while (n5 < layoutPartArray.length) {
                if (layoutPartArray[n5] instanceof ViewPane) {
                    this.derefPart(layoutPartArray[n5]);
                    ViewPane viewPane = (ViewPane)layoutPartArray[n5];
                    detachedWindow.add(viewPane);
                }
                ++n5;
            }
            if (partPane != null) {
                this.bringPartToTop(partPane);
                ((LayoutPart)partPane).setFocus();
            }
            detachedWindow.getShell().setRedraw(true);
            this.parentWidget.setRedraw(true);
        } else {
            this.derefPart(layoutPart2);
            ViewPane viewPane = (ViewPane)layoutPart2;
            detachedWindow.add(viewPane);
            layoutPart2.setFocus();
        }
    }

    public void detachPart(IViewReference iViewReference) {
        ViewPane viewPane = (ViewPane)((WorkbenchPartReference)((Object)iViewReference)).getPane();
        if (this.canDetach() && viewPane != null) {
            if (this.getMaximizedStack() != null) {
                this.getMaximizedStack().setState(2);
            }
            Rectangle rectangle = viewPane.getParentBounds();
            this.detach(viewPane, rectangle.x, rectangle.y);
        }
    }

    public void addDetachedPart(LayoutPart layoutPart) {
        Rectangle rectangle = this.parentWidget.getShell().getBounds();
        rectangle.x += (rectangle.width - 300) / 2;
        rectangle.y += (rectangle.height - 300) / 2;
        this.addDetachedPart(layoutPart, rectangle);
    }

    public void addDetachedPart(LayoutPart layoutPart, Rectangle rectangle) {
        if (!this.detachable) {
            this.addPart(layoutPart);
            return;
        }
        DetachedWindow detachedWindow = new DetachedWindow(this.page);
        this.detachedWindowList.add(detachedWindow);
        detachedWindow.create();
        layoutPart.createControl((Composite)detachedWindow.getShell());
        ViewPane viewPane = (ViewPane)layoutPart;
        detachedWindow.add(viewPane);
        detachedWindow.getShell().setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        detachedWindow.open();
        layoutPart.setFocus();
    }

    private void disableAllDrag() {
        DragUtil.removeDragTarget(null, this.dragTarget);
    }

    private void enableAllDrag() {
        DragUtil.addDragTarget(null, this.dragTarget);
    }

    private LayoutPart findPart(String string) {
        return this.findPart(string, null);
    }

    public LayoutPart findPart(String string, String string2) {
        LayoutPart layoutPart;
        ArrayList arrayList = new ArrayList();
        LayoutPart layoutPart2 = layoutPart = string2 != null ? this.findPart(string, string2, this.mainLayout.getChildren(), arrayList) : this.findPart(string, this.mainLayout.getChildren(), arrayList);
        if (layoutPart != null) {
            return layoutPart;
        }
        int n = 0;
        int n2 = this.detachedWindowList.size();
        while (n < n2) {
            DetachedWindow detachedWindow = (DetachedWindow)this.detachedWindowList.get(n);
            LayoutPart layoutPart3 = layoutPart = string2 != null ? this.findPart(string, string2, detachedWindow.getChildren(), arrayList) : this.findPart(string, detachedWindow.getChildren(), arrayList);
            if (layoutPart != null) {
                return layoutPart;
            }
            ++n;
        }
        n = 0;
        while (n < this.detachedPlaceHolderList.size()) {
            DetachedPlaceHolder detachedPlaceHolder = (DetachedPlaceHolder)this.detachedPlaceHolderList.get(n);
            LayoutPart layoutPart4 = layoutPart = string2 != null ? this.findPart(string, string2, detachedPlaceHolder.getChildren(), arrayList) : this.findPart(string, detachedPlaceHolder.getChildren(), arrayList);
            if (layoutPart != null) {
                return layoutPart;
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            Collections.sort(arrayList);
            MatchingPart matchingPart = (MatchingPart)arrayList.get(0);
            if (matchingPart != null) {
                return matchingPart.part;
            }
        }
        return null;
    }

    private LayoutPart findPart(String string, LayoutPart[] layoutPartArray, ArrayList arrayList) {
        int n = 0;
        int n2 = layoutPartArray.length;
        while (n < n2) {
            Object object;
            LayoutPart layoutPart = layoutPartArray[n];
            if (layoutPart.getID().equals(string)) {
                IViewReference iViewReference;
                if (!(layoutPart instanceof ViewPane) || (iViewReference = (IViewReference)((PartPane)(object = (ViewPane)layoutPart)).getPartReference()).getSecondaryId() == null) {
                    return layoutPart;
                }
            } else if (layoutPart instanceof PartPlaceholder && ((PartPlaceholder)layoutPart).hasWildCard()) {
                object = new StringMatcher(layoutPart.getID(), true, false);
                if (((StringMatcher)object).match(string)) {
                    arrayList.add(new MatchingPart(layoutPart.getID(), null, layoutPart));
                }
            } else if (!(layoutPart instanceof EditorSashContainer) && layoutPart instanceof ILayoutContainer && (layoutPart = this.findPart(string, ((ILayoutContainer)((Object)layoutPart)).getChildren(), arrayList)) != null) {
                return layoutPart;
            }
            ++n;
        }
        return null;
    }

    private LayoutPart findPart(String string, String string2, LayoutPart[] layoutPartArray, ArrayList arrayList) {
        int n = 0;
        int n2 = layoutPartArray.length;
        while (n < n2) {
            Object object;
            Object object2;
            LayoutPart layoutPart = layoutPartArray[n];
            if (layoutPart instanceof ILayoutContainer && (object2 = this.findPart(string, string2, ((ILayoutContainer)((Object)layoutPart)).getChildren(), arrayList)) != null) {
                return object2;
            }
            if (layoutPart instanceof ViewPane) {
                object2 = (ViewPane)layoutPart;
                object = (IViewReference)((PartPane)object2).getPartReference();
                if (object.getId().equals(string) && object.getSecondaryId() != null && object.getSecondaryId().equals(string2)) {
                    return layoutPart;
                }
            } else if (layoutPartArray[n] instanceof PartPlaceholder) {
                object2 = layoutPart.getID();
                object = ViewFactory.extractSecondaryId((String)object2);
                if (object == null) {
                    if (((String)object2).equals(PartPlaceholder.WILD_CARD)) {
                        arrayList.add(new MatchingPart((String)object2, null, layoutPart));
                    }
                } else {
                    String string3 = ViewFactory.extractPrimaryId((String)object2);
                    if (string3.equals(string) && ((String)object).equals(string2)) {
                        return layoutPart;
                    }
                    StringMatcher stringMatcher = new StringMatcher(string3, true, false);
                    if (stringMatcher.match(string) && (stringMatcher = new StringMatcher((String)object, true, false)).match(string2)) {
                        arrayList.add(new MatchingPart(string3, (String)object, layoutPart));
                    }
                }
            } else {
                boolean cfr_ignored_0 = layoutPart instanceof EditorSashContainer;
            }
            ++n;
        }
        return null;
    }

    public boolean hasPlaceholder(String string) {
        return this.hasPlaceholder(string, null);
    }

    public boolean hasPlaceholder(String string, String string2) {
        LayoutPart layoutPart = string2 == null ? this.findPart(string) : this.findPart(string, string2);
        return layoutPart != null && layoutPart instanceof PartPlaceholder;
    }

    public ViewSashContainer getLayout() {
        return this.mainLayout;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isZoomed() {
        return this.mainLayout.getZoomedPart() != null;
    }

    public PartStack getMaximizedStack() {
        return this.maximizedStack;
    }

    public void setMaximizedStack(PartStack partStack) {
        if (partStack == this.maximizedStack) {
            return;
        }
        this.maximizedStack = partStack;
    }

    public static float getDockingRatio(LayoutPart layoutPart, LayoutPart layoutPart2) {
        if ((layoutPart instanceof ViewPane || layoutPart instanceof ViewStack) && layoutPart2 instanceof EditorSashContainer) {
            return 0.25f;
        }
        return 0.5f;
    }

    public boolean partChangeAffectsZoom(LayoutPart layoutPart) {
        return layoutPart.isObscuredByZoom();
    }

    public void removePart(LayoutPart layoutPart) {
        Composite composite = this.mainLayout.getParent();
        layoutPart.reparent(composite);
        ILayoutContainer iLayoutContainer = layoutPart.getContainer();
        if (iLayoutContainer != null) {
            String string = layoutPart.getPlaceHolderId();
            iLayoutContainer.replace(layoutPart, new PartPlaceholder(string));
            if (iLayoutContainer == this.mainLayout) {
                return;
            }
            LayoutPart[] layoutPartArray = iLayoutContainer.getChildren();
            if (layoutPartArray != null) {
                int n;
                boolean bl = true;
                if (iLayoutContainer instanceof ViewStack && !((ViewStack)iLayoutContainer).isMinimized && ((ViewStack)iLayoutContainer).getDurable()) {
                    bl = false;
                } else {
                    int n2 = 0;
                    n = layoutPartArray.length;
                    while (n2 < n) {
                        if (!(layoutPartArray[n2] instanceof PartPlaceholder)) {
                            bl = false;
                            break;
                        }
                        ++n2;
                    }
                }
                if (bl && iLayoutContainer instanceof LayoutPart) {
                    LayoutPart layoutPart2 = (LayoutPart)((Object)iLayoutContainer);
                    n = layoutPart2.isDocked() ? 1 : 0;
                    Shell shell = layoutPart2.getShell();
                    if (n != 0) {
                        if (iLayoutContainer instanceof ViewStack) {
                            ((ViewStack)iLayoutContainer).dispose();
                        }
                        ILayoutContainer iLayoutContainer2 = layoutPart2.getContainer();
                        ContainerPlaceholder containerPlaceholder = new ContainerPlaceholder(layoutPart2.getID());
                        containerPlaceholder.setRealContainer(iLayoutContainer);
                        iLayoutContainer2.replace(layoutPart2, containerPlaceholder);
                    } else {
                        DetachedPlaceHolder detachedPlaceHolder = new DetachedPlaceHolder("", shell.getBounds());
                        int n3 = 0;
                        int n4 = layoutPartArray.length;
                        while (n3 < n4) {
                            layoutPartArray[n3].getContainer().remove(layoutPartArray[n3]);
                            layoutPartArray[n3].setContainer(detachedPlaceHolder);
                            detachedPlaceHolder.add(layoutPartArray[n3]);
                            ++n3;
                        }
                        this.detachedPlaceHolderList.add(detachedPlaceHolder);
                        DetachedWindow detachedWindow = (DetachedWindow)shell.getData();
                        shell.close();
                        this.detachedWindowList.remove(detachedWindow);
                    }
                }
            }
        }
    }

    public void replacePlaceholderWithPart(LayoutPart layoutPart) {
        PartPlaceholder[] partPlaceholderArray = this.collectPlaceholders();
        int n = 0;
        int n2 = partPlaceholderArray.length;
        while (n < n2) {
            ILayoutContainer iLayoutContainer;
            if (partPlaceholderArray[n].getCompoundId().equals(layoutPart.getCompoundId()) && (iLayoutContainer = partPlaceholderArray[n].getContainer()) != null) {
                if (iLayoutContainer instanceof ContainerPlaceholder) {
                    ContainerPlaceholder containerPlaceholder = (ContainerPlaceholder)iLayoutContainer;
                    ILayoutContainer iLayoutContainer2 = containerPlaceholder.getContainer();
                    iLayoutContainer = (ILayoutContainer)((Object)containerPlaceholder.getRealContainer());
                    if (iLayoutContainer instanceof LayoutPart) {
                        iLayoutContainer2.replace(containerPlaceholder, (LayoutPart)((Object)iLayoutContainer));
                    }
                    containerPlaceholder.setRealContainer(null);
                }
                iLayoutContainer.replace(partPlaceholderArray[n], layoutPart);
                return;
            }
            ++n;
        }
    }

    public IStatus restoreState(IMemento iMemento) {
        IMemento iMemento2 = iMemento.getChild("mainWindow");
        IStatus iStatus = this.mainLayout.restoreState(iMemento2);
        if (this.detachable) {
            IMemento[] iMementoArray = iMemento.getChildren("detachedWindow");
            int n = 0;
            while (n < iMementoArray.length) {
                DetachedWindow detachedWindow = new DetachedWindow(this.page);
                this.detachedWindowList.add(detachedWindow);
                detachedWindow.restoreState(iMementoArray[n]);
                ++n;
            }
            IMemento[] iMementoArray2 = iMemento.getChildren("hiddenWindow");
            int n2 = 0;
            int n3 = iMementoArray2.length;
            while (n2 < n3) {
                DetachedPlaceHolder detachedPlaceHolder = new DetachedPlaceHolder("", new Rectangle(0, 0, 0, 0));
                detachedPlaceHolder.restoreState(iMementoArray2[n2]);
                this.detachedPlaceHolderList.add(detachedPlaceHolder);
                ++n2;
            }
        }
        this.maximizedStackId = iMemento2.getString("maximized");
        return iStatus;
    }

    public IStatus saveState(IMemento iMemento) {
        IMemento iMemento2 = iMemento.createChild("mainWindow");
        IStatus iStatus = this.mainLayout.saveState(iMemento2);
        if (this.detachable) {
            Object object;
            int n = 0;
            int n2 = this.detachedWindowList.size();
            while (n < n2) {
                object = (DetachedWindow)this.detachedWindowList.get(n);
                iMemento2 = iMemento.createChild("detachedWindow");
                ((DetachedWindow)object).saveState(iMemento2);
                ++n;
            }
            n = 0;
            n2 = this.detachedPlaceHolderList.size();
            while (n < n2) {
                object = (DetachedPlaceHolder)this.detachedPlaceHolderList.get(n);
                iMemento2 = iMemento.createChild("hiddenWindow");
                ((DetachedPlaceHolder)object).saveState(iMemento2);
                ++n;
            }
        }
        if (this.maximizedStack instanceof ViewStack) {
            iMemento2.putString("maximized", this.maximizedStack.getID());
        } else if (this.maximizedStackId != null) {
            iMemento2.putString("maximized", this.maximizedStackId);
        }
        return iStatus;
    }

    public void zoomIn(IWorkbenchPartReference iWorkbenchPartReference) {
        PartPane partPane = ((WorkbenchPartReference)iWorkbenchPartReference).getPane();
        this.parentWidget.setRedraw(false);
        try {
            partPane.requestZoomIn();
        }
        finally {
            this.parentWidget.setRedraw(true);
        }
    }

    public void zoomOut() {
        if (Perspective.useNewMinMax(this.perspective)) {
            if (this.maximizedStack != null) {
                this.maximizedStack.setState(2);
            }
            return;
        }
        LayoutPart layoutPart = this.mainLayout.getZoomedPart();
        if (layoutPart != null) {
            layoutPart.requestZoomOut();
        }
    }

    public void forceNoZoom() {
        this.zoomOut();
        LayoutPart[] layoutPartArray = this.mainLayout.getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            if (layoutPartArray[n] instanceof ViewStack) {
                ((ViewStack)layoutPartArray[n]).setMinimized(false);
            } else if (layoutPartArray[n] instanceof EditorSashContainer) {
                LayoutPart[] layoutPartArray2 = ((EditorSashContainer)layoutPartArray[n]).getChildren();
                int n2 = 0;
                while (n2 < layoutPartArray2.length) {
                    if (layoutPartArray2[n2] instanceof EditorStack) {
                        ((EditorStack)layoutPartArray2[n2]).setMinimized(false);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void updateBoundsMap() {
        this.boundsMap.clear();
        LayoutPart[] layoutPartArray = this.mainLayout.getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            LayoutPart layoutPart;
            if (layoutPartArray[n] instanceof ViewStack) {
                layoutPart = (ViewStack)layoutPartArray[n];
                this.boundsMap.put(layoutPart.getID(), ((PartStack)layoutPart).getBounds());
            } else if (layoutPartArray[n] instanceof EditorSashContainer) {
                layoutPart = (EditorSashContainer)layoutPartArray[n];
                this.boundsMap.put(layoutPart.getID(), ((PartSashContainer)layoutPart).getBounds());
            }
            ++n;
        }
    }

    public void resetBoundsMap() {
        this.boundsMap.clear();
    }

    public Rectangle getCachedBoundsFor(String string) {
        return (Rectangle)this.boundsMap.get(string);
    }

    private final class ActualDropTarget
    extends AbstractDropTarget {
        private LayoutPart part;
        private Rectangle dragRectangle;

        private ActualDropTarget(LayoutPart layoutPart, Rectangle rectangle) {
            this.setTarget(layoutPart, rectangle);
        }

        private void setTarget(LayoutPart layoutPart, Rectangle rectangle) {
            this.part = layoutPart;
            this.dragRectangle = rectangle;
        }

        @Override
        public void drop() {
            Shell shell = this.part.getShell();
            if (shell.getData() instanceof DetachedWindow) {
                if (this.part instanceof ViewStack) {
                    shell.setLocation(this.dragRectangle.x, this.dragRectangle.y);
                    return;
                }
                ILayoutContainer iLayoutContainer = this.part.getContainer();
                if (iLayoutContainer instanceof ViewStack && ((ViewStack)iLayoutContainer).getItemCount() == 1) {
                    shell.setLocation(this.dragRectangle.x, this.dragRectangle.y);
                    return;
                }
            }
            if (PerspectiveHelper.this.isZoomed()) {
                PerspectiveHelper.this.zoomOut();
            }
            PerspectiveHelper.this.detach(this.part, this.dragRectangle.x, this.dragRectangle.y);
        }

        @Override
        public Cursor getCursor() {
            return DragCursors.getCursor(6);
        }
    }

    private class MatchingPart
    implements Comparable {
        LayoutPart part;
        boolean hasWildcard;
        int len;

        MatchingPart(String string, String string2, LayoutPart layoutPart) {
            this.part = layoutPart;
            this.len = (string == null ? 0 : string.length()) + (string2 == null ? 0 : string2.length());
            this.hasWildcard = string != null && string.indexOf(PartPlaceholder.WILD_CARD) != -1 || string2 != null && string2.indexOf(PartPlaceholder.WILD_CARD) != -1;
        }

        public int compareTo(Object object) {
            MatchingPart matchingPart = (MatchingPart)object;
            if (this.hasWildcard && !matchingPart.hasWildcard) {
                return -1;
            }
            if (!this.hasWildcard && matchingPart.hasWildcard) {
                return 1;
            }
            return matchingPart.len - this.len;
        }
    }
}

