/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;

public class PerspectiveBarNewContributionItem
extends ContributionItem {
    private MenuManager menuManager = new MenuManager();
    private Image image;
    private ToolItem toolItem = null;

    public PerspectiveBarNewContributionItem(IWorkbenchWindow iWorkbenchWindow) {
        super(PerspectiveBarNewContributionItem.class.getName());
        this.menuManager.add(ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(iWorkbenchWindow));
    }

    public void dispose() {
        super.dispose();
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
    }

    public void fill(final ToolBar toolBar, int n) {
        if (this.toolItem == null && toolBar != null) {
            toolBar.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    PerspectiveBarNewContributionItem.this.toolItem.dispose();
                    PerspectiveBarNewContributionItem.this.toolItem = null;
                }
            });
            this.toolItem = new ToolItem(toolBar, 8);
            if (this.image == null || this.image.isDisposed()) {
                this.image = WorkbenchImages.getImageDescriptor("IMG_ETOOL_NEW_PAGE").createImage();
            }
            this.toolItem.setImage(this.image);
            this.toolItem.setText("");
            this.toolItem.setToolTipText(WorkbenchMessages.PerspectiveBarNewContributionItem_toolTip);
            this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ToolItem toolItem;
                    PerspectiveBarNewContributionItem.this.menuManager.update(true);
                    Point point = new Point(selectionEvent.x, selectionEvent.y);
                    if (selectionEvent.widget instanceof ToolItem) {
                        toolItem = (ToolItem)selectionEvent.widget;
                        Rectangle rectangle = toolItem.getBounds();
                        point = new Point(rectangle.x, rectangle.y + rectangle.height);
                    }
                    toolItem = PerspectiveBarNewContributionItem.this.menuManager.createContextMenu((Control)toolBar);
                    point = toolBar.toDisplay(point);
                    toolItem.setLocation(point.x, point.y);
                    toolItem.setVisible(true);
                }
            });
        }
    }
}

