/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.PerspectiveBarContributionItem;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.util.PrefUtil;

public class PerspectiveBarManager
extends ToolBarManager {
    private CoolBar coolBar;
    private Menu chevronMenu = null;

    public PerspectiveBarManager(int n) {
        super(n);
    }

    public ToolBar createControl(Composite composite) {
        ToolBar toolBar = super.createControl(composite);
        return toolBar;
    }

    public void handleChevron(SelectionEvent selectionEvent) {
        ToolItem toolItem;
        CoolItem coolItem = (CoolItem)selectionEvent.widget;
        ToolBar toolBar = this.getControl();
        if (!(toolBar instanceof ToolBar)) {
            return;
        }
        Rectangle rectangle = coolItem.getBounds();
        Point point = this.coolBar.toDisplay(new Point(rectangle.x, rectangle.y));
        rectangle.x = point.x;
        rectangle.y = point.y;
        ToolBar toolBar2 = toolBar;
        ToolItem[] toolItemArray = toolBar2.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle2 = toolItemArray[n2].getBounds();
            point = toolBar2.toDisplay(new Point(rectangle2.x, rectangle2.y));
            rectangle2.x = point.x;
            rectangle2.y = point.y;
            toolItem = rectangle.intersection(rectangle2);
            if (!toolItem.equals((Object)rectangle2)) break;
            ++n2;
        }
        if (this.chevronMenu != null && !this.chevronMenu.isDisposed()) {
            this.chevronMenu.dispose();
        }
        this.chevronMenu = new Menu((Control)this.coolBar);
        int n3 = n2;
        while (n3 < n) {
            toolItem = toolItemArray[n3];
            MenuItem menuItem = new MenuItem(this.chevronMenu, 0);
            if (toolItem.getSelection()) {
                menuItem.setEnabled(false);
            }
            if (toolItem.getData() instanceof PerspectiveBarContributionItem) {
                menuItem.setText(((PerspectiveBarContributionItem)((Object)toolItem.getData())).getPerspective().getLabel());
            } else {
                menuItem.setText(toolItem.getText());
            }
            menuItem.setImage(toolItem.getImage());
            menuItem.setData("IContributionItem", toolItem.getData());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    MenuItem menuItem = (MenuItem)selectionEvent.widget;
                    Object object = menuItem.getData("IContributionItem");
                    if (object instanceof PerspectiveBarContributionItem) {
                        PerspectiveBarContributionItem perspectiveBarContributionItem = (PerspectiveBarContributionItem)((Object)object);
                        PerspectiveBarManager.this.update(false);
                        perspectiveBarContributionItem.select();
                    }
                }
            });
            ++n3;
        }
        point = this.coolBar.toDisplay(new Point(selectionEvent.x, selectionEvent.y));
        this.chevronMenu.setLocation(point.x, point.y);
        this.chevronMenu.setVisible(true);
    }

    protected void relayout(ToolBar toolBar, int n, int n2) {
        super.relayout(toolBar, n, n2);
        if (this.getControl() != null) {
            LayoutUtil.resize((Control)this.getControl());
        }
    }

    void setParent(CoolBar coolBar) {
        this.coolBar = coolBar;
    }

    void select(PerspectiveBarContributionItem perspectiveBarContributionItem) {
        if (perspectiveBarContributionItem.getToolItem() == null) {
            return;
        }
        if (this.getControl().isVisible() && !this.isItemVisible(perspectiveBarContributionItem.getToolItem())) {
            this.ensureVisible(perspectiveBarContributionItem);
        }
    }

    public void addItem(PerspectiveBarContributionItem perspectiveBarContributionItem) {
        IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
        if (iPreferenceStore.getBoolean("SHOW_OPEN_ON_PERSPECTIVE_BAR")) {
            this.insert(1, (IContributionItem)perspectiveBarContributionItem);
        } else {
            this.insert(0, (IContributionItem)perspectiveBarContributionItem);
        }
        this.update(false);
    }

    public void removeItem(PerspectiveBarContributionItem perspectiveBarContributionItem) {
        this.remove((IContributionItem)perspectiveBarContributionItem);
    }

    private void ensureVisible(PerspectiveBarContributionItem perspectiveBarContributionItem) {
        this.relocate(perspectiveBarContributionItem, 1);
    }

    void relocate(PerspectiveBarContributionItem perspectiveBarContributionItem, int n) {
        PerspectiveBarContributionItem perspectiveBarContributionItem2 = new PerspectiveBarContributionItem(perspectiveBarContributionItem.getPerspective(), perspectiveBarContributionItem.getPage());
        this.removeItem(perspectiveBarContributionItem);
        perspectiveBarContributionItem.dispose();
        perspectiveBarContributionItem = null;
        this.insert(n, (IContributionItem)perspectiveBarContributionItem2);
        this.update(false);
    }

    private boolean isItemVisible(ToolItem toolItem) {
        Rectangle rectangle = this.getControl().getBounds();
        Rectangle rectangle2 = toolItem.getBounds();
        return rectangle.intersection(rectangle2).equals((Object)rectangle2);
    }

    public void arrangeToolbar() {
        if (!this.getControl().isVisible()) {
            return;
        }
        if (this.getControl().getItemCount() < 3) {
            return;
        }
        IContributionItem[] iContributionItemArray = this.getItems();
        int n = 2;
        while (n < iContributionItemArray.length) {
            PerspectiveBarContributionItem perspectiveBarContributionItem = (PerspectiveBarContributionItem)iContributionItemArray[n];
            if (perspectiveBarContributionItem.getToolItem().getSelection() && !this.isItemVisible(perspectiveBarContributionItem.getToolItem())) {
                this.ensureVisible(perspectiveBarContributionItem);
                break;
            }
            ++n;
        }
    }
}

