/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.util.PrefUtil;

public class PerspectiveBarContributionItem
extends ContributionItem {
    private IPerspectiveDescriptor perspective;
    private IPreferenceStore apiPreferenceStore = PrefUtil.getAPIPreferenceStore();
    private ToolItem toolItem = null;
    private Image image;
    private IWorkbenchPage workbenchPage;
    private static final String ellipsis = "...";

    public PerspectiveBarContributionItem(IPerspectiveDescriptor iPerspectiveDescriptor, IWorkbenchPage iWorkbenchPage) {
        super(iPerspectiveDescriptor.getId());
        this.perspective = iPerspectiveDescriptor;
        this.workbenchPage = iWorkbenchPage;
    }

    public void dispose() {
        super.dispose();
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
        this.apiPreferenceStore = null;
        this.workbenchPage = null;
        this.perspective = null;
    }

    public void fill(ToolBar toolBar, int n) {
        if (this.toolItem == null && toolBar != null && !toolBar.isDisposed()) {
            this.toolItem = n >= 0 ? new ToolItem(toolBar, 32, n) : new ToolItem(toolBar, 32);
            if (this.image == null || this.image.isDisposed()) {
                this.createImage();
            }
            this.toolItem.setImage(this.image);
            this.toolItem.setToolTipText(NLS.bind((String)WorkbenchMessages.PerspectiveBarContributionItem_toolTip, (Object)this.perspective.getLabel()));
            this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PerspectiveBarContributionItem.this.select();
                }
            });
            this.toolItem.setData((Object)this);
            this.update();
        }
    }

    private void createImage() {
        ImageDescriptor imageDescriptor = this.perspective.getImageDescriptor();
        this.image = imageDescriptor != null ? imageDescriptor.createImage() : WorkbenchImages.getImageDescriptor("IMG_ETOOL_DEF_PERSPECTIVE").createImage();
    }

    Image getImage() {
        if (this.image == null) {
            this.createImage();
        }
        return this.image;
    }

    public void select() {
        if (this.workbenchPage.getPerspective() != this.perspective) {
            this.workbenchPage.setPerspective(this.perspective);
        } else {
            this.toolItem.setSelection(true);
        }
    }

    public void update() {
        if (this.toolItem != null && !this.toolItem.isDisposed()) {
            this.toolItem.setSelection(this.workbenchPage.getPerspective() == this.perspective);
            if (this.apiPreferenceStore.getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR")) {
                if (this.apiPreferenceStore.getString("DOCK_PERSPECTIVE_BAR").equals("topLeft")) {
                    this.toolItem.setText(this.perspective.getLabel());
                } else {
                    this.toolItem.setText(this.shortenText(this.perspective.getLabel(), this.toolItem));
                }
            } else {
                this.toolItem.setText("");
            }
        }
    }

    public void update(IPerspectiveDescriptor iPerspectiveDescriptor) {
        this.perspective = iPerspectiveDescriptor;
        if (this.toolItem != null && !this.toolItem.isDisposed()) {
            ImageDescriptor imageDescriptor = this.perspective.getImageDescriptor();
            if (imageDescriptor != null) {
                this.toolItem.setImage(imageDescriptor.createImage());
            } else {
                this.toolItem.setImage(WorkbenchImages.getImageDescriptor("IMG_ETOOL_DEF_PERSPECTIVE").createImage());
            }
            this.toolItem.setToolTipText(NLS.bind((String)WorkbenchMessages.PerspectiveBarContributionItem_toolTip, (Object)this.perspective.getLabel()));
        }
        this.update();
    }

    IWorkbenchPage getPage() {
        return this.workbenchPage;
    }

    IPerspectiveDescriptor getPerspective() {
        return this.perspective;
    }

    ToolItem getToolItem() {
        return this.toolItem;
    }

    public boolean handles(IPerspectiveDescriptor iPerspectiveDescriptor, IWorkbenchPage iWorkbenchPage) {
        return this.perspective == iPerspectiveDescriptor && this.workbenchPage == iWorkbenchPage;
    }

    public void setPerspective(IPerspectiveDescriptor iPerspectiveDescriptor) {
        this.perspective = iPerspectiveDescriptor;
    }

    void setSelection(boolean bl) {
        if (this.toolItem != null && !this.toolItem.isDisposed()) {
            this.toolItem.setSelection(bl);
        }
    }

    static int getMaxWidth(Image image) {
        return image.getBounds().width * 5;
    }

    protected String shortenText(String string, ToolItem toolItem) {
        if (string == null || this.toolItem == null || this.toolItem.isDisposed()) {
            return null;
        }
        String string2 = string;
        GC gC = new GC((Drawable)toolItem.getParent());
        int n = PerspectiveBarContributionItem.getMaxWidth(toolItem.getImage());
        if (gC.textExtent((String)string).x >= n) {
            int n2 = string.length();
            while (n2 > 0) {
                String string3 = string.substring(0, n2);
                string3 = String.valueOf(string3) + ellipsis;
                if (gC.textExtent((String)string3).x < n) {
                    string2 = string3;
                    break;
                }
                --n2;
            }
        }
        gC.dispose();
        return string2;
    }
}

