/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Geometry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.DetachedPlaceHolder;
import org.eclipse.ui.internal.EditorAreaTrimToolBar;
import org.eclipse.ui.internal.EditorSashContainer;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.FastViewManager;
import org.eclipse.ui.internal.FastViewPane;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PageLayout;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.PerspectiveHelper;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewIntroAdapterPart;
import org.eclipse.ui.internal.ViewLayoutRec;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewSashContainer;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.layout.ITrimManager;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.TrimLayout;
import org.eclipse.ui.internal.layout.TrimToolBarBase;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveExtensionReader;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.IStickyViewDescriptor;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class Perspective {
    protected PerspectiveDescriptor descriptor;
    protected WorkbenchPage page;
    protected LayoutPart editorArea;
    protected PartPlaceholder editorHolder;
    protected boolean editorHidden = false;
    protected boolean editorAreaRestoreOnUnzoom = false;
    protected int editorAreaState = 2;
    private ViewFactory viewFactory;
    protected ArrayList alwaysOnActionSets;
    protected ArrayList alwaysOffActionSets;
    protected ArrayList newWizardShortcuts;
    protected ArrayList showViewShortcuts;
    protected ArrayList perspectiveShortcuts;
    protected Collection hideMenuIDs;
    protected Collection hideToolBarIDs;
    protected FastViewManager fastViewManager = null;
    private Map mapIDtoViewLayoutRec;
    protected boolean fixed;
    protected ArrayList showInPartIds;
    protected HashMap showInTimes = new HashMap();
    private IViewReference activeFastView;
    protected IMemento memento;
    protected PerspectiveHelper presentation;
    private static final String VERSION_STRING = "0.016";
    private FastViewPane fastViewPane = new FastViewPane();
    private static final int FASTVIEW_HIDE_STEPS = 5;
    private IWorkbenchPartReference oldPartRef = null;
    protected boolean shouldHideEditorsOnActivate = false;
    protected PageLayout layout;

    public Perspective(PerspectiveDescriptor perspectiveDescriptor, WorkbenchPage workbenchPage) throws WorkbenchException {
        this(workbenchPage);
        this.descriptor = perspectiveDescriptor;
        if (perspectiveDescriptor != null) {
            this.createPresentation(perspectiveDescriptor);
        }
    }

    protected Perspective(WorkbenchPage workbenchPage) throws WorkbenchException {
        this.page = workbenchPage;
        this.editorArea = workbenchPage.getEditorPresentation().getLayoutPart();
        this.viewFactory = workbenchPage.getViewFactory();
        this.alwaysOnActionSets = new ArrayList(2);
        this.alwaysOffActionSets = new ArrayList(2);
        this.hideMenuIDs = new HashSet();
        this.hideToolBarIDs = new HashSet();
        IWorkbenchWindow iWorkbenchWindow = workbenchPage.getWorkbenchWindow();
        if (iWorkbenchWindow instanceof WorkbenchWindow && ((WorkbenchWindow)iWorkbenchWindow).getTrimManager() != null) {
            this.fastViewManager = new FastViewManager(this, workbenchPage);
        }
        this.mapIDtoViewLayoutRec = new HashMap();
    }

    public void makeFastView(IViewReference iViewReference) {
        this.addFastView(iViewReference, true);
    }

    public void addFastView(IViewReference iViewReference, boolean bl) {
        ViewPane viewPane = (ViewPane)((WorkbenchPartReference)((Object)iViewReference)).getPane();
        if (!this.isFastView(iViewReference)) {
            if (bl && (this.presentation.hasPlaceholder(iViewReference.getId(), iViewReference.getSecondaryId()) || viewPane.getContainer() != null)) {
                this.presentation.removePart(viewPane);
            }
            viewPane.setFast(true);
            Control control = viewPane.getControl();
            if (control != null) {
                control.setEnabled(false);
            }
        }
    }

    public boolean bringToTop(IViewReference iViewReference) {
        if (this.isFastView(iViewReference)) {
            this.setActiveFastView(iViewReference);
            return true;
        }
        return this.presentation.bringPartToTop(this.getPane(iViewReference));
    }

    public boolean containsView(IViewPart iViewPart) {
        IViewSite iViewSite = iViewPart.getViewSite();
        IViewReference iViewReference = this.findView(iViewSite.getId(), iViewSite.getSecondaryId());
        if (iViewReference == null) {
            return false;
        }
        return iViewPart == iViewReference.getPart(false);
    }

    protected void createInitialActionSets(List list, List list2) {
        ActionSetRegistry actionSetRegistry = WorkbenchPlugin.getDefault().getActionSetRegistry();
        for (String string : list2) {
            IActionSetDescriptor iActionSetDescriptor = actionSetRegistry.findActionSet(string);
            if (iActionSetDescriptor != null) {
                list.add(iActionSetDescriptor);
                continue;
            }
            WorkbenchPlugin.log("Unable to find Action Set: " + string);
        }
    }

    private void createPresentation(PerspectiveDescriptor perspectiveDescriptor) throws WorkbenchException {
        if (perspectiveDescriptor.hasCustomDefinition()) {
            this.loadCustomPersp(perspectiveDescriptor);
        } else {
            this.loadPredefinedPersp(perspectiveDescriptor);
        }
    }

    public void dispose() {
        if (this.presentation == null) {
            this.disposeViewRefs();
            return;
        }
        this.presentation.deactivate();
        this.presentation.dispose();
        this.fastViewPane.dispose();
        IViewReference[] iViewReferenceArray = this.getViewReferences();
        int n = 0;
        int n2 = iViewReferenceArray.length;
        while (n < n2) {
            this.getViewFactory().releaseView(iViewReferenceArray[n]);
            ++n;
        }
        this.mapIDtoViewLayoutRec.clear();
    }

    private void disposeViewRefs() {
        if (this.memento == null) {
            return;
        }
        IMemento[] iMementoArray = this.memento.getChildren("view");
        int n = 0;
        while (n < iMementoArray.length) {
            IMemento iMemento = iMementoArray[n];
            String string = iMemento.getString("id");
            if (!string.equals("org.eclipse.ui.internal.introview")) {
                IViewReference iViewReference;
                String string2 = ViewFactory.extractSecondaryId(string);
                if (string2 != null) {
                    string = ViewFactory.extractPrimaryId(string);
                }
                if (!"true".equals(iMemento.getString("removed")) && (iViewReference = this.viewFactory.getView(string, string2)) != null) {
                    this.viewFactory.releaseView(iViewReference);
                }
            }
            ++n;
        }
    }

    public IViewReference findView(String string) {
        return this.findView(string, null);
    }

    public IViewReference findView(String string, String string2) {
        IViewReference[] iViewReferenceArray = this.getViewReferences();
        int n = 0;
        while (n < iViewReferenceArray.length) {
            IViewReference iViewReference = iViewReferenceArray[n];
            if (string.equals(iViewReference.getId()) && (string2 == null ? iViewReference.getSecondaryId() == null : string2.equals(iViewReference.getSecondaryId()))) {
                return iViewReference;
            }
            ++n;
        }
        return null;
    }

    public Composite getClientComposite() {
        return this.page.getClientComposite();
    }

    public IPerspectiveDescriptor getDesc() {
        return this.descriptor;
    }

    Rectangle getFastViewBounds(IViewReference iViewReference) {
        Rectangle rectangle = this.page.getClientComposite().getBounds();
        float f = this.getFastViewWidthRatio(iViewReference);
        rectangle.width = (int)(f * (float)this.getClientComposite().getSize().x);
        return rectangle;
    }

    public IViewReference[] getFastViews() {
        if (this.fastViewManager == null) {
            return new IViewReference[0];
        }
        List list = this.fastViewManager.getFastViews(FastViewBar.FASTVIEWBAR_ID);
        IViewReference[] iViewReferenceArray = new IViewReference[list.size()];
        list.toArray(iViewReferenceArray);
        return iViewReferenceArray;
    }

    public String[] getNewWizardShortcuts() {
        return this.newWizardShortcuts.toArray(new String[this.newWizardShortcuts.size()]);
    }

    protected ViewPane getPane(IViewReference iViewReference) {
        return (ViewPane)((WorkbenchPartReference)((Object)iViewReference)).getPane();
    }

    public String[] getPerspectiveShortcuts() {
        return this.perspectiveShortcuts.toArray(new String[this.perspectiveShortcuts.size()]);
    }

    public PerspectiveHelper getPresentation() {
        return this.presentation;
    }

    public float getFastViewWidthRatio(IViewReference iViewReference) {
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(iViewReference, true);
        if (viewLayoutRec.fastViewWidthRatio == -1.0f) {
            IViewRegistry iViewRegistry = WorkbenchPlugin.getDefault().getViewRegistry();
            IViewDescriptor iViewDescriptor = iViewRegistry.find(iViewReference.getId());
            viewLayoutRec.fastViewWidthRatio = iViewDescriptor != null ? iViewDescriptor.getFastViewWidthRatio() : 0.3f;
        }
        return viewLayoutRec.fastViewWidthRatio;
    }

    public ArrayList getShowInPartIds() {
        return this.showInPartIds;
    }

    public long getShowInTime(String string) {
        Long l = (Long)this.showInTimes.get(string);
        return l == null ? 0L : l;
    }

    public String[] getShowViewShortcuts() {
        return this.showViewShortcuts.toArray(new String[this.showViewShortcuts.size()]);
    }

    public ViewFactory getViewFactory() {
        return this.viewFactory;
    }

    public IViewReference[] getViewReferences() {
        if (this.presentation == null) {
            return new IViewReference[0];
        }
        ArrayList arrayList = new ArrayList(5);
        this.presentation.collectViewPanes(arrayList);
        List list = this.fastViewManager != null ? this.fastViewManager.getFastViews(null) : new ArrayList();
        IViewReference[] iViewReferenceArray = new IViewReference[arrayList.size() + list.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < list.size()) {
            iViewReferenceArray[n] = (IViewReference)list.get(n2);
            ++n;
            ++n2;
        }
        n2 = 0;
        while (n2 < arrayList.size()) {
            ViewPane viewPane = (ViewPane)arrayList.get(n2);
            iViewReferenceArray[n] = viewPane.getViewReference();
            ++n;
            ++n2;
        }
        return iViewReferenceArray;
    }

    protected void hideEditorArea() {
        if (!this.isEditorAreaVisible()) {
            return;
        }
        if (Perspective.useNewMinMax(this)) {
            boolean bl;
            if (this.getPresentation().getMaximizedStack() instanceof EditorStack) {
                this.getPresentation().getMaximizedStack().setState(2);
            }
            boolean bl2 = bl = this.editorAreaState == 0;
            if (!bl) {
                this.hideEditorAreaLocal();
            } else {
                this.setEditorAreaTrimVisibility(false);
            }
        } else {
            this.hideEditorAreaLocal();
        }
        this.editorHidden = true;
    }

    protected void hideEditorAreaLocal() {
        if (this.editorHolder != null) {
            return;
        }
        this.editorHolder = new PartPlaceholder(this.editorArea.getID());
        this.presentation.getLayout().replace(this.editorArea, this.editorHolder);
    }

    private void hideFastView(IViewReference iViewReference, int n) {
        this.setFastViewIconSelection(iViewReference, false);
        if (iViewReference == this.activeFastView) {
            this.saveFastViewWidthRatio();
            this.fastViewPane.hideView();
        }
    }

    void hideFastViewSash() {
        this.fastViewPane.hideFastViewSash();
    }

    public boolean hideView(IViewReference iViewReference) {
        ViewPane viewPane = this.getPane(iViewReference);
        if (this.isFastView(iViewReference)) {
            if (viewPane != null) {
                viewPane.setFast(false);
            }
            if (this.activeFastView == iViewReference) {
                this.setActiveFastView(null);
            }
            if (viewPane != null && viewPane.getControl() != null) {
                viewPane.getControl().setEnabled(true);
            }
            if (this.fastViewManager != null) {
                this.fastViewManager.removeViewReference(iViewReference, false, true);
            }
        } else {
            this.presentation.removePart(viewPane);
        }
        this.getViewFactory().releaseView(iViewReference);
        return true;
    }

    protected boolean isEditorAreaVisible() {
        return !this.editorHidden;
    }

    public boolean isFastView(IViewReference iViewReference) {
        if (this.fastViewManager == null) {
            return false;
        }
        return this.fastViewManager.isFastView(iViewReference);
    }

    public ViewLayoutRec getViewLayoutRec(IViewReference iViewReference, boolean bl) {
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(ViewFactory.getKey(iViewReference), bl);
        if (viewLayoutRec == null && !bl) {
            viewLayoutRec = this.getViewLayoutRec(iViewReference.getId(), false);
        }
        return viewLayoutRec;
    }

    private ViewLayoutRec getViewLayoutRec(String string, boolean bl) {
        ViewLayoutRec viewLayoutRec = (ViewLayoutRec)this.mapIDtoViewLayoutRec.get(string);
        if (viewLayoutRec == null && bl) {
            viewLayoutRec = new ViewLayoutRec();
            this.mapIDtoViewLayoutRec.put(string, viewLayoutRec);
        }
        return viewLayoutRec;
    }

    public boolean isFixedLayout() {
        return this.fixed;
    }

    public boolean isStandaloneView(IViewReference iViewReference) {
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(iViewReference, false);
        return viewLayoutRec != null && viewLayoutRec.isStandalone;
    }

    public boolean getShowTitleView(IViewReference iViewReference) {
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(iViewReference, false);
        return viewLayoutRec != null && viewLayoutRec.showTitle;
    }

    private void loadCustomPersp(PerspectiveDescriptor perspectiveDescriptor) {
        PerspectiveRegistry perspectiveRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        try {
            IMemento iMemento = perspectiveRegistry.getCustomPersp(perspectiveDescriptor.getId());
            MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.Perspective_unableToRestorePerspective, (Object)perspectiveDescriptor.getLabel()), null);
            multiStatus.merge(this.restoreState(iMemento));
            multiStatus.merge(this.restoreState());
            if (multiStatus.getSeverity() != 0) {
                this.unableToOpenPerspective(perspectiveDescriptor, (IStatus)multiStatus);
            }
        }
        catch (IOException iOException) {
            this.unableToOpenPerspective(perspectiveDescriptor, null);
        }
        catch (WorkbenchException workbenchException) {
            this.unableToOpenPerspective(perspectiveDescriptor, workbenchException.getStatus());
        }
    }

    private void unableToOpenPerspective(PerspectiveDescriptor perspectiveDescriptor, IStatus iStatus) {
        PerspectiveRegistry perspectiveRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        perspectiveRegistry.deletePerspective(perspectiveDescriptor);
        perspectiveDescriptor.deleteCustomDefinition();
        String string = WorkbenchMessages.Perspective_problemRestoringTitle;
        String string2 = WorkbenchMessages.Perspective_errorReadingState;
        if (iStatus == null) {
            MessageDialog.openError(null, (String)string, (String)string2);
        } else {
            ErrorDialog.openError(null, (String)string, (String)string2, (IStatus)iStatus);
        }
    }

    protected void loadPredefinedPersp(PerspectiveDescriptor perspectiveDescriptor) throws WorkbenchException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        IPerspectiveFactory iPerspectiveFactory = null;
        try {
            iPerspectiveFactory = perspectiveDescriptor.createFactory();
        }
        catch (CoreException coreException) {
            throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.Perspective_unableToLoad, (Object)perspectiveDescriptor.getId()));
        }
        if (iPerspectiveFactory == null) {
            throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.Perspective_unableToLoad, (Object)perspectiveDescriptor.getId()));
        }
        ViewSashContainer viewSashContainer = new ViewSashContainer(this.page, this.getClientComposite());
        this.layout = new PageLayout(viewSashContainer, this.getViewFactory(), this.editorArea, this.descriptor);
        this.layout.setFixed(this.descriptor.getFixed());
        IPlaceholderFolderLayout iPlaceholderFolderLayout = null;
        IPlaceholderFolderLayout iPlaceholderFolderLayout2 = null;
        IPlaceholderFolderLayout iPlaceholderFolderLayout3 = null;
        IPlaceholderFolderLayout iPlaceholderFolderLayout4 = null;
        IStickyViewDescriptor[] iStickyViewDescriptorArray = WorkbenchPlugin.getDefault().getViewRegistry().getStickyViews();
        int n = 0;
        while (n < iStickyViewDescriptorArray.length) {
            object4 = iStickyViewDescriptorArray[n];
            object3 = object4.getId();
            switch (object4.getLocation()) {
                case 2: {
                    if (iPlaceholderFolderLayout == null) {
                        iPlaceholderFolderLayout = this.layout.createPlaceholderFolder("stickyFolderRight", 2, 0.75f, "org.eclipse.ui.editorss");
                    }
                    iPlaceholderFolderLayout.addPlaceholder((String)object3);
                    break;
                }
                case 1: {
                    if (iPlaceholderFolderLayout2 == null) {
                        iPlaceholderFolderLayout2 = this.layout.createPlaceholderFolder("stickyFolderLeft", 1, 0.25f, "org.eclipse.ui.editorss");
                    }
                    iPlaceholderFolderLayout2.addPlaceholder((String)object3);
                    break;
                }
                case 3: {
                    if (iPlaceholderFolderLayout3 == null) {
                        iPlaceholderFolderLayout3 = this.layout.createPlaceholderFolder("stickyFolderTop", 3, 0.25f, "org.eclipse.ui.editorss");
                    }
                    iPlaceholderFolderLayout3.addPlaceholder((String)object3);
                    break;
                }
                case 4: {
                    if (iPlaceholderFolderLayout4 == null) {
                        iPlaceholderFolderLayout4 = this.layout.createPlaceholderFolder("stickyFolderBottom", 4, 0.75f, "org.eclipse.ui.editorss");
                    }
                    iPlaceholderFolderLayout4.addPlaceholder((String)object3);
                }
            }
            object2 = this.layout.getViewLayout((String)object3);
            object2.setCloseable(object4.isCloseable());
            object2.setMoveable(object4.isMoveable());
            ++n;
        }
        iPerspectiveFactory.createInitialLayout(this.layout);
        PerspectiveExtensionReader perspectiveExtensionReader = new PerspectiveExtensionReader();
        perspectiveExtensionReader.extendLayout(this.page.getExtensionTracker(), this.descriptor.getId(), this.layout);
        this.mapIDtoViewLayoutRec.putAll(this.layout.getIDtoViewLayoutRecMap());
        object4 = new ArrayList();
        this.createInitialActionSets((List)object4, this.layout.getActionSets());
        object3 = null;
        if (this.page != null) {
            object3 = (IContextService)this.page.getWorkbenchWindow().getService(IContextService.class);
        }
        try {
            if (object3 != null) {
                object3.deferUpdates(true);
            }
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (IActionSetDescriptor)object2.next();
                this.addAlwaysOn((IActionSetDescriptor)object);
            }
        }
        finally {
            if (object3 != null) {
                object3.deferUpdates(false);
            }
        }
        this.newWizardShortcuts = this.layout.getNewWizardShortcuts();
        this.showViewShortcuts = this.layout.getShowViewShortcuts();
        this.perspectiveShortcuts = this.layout.getPerspectiveShortcuts();
        this.showInPartIds = this.layout.getShowInPartIds();
        this.hideMenuIDs = this.layout.getHiddenMenuItems();
        this.hideToolBarIDs = this.layout.getHiddenToolBarItems();
        if (this.fastViewManager != null) {
            object2 = this.layout.getFastViews();
            object = ((ArrayList)object2).iterator();
            while (object.hasNext()) {
                IViewReference iViewReference = (IViewReference)object.next();
                this.fastViewManager.addViewReference(FastViewBar.FASTVIEWBAR_ID, -1, iViewReference, !object.hasNext());
            }
        }
        this.fixed = this.layout.isFixed();
        this.presentation = new PerspectiveHelper(this.page, viewSashContainer, this);
        if (!this.layout.isEditorAreaVisible()) {
            this.hideEditorArea();
        }
    }

    private void removeAlwaysOn(IActionSetDescriptor iActionSetDescriptor) {
        if (iActionSetDescriptor == null) {
            return;
        }
        if (!this.alwaysOnActionSets.contains(iActionSetDescriptor)) {
            return;
        }
        this.alwaysOnActionSets.remove(iActionSetDescriptor);
        if (this.page != null) {
            this.page.perspectiveActionSetChanged(this, iActionSetDescriptor, 3);
        }
    }

    protected void addAlwaysOff(IActionSetDescriptor iActionSetDescriptor) {
        if (iActionSetDescriptor == null) {
            return;
        }
        if (this.alwaysOffActionSets.contains(iActionSetDescriptor)) {
            return;
        }
        this.alwaysOffActionSets.add(iActionSetDescriptor);
        if (this.page != null) {
            this.page.perspectiveActionSetChanged(this, iActionSetDescriptor, 0);
        }
        this.removeAlwaysOn(iActionSetDescriptor);
    }

    protected void addAlwaysOn(IActionSetDescriptor iActionSetDescriptor) {
        if (iActionSetDescriptor == null) {
            return;
        }
        if (this.alwaysOnActionSets.contains(iActionSetDescriptor)) {
            return;
        }
        this.alwaysOnActionSets.add(iActionSetDescriptor);
        if (this.page != null) {
            this.page.perspectiveActionSetChanged(this, iActionSetDescriptor, 2);
        }
        this.removeAlwaysOff(iActionSetDescriptor);
    }

    private void removeAlwaysOff(IActionSetDescriptor iActionSetDescriptor) {
        if (iActionSetDescriptor == null) {
            return;
        }
        if (!this.alwaysOffActionSets.contains(iActionSetDescriptor)) {
            return;
        }
        this.alwaysOffActionSets.remove(iActionSetDescriptor);
        if (this.page != null) {
            this.page.perspectiveActionSetChanged(this, iActionSetDescriptor, 1);
        }
    }

    protected void onActivate() {
        Object object;
        boolean bl;
        int n;
        boolean bl2;
        boolean bl3 = Perspective.useNewMinMax(this);
        boolean bl4 = bl2 = this.shouldHideEditorsOnActivate || this.editorHidden && this.editorHolder == null;
        if (this.editorArea.getControl() != null) {
            boolean bl5 = this.isEditorAreaVisible();
            n = this.editorAreaState == 0 ? 1 : 0;
            bl = this.getPresentation().getLayout().childObscuredByZoom(this.editorArea);
            if (bl3 && !bl2 && !bl) {
                this.refreshEditorAreaVisibility();
            }
            this.editorArea.setVisible(bl5 && n == 0 && !bl);
        }
        if (this.fastViewManager != null) {
            List list = this.fastViewManager.getFastViews(null);
            n = 0;
            while (n < list.size()) {
                ViewPane viewPane = this.getPane((IViewReference)list.get(n));
                if (viewPane != null) {
                    object = viewPane.getControl();
                    if (object == null) {
                        viewPane.createControl(this.getClientComposite());
                        object = viewPane.getControl();
                    }
                    object.setEnabled(false);
                }
                ++n;
            }
        }
        this.setAllPinsVisible(true);
        this.presentation.activate(this.getClientComposite());
        IMenuManager iMenuManager = this.page.getActionBars().getMenuManager();
        this.allowUpdates(iMenuManager);
        iMenuManager.update(false);
        if (bl3) {
            this.fastViewManager.activate();
            if (this.layout != null) {
                IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
                bl = iPreferenceStore.getBoolean("ENABLE_ANIMATIONS");
                iPreferenceStore.setValue("ENABLE_ANIMATIONS", false);
                object = this.layout.getMinimizedStacks();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    ViewStack viewStack = (ViewStack)iterator.next();
                    viewStack.setMinimized(true);
                }
                iPreferenceStore.setValue("ENABLE_ANIMATIONS", bl);
                object.clear();
                this.layout = null;
            }
        } else {
            ITrimManager iTrimManager;
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.page.getWorkbenchWindow();
            if (workbenchWindow != null && (iTrimManager = workbenchWindow.getTrimManager()) != null && (object = iTrimManager.getTrim(FastViewBar.FASTVIEWBAR_ID)) instanceof FastViewBar) {
                ((FastViewBar)object).update(true);
            }
        }
        if (!Perspective.useNewMinMax(this) && this.fastViewManager != null) {
            boolean bl6 = this.fastViewManager.restoreAllTrimStacks();
            this.setEditorAreaTrimVisibility(false);
            if (bl6 && this.presentation.getMaximizedStack() instanceof ViewStack) {
                ViewStack viewStack = (ViewStack)this.presentation.getMaximizedStack();
                viewStack.setPresentationState(2);
                this.presentation.setMaximizedStack(null);
            }
        }
        if (bl2) {
            this.hideEditorArea();
            this.shouldHideEditorsOnActivate = false;
            if (bl3) {
                this.setEditorAreaTrimVisibility(this.editorAreaState == 0);
            }
        }
        this.fixOrphan();
        if (this.page.window != null && this.page.window.getTrimManager() != null) {
            this.page.window.getTrimManager().forceLayout();
        }
    }

    private void allowUpdates(IMenuManager iMenuManager) {
        iMenuManager.markDirty();
        IContributionItem[] iContributionItemArray = iMenuManager.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            IContributionItem iContributionItem;
            if (iContributionItemArray[n] instanceof IMenuManager) {
                this.allowUpdates((IMenuManager)iContributionItemArray[n]);
            } else if (iContributionItemArray[n] instanceof SubContributionItem && (iContributionItem = ((SubContributionItem)iContributionItemArray[n]).getInnerItem()) instanceof IMenuManager) {
                this.allowUpdates((IMenuManager)iContributionItem);
            }
            ++n;
        }
    }

    private void fixOrphan() {
        PerspectiveRegistry perspectiveRegistry = (PerspectiveRegistry)PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor iPerspectiveDescriptor = perspectiveRegistry.findPerspectiveWithId(this.descriptor.getId());
        if (iPerspectiveDescriptor == null) {
            String string = "Perspective " + this.descriptor.getLabel() + " has been made into a local copy";
            IStatus iStatus = StatusUtil.newStatus(2, string, null);
            StatusManager.getManager().handle(iStatus, 1);
            String string2 = NLS.bind((String)WorkbenchMessages.Perspective_localCopyLabel, (Object)this.descriptor.getLabel());
            while (perspectiveRegistry.findPerspectiveWithId(string2) != null) {
                string2 = NLS.bind((String)WorkbenchMessages.Perspective_localCopyLabel, (Object)string2);
            }
            PerspectiveDescriptor perspectiveDescriptor = perspectiveRegistry.createPerspective(string2, this.descriptor);
            this.page.savePerspectiveAs(perspectiveDescriptor);
        }
    }

    protected void onDeactivate() {
        this.setActiveFastView(null);
        this.presentation.deactivate();
        this.setAllPinsVisible(false);
        if (this.fastViewManager != null) {
            List list = this.fastViewManager.getFastViews(null);
            int n = 0;
            while (n < list.size()) {
                Control control;
                ViewPane viewPane = this.getPane((IViewReference)list.get(n));
                if (viewPane != null && (control = viewPane.getControl()) != null) {
                    control.setEnabled(true);
                }
                ++n;
            }
            this.fastViewManager.deActivate();
        }
        this.setEditorAreaTrimVisibility(false);
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (this.activeFastView != null && this.activeFastView.getPart(false) != iWorkbenchPart) {
            this.setActiveFastView(null);
        }
    }

    public void performedShowIn(String string) {
        this.showInTimes.put(string, new Long(System.currentTimeMillis()));
    }

    public void removeFastView(IViewReference iViewReference) {
        this.removeFastView(iViewReference, true);
    }

    public void removeFastView(IViewReference iViewReference, boolean bl) {
        ViewPane viewPane = this.getPane(iViewReference);
        if (this.activeFastView == iViewReference) {
            this.setActiveFastView(null);
        }
        viewPane.setFast(false);
        Control control = viewPane.getControl();
        if (control != null) {
            control.setEnabled(true);
        }
        if (bl) {
            this.presentation.addPart(viewPane);
        }
    }

    public IStatus restoreState(IMemento iMemento) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsRestoringPerspective, null);
        this.descriptor = new PerspectiveDescriptor(null, null, null);
        multiStatus.add(this.descriptor.restoreState(iMemento));
        PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)WorkbenchPlugin.getDefault().getPerspectiveRegistry().findPerspectiveWithId(this.descriptor.getId());
        if (perspectiveDescriptor != null) {
            this.descriptor = perspectiveDescriptor;
        }
        this.memento = iMemento;
        IMemento[] iMementoArray = iMemento.getChildren("view");
        multiStatus.merge(this.createReferences(iMementoArray));
        iMemento = iMemento.getChild("fastViews");
        if (iMemento != null) {
            iMementoArray = iMemento.getChildren("view");
            multiStatus.merge(this.createReferences(iMementoArray));
        }
        return multiStatus;
    }

    IStatus createReferences(IMemento[] iMementoArray) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsRestoringViews, null);
        int n = 0;
        while (n < iMementoArray.length) {
            IMemento iMemento = iMementoArray[n];
            String string = iMemento.getString("id");
            if (!string.equals("org.eclipse.ui.internal.introview")) {
                String string2 = ViewFactory.extractSecondaryId(string);
                if (string2 != null) {
                    string = ViewFactory.extractPrimaryId(string);
                }
                try {
                    if (!"true".equals(iMemento.getString("removed"))) {
                        this.viewFactory.createView(string, string2);
                    }
                }
                catch (PartInitException partInitException) {
                    iMemento.putString("removed", "true");
                    multiStatus.add(StatusUtil.newStatus(4, partInitException.getMessage() == null ? "" : partInitException.getMessage(), (Throwable)((Object)partInitException)));
                }
            }
            ++n;
        }
        return multiStatus;
    }

    public IStatus restoreState() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Rectangle rectangle;
        if (this.memento == null) {
            return Status.OK_STATUS;
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsRestoringPerspective, null);
        IMemento iMemento = this.memento;
        this.memento = null;
        IMemento iMemento2 = iMemento.getChild("window");
        if (iMemento2 != null) {
            rectangle = new Rectangle(0, 0, 0, 0);
            rectangle.x = iMemento2.getInteger("x");
            rectangle.y = iMemento2.getInteger("y");
            rectangle.height = iMemento2.getInteger("height");
            rectangle.width = iMemento2.getInteger("width");
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    if (Perspective.this.page.getWorkbenchWindow().getPages().length == 0) {
                        Perspective.this.page.getWorkbenchWindow().getShell().setBounds(rectangle);
                    }
                }
            });
        }
        rectangle = new PerspectiveHelper[1];
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable((PerspectiveHelper[])rectangle){
            private final /* synthetic */ PerspectiveHelper[] val$presArray;
            {
                this.val$presArray = perspectiveHelperArray;
            }

            @Override
            public void runWithException() throws Throwable {
                ViewSashContainer viewSashContainer = new ViewSashContainer(Perspective.this.page, Perspective.this.getClientComposite());
                this.val$presArray[0] = new PerspectiveHelper(Perspective.this.page, viewSashContainer, Perspective.this);
            }
        });
        Rectangle rectangle2 = rectangle[0];
        multiStatus.merge(rectangle2.restoreState(iMemento.getChild("layout")));
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable((PerspectiveHelper)rectangle2){
            private final /* synthetic */ PerspectiveHelper val$pres;
            {
                this.val$pres = perspectiveHelper;
            }

            @Override
            public void runWithException() throws Throwable {
                this.val$pres.replacePlaceholderWithPart(Perspective.this.editorArea);
            }
        });
        IMemento[] iMementoArray = iMemento.getChildren("view");
        int n = 0;
        while (n < iMementoArray.length) {
            IMemento iMemento3 = iMementoArray[n];
            object7 = iMemento3.getString("id");
            object6 = ViewFactory.extractSecondaryId((String)object7);
            if (object6 != null) {
                object7 = ViewFactory.extractPrimaryId((String)object7);
            }
            if (!((String)object7).equals("org.eclipse.ui.internal.introview")) {
                object5 = this.viewFactory.getView((String)object7, (String)object6);
                object4 = (WorkbenchPartReference)object5;
                if (object4 == null) {
                    object3 = ViewFactory.getKey(object7, (String)object6);
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.Perspective_couldNotFind, (Object)object3), null));
                } else {
                    boolean bl = rectangle2.willPartBeVisible(((WorkbenchPartReference)object4).getId(), (String)object6);
                    if (bl) {
                        IViewPart iViewPart = (IViewPart)((WorkbenchPartReference)object4).getPart(true);
                        if (iViewPart != null) {
                            ViewSite viewSite = (ViewSite)iViewPart.getSite();
                            object2 = (ViewPane)viewSite.getPane();
                            rectangle2.replacePlaceholderWithPart((LayoutPart)object2);
                        }
                    } else {
                        rectangle2.replacePlaceholderWithPart(((WorkbenchPartReference)object4).getPane());
                    }
                }
            }
            ++n;
        }
        if (this.fastViewManager != null) {
            this.fastViewManager.restoreState(iMemento, multiStatus);
        }
        IMemento[] iMementoArray2 = iMemento.getChildren("viewLayoutRec");
        int n2 = 0;
        while (n2 < iMementoArray2.length) {
            object7 = iMementoArray2[n2];
            object6 = object7.getString("id");
            if (object6 != null) {
                object5 = this.getViewLayoutRec((String)object6, true);
                if ("false".equals(object7.getString("closeable"))) {
                    ((ViewLayoutRec)object5).isCloseable = false;
                }
                if ("false".equals(object7.getString("moveable"))) {
                    ((ViewLayoutRec)object5).isMoveable = false;
                }
                if ("true".equals(object7.getString("standalone"))) {
                    ((ViewLayoutRec)object5).isStandalone = true;
                    ((ViewLayoutRec)object5).showTitle = !"false".equals(object7.getString("showTitle"));
                }
            }
            ++n2;
        }
        IContextService iContextService = (IContextService)this.page.getWorkbenchWindow().getService(IContextService.class);
        try {
            if (iContextService != null) {
                iContextService.deferUpdates(true);
            }
            object7 = new HashSet<Object>();
            object6 = iMemento.getChildren("alwaysOnActionSet");
            int n3 = 0;
            while (n3 < ((IMemento[])object6).length) {
                object4 = object6[n3].getString("id");
                object3 = WorkbenchPlugin.getDefault().getActionSetRegistry().findActionSet((String)object4);
                if (object3 != null) {
                    StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable((IActionSetDescriptor)object3){
                        private final /* synthetic */ IActionSetDescriptor val$d;
                        {
                            this.val$d = iActionSetDescriptor;
                        }

                        @Override
                        public void runWithException() throws Throwable {
                            Perspective.this.addAlwaysOn(this.val$d);
                        }
                    });
                    ((HashSet)object7).add(object4);
                }
                ++n3;
            }
            object6 = iMemento.getChildren("alwaysOffActionSet");
            n3 = 0;
            while (n3 < ((IMemento[])object6).length) {
                object4 = object6[n3].getString("id");
                object3 = WorkbenchPlugin.getDefault().getActionSetRegistry().findActionSet((String)object4);
                if (object3 != null) {
                    StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable((IActionSetDescriptor)object3){
                        private final /* synthetic */ IActionSetDescriptor val$d;
                        {
                            this.val$d = iActionSetDescriptor;
                        }

                        @Override
                        public void runWithException() throws Throwable {
                            Perspective.this.addAlwaysOff(this.val$d);
                        }
                    });
                    ((HashSet)object7).add(object4);
                }
                ++n3;
            }
            object6 = iMemento.getChildren("show_view_action");
            this.showViewShortcuts = new ArrayList(((IMemento[])object6).length);
            n3 = 0;
            while (n3 < ((IMemento[])object6).length) {
                object4 = object6[n3].getString("id");
                this.showViewShortcuts.add(object4);
                ++n3;
            }
            object6 = iMemento.getChildren("show_in_time");
            n3 = 0;
            while (n3 < ((IMemento[])object6).length) {
                object4 = object6[n3].getString("id");
                object3 = object6[n3].getString("time");
                if (object4 != null && object3 != null) {
                    try {
                        long l = Long.parseLong((String)object3);
                        this.showInTimes.put(object4, new Long(l));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++n3;
            }
            this.showInPartIds = this.getShowInIdsFromRegistry();
            object6 = iMemento.getChildren("new_wizard_action");
            this.newWizardShortcuts = new ArrayList(((IMemento[])object6).length);
            n3 = 0;
            while (n3 < ((IMemento[])object6).length) {
                object4 = object6[n3].getString("id");
                this.newWizardShortcuts.add(object4);
                ++n3;
            }
            object6 = iMemento.getChildren("perspective_action");
            this.perspectiveShortcuts = new ArrayList(((IMemento[])object6).length);
            n3 = 0;
            while (n3 < ((IMemento[])object6).length) {
                object4 = object6[n3].getString("id");
                this.perspectiveShortcuts.add(object4);
                ++n3;
            }
            object6 = iMemento.getChildren("hide_menu_item_id");
            this.hideMenuIDs = new HashSet();
            n3 = 0;
            while (n3 < ((IMemento[])object6).length) {
                object4 = object6[n3].getString("id");
                this.hideMenuIDs.add(object4);
                ++n3;
            }
            object6 = iMemento.getChildren("hide_toolbar_item_id");
            this.hideToolBarIDs = new HashSet();
            n3 = 0;
            while (n3 < ((IMemento[])object6).length) {
                object4 = object6[n3].getString("id");
                this.hideToolBarIDs.add(object4);
                ++n3;
            }
            ArrayList arrayList = this.getPerspectiveExtensionActionSets();
            int n4 = 0;
            while (n4 < arrayList.size()) {
                IActionSetDescriptor iActionSetDescriptor;
                object3 = (String)arrayList.get(n4);
                if (!((HashSet)object7).contains(object3) && (iActionSetDescriptor = WorkbenchPlugin.getDefault().getActionSetRegistry().findActionSet((String)object3)) != null) {
                    StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                        @Override
                        public void runWithException() throws Throwable {
                            Perspective.this.addAlwaysOn(iActionSetDescriptor);
                        }
                    });
                    ((HashSet)object7).add(iActionSetDescriptor.getId());
                }
                ++n4;
            }
            object = WorkbenchPlugin.getDefault().getActionSetRegistry();
            object3 = ((ActionSetRegistry)object).getActionSets();
            int n5 = ((IActionSetDescriptor[])object3).length;
            int n6 = 0;
            while (n6 < n5) {
                object2 = object3[n6];
                if (!((HashSet)object7).contains(object2.getId()) && object2.isInitiallyVisible()) {
                    this.addActionSet((IActionSetDescriptor)object2);
                }
                ++n6;
            }
        }
        catch (Throwable throwable) {
            if (iContextService != null) {
                StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(iContextService){
                    private final /* synthetic */ IContextService val$service;
                    {
                        this.val$service = iContextService;
                    }

                    @Override
                    public void runWithException() throws Throwable {
                        this.val$service.deferUpdates(false);
                    }
                });
            }
            throw throwable;
        }
        if (iContextService != null) {
            StartupThreading.runWithoutExceptions(new /* invalid duplicate definition of identical inner class */);
        }
        this.presentation = rectangle2;
        object7 = iMemento.getInteger("editorAreaVisible");
        this.shouldHideEditorsOnActivate = object7 != null && (Integer)object7 == 0;
        object6 = PrefUtil.getAPIPreferenceStore();
        boolean bl = object6.getBoolean("ENABLE_MIN_MAX");
        if (bl && (object = iMemento.getInteger("editorAreaTrimState")) != null) {
            this.editorAreaState = (Integer)object & 3;
            this.editorAreaRestoreOnUnzoom = ((Integer)object & 4) != 0;
        }
        this.fixed = (object = iMemento.getInteger("fixed")) != null && (Integer)object == 1;
        return multiStatus;
    }

    public IViewReference restoreFastView(IMemento iMemento, MultiStatus multiStatus) {
        Object object;
        IViewReference iViewReference;
        String string = iMemento.getString("id");
        String string2 = ViewFactory.extractSecondaryId(string);
        if (string2 != null) {
            string = ViewFactory.extractPrimaryId(string);
        }
        if ((iViewReference = this.getViewFactory().getView(string, string2)) == null) {
            String string3 = ViewFactory.getKey(string, string2);
            WorkbenchPlugin.log("Could not create view: '" + string3 + "'.");
            multiStatus.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.Perspective_couldNotFind, (Object)string3), null));
            return null;
        }
        Float f = iMemento.getFloat("ratio");
        if (f == null) {
            object = iMemento.getInteger("width");
            f = object == null ? new Float(0.3f) : new Float((float)((Integer)object).intValue() / (float)this.getClientComposite().getSize().x);
        }
        object = this.getViewLayoutRec(iViewReference, true);
        ((ViewLayoutRec)object).fastViewWidthRatio = f.floatValue();
        return iViewReference;
    }

    protected ArrayList getPerspectiveExtensionActionSets() {
        PerspectiveExtensionReader perspectiveExtensionReader = new PerspectiveExtensionReader();
        perspectiveExtensionReader.setIncludeOnlyTags(new String[]{"actionSet"});
        PageLayout pageLayout = new PageLayout();
        perspectiveExtensionReader.extendLayout(null, this.descriptor.getOriginalId(), pageLayout);
        return pageLayout.getActionSets();
    }

    protected ArrayList getShowInIdsFromRegistry() {
        PerspectiveExtensionReader perspectiveExtensionReader = new PerspectiveExtensionReader();
        perspectiveExtensionReader.setIncludeOnlyTags(new String[]{"showInPart"});
        PageLayout pageLayout = new PageLayout();
        perspectiveExtensionReader.extendLayout(null, this.descriptor.getOriginalId(), pageLayout);
        return pageLayout.getShowInPartIds();
    }

    public void saveDesc() {
        this.saveDescAs(this.descriptor);
    }

    public void saveDescAs(IPerspectiveDescriptor iPerspectiveDescriptor) {
        PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)iPerspectiveDescriptor;
        PerspectiveRegistry perspectiveRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        XMLMemento xMLMemento = XMLMemento.createWriteRoot("perspective");
        IStatus iStatus = this.saveState(xMLMemento, perspectiveDescriptor, false);
        if (iStatus.getSeverity() == 4) {
            ErrorDialog.openError(null, (String)WorkbenchMessages.Perspective_problemSavingTitle, (String)WorkbenchMessages.Perspective_problemSavingMessage, (IStatus)iStatus);
            return;
        }
        try {
            perspectiveRegistry.saveCustomPersp(perspectiveDescriptor, xMLMemento);
            this.descriptor = perspectiveDescriptor;
        }
        catch (IOException iOException) {
            perspectiveRegistry.deletePerspective(perspectiveDescriptor);
            MessageDialog.openError(null, (String)WorkbenchMessages.Perspective_problemSavingTitle, (String)WorkbenchMessages.Perspective_problemSavingMessage);
        }
    }

    public IStatus saveState(IMemento iMemento) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsSavingPerspective, null);
        multiStatus.merge(this.saveState(iMemento, this.descriptor, true));
        return multiStatus;
    }

    private IStatus saveState(IMemento iMemento, PerspectiveDescriptor perspectiveDescriptor, boolean bl) {
        IMemento iMemento2;
        Object object;
        Object object22;
        Object object3;
        Object object4;
        ArrayList arrayList2;
        Object object5;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsSavingPerspective, null);
        if (this.memento != null) {
            iMemento.putMemento(this.memento);
            return multiStatus;
        }
        iMemento.putString("version", VERSION_STRING);
        multiStatus.add(perspectiveDescriptor.saveState(iMemento));
        if (!bl) {
            object5 = this.page.getWorkbenchWindow().getShell().getBounds();
            arrayList2 = iMemento.createChild("window");
            arrayList2.putInteger("x", ((Rectangle)object5).x);
            arrayList2.putInteger("y", ((Rectangle)object5).y);
            arrayList2.putInteger("height", ((Rectangle)object5).height);
            arrayList2.putInteger("width", ((Rectangle)object5).width);
        }
        for (ArrayList arrayList2 : this.alwaysOnActionSets) {
            object4 = iMemento.createChild("alwaysOnActionSet");
            object4.putString("id", arrayList2.getId());
        }
        for (ArrayList arrayList2 : this.alwaysOffActionSets) {
            object4 = iMemento.createChild("alwaysOffActionSet");
            object4.putString("id", arrayList2.getId());
        }
        for (ArrayList arrayList2 : this.showViewShortcuts) {
            object4 = iMemento.createChild("show_view_action");
            object4.putString("id", (String)((Object)arrayList2));
        }
        for (ArrayList arrayList2 : this.showInTimes.keySet()) {
            object4 = (Long)this.showInTimes.get(arrayList2);
            object3 = iMemento.createChild("show_in_time");
            object3.putString("id", (String)((Object)arrayList2));
            object3.putString("time", ((Long)object4).toString());
        }
        for (ArrayList arrayList2 : this.newWizardShortcuts) {
            object4 = iMemento.createChild("new_wizard_action");
            object4.putString("id", (String)((Object)arrayList2));
        }
        for (ArrayList arrayList2 : this.perspectiveShortcuts) {
            object4 = iMemento.createChild("perspective_action");
            object4.putString("id", (String)((Object)arrayList2));
        }
        for (ArrayList arrayList2 : this.hideMenuIDs) {
            object4 = iMemento.createChild("hide_menu_item_id");
            object4.putString("id", (String)((Object)arrayList2));
        }
        for (ArrayList arrayList2 : this.hideToolBarIDs) {
            object4 = iMemento.createChild("hide_toolbar_item_id");
            object4.putString("id", (String)((Object)arrayList2));
        }
        arrayList2 = new ArrayList(5);
        this.presentation.collectViewPanes(arrayList2);
        object5 = arrayList2.iterator();
        int n = 0;
        while (object5.hasNext()) {
            object3 = (ViewPane)object5.next();
            object22 = ((ViewPane)object3).getViewReference();
            object = this.page.getViewFactory().getViewRegistry().find(object22.getId());
            if (object == null || !object.isRestorable()) continue;
            iMemento2 = iMemento.createChild("view");
            iMemento2.putString("id", ViewFactory.getKey((IViewReference)object22));
        }
        if (this.fastViewManager != null) {
            this.fastViewManager.saveState(iMemento);
        }
        for (Object object22 : this.mapIDtoViewLayoutRec.keySet()) {
            object = (ViewLayoutRec)this.mapIDtoViewLayoutRec.get(object22);
            if (object == null || ((ViewLayoutRec)object).isCloseable && ((ViewLayoutRec)object).isMoveable && !((ViewLayoutRec)object).isStandalone) continue;
            iMemento2 = iMemento.createChild("viewLayoutRec");
            iMemento2.putString("id", (String)object22);
            if (!((ViewLayoutRec)object).isCloseable) {
                iMemento2.putString("closeable", "false");
            }
            if (!((ViewLayoutRec)object).isMoveable) {
                iMemento2.putString("moveable", "false");
            }
            if (!((ViewLayoutRec)object).isStandalone) continue;
            iMemento2.putString("standalone", "true");
            iMemento2.putString("showTitle", String.valueOf(((ViewLayoutRec)object).showTitle));
        }
        if (n > 0) {
            object3 = WorkbenchMessages.Perspective_multipleErrors;
            if (n == 1) {
                object3 = WorkbenchMessages.Perspective_oneError;
            }
            MessageDialog.openError(null, (String)WorkbenchMessages.Error, (String)object3);
        }
        object3 = iMemento.createChild("layout");
        multiStatus.add(this.presentation.saveState((IMemento)object3));
        if (this.isEditorAreaVisible()) {
            iMemento.putInteger("editorAreaVisible", 1);
        } else {
            iMemento.putInteger("editorAreaVisible", 0);
        }
        object22 = PrefUtil.getAPIPreferenceStore();
        boolean bl2 = object22.getBoolean("ENABLE_MIN_MAX");
        if (bl2) {
            int n2 = this.editorAreaState;
            iMemento.putInteger("editorAreaTrimState", n2 |= this.editorAreaRestoreOnUnzoom ? 4 : 0);
        }
        if (this.fixed) {
            iMemento.putInteger("fixed", 1);
        } else {
            iMemento.putInteger("fixed", 0);
        }
        return multiStatus;
    }

    public void turnOnActionSets(IActionSetDescriptor[] iActionSetDescriptorArray) {
        int n = 0;
        while (n < iActionSetDescriptorArray.length) {
            IActionSetDescriptor iActionSetDescriptor = iActionSetDescriptorArray[n];
            this.addAlwaysOn(iActionSetDescriptor);
            ++n;
        }
    }

    public void turnOffActionSets(IActionSetDescriptor[] iActionSetDescriptorArray) {
        int n = 0;
        while (n < iActionSetDescriptorArray.length) {
            IActionSetDescriptor iActionSetDescriptor = iActionSetDescriptorArray[n];
            this.turnOffActionSet(iActionSetDescriptor);
            ++n;
        }
    }

    public void turnOffActionSet(IActionSetDescriptor iActionSetDescriptor) {
        this.addAlwaysOff(iActionSetDescriptor);
    }

    public IViewReference getActiveFastView() {
        return this.activeFastView;
    }

    void setActiveFastView(IViewReference iViewReference, int n) {
        ViewPane viewPane;
        if (this.activeFastView == iViewReference) {
            return;
        }
        if (this.activeFastView != null && (viewPane = this.getPane(this.activeFastView)) != null) {
            if (viewPane.isZoomed()) {
                viewPane.setZoomed(false);
            }
            this.hideFastView(this.activeFastView, n);
        }
        this.activeFastView = iViewReference;
        try {
            if (this.activeFastView != null && !this.showFastView(this.activeFastView)) {
                this.activeFastView = null;
            }
        }
        catch (RuntimeException runtimeException) {
            this.activeFastView = null;
        }
    }

    void setActiveFastView(IViewReference iViewReference) {
        this.setActiveFastView(iViewReference, 5);
    }

    protected void setAllPinsVisible(boolean bl) {
        if (this.fastViewManager == null) {
            return;
        }
        Iterator iterator = this.fastViewManager.getFastViews(null).iterator();
        while (iterator.hasNext()) {
            ViewPane viewPane = this.getPane((IViewReference)iterator.next());
            if (viewPane == null) continue;
            viewPane.setFast(bl);
        }
    }

    private void setFastViewIconSelection(IViewReference iViewReference, boolean bl) {
        if (this.fastViewManager == null) {
            return;
        }
        this.fastViewManager.setFastViewIconSelection(iViewReference, bl);
    }

    public void setNewWizardActionIds(ArrayList arrayList) {
        this.newWizardShortcuts = arrayList;
    }

    public void setPerspectiveActionIds(ArrayList arrayList) {
        this.perspectiveShortcuts = arrayList;
    }

    public void setShowInPartIds(ArrayList arrayList) {
        this.showInPartIds = arrayList;
    }

    public void setShowViewActionIds(ArrayList arrayList) {
        this.showViewShortcuts = arrayList;
    }

    protected void showEditorArea() {
        if (this.isEditorAreaVisible()) {
            return;
        }
        this.editorHidden = false;
        if (Perspective.useNewMinMax(this)) {
            boolean bl;
            boolean bl2 = bl = this.editorAreaState == 0;
            if (!bl) {
                if (this.getPresentation().getMaximizedStack() != null) {
                    this.getPresentation().getMaximizedStack().setState(2);
                }
                this.showEditorAreaLocal();
            } else {
                this.setEditorAreaTrimVisibility(true);
            }
        } else {
            this.showEditorAreaLocal();
        }
    }

    protected void showEditorAreaLocal() {
        if (this.editorHolder == null || this.editorHidden) {
            return;
        }
        this.presentation.getLayout().replace(this.editorHolder, this.editorArea);
        this.editorHolder = null;
    }

    private EditorAreaTrimToolBar getEditorAreaTrim(boolean bl) {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.page.getWorkbenchWindow();
        ITrimManager iTrimManager = workbenchWindow.getTrimManager();
        if (iTrimManager == null) {
            return null;
        }
        EditorAreaTrimToolBar editorAreaTrimToolBar = (EditorAreaTrimToolBar)iTrimManager.getTrim("org.eclipse.ui.editorss");
        if (editorAreaTrimToolBar == null && bl) {
            int n = 131072;
            int n2 = ((TrimLayout)iTrimManager).getPreferredArea("org.eclipse.ui.editorss");
            if (n2 != -1) {
                n = n2;
            }
            IWindowTrim iWindowTrim = ((TrimLayout)iTrimManager).getPreferredLocation("org.eclipse.ui.editorss");
            editorAreaTrimToolBar = new EditorAreaTrimToolBar(workbenchWindow);
            editorAreaTrimToolBar.dock(n);
            iTrimManager.addTrim(n, editorAreaTrimToolBar, iWindowTrim);
        }
        return editorAreaTrimToolBar;
    }

    public void setEditorAreaState(int n) {
        if (n == this.editorAreaState) {
            return;
        }
        this.editorAreaState = n;
        if (n != 0) {
            this.editorAreaRestoreOnUnzoom = false;
        }
        this.refreshEditorAreaVisibility();
    }

    public int getEditorAreaState() {
        return this.editorAreaState;
    }

    public void refreshEditorAreaVisibility() {
        if (this.editorHidden) {
            this.hideEditorAreaLocal();
            this.setEditorAreaTrimVisibility(false);
            return;
        }
        EditorStack editorStack = ((EditorSashContainer)this.editorArea).getUpperRightEditorStack(null);
        if (editorStack == null) {
            return;
        }
        LayoutPart[] layoutPartArray = ((EditorSashContainer)this.editorArea).getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            if (layoutPartArray[n] instanceof EditorStack && layoutPartArray[n] != editorStack) {
                EditorStack editorStack2 = (EditorStack)layoutPartArray[n];
                editorStack2.setPresentationState(this.editorAreaState);
            }
            ++n;
        }
        editorStack.setStateLocal(this.editorAreaState);
        editorStack.showMinMax(!this.isFixedLayout());
        if (this.editorAreaState == 0) {
            this.hideEditorAreaLocal();
            this.setEditorAreaTrimVisibility(true);
        } else {
            this.setEditorAreaTrimVisibility(false);
            this.showEditorAreaLocal();
            if (this.editorAreaState == 1) {
                this.getPresentation().setMaximizedStack(editorStack);
            }
        }
    }

    protected EditorAreaTrimToolBar setEditorAreaTrimVisibility(boolean bl) {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.page.getWorkbenchWindow();
        ITrimManager iTrimManager = workbenchWindow.getTrimManager();
        if (iTrimManager == null) {
            return null;
        }
        EditorAreaTrimToolBar editorAreaTrimToolBar = this.getEditorAreaTrim(bl);
        if (editorAreaTrimToolBar == null) {
            return null;
        }
        iTrimManager.setTrimVisible(editorAreaTrimToolBar, bl);
        iTrimManager.forceLayout();
        return editorAreaTrimToolBar;
    }

    boolean showFastView(IViewReference iViewReference) {
        if (this.fastViewManager == null) {
            return false;
        }
        IWorkbenchPart iWorkbenchPart = iViewReference.getPart(true);
        if (iWorkbenchPart == null) {
            return false;
        }
        ViewPane viewPane = this.getPane(iViewReference);
        if (viewPane == null) {
            return false;
        }
        this.saveFastViewWidthRatio();
        if (iViewReference.getId().equals("org.eclipse.ui.internal.introview") && iWorkbenchPart instanceof ViewIntroAdapterPart) {
            ((ViewIntroAdapterPart)iWorkbenchPart).setStandby(true);
        }
        int n = this.fastViewManager.getViewSide(iViewReference);
        this.fastViewPane.showView(this.getClientComposite(), viewPane, n, this.getFastViewWidthRatio(iViewReference));
        this.setFastViewIconSelection(iViewReference, true);
        return true;
    }

    private void saveFastViewWidthRatio() {
        ViewPane viewPane = this.fastViewPane.getCurrentPane();
        if (viewPane != null) {
            ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(viewPane.getViewReference(), true);
            viewLayoutRec.fastViewWidthRatio = this.fastViewPane.getCurrentRatio();
        }
    }

    public IViewReference getViewReference(String string, String string2) {
        IViewReference iViewReference = this.page.findViewReference(string, string2);
        if (iViewReference == null) {
            ViewFactory viewFactory = this.getViewFactory();
            try {
                iViewReference = viewFactory.createView(string, string2);
            }
            catch (PartInitException partInitException) {
                IStatus iStatus = StatusUtil.newStatus(4, partInitException.getMessage() == null ? "" : partInitException.getMessage(), (Throwable)((Object)partInitException));
                StatusUtil.handleStatus(iStatus, "Failed to create view: id=" + string, 1);
            }
        }
        return iViewReference;
    }

    public IViewPart showView(String string, String string2) throws PartInitException {
        ViewFactory viewFactory = this.getViewFactory();
        IViewReference iViewReference = viewFactory.createView(string, string2);
        IViewPart iViewPart = (IViewPart)iViewReference.getPart(true);
        if (iViewPart == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.ViewFactory_couldNotCreate, (Object)iViewReference.getId()));
        }
        ViewSite viewSite = (ViewSite)iViewPart.getSite();
        ViewPane viewPane = (ViewPane)viewSite.getPane();
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        int n = iPreferenceStore.getInt("OPEN_VIEW_MODE");
        if (n == 1 && this.fastViewManager != null) {
            this.fastViewManager.addViewReference(FastViewBar.FASTVIEWBAR_ID, -1, iViewReference, true);
            this.setActiveFastView(iViewReference);
        } else if (n == 2 && this.presentation.canDetach()) {
            this.presentation.addDetachedPart(viewPane);
        } else if (Perspective.useNewMinMax(this)) {
            ContainerPlaceholder containerPlaceholder;
            Object object;
            Object object2;
            LayoutPart layoutPart = this.presentation.findPart(string, string2);
            Object object3 = null;
            if (layoutPart != null) {
                object2 = null;
                object = layoutPart.getContainer();
                if (object instanceof ContainerPlaceholder) {
                    object2 = ((ContainerPlaceholder)object).getID();
                } else if (object instanceof ViewStack) {
                    object2 = ((ViewStack)object).getID();
                } else if (object instanceof DetachedPlaceHolder) {
                    this.presentation.addPart(viewPane);
                    return iViewPart;
                }
                if (object2 != null && this.fastViewManager.getFastViews((String)object2).size() > 0) {
                    object3 = object2;
                }
            }
            if (object3 == null && this.presentation.getMaximizedStack() != null && layoutPart == null && (object2 = this.fastViewManager.getBottomRightTrimStack()) != null && (object = this.presentation.findPart((String)(object3 = ((TrimToolBarBase)object2).getId()), null)) instanceof ContainerPlaceholder && (containerPlaceholder = (ContainerPlaceholder)object).getRealContainer() instanceof ViewStack) {
                ViewStack viewStack = (ViewStack)containerPlaceholder.getRealContainer();
                String string3 = iViewReference.getId();
                if (iViewReference.getSecondaryId() != null) {
                    string3 = String.valueOf(string3) + ':' + iViewReference.getSecondaryId();
                }
                viewStack.add(new PartPlaceholder(string3));
            }
            if (object3 != null) {
                this.fastViewManager.addViewReference((String)object3, -1, iViewReference, true);
            } else {
                boolean bl = layoutPart != null && layoutPart.getContainer() == this.presentation.getMaximizedStack();
                this.presentation.addPart(viewPane);
                if (this.presentation.getMaximizedStack() != null && !bl && (layoutPart = this.presentation.findPart(string, string2)) != null && layoutPart.getContainer() instanceof ViewStack) {
                    object = (ViewStack)layoutPart.getContainer();
                    ((PartStack)object).setState(0);
                    this.fastViewManager.getViewStackTrimToolbar(((LayoutPart)object).getID()).setRestoreOnUnzoom(true);
                }
            }
        } else {
            this.presentation.addPart(viewPane);
        }
        if (viewPane != null && viewPane.getControl() != null) {
            viewPane.getControl().setEnabled(true);
        }
        return iViewPart;
    }

    public void toggleFastView(IViewReference iViewReference) {
        if (iViewReference == this.activeFastView) {
            this.setActiveFastView(null);
        } else {
            this.setActiveFastView(iViewReference);
        }
    }

    public IWorkbenchPartReference getOldPartRef() {
        return this.oldPartRef;
    }

    public void setOldPartRef(IWorkbenchPartReference iWorkbenchPartReference) {
        this.oldPartRef = iWorkbenchPartReference;
    }

    protected void addActionSet(IActionSetDescriptor iActionSetDescriptor) {
        IContextService iContextService = (IContextService)this.page.getWorkbenchWindow().getService(IContextService.class);
        try {
            iContextService.deferUpdates(true);
            int n = 0;
            while (n < this.alwaysOnActionSets.size()) {
                IActionSetDescriptor iActionSetDescriptor2 = (IActionSetDescriptor)this.alwaysOnActionSets.get(n);
                if (iActionSetDescriptor2.getId().equals(iActionSetDescriptor.getId())) {
                    this.removeAlwaysOn(iActionSetDescriptor2);
                    this.removeAlwaysOff(iActionSetDescriptor2);
                    break;
                }
                ++n;
            }
            this.addAlwaysOn(iActionSetDescriptor);
        }
        finally {
            iContextService.deferUpdates(false);
        }
    }

    void removeActionSet(String string) {
        IContextService iContextService = (IContextService)this.page.getWorkbenchWindow().getService(IContextService.class);
        try {
            IActionSetDescriptor iActionSetDescriptor;
            iContextService.deferUpdates(true);
            int n = 0;
            while (n < this.alwaysOnActionSets.size()) {
                iActionSetDescriptor = (IActionSetDescriptor)this.alwaysOnActionSets.get(n);
                if (iActionSetDescriptor.getId().equals(string)) {
                    this.removeAlwaysOn(iActionSetDescriptor);
                    break;
                }
                ++n;
            }
            n = 0;
            while (n < this.alwaysOffActionSets.size()) {
                iActionSetDescriptor = (IActionSetDescriptor)this.alwaysOffActionSets.get(n);
                if (iActionSetDescriptor.getId().equals(string)) {
                    this.removeAlwaysOff(iActionSetDescriptor);
                    break;
                }
                ++n;
            }
        }
        finally {
            iContextService.deferUpdates(false);
        }
    }

    void removeActionSet(IActionSetDescriptor iActionSetDescriptor) {
        this.removeAlwaysOn(iActionSetDescriptor);
        this.removeAlwaysOff(iActionSetDescriptor);
    }

    public void setFastViewState(IViewReference iViewReference, int n) {
        String string;
        if (this.fastViewManager != null && (string = this.fastViewManager.getIdForRef(iViewReference)) != null && string != FastViewBar.FASTVIEWBAR_ID) {
            if (n == 0) {
                return;
            }
            this.fastViewManager.restoreToPresentation(string);
            if (n == 1) {
                this.page.setState(iViewReference, n);
            }
            return;
        }
        if (this.fastViewPane.getCurrentPane() != null) {
            this.fastViewPane.setState(n);
        }
    }

    public void setFastViewState(int n) {
        this.fastViewPane.setState(n);
    }

    public int getFastViewState() {
        return this.fastViewPane.getState();
    }

    public boolean isCloseable(IViewReference iViewReference) {
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(iViewReference, false);
        if (viewLayoutRec != null) {
            return viewLayoutRec.isCloseable;
        }
        return true;
    }

    public boolean isMoveable(IViewReference iViewReference) {
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(iViewReference, false);
        if (viewLayoutRec != null) {
            return viewLayoutRec.isMoveable;
        }
        return true;
    }

    public void describeLayout(StringBuffer stringBuffer) {
        IViewReference[] iViewReferenceArray = this.getFastViews();
        if (iViewReferenceArray.length != 0) {
            stringBuffer.append("fastviews (");
            int n = 0;
            while (n < iViewReferenceArray.length) {
                IViewReference iViewReference = iViewReferenceArray[n];
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(iViewReference.getPartName());
                ++n;
            }
            stringBuffer.append("), ");
        }
        this.getPresentation().describeLayout(stringBuffer);
    }

    public void testInvariants() {
        this.getPresentation().getLayout().testInvariants();
    }

    public IActionSetDescriptor[] getAlwaysOnActionSets() {
        return this.alwaysOnActionSets.toArray(new IActionSetDescriptor[this.alwaysOnActionSets.size()]);
    }

    public IActionSetDescriptor[] getAlwaysOffActionSets() {
        return this.alwaysOffActionSets.toArray(new IActionSetDescriptor[this.alwaysOffActionSets.size()]);
    }

    FastViewPane getFastViewPane() {
        return this.fastViewPane;
    }

    public void restoreTrimPart(LayoutPart layoutPart) {
        if (this.fastViewManager == null) {
            return;
        }
        this.setActiveFastView(null);
        if (layoutPart instanceof ViewStack) {
            ViewStack viewStack = (ViewStack)layoutPart;
            this.fastViewManager.restoreToPresentation(viewStack.getID());
        }
        if (layoutPart == this.editorArea) {
            this.setEditorAreaState(2);
            this.editorAreaRestoreOnUnzoom = false;
        }
    }

    public int calcStackSide(Rectangle rectangle) {
        Rectangle rectangle2 = this.editorArea.getBounds();
        if (rectangle2.equals((Object)rectangle)) {
            return 128;
        }
        Point point = Geometry.centerPoint((Rectangle)rectangle);
        Point point2 = Geometry.centerPoint((Rectangle)rectangle2);
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        if (Math.abs(n) > Math.abs(n2)) {
            return n > 0 ? 16384 : 131072;
        }
        if (n2 > 0) {
            return n > 0 ? 16384 : 131072;
        }
        return 1024;
    }

    public void restoreZoomedParts() {
        if (this.fastViewManager == null) {
            return;
        }
        this.setActiveFastView(null);
        this.fastViewManager.restoreZoomedViewStacks();
        if (this.editorAreaRestoreOnUnzoom) {
            this.restoreTrimPart(this.editorArea);
        }
    }

    public FastViewManager getFastViewManager() {
        return this.fastViewManager;
    }

    public void setEditorAreaRestoreOnUnzoom(boolean bl) {
        this.editorAreaRestoreOnUnzoom = bl;
    }

    public boolean getEditorAreaRestoreOnUnzoom() {
        return this.editorAreaRestoreOnUnzoom;
    }

    public static boolean useNewMinMax(Perspective perspective) {
        if (perspective == null) {
            return false;
        }
        if (perspective.getFastViewManager() == null) {
            return false;
        }
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)perspective.page.getWorkbenchWindow();
        if (workbenchWindow == null) {
            return false;
        }
        WorkbenchWindowConfigurer workbenchWindowConfigurer = workbenchWindow.getWindowConfigurer();
        if (workbenchWindowConfigurer == null) {
            return false;
        }
        AbstractPresentationFactory abstractPresentationFactory = workbenchWindowConfigurer.getPresentationFactory();
        if (abstractPresentationFactory == null) {
            return false;
        }
        IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("ENABLE_MIN_MAX");
        return bl;
    }

    public Collection getHiddenMenuItems() {
        return this.hideMenuIDs;
    }

    public Collection getHiddenToolbarItems() {
        return this.hideToolBarIDs;
    }

    public void updateActionBars() {
        this.page.getActionBars().getMenuManager().updateAll(true);
        this.page.resetToolBarLayout();
    }
}

