/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;

public class PartTester {
    private PartTester() {
    }

    public static void testEditor(IEditorPart iEditorPart) throws Exception {
        PartTester.testWorkbenchPart(iEditorPart);
        Assert.isTrue((iEditorPart.getEditorSite() == iEditorPart.getSite() ? 1 : 0) != 0, (String)"The part's editor site must be the same as the part's site");
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        Assert.isNotNull((Object)iEditorInput, (String)"The editor input must be non-null");
        PartTester.testEditorInput(iEditorInput);
        iEditorPart.isDirty();
        iEditorPart.isSaveAsAllowed();
        iEditorPart.isSaveOnCloseNeeded();
    }

    public static void testEditorInput(IEditorInput iEditorInput) throws Exception {
        iEditorInput.getAdapter(Object.class);
        Assert.isNotNull((Object)iEditorInput.getName(), (String)"The editor input must have a non-null name");
        Assert.isNotNull((Object)iEditorInput.getToolTipText(), (String)"The editor input must have a non-null tool tip");
        IPersistableElement iPersistableElement = iEditorInput.getPersistable();
        if (iPersistableElement != null) {
            Assert.isNotNull((Object)iPersistableElement.getFactoryId(), (String)"The persistable element for the editor input must have a non-null factory id");
        }
    }

    private static void testWorkbenchPart(IWorkbenchPart iWorkbenchPart) throws Exception {
        IPropertyListener iPropertyListener = new IPropertyListener(){

            @Override
            public void propertyChanged(Object object, int n) {
            }
        };
        iWorkbenchPart.addPropertyListener(iPropertyListener);
        iWorkbenchPart.removePropertyListener(iPropertyListener);
        Assert.isTrue((boolean)iWorkbenchPart.equals(iWorkbenchPart), (String)"A part must be equal to itself");
        Assert.isTrue((!iWorkbenchPart.equals(new Integer(32)) ? 1 : 0) != 0, (String)"A part must have a meaningful equals method");
        Object object = iWorkbenchPart.getAdapter(iWorkbenchPart.getClass());
        Assert.isTrue((object == null || object == iWorkbenchPart ? 1 : 0) != 0, (String)"A part must adapter to itself or return null");
        Assert.isNotNull((Object)iWorkbenchPart.getTitle(), (String)"A part's title must be non-null");
        Assert.isNotNull((Object)iWorkbenchPart.getTitleImage(), (String)"A part's title image must be non-null");
        Assert.isNotNull((Object)iWorkbenchPart.getTitleToolTip(), (String)"A part's title tool tip must be non-null");
        Assert.isNotNull((Object)iWorkbenchPart.toString(), (String)"A part's toString method must return a non-null value");
        iWorkbenchPart.hashCode();
        if (iWorkbenchPart instanceof IWorkbenchPart2) {
            PartTester.testWorkbenchPart2((IWorkbenchPart2)iWorkbenchPart);
        }
    }

    private static void testWorkbenchPart2(IWorkbenchPart2 iWorkbenchPart2) throws Exception {
        Assert.isNotNull((Object)iWorkbenchPart2.getContentDescription(), (String)"A part must return a non-null content description");
        Assert.isNotNull((Object)iWorkbenchPart2.getPartName(), (String)"A part must return a non-null part name");
    }

    public static void testView(IViewPart iViewPart) throws Exception {
        Assert.isTrue((iViewPart.getSite() == iViewPart.getViewSite() ? 1 : 0) != 0, (String)"A part's site must be the same as a part's view site");
        PartTester.testWorkbenchPart(iViewPart);
    }
}

